/*
 * Decompiled with CFR 0.152.
 */
package r.data;

import java.util.HashMap;
import r.data.RAny;
import r.data.RInt;
import r.data.RList;
import r.data.RString;
import r.data.RSymbol;
import r.data.internal.View;

public interface RArray
extends RAny {
    public static final int[] SCALAR_DIMENSIONS = new int[]{1, 1};

    public int size();

    public int[] dimensions();

    public Names names();

    public Object get(int var1);

    public Object getRef(int var1);

    public RAny boxedGet(int var1);

    public RAny boxedNamedGet(int var1);

    public RArray set(int var1, Object var2);

    public RArray setDimensions(int[] var1);

    public RArray setNames(Names var1);

    @Override
    public RArray setAttributes(RAny.Attributes var1);

    @Override
    public RArray stripAttributes();

    public RArray stripAttributesKeepNames();

    public boolean isNAorNaN(int var1);

    public int index(int var1, int var2);

    public RArray subset(RAny var1);

    public RArray subset(RInt var1);

    public RArray subset(RString var1);

    public RArray materialize();

    public static class RListView
    extends View.RListProxy<RArray>
    implements RList {
        public RListView(RArray orig) {
            super(orig);
        }

        @Override
        public RAny getRAny(int i) {
            return this.orig.boxedGet(i);
        }
    }

    public static final class Names {
        RSymbol[] names;
        HashMap<RSymbol, Integer> map;

        private Names(RSymbol[] names, HashMap<RSymbol, Integer> preparedMap) {
            this.names = names;
            this.map = preparedMap;
        }

        public static Names create(int size) {
            RSymbol[] n = new RSymbol[size];
            for (int i = 0; i < n.length; ++i) {
                n[i] = RSymbol.EMPTY_SYMBOL;
            }
            return new Names(n, null);
        }

        public static Names create(RSymbol[] names) {
            return new Names(names, null);
        }

        public static Names create(RSymbol[] names, HashMap<RSymbol, Integer> preparedMap) {
            return new Names(names, preparedMap);
        }

        public RSymbol[] sequence() {
            return this.names;
        }

        public Names exclude(int i) {
            int size = this.names.length;
            int nsize = size - 1;
            RSymbol[] newNames = new RSymbol[nsize];
            System.arraycopy(this.names, 0, newNames, 0, i);
            if (i < nsize) {
                System.arraycopy(this.names, i + 1, newNames, i, nsize - i);
            }
            return Names.create(newNames);
        }

        public String[] asStringArray() {
            String[] res = new String[this.names.length];
            for (int i = 0; i < this.names.length; ++i) {
                res[i] = this.names[i] != null ? this.names[i].name() : RString.NA;
            }
            return res;
        }

        static boolean partialNameMatch(RSymbol src, RSymbol tgt) {
            if (src.name() == null || tgt.name() == null) {
                return false;
            }
            return tgt.name().startsWith(src.name());
        }

        public int mapPartial(RSymbol name) {
            int res = -1;
            int matches = 0;
            for (int i = 0; i < this.names.length; ++i) {
                if (!Names.partialNameMatch(name, this.names[i])) continue;
                res = i;
                if (++matches <= 1) continue;
                return -1;
            }
            return res;
        }

        public int size() {
            return this.names.length;
        }

        private void initializeMapIfNeeded() {
            if (this.map != null) {
                return;
            }
            this.map = new HashMap(this.names.length);
            for (int i = 0; i < this.names.length; ++i) {
                RSymbol name = this.names[i];
                if (name == RSymbol.EMPTY_SYMBOL || name == RSymbol.NA_SYMBOL || this.map.containsKey(name)) continue;
                this.map.put(this.names[i], i);
            }
        }

        public int map(RSymbol name) {
            this.initializeMapIfNeeded();
            Integer index = this.map.get(name);
            return index == null ? -1 : index;
        }

        public HashMap<RSymbol, Integer> getMap() {
            this.initializeMapIfNeeded();
            return this.map;
        }

        public boolean keepsMap() {
            return true;
        }
    }

    public static class RArrayUtils {
        public static RArray markShared(RArray a) {
            a.ref();
            a.ref();
            return a;
        }
    }
}

