/*
 * Decompiled with CFR 0.152.
 */
package r.data;

import java.util.Arrays;
import r.Convert;
import r.Utils;
import r.data.RAny;
import r.data.RArray;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RRaw;
import r.data.RString;
import r.data.RSymbol;
import r.data.internal.ComplexImpl;
import r.data.internal.ScalarComplexImpl;
import r.data.internal.View;

public interface RComplex
extends RArray {
    public static final String TYPE_STRING = "complex";
    public static final ComplexImpl EMPTY = (ComplexImpl)RArray.RArrayUtils.markShared(RComplexFactory.getUninitializedArray(0));
    public static final ScalarComplexImpl BOXED_NA = (ScalarComplexImpl)RArray.RArrayUtils.markShared(RComplexFactory.getScalar(RDouble.NA, RDouble.NA));
    public static final Complex COMPLEX_BOXED_NA = new Complex(RDouble.NA, RDouble.NA);
    public static final ScalarComplexImpl BOXED_ZERO = (ScalarComplexImpl)RArray.RArrayUtils.markShared(RComplexFactory.getScalar(0.0, 0.0));
    public static final ComplexImpl EMPTY_NAMED_NA = (ComplexImpl)RArray.RArrayUtils.markShared(RComplexFactory.getFor(new double[0], null, RArray.Names.create(new RSymbol[]{RSymbol.NA_SYMBOL})));
    public static final ComplexImpl NA_NAMED_NA = (ComplexImpl)RArray.RArrayUtils.markShared(RComplexFactory.getFor(new double[]{RDouble.NA, RDouble.NA}, null, RArray.Names.create(new RSymbol[]{RSymbol.NA_SYMBOL})));
    public static final ScalarComplexImpl BOXED_E = (ScalarComplexImpl)RArray.RArrayUtils.markShared(RComplexFactory.getScalar(Math.E, 0.0));

    public RComplex set(int var1, double var2, double var4);

    public double getReal(int var1);

    public double getImag(int var1);

    @Override
    public RComplex materialize();

    public double[] getContent();

    public static class RComplexSubset
    extends View.RComplexView
    implements RComplex {
        final RComplex value;
        final int vsize;
        final RInt index;
        final int isize;

        public RComplexSubset(RComplex value, RInt index) {
            this.value = value;
            this.index = index;
            this.isize = index.size();
            this.vsize = value.size();
        }

        @Override
        public int size() {
            return this.isize;
        }

        @Override
        public double getReal(int i) {
            int j = this.index.getInt(i);
            assert (Utils.check(j > 0));
            if (j > this.vsize) {
                return RDouble.NA;
            }
            return this.value.getReal(j - 1);
        }

        @Override
        public double getImag(int i) {
            int j = this.index.getInt(i);
            assert (Utils.check(j > 0));
            if (j > this.vsize) {
                return RDouble.NA;
            }
            return this.value.getImag(j - 1);
        }

        @Override
        public boolean isSharedReal() {
            return this.value.isShared() || this.index.isShared();
        }

        @Override
        public void ref() {
            this.value.ref();
            this.index.ref();
        }

        @Override
        public boolean dependsOn(RAny v) {
            return this.value.dependsOn(v) || this.index.dependsOn(v);
        }
    }

    public static class RComplexExclusion
    extends View.RComplexView
    implements RComplex {
        final RComplex orig;
        final int excludeIndex;
        final int size;

        public RComplexExclusion(int excludeIndex, RComplex orig) {
            this.orig = orig;
            this.excludeIndex = excludeIndex;
            this.size = orig.size() - 1;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public double getReal(int i) {
            assert (Utils.check(i < this.size, "bounds check"));
            assert (Utils.check(i >= 0, "bounds check"));
            if (i < this.excludeIndex) {
                return this.orig.getReal(i);
            }
            return this.orig.getReal(i + 1);
        }

        @Override
        public double getImag(int i) {
            assert (Utils.check(i < this.size, "bounds check"));
            assert (Utils.check(i >= 0, "bounds check"));
            if (i < this.excludeIndex) {
                return this.orig.getImag(i);
            }
            return this.orig.getImag(i + 1);
        }

        @Override
        public boolean isSharedReal() {
            return this.orig.isShared();
        }

        @Override
        public void ref() {
            this.orig.ref();
        }

        @Override
        public boolean dependsOn(RAny value) {
            return this.orig.dependsOn(value);
        }
    }

    public static class RLogicalView
    extends View.RLogicalProxy<RComplex>
    implements RLogical {
        public RLogicalView(RComplex orig) {
            super(orig);
        }

        @Override
        public int getLogical(int i) {
            return Convert.complex2logical(((RComplex)this.orig).getReal(i), ((RComplex)this.orig).getImag(i));
        }
    }

    public static class RStringView
    extends View.RStringProxy<RComplex>
    implements RString {
        public RStringView(RComplex orig) {
            super(orig);
        }

        @Override
        public RComplex asComplex() {
            return (RComplex)this.orig;
        }

        @Override
        public RComplex asComplex(Convert.ConversionStatus warn) {
            return (RComplex)this.orig;
        }

        @Override
        public String getString(int i) {
            return Convert.complex2string(((RComplex)this.orig).getReal(i), ((RComplex)this.orig).getImag(i));
        }
    }

    public static class RComplexFactory {
        public static ScalarComplexImpl getScalar(double real, double imag) {
            return new ScalarComplexImpl(real, imag);
        }

        public static ScalarComplexImpl getScalar(Complex value) {
            return new ScalarComplexImpl(value.realValue(), value.imagValue());
        }

        public static RComplex getScalar(double real, double imag, int[] dimensions) {
            if (dimensions == null) {
                return new ScalarComplexImpl(real, imag);
            }
            return RComplexFactory.getFor(new double[]{real, imag}, dimensions, null);
        }

        public static RComplex getArray(double ... values) {
            if (values.length == 2) {
                return new ScalarComplexImpl(values[0], values[1]);
            }
            return new ComplexImpl(values);
        }

        public static RComplex getArray(double[] values, int[] dimensions) {
            if (dimensions == null && values.length == 2) {
                return new ScalarComplexImpl(values[0], values[1]);
            }
            return new ComplexImpl(values, dimensions);
        }

        public static RComplex getArray(double[] realValues, double[] imagValues, int[] dimensions) {
            if (dimensions == null && realValues.length == 1) {
                return new ScalarComplexImpl(realValues[0], imagValues[0]);
            }
            return new ComplexImpl(realValues, imagValues, dimensions);
        }

        public static RComplex getUninitializedArray(int size) {
            if (size == 1) {
                return new ScalarComplexImpl(0.0, 0.0);
            }
            return new ComplexImpl(size);
        }

        public static RComplex getUninitializedNonScalarArray(int size) {
            return new ComplexImpl(size);
        }

        public static RComplex getUninitializedArray(int size, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
            if (size == 1 && dimensions == null && names == null && attributes == null) {
                return new ScalarComplexImpl(0.0, 0.0);
            }
            return new ComplexImpl(new double[2 * size], dimensions, names, attributes, false);
        }

        public static RComplex getNAArray(int size) {
            return RComplexFactory.getNAArray(size, null);
        }

        public static RComplex getNAArray(int size, int[] dimensions) {
            if (size == 1 && dimensions == null) {
                return BOXED_NA;
            }
            double[] content = new double[2 * size];
            Arrays.fill(content, RDouble.NA);
            return new ComplexImpl(content, dimensions, null, null, false);
        }

        public static ComplexImpl getMatrixFor(double[] values, int m, int n) {
            return new ComplexImpl(values, new int[]{m, n}, null, null, false);
        }

        public static RComplex copy(RComplex c) {
            if (c.size() == 1 && c.dimensions() == null && c.names() == null && c.attributes() == null) {
                return new ScalarComplexImpl(c.getReal(0), c.getImag(0));
            }
            return new ComplexImpl(c, false);
        }

        public static RComplex strip(RComplex v) {
            if (v.size() == 1) {
                return new ScalarComplexImpl(v.getReal(0), v.getImag(0));
            }
            return new ComplexImpl(v, true);
        }

        public static RComplex stripKeepNames(RComplex v) {
            RArray.Names names = v.names();
            if (v.size() == 1 && names == null) {
                return new ScalarComplexImpl(v.getReal(0), v.getImag(0));
            }
            return new ComplexImpl(v, null, names, null);
        }

        public static RComplex getFor(double[] values) {
            return RComplexFactory.getFor(values, null, null);
        }

        public static RComplex getFor(double[] values, int[] dimensions, RArray.Names names) {
            if (values.length == 2 && dimensions == null && names == null) {
                return new ScalarComplexImpl(values[0], values[1]);
            }
            return new ComplexImpl(values, dimensions, names, null, false);
        }

        public static RComplex getFor(double[] values, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
            if (values.length == 2 && dimensions == null && names == null && attributes == null) {
                return new ScalarComplexImpl(values[0], values[1]);
            }
            return new ComplexImpl(values, dimensions, names, attributes, false);
        }

        public static RComplex getEmpty(boolean named) {
            return named ? EMPTY_NAMED_NA : EMPTY;
        }

        public static RComplex getNA(boolean named) {
            return (RComplex)((Object)(named ? NA_NAMED_NA : BOXED_NA));
        }

        public static RComplex exclude(int excludeIndex, RComplex orig) {
            int i;
            RArray.Names names = orig.names();
            if (names == null) {
                return new RComplexExclusion(excludeIndex, orig);
            }
            int size = orig.size();
            int nsize = size - 1;
            double[] content = new double[2 * nsize];
            for (i = 0; i < excludeIndex; ++i) {
                content[2 * i] = orig.getReal(i);
                content[2 * i + 1] = orig.getImag(i);
            }
            for (i = excludeIndex; i < nsize; ++i) {
                content[2 * i] = orig.getReal(i + 1);
                content[2 * i + 1] = orig.getImag(i + 1);
            }
            return RComplexFactory.getFor(content, null, names.exclude(excludeIndex));
        }

        public static RComplex subset(RComplex value, RInt index) {
            return new RComplexSubset(value, index);
        }
    }

    public static class RComplexUtils {
        public static boolean eitherIsNA(double real, double imag) {
            return RDouble.RDoubleUtils.isNA(real) || RDouble.RDoubleUtils.isNA(imag);
        }

        public static boolean arithEitherIsNA(double real, double imag) {
            return RDouble.RDoubleUtils.arithIsNA(real) || RDouble.RDoubleUtils.arithIsNA(imag);
        }

        public static boolean eitherIsNAorNaN(double real, double imag) {
            return RDouble.RDoubleUtils.isNAorNaN(real) || RDouble.RDoubleUtils.isNAorNaN(imag);
        }

        public static RDouble complex2double(RComplex value, Convert.ConversionStatus warn) {
            int size = value.size();
            double[] content = new double[size];
            for (int i = 0; i < size; ++i) {
                double real = value.getReal(i);
                double imag = value.getImag(i);
                content[i] = Convert.complex2double(real, imag, warn);
            }
            return RDouble.RDoubleFactory.getFor(content, value.dimensions(), value.names());
        }

        public static RInt complex2int(RComplex value, Convert.ConversionStatus warn) {
            int size = value.size();
            int[] content = new int[size];
            for (int i = 0; i < size; ++i) {
                double real = value.getReal(i);
                double imag = value.getImag(i);
                content[i] = Convert.complex2int(real, imag, warn);
            }
            return RInt.RIntFactory.getFor(content, value.dimensions(), value.names());
        }

        public static RRaw complexToRaw(RComplex value, Convert.ConversionStatus warn) {
            int size = value.size();
            byte[] content = new byte[size];
            for (int i = 0; i < size; ++i) {
                double real = value.getReal(i);
                double imag = value.getImag(i);
                content[i] = Convert.complex2raw(real, imag, warn);
            }
            return RRaw.RRawFactory.getFor(content, value.dimensions(), value.names());
        }

        public static double[] copyAsDoubleArray(RComplex c) {
            int size = c.size();
            if (size == 1) {
                return new double[]{c.getReal(0), c.getImag(0)};
            }
            int rawsize = size * 2;
            double[] res = new double[rawsize];
            if (c instanceof ComplexImpl) {
                System.arraycopy(((ComplexImpl)c).getContent(), 0, res, 0, rawsize);
            } else {
                for (int i = 0; i < size; ++i) {
                    res[2 * i] = c.getReal(i);
                    res[2 * i + 1] = c.getImag(i);
                }
            }
            return res;
        }

        public static double[] asDoubleArray(RComplex c) {
            if (c.size() == 1) {
                return new double[]{c.getReal(0), c.getImag(0)};
            }
            return ((ComplexImpl)c.materialize()).getContent();
        }
    }

    public static final class Complex {
        public static final Complex NA = new Complex(RDouble.NA, RDouble.NA);
        private final double real;
        private final double imag;

        public Complex(double real, double imag) {
            this.real = real;
            this.imag = imag;
        }

        public double realValue() {
            return this.real;
        }

        public double imagValue() {
            return this.imag;
        }

        public boolean equals(Object o) {
            if (o instanceof Complex) {
                Complex c = (Complex)o;
                return this.real == c.real && this.imag == c.imag;
            }
            return false;
        }

        public int hashCode() {
            return (int)this.real;
        }
    }
}

