/*
 * Decompiled with CFR 0.152.
 */
package r.data;

import java.util.Arrays;
import r.Convert;
import r.Utils;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RInt;
import r.data.RLogical;
import r.data.RNumber;
import r.data.RRaw;
import r.data.RString;
import r.data.RSymbol;
import r.data.internal.DoubleImpl;
import r.data.internal.ScalarDoubleImpl;
import r.data.internal.View;

public interface RDouble
extends RNumber {
    public static final String TYPE_STRING = "double";
    public static final long NA_LONGBITS = 9218868437227407266L;
    public static final int NA_LOWBITS = 1954;
    public static final double NA = Double.longBitsToDouble(9218868437227407266L);
    public static final double NaN = Double.NaN;
    public static final double EPSILON = Math.pow(2.0, -52.0);
    public static final double NEG_INF = Double.NEGATIVE_INFINITY;
    public static final double POS_INF = Double.POSITIVE_INFINITY;
    public static final DoubleImpl EMPTY = (DoubleImpl)RArray.RArrayUtils.markShared(RDoubleFactory.getUninitializedArray(0));
    public static final ScalarDoubleImpl BOXED_ZERO = (ScalarDoubleImpl)RArray.RArrayUtils.markShared(RDoubleFactory.getScalar(0.0));
    public static final ScalarDoubleImpl BOXED_NA = (ScalarDoubleImpl)RArray.RArrayUtils.markShared(RDoubleFactory.getScalar(NA));
    public static final ScalarDoubleImpl BOXED_NEG_INF = (ScalarDoubleImpl)RArray.RArrayUtils.markShared(RDoubleFactory.getScalar(Double.NEGATIVE_INFINITY));
    public static final ScalarDoubleImpl BOXED_POS_INF = (ScalarDoubleImpl)RArray.RArrayUtils.markShared(RDoubleFactory.getScalar(Double.POSITIVE_INFINITY));
    public static final DoubleImpl EMPTY_NAMED_NA = (DoubleImpl)RArray.RArrayUtils.markShared(RDoubleFactory.getFor(new double[0], null, RArray.Names.create(new RSymbol[]{RSymbol.NA_SYMBOL})));
    public static final DoubleImpl NA_NAMED_NA = (DoubleImpl)RArray.RArrayUtils.markShared(RDoubleFactory.getFor(new double[]{NA}, null, RArray.Names.create(new RSymbol[]{RSymbol.NA_SYMBOL})));

    public RDouble set(int var1, double var2);

    public double getDouble(int var1);

    @Override
    public RDouble materialize();

    public double[] getContent();

    public static class RDoubleSubset
    extends View.RDoubleView
    implements RDouble {
        final RDouble value;
        final int vsize;
        final RInt index;
        final int isize;

        public RDoubleSubset(RDouble value, RInt index) {
            this.value = value;
            this.index = index;
            this.isize = index.size();
            this.vsize = value.size();
        }

        @Override
        public int size() {
            return this.isize;
        }

        @Override
        public double getDouble(int i) {
            int j = this.index.getInt(i);
            assert (Utils.check(j > 0));
            if (j > this.vsize) {
                return NA;
            }
            return this.value.getDouble(j - 1);
        }

        @Override
        public boolean isSharedReal() {
            return this.value.isShared() || this.index.isShared();
        }

        @Override
        public void ref() {
            this.value.ref();
            this.index.ref();
        }

        @Override
        public boolean dependsOn(RAny v) {
            return this.value.dependsOn(v) || this.index.dependsOn(v);
        }
    }

    public static class RDoubleExclusion
    extends View.RDoubleView
    implements RDouble {
        final RDouble orig;
        final int excludeIndex;
        final int size;

        public RDoubleExclusion(int excludeIndex, RDouble orig) {
            this.orig = orig;
            this.excludeIndex = excludeIndex;
            this.size = orig.size() - 1;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public double getDouble(int i) {
            assert (Utils.check(i < this.size, "bounds check"));
            assert (Utils.check(i >= 0, "bounds check"));
            if (i < this.excludeIndex) {
                return this.orig.getDouble(i);
            }
            return this.orig.getDouble(i + 1);
        }

        @Override
        public boolean isSharedReal() {
            return this.orig.isShared();
        }

        @Override
        public void ref() {
            this.orig.ref();
        }

        @Override
        public boolean dependsOn(RAny value) {
            return this.orig.dependsOn(value);
        }
    }

    public static class RRawView
    extends View.RRawProxy<RDouble>
    implements RRaw {
        public RRawView(RDouble orig) {
            super(orig);
        }

        @Override
        public byte getRaw(int i) {
            return Convert.double2raw(((RDouble)this.orig).getDouble(i));
        }
    }

    public static class RLogicalView
    extends View.RLogicalProxy<RDouble>
    implements RLogical {
        public RLogicalView(RDouble orig) {
            super(orig);
        }

        @Override
        public int getLogical(int i) {
            return Convert.double2logical(((RDouble)this.orig).getDouble(i));
        }
    }

    public static class RIntView
    extends View.RIntProxy<RDouble>
    implements RInt {
        public RIntView(RDouble orig) {
            super(orig);
        }

        @Override
        public int getInt(int i) {
            return Convert.double2int(((RDouble)this.orig).getDouble(i));
        }
    }

    public static class RComplexView
    extends View.RComplexProxy<RDouble>
    implements RComplex {
        public RComplexView(RDouble orig) {
            super(orig);
        }

        @Override
        public RDouble asDouble() {
            return (RDouble)this.orig;
        }

        @Override
        public RInt asInt() {
            return ((RDouble)this.orig).asInt();
        }

        @Override
        public RLogical asLogical() {
            return ((RDouble)this.orig).asLogical();
        }

        @Override
        public RRaw asRaw() {
            return ((RDouble)this.orig).asRaw();
        }

        @Override
        public RDouble asDouble(Convert.ConversionStatus warn) {
            return (RDouble)this.orig;
        }

        @Override
        public RInt asInt(Convert.ConversionStatus warn) {
            return ((RDouble)this.orig).asInt(warn);
        }

        @Override
        public RLogical asLogical(Convert.ConversionStatus warn) {
            return ((RDouble)this.orig).asLogical();
        }

        @Override
        public RRaw asRaw(Convert.ConversionStatus warn) {
            return ((RDouble)this.orig).asRaw(warn);
        }

        @Override
        public double getReal(int i) {
            double d = ((RDouble)this.orig).getDouble(i);
            if (RDoubleUtils.isNAorNaN(d)) {
                return NA;
            }
            return d;
        }

        @Override
        public double getImag(int i) {
            double d = ((RDouble)this.orig).getDouble(i);
            if (RDoubleUtils.isNAorNaN(d)) {
                return NA;
            }
            return 0.0;
        }
    }

    public static class RStringView
    extends View.RStringProxy<RDouble>
    implements RString {
        public RStringView(RDouble orig) {
            super(orig);
        }

        @Override
        public RComplex asComplex() {
            return ((RDouble)this.orig).asComplex();
        }

        @Override
        public RDouble asDouble() {
            return (RDouble)this.orig;
        }

        @Override
        public RInt asInt() {
            return ((RDouble)this.orig).asInt();
        }

        @Override
        public RRaw asRaw() {
            return ((RDouble)this.orig).asRaw();
        }

        @Override
        public RComplex asComplex(Convert.ConversionStatus warn) {
            return ((RDouble)this.orig).asComplex();
        }

        @Override
        public RDouble asDouble(Convert.ConversionStatus warn) {
            return (RDouble)this.orig;
        }

        @Override
        public RInt asInt(Convert.ConversionStatus warn) {
            return ((RDouble)this.orig).asInt(warn);
        }

        @Override
        public RRaw asRaw(Convert.ConversionStatus warn) {
            return ((RDouble)this.orig).asRaw(warn);
        }

        @Override
        public String getString(int i) {
            return Convert.double2string(((RDouble)this.orig).getDouble(i));
        }
    }

    public static class RDoubleFactory {
        public static ScalarDoubleImpl getScalar(double value) {
            return new ScalarDoubleImpl(value);
        }

        public static RDouble getScalar(double value, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
            if (dimensions == null && names == null && attributes == null) {
                return new ScalarDoubleImpl(value);
            }
            return RDoubleFactory.getFor(new double[]{value}, dimensions, names, attributes);
        }

        public static RDouble getArray(double ... values) {
            if (values.length == 1) {
                return new ScalarDoubleImpl(values[0]);
            }
            return new DoubleImpl(values);
        }

        public static RDouble getArray(double[] values, int[] dimensions) {
            if (dimensions == null && values.length == 1) {
                return new ScalarDoubleImpl(values[0]);
            }
            return new DoubleImpl(values, dimensions, null);
        }

        public static RDouble getUninitializedArray(int size) {
            if (size == 1) {
                return new ScalarDoubleImpl(0.0);
            }
            return new DoubleImpl(size);
        }

        public static RDouble getUninitializedNonScalarArray(int size) {
            return new DoubleImpl(size);
        }

        public static RDouble getUninitializedArray(int size, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
            if (size == 1 && dimensions == null && names == null && attributes == null) {
                return new ScalarDoubleImpl(0.0);
            }
            return new DoubleImpl(new double[size], dimensions, names, attributes, false);
        }

        public static RDouble getNAArray(int size) {
            return RDoubleFactory.getNAArray(size, null);
        }

        public static RDouble getNAArray(int size, int[] dimensions) {
            if (size == 1 && dimensions == null) {
                return BOXED_NA;
            }
            double[] content = new double[size];
            Arrays.fill(content, NA);
            return new DoubleImpl(content, dimensions, null, null, false);
        }

        public static DoubleImpl getMatrixFor(double[] values, int m, int n) {
            return new DoubleImpl(values, new int[]{m, n}, null, null, false);
        }

        public static RDouble copy(RDouble d) {
            if (d.size() == 1 && d.dimensions() == null && d.names() == null && d.attributes() == null) {
                return new ScalarDoubleImpl(d.getDouble(0));
            }
            return new DoubleImpl(d, false);
        }

        public static RDouble strip(RDouble v) {
            if (v.size() == 1) {
                return new ScalarDoubleImpl(v.getDouble(0));
            }
            return new DoubleImpl(v, true);
        }

        public static RDouble stripKeepNames(RDouble v) {
            RArray.Names names = v.names();
            if (v.size() == 1 && names == null) {
                return new ScalarDoubleImpl(v.getDouble(0));
            }
            return new DoubleImpl(v, null, names, null);
        }

        public static RDouble getFor(double[] values) {
            return RDoubleFactory.getFor(values, null, null);
        }

        public static RDouble getFor(double[] values, int[] dimensions, RArray.Names names) {
            if (values.length == 1 && dimensions == null && names == null) {
                return new ScalarDoubleImpl(values[0]);
            }
            return new DoubleImpl(values, dimensions, names, null, false);
        }

        public static RDouble getFor(double[] values, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
            if (values.length == 1 && dimensions == null && names == null && attributes == null) {
                return new ScalarDoubleImpl(values[0]);
            }
            return new DoubleImpl(values, dimensions, names, attributes, false);
        }

        public static RDouble getEmpty(boolean named) {
            return named ? EMPTY_NAMED_NA : EMPTY;
        }

        public static RDouble getNA(boolean named) {
            return (RDouble)((Object)(named ? NA_NAMED_NA : BOXED_NA));
        }

        public static RDouble exclude(int excludeIndex, RDouble orig) {
            int i;
            RArray.Names names = orig.names();
            if (names == null) {
                return new RDoubleExclusion(excludeIndex, orig);
            }
            int size = orig.size();
            int nsize = size - 1;
            double[] content = new double[nsize];
            for (i = 0; i < excludeIndex; ++i) {
                content[i] = orig.getDouble(i);
            }
            for (i = excludeIndex; i < nsize; ++i) {
                content[i] = orig.getDouble(i + 1);
            }
            return RDoubleFactory.getFor(content, null, names.exclude(excludeIndex));
        }

        public static RDouble subset(RDouble value, RInt index) {
            return new RDoubleSubset(value, index);
        }
    }

    public static class RDoubleUtils {
        private static final boolean ARITH_NA_CHECKS = false;

        public static boolean isNA(double d) {
            return (int)Double.doubleToRawLongBits(d) == 1954;
        }

        public static boolean arithIsNA(double d) {
            return false;
        }

        public static boolean fitsRInt(double d) {
            return d >= -2.147483648E9 && d <= 2.147483647E9;
        }

        public static boolean isNAorNaN(double d) {
            return Double.isNaN(d);
        }

        public static boolean isFinite(double d) {
            return !RDoubleUtils.isNAorNaN(d) && !Double.isInfinite(d);
        }

        public static RInt double2int(RDouble value, Convert.ConversionStatus warn) {
            int size = value.size();
            int[] content = new int[size];
            for (int i = 0; i < size; ++i) {
                double d = value.getDouble(i);
                content[i] = Convert.double2int(d, warn);
            }
            return RInt.RIntFactory.getFor(content, value.dimensions(), value.names());
        }

        public static RRaw doubleToRaw(RDouble value, Convert.ConversionStatus warn) {
            int size = value.size();
            byte[] content = new byte[size];
            for (int i = 0; i < size; ++i) {
                double dval = value.getDouble(i);
                content[i] = Convert.double2raw(dval, warn);
            }
            return RRaw.RRawFactory.getFor(content, value.dimensions(), value.names());
        }

        public static double[] copyAsDoubleArray(RDouble d) {
            int size = d.size();
            if (size == 1) {
                return new double[]{d.getDouble(0)};
            }
            double[] res = new double[size];
            if (d instanceof DoubleImpl) {
                System.arraycopy(((DoubleImpl)d).getContent(), 0, res, 0, size);
            } else {
                for (int i = 0; i < size; ++i) {
                    res[i] = d.getDouble(i);
                }
            }
            return res;
        }

        public static boolean hasNAorNaN(RDouble d) {
            int size = d.size();
            for (int i = 0; i < size; ++i) {
                if (!RDoubleUtils.isNAorNaN(d.getDouble(i))) continue;
                return true;
            }
            return false;
        }

        public static RDouble convertNAandNaNtoZero(RDouble d) {
            if (d instanceof ScalarDoubleImpl) {
                ScalarDoubleImpl sd = (ScalarDoubleImpl)d;
                if (sd.isNAorNaN()) {
                    return BOXED_ZERO;
                }
                return sd;
            }
            RDouble res = d.materialize();
            double[] content = res.getContent();
            for (int i = 0; i < content.length; ++i) {
                if (!RDoubleUtils.isNAorNaN(content[i])) continue;
                content[i] = 0.0;
            }
            return res;
        }
    }
}

