/*
 * Decompiled with CFR 0.152.
 */
package r.data;

import java.util.Arrays;
import r.Convert;
import r.Utils;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RLogical;
import r.data.RNumber;
import r.data.RRaw;
import r.data.RString;
import r.data.RSymbol;
import r.data.internal.IntImpl;
import r.data.internal.ScalarIntImpl;
import r.data.internal.View;

public interface RInt
extends RNumber {
    public static final int NA = Integer.MIN_VALUE;
    public static final String TYPE_STRING = "integer";
    public static final ScalarIntImpl BOXED_NA = (ScalarIntImpl)RArray.RArrayUtils.markShared(RIntFactory.getScalar(Integer.MIN_VALUE));
    public static final ScalarIntImpl BOXED_ZERO = (ScalarIntImpl)RArray.RArrayUtils.markShared(RIntFactory.getScalar(0));
    public static final ScalarIntImpl BOXED_ONE = (ScalarIntImpl)RArray.RArrayUtils.markShared(RIntFactory.getScalar(1));
    public static final IntImpl EMPTY = (IntImpl)RArray.RArrayUtils.markShared(RIntFactory.getUninitializedArray(0));
    public static final IntImpl EMPTY_NAMED_NA = (IntImpl)RArray.RArrayUtils.markShared(RIntFactory.getFor(new int[0], null, RArray.Names.create(new RSymbol[]{RSymbol.NA_SYMBOL})));
    public static final IntImpl NA_NAMED_NA = (IntImpl)RArray.RArrayUtils.markShared(RIntFactory.getFor(new int[]{Integer.MIN_VALUE}, null, RArray.Names.create(new RSymbol[]{RSymbol.NA_SYMBOL})));

    public int getInt(int var1);

    public RInt set(int var1, int var2);

    @Override
    public RInt materialize();

    public int[] getContent();

    public static class RIntSubset
    extends View.RIntView
    implements RInt {
        final RInt value;
        final int vsize;
        final RInt index;
        final int isize;

        public RIntSubset(RInt value, RInt index) {
            this.value = value;
            this.index = index;
            this.isize = index.size();
            this.vsize = value.size();
        }

        @Override
        public int size() {
            return this.isize;
        }

        @Override
        public int getInt(int i) {
            int j = this.index.getInt(i);
            assert (Utils.check(j > 0));
            if (j > this.vsize) {
                return Integer.MIN_VALUE;
            }
            return this.value.getInt(j - 1);
        }

        @Override
        public boolean isSharedReal() {
            return this.value.isShared() || this.index.isShared();
        }

        @Override
        public void ref() {
            this.value.ref();
            this.index.ref();
        }

        @Override
        public boolean dependsOn(RAny v) {
            return this.value.dependsOn(v) || this.index.dependsOn(v);
        }
    }

    public static class RIntExclusion
    extends View.RIntView
    implements RInt {
        final RInt orig;
        final int excludeIndex;
        final int size;

        public RIntExclusion(int excludeIndex, RInt orig) {
            this.orig = orig;
            this.excludeIndex = excludeIndex;
            this.size = orig.size() - 1;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public int getInt(int i) {
            assert (Utils.check(i < this.size, "bounds check"));
            assert (Utils.check(i >= 0, "bounds check"));
            if (i < this.excludeIndex) {
                return this.orig.getInt(i);
            }
            return this.orig.getInt(i + 1);
        }

        @Override
        public boolean isSharedReal() {
            return this.orig.isShared();
        }

        @Override
        public void ref() {
            this.orig.ref();
        }

        @Override
        public boolean dependsOn(RAny value) {
            return this.orig.dependsOn(value);
        }
    }

    public static class RRawView
    extends View.RRawProxy<RInt>
    implements RRaw {
        public RRawView(RInt orig) {
            super(orig);
        }

        @Override
        public byte getRaw(int i) {
            int v = ((RInt)this.orig).getInt(i);
            return Convert.int2raw(v);
        }
    }

    public static class RLogicalView
    extends View.RLogicalProxy<RInt>
    implements RLogical {
        public RLogicalView(RInt orig) {
            super(orig);
        }

        @Override
        public int getLogical(int i) {
            int v = ((RInt)this.orig).getInt(i);
            return Convert.int2logical(v);
        }
    }

    public static class RDoubleView
    extends View.RDoubleProxy<RInt>
    implements RDouble {
        public RDoubleView(RInt orig) {
            super(orig);
        }

        @Override
        public RComplex asComplex() {
            return ((RInt)this.orig).asComplex();
        }

        @Override
        public RInt asInt() {
            return (RInt)this.orig;
        }

        @Override
        public RLogical asLogical() {
            return ((RInt)this.orig).asLogical();
        }

        @Override
        public RRaw asRaw() {
            return ((RInt)this.orig).asRaw();
        }

        @Override
        public RComplex asComplex(Convert.ConversionStatus warn) {
            return ((RInt)this.orig).asComplex();
        }

        @Override
        public RInt asInt(Convert.ConversionStatus warn) {
            return (RInt)this.orig;
        }

        @Override
        public RLogical asLogical(Convert.ConversionStatus warn) {
            return ((RInt)this.orig).asLogical();
        }

        @Override
        public RRaw asRaw(Convert.ConversionStatus warn) {
            return ((RInt)this.orig).asRaw(warn);
        }

        @Override
        public double getDouble(int i) {
            int v = ((RInt)this.orig).getInt(i);
            return Convert.int2double(v);
        }
    }

    public static class RComplexView
    extends View.RComplexProxy<RInt>
    implements RComplex {
        public RComplexView(RInt orig) {
            super(orig);
        }

        @Override
        public RDouble asDouble() {
            return ((RInt)this.orig).asDouble();
        }

        @Override
        public RInt asInt() {
            return (RInt)this.orig;
        }

        @Override
        public RLogical asLogical() {
            return ((RInt)this.orig).asLogical();
        }

        @Override
        public RRaw asRaw() {
            return ((RInt)this.orig).asRaw();
        }

        @Override
        public RDouble asDouble(Convert.ConversionStatus warn) {
            return ((RInt)this.orig).asDouble();
        }

        @Override
        public RInt asInt(Convert.ConversionStatus warn) {
            return (RInt)this.orig;
        }

        @Override
        public RLogical asLogical(Convert.ConversionStatus warn) {
            return ((RInt)this.orig).asLogical();
        }

        @Override
        public RRaw asRaw(Convert.ConversionStatus warn) {
            return ((RInt)this.orig).asRaw(warn);
        }

        @Override
        public double getReal(int i) {
            int v = ((RInt)this.orig).getInt(i);
            return Convert.int2double(v);
        }

        @Override
        public double getImag(int i) {
            return 0.0;
        }
    }

    public static class RStringView
    extends View.RStringProxy<RInt>
    implements RString {
        public RStringView(RInt orig) {
            super(orig);
        }

        @Override
        public RComplex asComplex() {
            return ((RInt)this.orig).asComplex();
        }

        @Override
        public RDouble asDouble() {
            return ((RInt)this.orig).asDouble();
        }

        @Override
        public RInt asInt() {
            return (RInt)this.orig;
        }

        @Override
        public RRaw asRaw() {
            return ((RInt)this.orig).asRaw();
        }

        @Override
        public RComplex asComplex(Convert.ConversionStatus warn) {
            return ((RInt)this.orig).asComplex();
        }

        @Override
        public RDouble asDouble(Convert.ConversionStatus warn) {
            return ((RInt)this.orig).asDouble();
        }

        @Override
        public RInt asInt(Convert.ConversionStatus warn) {
            return (RInt)this.orig;
        }

        @Override
        public RRaw asRaw(Convert.ConversionStatus warn) {
            return ((RInt)this.orig).asRaw(warn);
        }

        @Override
        public String getString(int i) {
            int v = ((RInt)this.orig).getInt(i);
            return Convert.int2string(v);
        }
    }

    public static class RIntFactory {
        public static ScalarIntImpl getScalar(int value) {
            return new ScalarIntImpl(value);
        }

        public static RInt getScalar(int value, int[] dimensions) {
            if (dimensions == null) {
                return new ScalarIntImpl(value);
            }
            return RIntFactory.getFor(new int[]{value}, dimensions, null);
        }

        public static RInt getArray(int ... values) {
            if (values.length == 1) {
                return new ScalarIntImpl(values[0]);
            }
            return new IntImpl(values);
        }

        public static RInt getArray(int[] values, int[] dimensions) {
            if (dimensions == null && values.length == 1) {
                return new ScalarIntImpl(values[0]);
            }
            return new IntImpl(values, dimensions, null);
        }

        public static RInt getUninitializedArray(int size) {
            if (size == 1) {
                return new ScalarIntImpl(0);
            }
            return new IntImpl(size);
        }

        public static RInt getUninitializedNonScalarArray(int size) {
            return new IntImpl(size);
        }

        public static RInt getUninitializedArray(int size, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
            if (size == 1 && dimensions == null && names == null && attributes == null) {
                return new ScalarIntImpl(0);
            }
            return new IntImpl(new int[size], dimensions, names, attributes, false);
        }

        public static RInt getNAArray(int size) {
            return RIntFactory.getNAArray(size, null);
        }

        public static RInt getNAArray(int size, int[] dimensions) {
            if (size == 1 && dimensions == null) {
                return BOXED_NA;
            }
            int[] content = new int[size];
            Arrays.fill(content, Integer.MIN_VALUE);
            return new IntImpl(content, dimensions, null, null, false);
        }

        public static IntImpl getMatrixFor(int[] values, int m, int n) {
            return new IntImpl(values, new int[]{m, n}, null, null, false);
        }

        public static RInt copy(RInt i) {
            if (i.size() == 1 && i.dimensions() == null && i.names() == null && i.attributes() == null) {
                return new ScalarIntImpl(i.getInt(0));
            }
            return new IntImpl(i, false);
        }

        public static RInt strip(RInt v) {
            if (v.size() == 1) {
                return new ScalarIntImpl(v.getInt(0));
            }
            return new IntImpl(v, true);
        }

        public static RInt stripKeepNames(RInt v) {
            RArray.Names names = v.names();
            if (v.size() == 1 && names == null) {
                return new ScalarIntImpl(v.getInt(0));
            }
            return new IntImpl(v, null, names, null);
        }

        public static RInt getFor(int[] values) {
            return RIntFactory.getFor(values, null, null);
        }

        public static RInt getFor(int[] values, int[] dimensions, RArray.Names names) {
            if (values.length == 1 && dimensions == null && names == null) {
                return new ScalarIntImpl(values[0]);
            }
            return new IntImpl(values, dimensions, names, null, false);
        }

        public static RInt getFor(int[] values, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
            if (values.length == 1 && dimensions == null && names == null && attributes == null) {
                return new ScalarIntImpl(values[0]);
            }
            return new IntImpl(values, dimensions, names, attributes, false);
        }

        public static RInt forSequence(int from, int to, int step) {
            return new IntImpl.RIntSequence(from, to, step);
        }

        public static RInt getEmpty(boolean named) {
            return named ? EMPTY_NAMED_NA : EMPTY;
        }

        public static RInt getNA(boolean named) {
            return (RInt)((Object)(named ? NA_NAMED_NA : BOXED_NA));
        }

        public static RInt exclude(int excludeIndex, RInt orig) {
            int i;
            RArray.Names names = orig.names();
            if (names == null) {
                return new RIntExclusion(excludeIndex, orig);
            }
            int size = orig.size();
            int nsize = size - 1;
            int[] content = new int[nsize];
            for (i = 0; i < excludeIndex; ++i) {
                content[i] = orig.getInt(i);
            }
            for (i = excludeIndex; i < nsize; ++i) {
                content[i] = orig.getInt(i + 1);
            }
            return RIntFactory.getFor(content, null, names.exclude(excludeIndex));
        }

        public static RInt subset(RInt value, RInt index) {
            return new RIntSubset(value, index);
        }
    }

    public static class RIntUtils {
        public static RRaw intToRaw(RInt value, Convert.ConversionStatus warn) {
            int size = value.size();
            byte[] content = new byte[size];
            for (int i = 0; i < size; ++i) {
                int ival = value.getInt(i);
                content[i] = Convert.int2raw(ival, warn);
            }
            return RRaw.RRawFactory.getFor(content, value.dimensions(), value.names());
        }

        public static int[] copyAsIntArray(RInt v) {
            int size = v.size();
            if (size == 1) {
                return new int[]{v.getInt(0)};
            }
            int[] res = new int[size];
            if (v instanceof IntImpl) {
                System.arraycopy(((IntImpl)v).getContent(), 0, res, 0, size);
            } else {
                for (int i = 0; i < size; ++i) {
                    res[i] = v.getInt(i);
                }
            }
            return res;
        }
    }
}

