/*
 * Decompiled with CFR 0.152.
 */
package r.data;

import r.Utils;
import r.data.RAny;
import r.data.RArray;
import r.data.RInt;
import r.data.RNull;
import r.data.RSymbol;
import r.data.internal.ListImpl;
import r.data.internal.View;

public interface RList
extends RArray {
    public static final String TYPE_STRING = "list";
    public static final RNull NULL = RNull.getNull();
    public static final ListImpl EMPTY = (ListImpl)RArray.RArrayUtils.markShared(RListFactory.getUninitializedArray(0));
    public static final ListImpl EMPTY_NAMED_NA = (ListImpl)RArray.RArrayUtils.markShared(RListFactory.getFor(new RAny[0], null, RArray.Names.create(new RSymbol[]{RSymbol.NA_SYMBOL})));
    public static final ListImpl BOXED_NULL = (ListImpl)RArray.RArrayUtils.markShared(RListFactory.getArray(NULL));
    public static final ListImpl NULL_NAMED_NA = (ListImpl)RArray.RArrayUtils.markShared(RListFactory.getFor(new RAny[]{NULL}, null, RArray.Names.create(new RSymbol[]{RSymbol.NA_SYMBOL})));

    public RAny getRAny(int var1);

    public RAny getRAnyRef(int var1);

    public RArray set(int var1, RAny var2);

    @Override
    public ListImpl materialize();

    public static class RListSubset
    extends View.RListView
    implements RList {
        final RList value;
        final int vsize;
        final RInt index;
        final int isize;

        public RListSubset(RList value, RInt index) {
            this.value = value;
            this.index = index;
            this.isize = index.size();
            this.vsize = value.size();
        }

        @Override
        public int size() {
            return this.isize;
        }

        @Override
        public RAny getRAny(int i) {
            int j = this.index.getInt(i);
            assert (Utils.check(j > 0));
            if (j > this.vsize) {
                return NULL;
            }
            return this.value.getRAny(j - 1);
        }

        @Override
        public boolean isSharedReal() {
            return this.value.isShared() || this.index.isShared();
        }

        @Override
        public void ref() {
            this.value.ref();
            this.index.ref();
        }

        @Override
        public boolean dependsOn(RAny v) {
            return this.value.dependsOn(v) || this.index.dependsOn(v);
        }
    }

    public static class RListExclusion
    extends View.RListView
    implements RList {
        final RList orig;
        final int excludeIndex;
        final int size;

        public RListExclusion(int excludeIndex, RList orig) {
            this.orig = orig;
            this.excludeIndex = excludeIndex;
            this.size = orig.size() - 1;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public RAny getRAny(int i) {
            assert (Utils.check(i < this.size, "bounds check"));
            assert (Utils.check(i >= 0, "bounds check"));
            if (i < this.excludeIndex) {
                return this.orig.getRAny(i);
            }
            return this.orig.getRAny(i + 1);
        }

        @Override
        public boolean isSharedReal() {
            return this.orig.isShared();
        }

        @Override
        public void ref() {
            this.orig.ref();
        }

        @Override
        public boolean dependsOn(RAny value) {
            return this.orig.dependsOn(value);
        }
    }

    public static class RListFactory {
        public static ListImpl getScalar(RAny value) {
            return new ListImpl(new RAny[]{value}, null, null, null, false);
        }

        public static ListImpl getArray(RAny ... values) {
            return new ListImpl(values);
        }

        public static ListImpl getUninitializedArray(int size) {
            return new ListImpl(size);
        }

        public static ListImpl getUninitializedNonScalarArray(int size) {
            return new ListImpl(size);
        }

        public static ListImpl getUninitializedArray(int size, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
            return new ListImpl(new RAny[size], dimensions, names, attributes, false);
        }

        public static ListImpl getNullArray(int size) {
            ListImpl v = RListFactory.getUninitializedArray(size);
            for (int i = 0; i < size; ++i) {
                v.set(i, NULL);
            }
            return v;
        }

        public static ListImpl copy(RList l) {
            return new ListImpl(l, false);
        }

        public static ListImpl strip(RList l) {
            return new ListImpl(l, true);
        }

        public static ListImpl stripKeepNames(RList l) {
            return new ListImpl(l, null, l.names(), null);
        }

        public static ListImpl getFor(RAny[] values) {
            return RListFactory.getFor(values, null, null);
        }

        public static ListImpl getFor(RAny[] values, int[] dimensions) {
            return RListFactory.getFor(values, dimensions, null);
        }

        public static ListImpl getFor(RAny[] values, int[] dimensions, RArray.Names names) {
            return new ListImpl(values, dimensions, names, null, false);
        }

        public static ListImpl getFor(RAny[] values, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
            return new ListImpl(values, dimensions, names, attributes, false);
        }

        public static ListImpl getEmpty(boolean named) {
            return named ? EMPTY_NAMED_NA : EMPTY;
        }

        public static ListImpl getNull(boolean named) {
            return named ? NULL_NAMED_NA : BOXED_NULL;
        }

        public static RList exclude(int excludeIndex, RList orig) {
            return new RListExclusion(excludeIndex, orig);
        }

        public static RList subset(RList value, RInt index) {
            return new RListSubset(value, index);
        }
    }
}

