/*
 * Decompiled with CFR 0.152.
 */
package r.data;

import java.util.Arrays;
import r.Convert;
import r.Utils;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RRaw;
import r.data.RString;
import r.data.RSymbol;
import r.data.internal.LogicalImpl;
import r.data.internal.ScalarLogicalImpl;
import r.data.internal.View;

public interface RLogical
extends RArray {
    public static final String TYPE_STRING = "logical";
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    public static final int NA = Integer.MIN_VALUE;
    public static final ScalarLogicalImpl BOXED_TRUE = (ScalarLogicalImpl)RArray.RArrayUtils.markShared(RLogicalFactory.getScalar(1));
    public static final ScalarLogicalImpl BOXED_FALSE = (ScalarLogicalImpl)RArray.RArrayUtils.markShared(RLogicalFactory.getScalar(0));
    public static final ScalarLogicalImpl BOXED_NA = (ScalarLogicalImpl)RArray.RArrayUtils.markShared(RLogicalFactory.getScalar(Integer.MIN_VALUE));
    public static final LogicalImpl EMPTY = (LogicalImpl)RArray.RArrayUtils.markShared(RLogicalFactory.getUninitializedArray(0));
    public static final LogicalImpl EMPTY_NAMED_NA = (LogicalImpl)RArray.RArrayUtils.markShared(RLogicalFactory.getFor(new int[0], null, RArray.Names.create(new RSymbol[]{RSymbol.NA_SYMBOL})));
    public static final LogicalImpl NA_NAMED_NA = (LogicalImpl)RArray.RArrayUtils.markShared(RLogicalFactory.getFor(new int[]{Integer.MIN_VALUE}, null, RArray.Names.create(new RSymbol[]{RSymbol.NA_SYMBOL})));

    public int getLogical(int var1);

    public RLogical set(int var1, int var2);

    @Override
    public RLogical materialize();

    public static class RLogicalSubset
    extends View.RLogicalView
    implements RLogical {
        final RLogical value;
        final int vsize;
        final RInt index;
        final int isize;

        public RLogicalSubset(RLogical value, RInt index) {
            this.value = value;
            this.index = index;
            this.isize = index.size();
            this.vsize = value.size();
        }

        @Override
        public int size() {
            return this.isize;
        }

        @Override
        public int getLogical(int i) {
            int j = this.index.getInt(i);
            assert (Utils.check(j > 0));
            if (j > this.vsize) {
                return Integer.MIN_VALUE;
            }
            return this.value.getLogical(j - 1);
        }

        @Override
        public boolean isSharedReal() {
            return this.value.isShared() || this.index.isShared();
        }

        @Override
        public void ref() {
            this.value.ref();
            this.index.ref();
        }

        @Override
        public boolean dependsOn(RAny v) {
            return this.value.dependsOn(v) || this.index.dependsOn(v);
        }
    }

    public static class RLogicalExclusion
    extends View.RLogicalView
    implements RLogical {
        final RLogical orig;
        final int excludeIndex;
        final int size;

        public RLogicalExclusion(int excludeIndex, RLogical orig) {
            this.orig = orig;
            this.excludeIndex = excludeIndex;
            this.size = orig.size() - 1;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public int getLogical(int i) {
            assert (Utils.check(i < this.size, "bounds check"));
            assert (Utils.check(i >= 0, "bounds check"));
            if (i < this.excludeIndex) {
                return this.orig.getLogical(i);
            }
            return this.orig.getLogical(i + 1);
        }

        @Override
        public boolean isSharedReal() {
            return this.orig.isShared();
        }

        @Override
        public void ref() {
            this.orig.ref();
        }

        @Override
        public boolean dependsOn(RAny value) {
            return this.orig.dependsOn(value);
        }
    }

    public static class RRawView
    extends View.RRawProxy<RLogical>
    implements RRaw {
        public RRawView(RLogical orig) {
            super(orig);
        }

        @Override
        public byte getRaw(int i) {
            int ll = ((RLogical)this.orig).getLogical(i);
            return Convert.logical2raw(ll);
        }
    }

    public static class RIntView
    extends View.RIntProxy<RLogical>
    implements RInt {
        public RIntView(RLogical orig) {
            super(orig);
        }

        @Override
        public RComplex asComplex() {
            return ((RLogical)this.orig).asComplex();
        }

        @Override
        public RDouble asDouble() {
            return ((RLogical)this.orig).asDouble();
        }

        @Override
        public RLogical asLogical() {
            return (RLogical)this.orig;
        }

        @Override
        public RRaw asRaw() {
            return ((RLogical)this.orig).asRaw();
        }

        @Override
        public RComplex asComplex(Convert.ConversionStatus warn) {
            return ((RLogical)this.orig).asComplex();
        }

        @Override
        public RDouble asDouble(Convert.ConversionStatus warn) {
            return ((RLogical)this.orig).asDouble();
        }

        @Override
        public RLogical asLogical(Convert.ConversionStatus warn) {
            return (RLogical)this.orig;
        }

        @Override
        public RRaw asRaw(Convert.ConversionStatus warn) {
            return ((RLogical)this.orig).asRaw(warn);
        }

        @Override
        public int getInt(int i) {
            return Convert.logical2int(((RLogical)this.orig).getLogical(i));
        }
    }

    public static class RDoubleView
    extends View.RDoubleProxy<RLogical>
    implements RDouble {
        public RDoubleView(RLogical orig) {
            super(orig);
        }

        @Override
        public RComplex asComplex() {
            return ((RLogical)this.orig).asComplex();
        }

        @Override
        public RInt asInt() {
            return ((RLogical)this.orig).asInt();
        }

        @Override
        public RLogical asLogical() {
            return (RLogical)this.orig;
        }

        @Override
        public RRaw asRaw() {
            return ((RLogical)this.orig).asRaw();
        }

        @Override
        public RComplex asComplex(Convert.ConversionStatus warn) {
            return ((RLogical)this.orig).asComplex();
        }

        @Override
        public RInt asInt(Convert.ConversionStatus warn) {
            return ((RLogical)this.orig).asInt();
        }

        @Override
        public RLogical asLogical(Convert.ConversionStatus warn) {
            return (RLogical)this.orig;
        }

        @Override
        public RRaw asRaw(Convert.ConversionStatus warn) {
            return ((RLogical)this.orig).asRaw(warn);
        }

        @Override
        public double getDouble(int i) {
            int ll = ((RLogical)this.orig).getLogical(i);
            return Convert.logical2double(ll);
        }
    }

    public static class RComplexView
    extends View.RComplexProxy<RLogical>
    implements RComplex {
        public RComplexView(RLogical orig) {
            super(orig);
        }

        @Override
        public RDouble asDouble() {
            return ((RLogical)this.orig).asDouble();
        }

        @Override
        public RInt asInt() {
            return ((RLogical)this.orig).asInt();
        }

        @Override
        public RLogical asLogical() {
            return (RLogical)this.orig;
        }

        @Override
        public RRaw asRaw() {
            return ((RLogical)this.orig).asRaw();
        }

        @Override
        public RDouble asDouble(Convert.ConversionStatus warn) {
            return ((RLogical)this.orig).asDouble();
        }

        @Override
        public RInt asInt(Convert.ConversionStatus warn) {
            return ((RLogical)this.orig).asInt();
        }

        @Override
        public RLogical asLogical(Convert.ConversionStatus warn) {
            return (RLogical)this.orig;
        }

        @Override
        public RRaw asRaw(Convert.ConversionStatus warn) {
            return ((RLogical)this.orig).asRaw(warn);
        }

        @Override
        public double getReal(int i) {
            int ll = ((RLogical)this.orig).getLogical(i);
            return Convert.logical2double(ll);
        }

        @Override
        public double getImag(int i) {
            return 0.0;
        }
    }

    public static class RStringView
    extends View.RStringProxy<RLogical>
    implements RString {
        public RStringView(RLogical orig) {
            super(orig);
        }

        @Override
        public RLogical asLogical() {
            return (RLogical)this.orig;
        }

        @Override
        public RLogical asLogical(Convert.ConversionStatus warn) {
            return (RLogical)this.orig;
        }

        @Override
        public String getString(int i) {
            int v = ((RLogical)this.orig).getLogical(i);
            return Convert.logical2string(v);
        }
    }

    public static class RLogicalFactory {
        public static ScalarLogicalImpl getScalar(int value) {
            return new ScalarLogicalImpl(value);
        }

        public static RLogical getScalar(int value, int[] dimensions) {
            if (dimensions == null) {
                return new ScalarLogicalImpl(value);
            }
            return RLogicalFactory.getFor(new int[]{value}, dimensions, null);
        }

        public static RLogical getArray(int ... values) {
            if (values.length == 1) {
                return new ScalarLogicalImpl(values[0]);
            }
            return new LogicalImpl(values);
        }

        public static RLogical getArray(int[] values, int[] dimensions) {
            if (values.length == 1) {
                return new ScalarLogicalImpl(values[0]);
            }
            return new LogicalImpl(values, dimensions);
        }

        public static RLogical getUninitializedArray(int size) {
            if (size == 1) {
                return new ScalarLogicalImpl(0);
            }
            return new LogicalImpl(size);
        }

        public static RLogical getUninitializedNonScalarArray(int size) {
            return new LogicalImpl(size);
        }

        public static RLogical getUninitializedArray(int size, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
            if (size == 1 && dimensions == null && names == null && attributes == null) {
                return new ScalarLogicalImpl(0);
            }
            return new LogicalImpl(new int[size], dimensions, names, attributes, false);
        }

        public static RLogical getNAArray(int size) {
            return RLogicalFactory.getNAArray(size, null);
        }

        public static RLogical getNAArray(int size, int[] dimensions) {
            if (size == 1 && dimensions == null) {
                return BOXED_NA;
            }
            int[] content = new int[size];
            Arrays.fill(content, Integer.MIN_VALUE);
            return new LogicalImpl(content, dimensions, null, null, false);
        }

        public static LogicalImpl getMatrixFor(int[] values, int m, int n) {
            return new LogicalImpl(values, new int[]{m, n}, null, null, false);
        }

        public static RLogical copy(RLogical l) {
            if (l.size() == 1 && l.dimensions() == null && l.names() == null && l.attributes() == null) {
                return new ScalarLogicalImpl(l.getLogical(0));
            }
            return new LogicalImpl(l, false);
        }

        public static RLogical strip(RLogical v) {
            if (v.size() == 1) {
                return new ScalarLogicalImpl(v.getLogical(0));
            }
            return new LogicalImpl(v, true);
        }

        public static RLogical stripKeepNames(RLogical v) {
            RArray.Names names = v.names();
            if (v.size() == 1 && names == null) {
                return new ScalarLogicalImpl(v.getLogical(0));
            }
            return new LogicalImpl(v, null, names, null);
        }

        public static RLogical getFor(int[] values) {
            return RLogicalFactory.getFor(values, null, null);
        }

        public static RLogical getFor(int[] values, int[] dimensions, RArray.Names names) {
            if (values.length == 1 && dimensions == null && names == null) {
                return new ScalarLogicalImpl(values[0]);
            }
            return new LogicalImpl(values, dimensions, names, null, false);
        }

        public static RLogical getFor(int[] values, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
            if (values.length == 1 && dimensions == null && names == null && attributes == null) {
                return new ScalarLogicalImpl(values[0]);
            }
            return new LogicalImpl(values, dimensions, names, attributes, false);
        }

        public static RLogical getEmpty(boolean named) {
            return named ? EMPTY_NAMED_NA : EMPTY;
        }

        public static RLogical getNA(boolean named) {
            return (RLogical)((Object)(named ? NA_NAMED_NA : BOXED_NA));
        }

        public static RLogical exclude(int excludeIndex, RLogical orig) {
            int i;
            RArray.Names names = orig.names();
            if (names == null) {
                return new RLogicalExclusion(excludeIndex, orig);
            }
            int size = orig.size();
            int nsize = size - 1;
            int[] content = new int[nsize];
            for (i = 0; i < excludeIndex; ++i) {
                content[i] = orig.getLogical(i);
            }
            for (i = excludeIndex; i < nsize; ++i) {
                content[i] = orig.getLogical(i + 1);
            }
            return RLogicalFactory.getFor(content, null, names.exclude(excludeIndex));
        }

        public static RLogical subset(RLogical value, RInt index) {
            return new RLogicalSubset(value, index);
        }
    }

    public static class RLogicalUtils {
        public static int truesInRange(RLogical l, int from, int to) {
            int ntrue = 0;
            for (int i = from; i < to; ++i) {
                if (l.getLogical(i) != 1) continue;
                ++ntrue;
            }
            return ntrue;
        }

        public static int nonFalsesInRange(RLogical l, int from, int to) {
            int nnonfalse = 0;
            for (int i = from; i < to; ++i) {
                if (l.getLogical(i) == 0) continue;
                ++nnonfalse;
            }
            return nnonfalse;
        }

        public static RRaw logicalToRaw(RLogical value, Convert.ConversionStatus warn) {
            int size = value.size();
            byte[] content = new byte[size];
            for (int i = 0; i < size; ++i) {
                int lval = value.getLogical(i);
                content[i] = Convert.logical2raw(lval, warn);
            }
            return RRaw.RRawFactory.getFor(content, value.dimensions(), value.names());
        }
    }
}

