/*
 * Decompiled with CFR 0.152.
 */
package r.data;

import r.data.RAny;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.ast.Constant;
import r.nodes.exec.BaseR;
import r.nodes.exec.RNode;
import r.runtime.Frame;

public final class RPromise {
    private final RNode expression;
    private final Frame frame;
    private RAny value;
    private int bits;
    private static final int FORCE_DIRTY_MASK = 1;
    private static final int MISSING_DIRTY_MASK = 2;
    private static final int MISSING_MASK = 12;
    private static final int MISSING_SHIFT = 2;
    private static final int MISSING_BITS_DEFAULT = 8;
    private static final int MISSING_BITS_MISSING = 4;

    private RPromise(RNode expression, Frame frame, int bits) {
        this.expression = expression;
        this.frame = frame;
        this.bits = bits;
    }

    public static RPromise createNormal(RNode expression, Frame frame) {
        return new RPromise(expression, frame, 0);
    }

    public static RPromise createDefault(RNode expression, Frame frame) {
        return new RPromise(expression, frame, 8);
    }

    public static RPromise createMissing(final RSymbol argName, Frame frame) {
        final ASTNode errorAST = frame == null ? null : frame.function().getSource();
        BaseR errorExpression = new BaseR(new Constant(RSymbol.EMPTY_SYMBOL)){

            @Override
            public Object execute(Frame dummy) {
                throw RError.getArgumentMissing(errorAST, argName.pretty());
            }
        };
        return new RPromise(errorExpression, frame, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object forceOrGet() {
        if (this.value == null) {
            try {
                if (!this.markForceDirty()) {
                    throw RError.getPromiseCycle(this.expression.getAST());
                }
                this.value = (RAny)this.expression.execute(this.frame);
            }
            finally {
                this.markForceClean();
            }
            this.value.ref();
        }
        return this.value;
    }

    public static Object force(Object o) {
        if (o instanceof RPromise) {
            return ((RPromise)o).forceOrGet();
        }
        return o;
    }

    public boolean markForceDirty() {
        boolean old = (this.bits & 1) != 0;
        this.bits |= 1;
        return !old;
    }

    public void markForceClean() {
        this.bits &= 0xFFFFFFFE;
    }

    public boolean markMissingDirty() {
        boolean old = (this.bits & 2) != 0;
        this.bits |= 2;
        return !old;
    }

    public void markMissingClean() {
        this.bits &= 0xFFFFFFFD;
    }

    public boolean isDefault() {
        return (this.bits & 0xC) == 8;
    }

    public boolean isMissing() {
        return (this.bits & 0xC) == 4;
    }

    public RNode expression() {
        return this.expression;
    }

    public Frame frame() {
        return this.frame;
    }
}

