/*
 * Decompiled with CFR 0.152.
 */
package r.data;

import r.Convert;
import r.Utils;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RString;
import r.data.RSymbol;
import r.data.internal.RawImpl;
import r.data.internal.View;

public interface RRaw
extends RArray {
    public static final String TYPE_STRING = "raw";
    public static final byte ZERO = 0;
    public static final RawImpl EMPTY = (RawImpl)RArray.RArrayUtils.markShared(RRawFactory.getUninitializedArray(0));
    public static final RawImpl BOXED_ZERO = (RawImpl)RArray.RArrayUtils.markShared(RRawFactory.getScalar((byte)0));
    public static final RawImpl EMPTY_NAMED_NA = (RawImpl)RArray.RArrayUtils.markShared(RRawFactory.getFor(new byte[0], null, RArray.Names.create(new RSymbol[]{RSymbol.NA_SYMBOL})));
    public static final RawImpl ZERO_NAMED_NA = (RawImpl)RArray.RArrayUtils.markShared(RRawFactory.getFor(new byte[]{0}, null, RArray.Names.create(new RSymbol[]{RSymbol.NA_SYMBOL})));

    public byte getRaw(int var1);

    public RRaw set(int var1, byte var2);

    @Override
    public RRaw materialize();

    public static class RRawExclusion
    extends View.RRawView
    implements RRaw {
        final RRaw orig;
        final int excludeIndex;
        final int size;

        public RRawExclusion(int excludeIndex, RRaw orig) {
            this.orig = orig;
            this.excludeIndex = excludeIndex;
            this.size = orig.size() - 1;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public byte getRaw(int i) {
            assert (Utils.check(i < this.size, "bounds check"));
            assert (Utils.check(i >= 0, "bounds check"));
            if (i < this.excludeIndex) {
                return this.orig.getRaw(i);
            }
            return this.orig.getRaw(i + 1);
        }

        @Override
        public boolean isSharedReal() {
            return this.orig.isShared();
        }

        @Override
        public void ref() {
            this.orig.ref();
        }

        @Override
        public boolean dependsOn(RAny value) {
            return this.orig.dependsOn(value);
        }
    }

    public static class RRawSubset
    extends View.RRawView
    implements RRaw {
        final RRaw value;
        final int vsize;
        final RInt index;
        final int isize;

        public RRawSubset(RRaw value, RInt index) {
            this.value = value;
            this.index = index;
            this.isize = index.size();
            this.vsize = value.size();
        }

        @Override
        public int size() {
            return this.isize;
        }

        @Override
        public byte getRaw(int i) {
            int j = this.index.getInt(i);
            assert (Utils.check(j > 0));
            if (j > this.vsize) {
                return 0;
            }
            return this.value.getRaw(j - 1);
        }

        @Override
        public boolean isSharedReal() {
            return this.value.isShared() || this.index.isShared();
        }

        @Override
        public void ref() {
            this.value.ref();
            this.index.ref();
        }

        @Override
        public boolean dependsOn(RAny v) {
            return this.value.dependsOn(v) || this.index.dependsOn(v);
        }
    }

    public static class RLogicalView
    extends View.RLogicalProxy<RRaw>
    implements RLogical {
        public RLogicalView(RRaw orig) {
            super(orig);
        }

        @Override
        public int getLogical(int i) {
            return Convert.raw2logical(((RRaw)this.orig).getRaw(i));
        }
    }

    public static class RIntView
    extends View.RIntProxy<RRaw>
    implements RInt {
        public RIntView(RRaw orig) {
            super(orig);
        }

        @Override
        public RComplex asComplex() {
            return ((RRaw)this.orig).asComplex();
        }

        @Override
        public RDouble asDouble() {
            return ((RRaw)this.orig).asDouble();
        }

        @Override
        public RLogical asLogical() {
            return ((RRaw)this.orig).asLogical();
        }

        @Override
        public RRaw asRaw() {
            return (RRaw)this.orig;
        }

        @Override
        public RComplex asComplex(Convert.ConversionStatus warn) {
            return ((RRaw)this.orig).asComplex();
        }

        @Override
        public RDouble asDouble(Convert.ConversionStatus warn) {
            return ((RRaw)this.orig).asDouble();
        }

        @Override
        public RLogical asLogical(Convert.ConversionStatus warn) {
            return ((RRaw)this.orig).asLogical();
        }

        @Override
        public RRaw asRaw(Convert.ConversionStatus warn) {
            return (RRaw)this.orig;
        }

        @Override
        public int getInt(int i) {
            return Convert.raw2int(((RRaw)this.orig).getRaw(i));
        }
    }

    public static class RDoubleView
    extends View.RDoubleProxy<RRaw>
    implements RDouble {
        public RDoubleView(RRaw orig) {
            super(orig);
        }

        @Override
        public RComplex asComplex() {
            return ((RRaw)this.orig).asComplex();
        }

        @Override
        public RInt asInt() {
            return ((RRaw)this.orig).asInt();
        }

        @Override
        public RLogical asLogical() {
            return ((RRaw)this.orig).asLogical();
        }

        @Override
        public RRaw asRaw() {
            return (RRaw)this.orig;
        }

        @Override
        public RComplex asComplex(Convert.ConversionStatus warn) {
            return ((RRaw)this.orig).asComplex();
        }

        @Override
        public RInt asInt(Convert.ConversionStatus warn) {
            return ((RRaw)this.orig).asInt();
        }

        @Override
        public RLogical asLogical(Convert.ConversionStatus warn) {
            return ((RRaw)this.orig).asLogical();
        }

        @Override
        public RRaw asRaw(Convert.ConversionStatus warn) {
            return (RRaw)this.orig;
        }

        @Override
        public double getDouble(int i) {
            byte v = ((RRaw)this.orig).getRaw(i);
            return Convert.raw2double(v);
        }
    }

    public static class RComplexView
    extends View.RComplexProxy<RRaw>
    implements RComplex {
        public RComplexView(RRaw orig) {
            super(orig);
        }

        @Override
        public RDouble asDouble() {
            return ((RRaw)this.orig).asDouble();
        }

        @Override
        public RInt asInt() {
            return ((RRaw)this.orig).asInt();
        }

        @Override
        public RLogical asLogical() {
            return ((RRaw)this.orig).asLogical();
        }

        @Override
        public RRaw asRaw() {
            return (RRaw)this.orig;
        }

        @Override
        public RDouble asDouble(Convert.ConversionStatus warn) {
            return ((RRaw)this.orig).asDouble();
        }

        @Override
        public RInt asInt(Convert.ConversionStatus warn) {
            return ((RRaw)this.orig).asInt();
        }

        @Override
        public RLogical asLogical(Convert.ConversionStatus warn) {
            return ((RRaw)this.orig).asLogical();
        }

        @Override
        public RRaw asRaw(Convert.ConversionStatus warn) {
            return (RRaw)this.orig;
        }

        @Override
        public double getReal(int i) {
            byte v = ((RRaw)this.orig).getRaw(i);
            return Convert.raw2double(v);
        }

        @Override
        public double getImag(int i) {
            return 0.0;
        }
    }

    public static class RStringView
    extends View.RStringProxy<RRaw>
    implements RString {
        public RStringView(RRaw orig) {
            super(orig);
        }

        @Override
        public RRaw asRaw() {
            return (RRaw)this.orig;
        }

        @Override
        public RRaw asRaw(Convert.ConversionStatus warn) {
            return (RRaw)this.orig;
        }

        @Override
        public String getString(int i) {
            byte v = ((RRaw)this.orig).getRaw(i);
            return Convert.raw2string(v);
        }
    }

    public static class RRawFactory {
        public static RawImpl getScalar(byte value) {
            return RRawFactory.getFor(new byte[]{value});
        }

        public static RawImpl getArray(byte ... values) {
            return new RawImpl(values);
        }

        public static RawImpl getArray(byte[] values, int[] dimensions) {
            return new RawImpl(values, dimensions);
        }

        public static RawImpl getUninitializedArray(int size) {
            return new RawImpl(size);
        }

        public static RawImpl getUninitializedNonScalarArray(int size) {
            return new RawImpl(size);
        }

        public static RawImpl getUninitializedArray(int size, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
            return new RawImpl(new byte[size], dimensions, names, attributes, false);
        }

        public static RawImpl getZeroArray(int size) {
            return RRawFactory.getUninitializedArray(size);
        }

        public static RawImpl getMatrixFor(byte[] values, int m, int n) {
            return new RawImpl(values, new int[]{m, n}, null, null, false);
        }

        public static RawImpl copy(RRaw v) {
            return new RawImpl(v, false);
        }

        public static RawImpl strip(RRaw v) {
            return new RawImpl(v, true);
        }

        public static RawImpl stripKeepNames(RRaw v) {
            return new RawImpl(v, null, v.names(), null);
        }

        public static RawImpl getFor(byte[] values) {
            return RRawFactory.getFor(values, null, null);
        }

        public static RawImpl getFor(byte[] values, int[] dimensions, RArray.Names names) {
            return new RawImpl(values, dimensions, names, null, false);
        }

        public static RawImpl getFor(byte[] values, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
            return new RawImpl(values, dimensions, names, attributes, false);
        }

        public static RRaw getEmpty(boolean named) {
            return named ? EMPTY_NAMED_NA : EMPTY;
        }

        public static RRaw getZero(boolean named) {
            return named ? ZERO_NAMED_NA : BOXED_ZERO;
        }

        public static RRaw exclude(int excludeIndex, RRaw orig) {
            int i;
            RArray.Names names = orig.names();
            if (names == null) {
                return new RRawExclusion(excludeIndex, orig);
            }
            int size = orig.size();
            int nsize = size - 1;
            byte[] content = new byte[nsize];
            for (i = 0; i < excludeIndex; ++i) {
                content[i] = orig.getRaw(i);
            }
            for (i = excludeIndex; i < nsize; ++i) {
                content[i] = orig.getRaw(i + 1);
            }
            return RRawFactory.getFor(content, null, names.exclude(excludeIndex));
        }

        public static RRaw subset(RRaw value, RInt index) {
            return new RRawSubset(value, index);
        }
    }
}

