/*
 * Decompiled with CFR 0.152.
 */
package r.data;

import r.Convert;
import r.Utils;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RRaw;
import r.data.RSymbol;
import r.data.internal.ScalarStringImpl;
import r.data.internal.StringImpl;
import r.data.internal.View;

public interface RString
extends RArray {
    public static final String TYPE_STRING = "character";
    public static final StringImpl EMPTY = (StringImpl)RArray.RArrayUtils.markShared(RStringFactory.getUninitializedArray(0));
    public static final String NA = null;
    public static final ScalarStringImpl BOXED_NA = (ScalarStringImpl)RArray.RArrayUtils.markShared(RStringFactory.getScalar(NA));
    public static final ScalarStringImpl BOXED_DOT = (ScalarStringImpl)RArray.RArrayUtils.markShared(RStringFactory.getScalar("."));
    public static final StringImpl EMPTY_NAMED_NA = (StringImpl)RArray.RArrayUtils.markShared(RStringFactory.getFor(new String[0], null, RArray.Names.create(new RSymbol[]{RSymbol.NA_SYMBOL})));
    public static final StringImpl NA_NAMED_NA = (StringImpl)RArray.RArrayUtils.markShared(RStringFactory.getFor(new String[]{NA}, null, RArray.Names.create(new RSymbol[]{RSymbol.NA_SYMBOL})));

    public String getString(int var1);

    public RString set(int var1, String var2);

    @Override
    public RString materialize();

    public static class RStringSubset
    extends View.RStringView
    implements RString {
        final RString value;
        final int vsize;
        final RInt index;
        final int isize;

        public RStringSubset(RString value, RInt index) {
            this.value = value;
            this.index = index;
            this.isize = index.size();
            this.vsize = value.size();
        }

        @Override
        public int size() {
            return this.isize;
        }

        @Override
        public String getString(int i) {
            int j = this.index.getInt(i);
            if (j > this.vsize) {
                return NA;
            }
            return this.value.getString(j - 1);
        }

        @Override
        public boolean isSharedReal() {
            return this.value.isShared() || this.index.isShared();
        }

        @Override
        public void ref() {
            this.value.ref();
            this.index.ref();
        }

        @Override
        public boolean dependsOn(RAny v) {
            return this.value.dependsOn(v) || this.index.dependsOn(v);
        }
    }

    public static class RStringExclusion
    extends View.RStringView
    implements RString {
        final RString orig;
        final int excludeIndex;
        final int size;

        public RStringExclusion(int excludeIndex, RString orig) {
            this.orig = orig;
            this.excludeIndex = excludeIndex;
            this.size = orig.size() - 1;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public String getString(int i) {
            assert (Utils.check(i < this.size, "bounds check"));
            assert (Utils.check(i >= 0, "bounds check"));
            if (i < this.excludeIndex) {
                return this.orig.getString(i);
            }
            return this.orig.getString(i + 1);
        }

        @Override
        public boolean isSharedReal() {
            return this.orig.isShared();
        }

        @Override
        public void ref() {
            this.orig.ref();
        }

        @Override
        public boolean dependsOn(RAny value) {
            return this.orig.dependsOn(value);
        }
    }

    public static class RStringFactory {
        public static ScalarStringImpl getScalar(String value) {
            return new ScalarStringImpl(value);
        }

        public static RString getScalar(String value, int[] dimensions) {
            if (dimensions == null) {
                return new ScalarStringImpl(value);
            }
            return RStringFactory.getFor(new String[]{value}, dimensions, null);
        }

        public static RString getArray(String ... values) {
            if (values.length == 1) {
                return new ScalarStringImpl(values[0]);
            }
            return new StringImpl(values);
        }

        public static RString getArray(String[] values, int[] dimensions) {
            if (dimensions == null && values.length == 1) {
                return new ScalarStringImpl(values[0]);
            }
            return new StringImpl(values, dimensions);
        }

        public static RString getUninitializedArray(int size) {
            if (size == 1) {
                return new ScalarStringImpl(NA);
            }
            return new StringImpl(size);
        }

        public static RString getUninitializedNonScalarArray(int size) {
            return new StringImpl(size);
        }

        public static RString getUninitializedArray(int size, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
            if (size == 1 && dimensions == null && names == null && attributes == null) {
                return new ScalarStringImpl(NA);
            }
            return new StringImpl(new String[size], dimensions, names, attributes, false);
        }

        public static RString getNAArray(int size) {
            return RStringFactory.getNAArray(size, null);
        }

        public static RString getNAArray(int size, int[] dimensions) {
            if (size == 1 && dimensions == null) {
                return BOXED_NA;
            }
            String[] content = new String[size];
            for (int i = 0; i < size; ++i) {
                content[i] = NA;
            }
            return new StringImpl(content, dimensions, null, null, false);
        }

        public static StringImpl getMatrixFor(String[] values, int m, int n) {
            return new StringImpl(values, new int[]{m, n}, null, null, false);
        }

        public static RString copy(RString s) {
            if (s.size() == 1 && s.dimensions() == null && s.names() == null && s.attributes() == null) {
                return new ScalarStringImpl(s.getString(0));
            }
            return new StringImpl(s, false);
        }

        public static RString strip(RString v) {
            if (v.size() == 1) {
                return new ScalarStringImpl(v.getString(0));
            }
            return new StringImpl(v, true);
        }

        public static RString stripKeepNames(RString v) {
            RArray.Names names = v.names();
            if (v.size() == 1 && names == null) {
                return new ScalarStringImpl(v.getString(0));
            }
            return new StringImpl(v, null, names, null);
        }

        public static RString getFor(String[] values) {
            return RStringFactory.getFor(values, null, null);
        }

        public static RString getFor(String[] values, int[] dimensions, RArray.Names names) {
            if (values.length == 1 && dimensions == null && names == null) {
                return new ScalarStringImpl(values[0]);
            }
            return new StringImpl(values, dimensions, names, null, false);
        }

        public static RString getFor(String[] values, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
            if (values.length == 1 && dimensions == null && names == null && attributes == null) {
                return new ScalarStringImpl(values[0]);
            }
            return new StringImpl(values, dimensions, names, attributes, false);
        }

        public static RString getEmpty(boolean named) {
            return named ? EMPTY_NAMED_NA : EMPTY;
        }

        public static RString getNA(boolean named) {
            return (RString)((Object)(named ? NA_NAMED_NA : BOXED_NA));
        }

        public static RString exclude(int excludeIndex, RString orig) {
            int i;
            RArray.Names names = orig.names();
            if (names == null) {
                return new RStringExclusion(excludeIndex, orig);
            }
            int size = orig.size();
            int nsize = size - 1;
            String[] content = new String[nsize];
            for (i = 0; i < excludeIndex; ++i) {
                content[i] = orig.getString(i);
            }
            for (i = excludeIndex; i < nsize; ++i) {
                content[i] = orig.getString(i + 1);
            }
            return RStringFactory.getFor(content, null, names.exclude(excludeIndex));
        }

        public static RString subset(RString value, RInt index) {
            return new RStringSubset(value, index);
        }
    }

    public static class RStringUtils {
        public static RComplex stringToComplex(RString value, Convert.ConversionStatus warn) {
            int size = value.size();
            double[] content = new double[2 * size];
            for (int i = 0; i < size; ++i) {
                String str = value.getString(i);
                RComplex.Complex c = Convert.string2complex(str, warn);
                content[2 * i] = c.realValue();
                content[2 * i + 1] = c.imagValue();
            }
            return RComplex.RComplexFactory.getFor(content, value.dimensions(), value.names());
        }

        public static RDouble stringToDouble(RString value, Convert.ConversionStatus warn) {
            int size = value.size();
            double[] content = new double[size];
            for (int i = 0; i < size; ++i) {
                String str = value.getString(i);
                content[i] = Convert.string2double(str, warn);
            }
            return RDouble.RDoubleFactory.getFor(content, value.dimensions(), value.names());
        }

        public static RInt stringToInt(RString value, Convert.ConversionStatus warn) {
            int size = value.size();
            int[] content = new int[size];
            for (int i = 0; i < size; ++i) {
                String str = value.getString(i);
                content[i] = Convert.string2int(str, warn);
            }
            return RInt.RIntFactory.getFor(content, value.dimensions(), value.names());
        }

        public static RLogical stringToLogical(RString value, Convert.ConversionStatus warn) {
            int size = value.size();
            int[] content = new int[size];
            for (int i = 0; i < size; ++i) {
                String str = value.getString(i);
                content[i] = Convert.string2logical(str, warn);
            }
            return RLogical.RLogicalFactory.getFor(content, value.dimensions(), null);
        }

        public static RRaw stringToRaw(RString value, Convert.ConversionStatus warn) {
            int size = value.size();
            byte[] content = new byte[size];
            for (int i = 0; i < size; ++i) {
                String str = value.getString(i);
                content[i] = Convert.string2raw(str, warn);
            }
            return RRaw.RRawFactory.getFor(content, value.dimensions(), value.names());
        }
    }
}

