/*
 * Decompiled with CFR 0.152.
 */
package r.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import r.Convert;
import r.Utils;
import r.builtins.Primitives;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.REnvironment;
import r.data.RInt;
import r.data.RList;
import r.data.RLogical;
import r.data.RPromise;
import r.data.RRaw;
import r.data.RString;
import r.data.internal.BaseObject;

public final class RSymbol
extends BaseObject
implements RAny {
    private static final SymbolTable symbolTable = new SymbolTable();
    public static final RSymbol[] EMPTY_SYMBOL_ARRAY = new RSymbol[0];
    public static final RSymbol NA_SYMBOL = RSymbol.getSymbol(RString.NA);
    public static final RSymbol EMPTY_SYMBOL = RSymbol.getSymbol("");
    public static final RSymbol DROP_SYMBOL = RSymbol.getSymbol("drop");
    public static final RSymbol EXACT_SYMBOL = RSymbol.getSymbol("exact");
    public static final RSymbol THREE_DOTS_SYMBOL = RSymbol.getSymbol("...");
    public static final RSymbol NAMES_SYMBOL = RSymbol.getSymbol("names");
    public static final RSymbol DIM_SYMBOL = RSymbol.getSymbol("dim");
    public static final RSymbol TIMES_SYMBOL = RSymbol.getSymbol("times");
    final String name;
    Object value;
    int version;
    Primitives.PrimitiveEntry primitive;
    static final String TYPE_STRING = "symbol";

    private RSymbol(String identifier) {
        this.name = identifier;
    }

    public static RSymbol getSymbol(String name) {
        return RSymbol.symbolTable.get(name);
    }

    public static RSymbol[] listSymbols() {
        return RSymbol.symbolTable.list();
    }

    public static RSymbol[] listUsedSymbols(boolean includingHidden) {
        return RSymbol.symbolTable.listUsed(includingHidden);
    }

    public static RSymbol[] getSymbols(String[] names) {
        RSymbol[] symbols = new RSymbol[names.length];
        for (int i = 0; i < names.length; ++i) {
            symbols[i] = RSymbol.getSymbol(names[i]);
        }
        return symbols;
    }

    public static RSymbol[] getSymbols(RString names) {
        int size = names.size();
        RSymbol[] symbols = new RSymbol[size];
        for (int i = 0; i < size; ++i) {
            symbols[i] = RSymbol.getSymbol(names.getString(i));
        }
        return symbols;
    }

    @Override
    public String pretty() {
        if (this.name == RString.NA || this.name.length() == 0 || this.name.matches("^[a-zA-Z.]+[a-zA-Z0-9_.]*$")) {
            return this.name;
        }
        return "`" + this.name + "`";
    }

    public String name() {
        return this.name;
    }

    public int id() {
        return this.hashCode();
    }

    public int hash() {
        return this.hashCode();
    }

    public static void resetTable() {
        for (RSymbol s : RSymbol.symbolTable.table.values()) {
            s.value = null;
            s.version = 0;
        }
        RSymbol.getSymbol(".GlobalEnv").setValue(REnvironment.GLOBAL);
    }

    public static Set<String> symbols() {
        return RSymbol.symbolTable.table.keySet();
    }

    @Override
    public RRaw asRaw() {
        Utils.nyi();
        return null;
    }

    @Override
    public RLogical asLogical() {
        Utils.nyi();
        return null;
    }

    @Override
    public RInt asInt() {
        Utils.nyi();
        return null;
    }

    @Override
    public RDouble asDouble() {
        Utils.nyi();
        return null;
    }

    @Override
    public RComplex asComplex() {
        Utils.nyi();
        return null;
    }

    @Override
    public RString asString() {
        Utils.nyi();
        return null;
    }

    @Override
    public RList asList() {
        Utils.nyi();
        return null;
    }

    public Object getValue() {
        return RPromise.force(this.value);
    }

    public Object getValueNoForce() {
        return this.value;
    }

    public void setValue(Object val) {
        this.value = val;
    }

    public int getVersion() {
        return this.version;
    }

    public Primitives.PrimitiveEntry getPrimitiveEntry() {
        return this.primitive;
    }

    public void setPrimitiveEntry(Primitives.PrimitiveEntry primitive) {
        this.primitive = primitive;
    }

    public void markDirty() {
        ++this.version;
    }

    @Override
    public boolean isShared() {
        return false;
    }

    public int dotDotValue() {
        int len = this.name.length();
        if (len < 3 || this.name.charAt(0) != '.' || this.name.charAt(1) != '.') {
            return -1;
        }
        char c = this.name.charAt(2);
        if (c < '1' || c > '9') {
            return -1;
        }
        int ivalue = c - 48;
        for (int i = 3; i < len; ++i) {
            c = this.name.charAt(i);
            if (c < '0' || c > '9') {
                return -1;
            }
            ivalue *= 10;
            ivalue += c - 48;
        }
        return ivalue;
    }

    @Override
    public void ref() {
    }

    @Override
    public RSymbol stripAttributes() {
        return this;
    }

    @Override
    public RRaw asRaw(Convert.ConversionStatus warn) {
        throw Utils.nyi();
    }

    @Override
    public RLogical asLogical(Convert.ConversionStatus warn) {
        throw Utils.nyi();
    }

    @Override
    public RInt asInt(Convert.ConversionStatus warn) {
        throw Utils.nyi();
    }

    @Override
    public RDouble asDouble(Convert.ConversionStatus warn) {
        throw Utils.nyi();
    }

    @Override
    public RComplex asComplex(Convert.ConversionStatus warn) {
        throw Utils.nyi();
    }

    @Override
    public RString asString(Convert.ConversionStatus warn) {
        throw Utils.nyi();
    }

    @Override
    public String typeOf() {
        return TYPE_STRING;
    }

    @Override
    public RAny.Attributes attributes() {
        return null;
    }

    @Override
    public RAny.Attributes attributesRef() {
        return null;
    }

    @Override
    public RArray setAttributes(RAny.Attributes attributes) {
        Utils.nyi();
        return null;
    }

    @Override
    public boolean dependsOn(RAny value) {
        return false;
    }

    @Override
    public boolean isTemporary() {
        return false;
    }

    public String toString() {
        return this.name;
    }

    public boolean startsWith(RSymbol other) {
        return this.name.startsWith(other.name);
    }

    public boolean isHidden() {
        return this.name != null && this.name.length() > 0 && this.name.charAt(0) == '.';
    }

    static {
        RSymbol.getSymbol(".GlobalEnv").setValue(REnvironment.GLOBAL);
    }

    private static class SymbolTable {
        final Map<String, RSymbol> table = new HashMap<String, RSymbol>();

        private SymbolTable() {
        }

        private RSymbol get(String name) {
            RSymbol sym = this.table.get(name);
            if (sym == null) {
                sym = new RSymbol(name);
                this.table.put(name, sym);
            }
            return sym;
        }

        private RSymbol[] list() {
            RSymbol[] res = new RSymbol[this.table.size()];
            return this.table.values().toArray(res);
        }

        private RSymbol[] listUsed(boolean includingHidden) {
            Collection<RSymbol> values = this.table.values();
            ArrayList<RSymbol> used = new ArrayList<RSymbol>(values.size());
            for (RSymbol s : values) {
                if (s.getValue() == null || !includingHidden && s.isHidden()) continue;
                used.add(s);
            }
            return used.toArray(new RSymbol[used.size()]);
        }
    }
}

