/*
 * Decompiled with CFR 0.152.
 */
package r.data.internal;

import r.Convert;
import r.Utils;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RRaw;
import r.data.RString;
import r.data.internal.NonScalarArrayImpl;

public class ComplexImpl
extends NonScalarArrayImpl
implements RComplex {
    final double[] content;
    final int size;
    private static final String EMPTY_STRING = "complex(0)";
    private static final String NAMED_EMPTY_STRING = "named complex(0)";

    @Override
    public double[] getContent() {
        return this.content;
    }

    public ComplexImpl(double[] values, int[] dimensions, RArray.Names names, RAny.Attributes attributes, boolean doCopy) {
        if (doCopy) {
            this.content = new double[values.length];
            System.arraycopy(values, 0, this.content, 0, values.length);
        } else {
            this.content = values;
        }
        this.dimensions = dimensions;
        this.names = names;
        this.attributes = attributes;
        this.size = values.length / 2;
    }

    public ComplexImpl(double[] realValues, double[] imagValues, int[] dimensions) {
        Utils.check(realValues.length == imagValues.length);
        this.size = realValues.length;
        this.content = new double[this.size * 2];
        for (int i = 0; i < this.size; ++i) {
            this.content[2 * i] = realValues[i];
            this.content[2 * i + 1] = imagValues[i];
        }
        this.dimensions = dimensions;
    }

    public ComplexImpl(double[] values, int[] dimensions) {
        this(values, dimensions, null, null, true);
    }

    public ComplexImpl(double[] values) {
        this(values, null, null, null, true);
    }

    public ComplexImpl(int size) {
        this.content = new double[2 * size];
        this.size = size;
    }

    public ComplexImpl(RComplex c, boolean valuesOnly) {
        this.size = c.size();
        this.content = new double[2 * this.size];
        for (int i = 0; i < this.size; ++i) {
            this.content[2 * i] = c.getReal(i);
            this.content[2 * i + 1] = c.getImag(i);
        }
        if (!valuesOnly) {
            this.dimensions = c.dimensions();
            this.names = c.names();
            this.attributes = c.attributes();
        }
    }

    public ComplexImpl(RComplex c, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
        this.size = c.size();
        this.content = new double[2 * this.size];
        for (int i = 0; i < this.size; ++i) {
            this.content[2 * i] = c.getReal(i);
            this.content[2 * i + 1] = c.getImag(i);
        }
        this.dimensions = dimensions;
        this.names = names;
        this.attributes = attributes;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Object get(int i) {
        return new RComplex.Complex(this.getReal(i), this.getImag(i));
    }

    @Override
    public RAny boxedGet(int i) {
        return RComplex.RComplexFactory.getScalar(this.getReal(i), this.getImag(i));
    }

    @Override
    public boolean isNAorNaN(int i) {
        return RComplex.RComplexUtils.eitherIsNAorNaN(this.getReal(i), this.getImag(i));
    }

    @Override
    public RArray set(int i, Object val) {
        RComplex.Complex c = (RComplex.Complex)val;
        return this.set(i, c.realValue(), c.imagValue());
    }

    @Override
    public RComplex set(int i, double real, double imag) {
        this.content[2 * i] = real;
        this.content[2 * i + 1] = imag;
        return this;
    }

    @Override
    public double getReal(int i) {
        return this.content[2 * i];
    }

    @Override
    public double getImag(int i) {
        return this.content[2 * i + 1];
    }

    @Override
    public ComplexImpl materialize() {
        return this;
    }

    @Override
    public String pretty() {
        StringBuilder str = new StringBuilder();
        if (this.dimensions != null) {
            str.append(this.arrayPretty());
        } else if (this.size == 0) {
            str.append(this.names() == null ? EMPTY_STRING : NAMED_EMPTY_STRING);
        } else if (this.names() != null) {
            str.append(this.namedPretty());
        } else {
            str.append(Convert.prettyNA(Convert.complex2string(this.content[0], this.content[1])));
            for (int i = 1; i < this.size; ++i) {
                str.append(", ");
                str.append(Convert.prettyNA(Convert.complex2string(this.content[2 * i], this.content[2 * i + 1])));
            }
        }
        str.append(this.attributesPretty());
        return str.toString();
    }

    @Override
    public RRaw asRaw() {
        return this.asRaw(null);
    }

    @Override
    public RRaw asRaw(Convert.ConversionStatus warn) {
        return RComplex.RComplexUtils.complexToRaw(this, warn);
    }

    @Override
    public RLogical asLogical() {
        return new RComplex.RLogicalView(this);
    }

    @Override
    public RLogical asLogical(Convert.ConversionStatus warn) {
        return this.asLogical();
    }

    @Override
    public RInt asInt() {
        return this.asInt(null);
    }

    @Override
    public RInt asInt(Convert.ConversionStatus warn) {
        return RComplex.RComplexUtils.complex2int(this, warn);
    }

    @Override
    public RDouble asDouble() {
        return this.asDouble(null);
    }

    @Override
    public RDouble asDouble(Convert.ConversionStatus warn) {
        return RComplex.RComplexUtils.complex2double(this, warn);
    }

    @Override
    public RComplex asComplex() {
        return this;
    }

    @Override
    public RComplex asComplex(Convert.ConversionStatus warn) {
        return this;
    }

    @Override
    public RString asString() {
        return new RComplex.RStringView(this);
    }

    @Override
    public RString asString(Convert.ConversionStatus warn) {
        return this.asString();
    }

    @Override
    public RArray subset(RInt index) {
        return RComplex.RComplexFactory.subset(this, index);
    }

    @Override
    public String typeOf() {
        return "complex";
    }

    @Override
    public ComplexImpl doStrip() {
        return new ComplexImpl(this.content, null, null, null, false);
    }

    @Override
    public ComplexImpl doStripKeepNames() {
        return new ComplexImpl(this.content, null, this.names, null, false);
    }
}

