/*
 * Decompiled with CFR 0.152.
 */
package r.data.internal;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.StringTokenizer;
import r.Utils;
import r.data.internal.ConnectionMode;
import r.errors.RError;
import r.nodes.ast.ASTNode;

public abstract class Connection {
    String description;
    ConnectionMode mode;
    ConnectionMode defaultMode;
    public static final int READ_BUFFER_SIZE = 8192;

    Connection(String description, ConnectionMode mode, ConnectionMode defaultMode) {
        this.description = description;
        this.mode = mode;
        this.defaultMode = defaultMode;
    }

    public abstract boolean isOpen();

    public ConnectionMode currentMode() {
        return this.mode;
    }

    public String description() {
        return this.description;
    }

    public abstract void open(ConnectionMode var1) throws IOException;

    public abstract void open(ConnectionMode var1, ASTNode var2);

    public abstract void flush(ASTNode var1);

    public abstract void close(ASTNode var1);

    public abstract BufferedReader reader(ASTNode var1);

    public abstract OutputStream output(ASTNode var1);

    public void finalize() throws Throwable {
        if (this.isOpen()) {
            this.close(null);
        }
        super.finalize();
    }

    public static class PipeConnection
    extends Connection {
        Process process;
        ProcessBuilder processBuilder;
        InputStream input;
        OutputStream output;
        BufferedReader reader;

        PipeConnection(String command, ConnectionMode mode, ConnectionMode defaultMode) {
            super(command, mode, defaultMode);
            StringTokenizer st = new StringTokenizer(command);
            String[] commandArray = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                commandArray[i] = st.nextToken();
                ++i;
            }
            this.processBuilder = new ProcessBuilder(commandArray);
        }

        public static PipeConnection createUnopened(String command, ConnectionMode defaultMode) {
            return new PipeConnection(command, null, defaultMode);
        }

        public static PipeConnection createOpened(String command, ConnectionMode mode) throws IOException {
            PipeConnection con = new PipeConnection(command, null, null);
            con.open(mode);
            return con;
        }

        public static PipeConnection createOpened(String command, ConnectionMode mode, ASTNode ast) {
            try {
                return PipeConnection.createOpened(command, mode);
            }
            catch (IOException e) {
                throw RError.getCannotOpenPipe(ast, command, e.toString());
            }
        }

        @Override
        public void open(ConnectionMode openMode) throws IOException {
            if (openMode.read()) {
                this.processBuilder.redirectOutput(ProcessBuilder.Redirect.PIPE);
            } else {
                this.processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
            }
            if (openMode.write() || openMode.append()) {
                this.processBuilder.redirectInput(ProcessBuilder.Redirect.PIPE);
            } else {
                this.processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
            }
            this.process = this.processBuilder.start();
            this.mode = openMode;
        }

        @Override
        public void open(ConnectionMode openMode, ASTNode ast) {
            try {
                this.open(openMode);
            }
            catch (IOException e) {
                throw RError.getCannotOpenPipe(ast, this.description, e.toString());
            }
        }

        @Override
        public BufferedReader reader(ASTNode ast) {
            if (this.reader != null) {
                return this.reader;
            }
            Utils.check(this.process != null);
            if (this.input == null) {
                this.input = this.process.getInputStream();
            }
            this.reader = new BufferedReader(new InputStreamReader(this.input), 8192);
            return this.reader;
        }

        @Override
        public OutputStream output(ASTNode ast) {
            if (this.output != null) {
                return this.output;
            }
            Utils.check(this.process != null);
            this.output = this.process.getOutputStream();
            return this.output;
        }

        @Override
        public void flush(ASTNode ast) {
            try {
                if (this.output != null) {
                    this.output.flush();
                }
            }
            catch (IOException e) {
                throw RError.getGenericError(ast, e.toString());
            }
        }

        @Override
        public void close(ASTNode ast) {
            try {
                if (this.process != null) {
                    if (this.output != null) {
                        this.output.close();
                    }
                    this.process.waitFor();
                    this.process = null;
                }
                this.output = null;
                this.input = null;
                this.reader = null;
                this.mode = null;
            }
            catch (InterruptedException e) {
                throw RError.getGenericError(ast, e.toString());
            }
            catch (IOException e) {
                throw RError.getGenericError(ast, e.toString());
            }
        }

        @Override
        public boolean isOpen() {
            return this.process != null;
        }
    }

    public static class FileConnection
    extends Connection {
        RandomAccessFile file;
        FileInputStream input;
        FileOutputStream output;
        BufferedReader reader;

        FileConnection(String name, ConnectionMode mode, ConnectionMode defaultMode) {
            super(name, mode, defaultMode);
        }

        public static FileConnection createUnopened(String name, ConnectionMode defaultMode) {
            return new FileConnection(name, null, defaultMode);
        }

        public static FileConnection createOpened(String name, ConnectionMode mode) throws IOException {
            FileConnection con = new FileConnection(name, null, null);
            con.open(mode);
            return con;
        }

        public static FileConnection createOpened(String name, ConnectionMode mode, ASTNode ast) {
            try {
                return FileConnection.createOpened(name, mode);
            }
            catch (IOException e) {
                throw RError.getCannotOpenFile(ast, name, e.toString());
            }
        }

        @Override
        public void open(ConnectionMode openMode) throws IOException {
            boolean needsWrite = openMode.write() || openMode.append();
            this.file = new RandomAccessFile(this.description, !needsWrite ? "r" : "rw");
            this.mode = openMode;
        }

        @Override
        public void open(ConnectionMode openMode, ASTNode ast) {
            try {
                this.open(openMode);
            }
            catch (IOException e) {
                throw RError.getCannotOpenFile(ast, this.description, e.toString());
            }
        }

        @Override
        public BufferedReader reader(ASTNode ast) {
            if (this.reader != null) {
                return this.reader;
            }
            Utils.check(this.file != null);
            try {
                if (this.input == null) {
                    this.input = new FileInputStream(this.file.getFD());
                }
                int bufSize = 8192;
                if (this.mode.write() || this.mode.append()) {
                    bufSize = 1;
                }
                this.reader = new BufferedReader(new InputStreamReader(this.input), bufSize);
                return this.reader;
            }
            catch (IOException e) {
                throw RError.getGenericError(ast, e.toString());
            }
        }

        @Override
        public OutputStream output(ASTNode ast) {
            if (this.output != null) {
                return this.output;
            }
            Utils.check(this.file != null);
            try {
                this.output = new FileOutputStream(this.file.getFD());
                return this.output;
            }
            catch (IOException e) {
                throw RError.getGenericError(ast, e.toString());
            }
        }

        @Override
        public void flush(ASTNode ast) {
            try {
                if (this.output != null) {
                    this.output.flush();
                }
            }
            catch (IOException e) {
                throw RError.getGenericError(ast, e.toString());
            }
        }

        @Override
        public void close(ASTNode ast) {
            try {
                if (this.file != null) {
                    this.file.close();
                    this.file = null;
                }
                this.output = null;
                this.input = null;
                this.reader = null;
                this.mode = null;
            }
            catch (IOException e) {
                throw RError.getGenericError(ast, e.toString());
            }
        }

        @Override
        public boolean isOpen() {
            return this.file != null;
        }
    }
}

