/*
 * Decompiled with CFR 0.152.
 */
package r.data.internal;

import java.util.HashMap;

public class ConnectionMode {
    boolean read;
    boolean write;
    boolean append;
    boolean binary;
    boolean truncate;
    static final HashMap<String, ConnectionMode> modes = new HashMap();

    ConnectionMode(boolean read, boolean write, boolean append, boolean binary, boolean truncate) {
        this.read = read;
        this.write = write;
        this.append = append;
        this.binary = binary;
        this.truncate = truncate;
    }

    public static ConnectionMode get(String mode) {
        return modes.get(mode);
    }

    public static void add(String mode, ConnectionMode modeObject) {
        modes.put(mode, modeObject);
    }

    public boolean read() {
        return this.read;
    }

    public boolean write() {
        return this.write;
    }

    public boolean append() {
        return this.append;
    }

    public boolean binary() {
        return this.binary;
    }

    public boolean text() {
        return !this.binary;
    }

    public boolean truncate() {
        return this.truncate;
    }

    static {
        ConnectionMode.add("r", new ConnectionMode(true, false, false, false, false));
        ConnectionMode.add("rt", new ConnectionMode(true, false, false, false, false));
        ConnectionMode.add("w", new ConnectionMode(false, true, false, false, false));
        ConnectionMode.add("wt", new ConnectionMode(false, true, false, false, false));
        ConnectionMode.add("a", new ConnectionMode(false, false, true, false, false));
        ConnectionMode.add("at", new ConnectionMode(false, false, true, false, false));
        ConnectionMode.add("rb", new ConnectionMode(true, false, false, true, false));
        ConnectionMode.add("wb", new ConnectionMode(false, true, false, true, false));
        ConnectionMode.add("ab", new ConnectionMode(false, false, true, true, false));
        ConnectionMode.add("r+", new ConnectionMode(true, true, false, false, false));
        ConnectionMode.add("r+b", new ConnectionMode(true, true, false, true, false));
        ConnectionMode.add("w+", new ConnectionMode(true, true, false, false, true));
        ConnectionMode.add("w+b", new ConnectionMode(true, true, false, true, false));
        ConnectionMode.add("a+", new ConnectionMode(true, false, true, false, false));
        ConnectionMode.add("a+b", new ConnectionMode(true, false, true, true, false));
    }
}

