/*
 * Decompiled with CFR 0.152.
 */
package r.data.internal;

import r.Convert;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RRaw;
import r.data.RString;
import r.data.internal.NonScalarArrayImpl;

public class DoubleImpl
extends NonScalarArrayImpl
implements RDouble {
    final double[] content;
    private static final String EMPTY_STRING = "numeric(0)";
    private static final String NAMED_EMPTY_STRING = "named numeric(0)";

    @Override
    public double[] getContent() {
        return this.content;
    }

    public DoubleImpl(double[] values, int[] dimensions, RArray.Names names, RAny.Attributes attributes, boolean doCopy) {
        if (doCopy) {
            this.content = new double[values.length];
            System.arraycopy(values, 0, this.content, 0, values.length);
        } else {
            this.content = values;
        }
        this.dimensions = dimensions;
        this.names = names;
        this.attributes = attributes;
    }

    public DoubleImpl(double[] values, int[] dimensions, RArray.Names names) {
        this(values, dimensions, names, null, true);
    }

    public DoubleImpl(double[] values) {
        this(values, null, null, null, true);
    }

    public DoubleImpl(int size) {
        this.content = new double[size];
    }

    public DoubleImpl(RDouble d, boolean valuesOnly) {
        this.content = new double[d.size()];
        for (int i = 0; i < this.content.length; ++i) {
            this.content[i] = d.getDouble(i);
        }
        if (!valuesOnly) {
            this.dimensions = d.dimensions();
            this.names = d.names();
            this.attributes = d.attributes();
        }
    }

    public DoubleImpl(RDouble d, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
        this.content = new double[d.size()];
        for (int i = 0; i < this.content.length; ++i) {
            this.content[i] = d.getDouble(i);
        }
        this.dimensions = dimensions;
        this.names = names;
        this.attributes = attributes;
    }

    @Override
    public int size() {
        return this.content.length;
    }

    @Override
    public Object get(int i) {
        return this.content[i];
    }

    @Override
    public RAny boxedGet(int i) {
        return RDouble.RDoubleFactory.getScalar(this.getDouble(i));
    }

    @Override
    public boolean isNAorNaN(int i) {
        return RDouble.RDoubleUtils.isNAorNaN(this.content[i]);
    }

    @Override
    public RArray set(int i, Object val) {
        return this.set(i, (Double)val);
    }

    @Override
    public RDouble set(int i, double val) {
        this.content[i] = val;
        return this;
    }

    @Override
    public double getDouble(int i) {
        return this.content[i];
    }

    @Override
    public DoubleImpl materialize() {
        return this;
    }

    @Override
    public String pretty() {
        StringBuilder str = new StringBuilder();
        if (this.dimensions != null) {
            str.append(this.arrayPretty());
        } else if (this.content.length == 0) {
            str.append(this.names() == null ? EMPTY_STRING : NAMED_EMPTY_STRING);
        } else if (this.names() != null) {
            str.append(this.namedPretty());
        } else {
            str.append(Convert.prettyNA(Convert.double2string(this.content[0])));
            for (int i = 1; i < this.content.length; ++i) {
                str.append(", ");
                str.append(Convert.prettyNA(Convert.double2string(this.content[i])));
            }
        }
        str.append(this.attributesPretty());
        return str.toString();
    }

    @Override
    public RRaw asRaw() {
        return new RDouble.RRawView(this);
    }

    @Override
    public RRaw asRaw(Convert.ConversionStatus warn) {
        return RDouble.RDoubleUtils.doubleToRaw(this, warn);
    }

    @Override
    public RLogical asLogical() {
        return new RDouble.RLogicalView(this);
    }

    @Override
    public RLogical asLogical(Convert.ConversionStatus warn) {
        return this.asLogical();
    }

    @Override
    public RInt asInt() {
        return new RDouble.RIntView(this);
    }

    @Override
    public RInt asInt(Convert.ConversionStatus warn) {
        return RDouble.RDoubleUtils.double2int(this, warn);
    }

    @Override
    public RDouble asDouble() {
        return this;
    }

    @Override
    public RDouble asDouble(Convert.ConversionStatus warn) {
        return this;
    }

    @Override
    public RComplex asComplex() {
        return new RDouble.RComplexView(this);
    }

    @Override
    public RComplex asComplex(Convert.ConversionStatus warn) {
        return this.asComplex();
    }

    @Override
    public RString asString() {
        return new RDouble.RStringView(this);
    }

    @Override
    public RString asString(Convert.ConversionStatus warn) {
        return this.asString();
    }

    @Override
    public RArray subset(RInt index) {
        return RDouble.RDoubleFactory.subset(this, index);
    }

    @Override
    public String typeOf() {
        return "double";
    }

    @Override
    public DoubleImpl doStrip() {
        return new DoubleImpl(this.content, null, null, null, false);
    }

    @Override
    public DoubleImpl doStripKeepNames() {
        return new DoubleImpl(this.content, null, this.names, null, false);
    }
}

