/*
 * Decompiled with CFR 0.152.
 */
package r.data.internal;

import java.util.ArrayList;
import r.Convert;
import r.Utils;
import r.builtins.Primitives;
import r.data.RAny;
import r.data.RArray;
import r.data.RCallable;
import r.data.RComplex;
import r.data.RDouble;
import r.data.REnvironment;
import r.data.RInt;
import r.data.RList;
import r.data.RLogical;
import r.data.RPromise;
import r.data.RRaw;
import r.data.RString;
import r.data.RSymbol;
import r.data.internal.BaseObject;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.runtime.Frame;
import r.runtime.NoSlotsFrame;

public class EnvironmentImpl
extends BaseObject
implements REnvironment {
    final Frame frame;

    public EnvironmentImpl(Frame frame) {
        this.frame = frame;
    }

    @Override
    public Frame frame() {
        return this.frame;
    }

    @Override
    public String pretty() {
        Utils.check(this.frame != null);
        return "<environment: " + this.frame + "(" + this + ")>";
    }

    @Override
    public String typeOf() {
        return "environment";
    }

    @Override
    public RAny stripAttributes() {
        Utils.nyi();
        return null;
    }

    @Override
    public RRaw asRaw() {
        Utils.nyi();
        return null;
    }

    @Override
    public RLogical asLogical() {
        Utils.nyi();
        return null;
    }

    @Override
    public RInt asInt() {
        Utils.nyi();
        return null;
    }

    @Override
    public RDouble asDouble() {
        Utils.nyi();
        return null;
    }

    @Override
    public RComplex asComplex() {
        Utils.nyi();
        return null;
    }

    @Override
    public RString asString() {
        Utils.nyi();
        return null;
    }

    @Override
    public RList asList() {
        Utils.nyi();
        return null;
    }

    @Override
    public RRaw asRaw(Convert.ConversionStatus warn) {
        Utils.nyi();
        return null;
    }

    @Override
    public RLogical asLogical(Convert.ConversionStatus warn) {
        Utils.nyi();
        return null;
    }

    @Override
    public RInt asInt(Convert.ConversionStatus warn) {
        Utils.nyi();
        return null;
    }

    @Override
    public RDouble asDouble(Convert.ConversionStatus warn) {
        Utils.nyi();
        return null;
    }

    @Override
    public RComplex asComplex(Convert.ConversionStatus warn) {
        Utils.nyi();
        return null;
    }

    @Override
    public RString asString(Convert.ConversionStatus warn) {
        Utils.nyi();
        return null;
    }

    @Override
    public void ref() {
    }

    @Override
    public boolean isShared() {
        return false;
    }

    @Override
    public boolean isTemporary() {
        return true;
    }

    @Override
    public void assign(RSymbol name, RAny value, boolean inherits, ASTNode ast) {
        if (!inherits) {
            this.frame.localWrite(name, value);
            return;
        }
        this.frame.reflectiveInheritsWrite(name, value);
    }

    @Override
    public void delayedAssign(RSymbol name, RPromise value, ASTNode ast) {
        this.frame.localWriteNoRef(name, value);
    }

    @Override
    public RAny get(RSymbol name, boolean inherits) {
        if (!inherits) {
            return (RAny)this.frame.localRead(name);
        }
        return (RAny)Utils.cast(this.frame.read(name));
    }

    @Override
    public Object localGetNotForcing(RSymbol name) {
        return this.frame.localReadNotForcing(name);
    }

    @Override
    public boolean exists(RSymbol name, boolean inherits) {
        if (!inherits) {
            return this.frame.localExists(name);
        }
        return this.frame.exists(name);
    }

    @Override
    public RCallable match(RSymbol name) {
        return Frame.match(this.frame, name);
    }

    public static RSymbol[] removeHidden(RSymbol[] symbols) {
        ArrayList<RSymbol> nonHidden = new ArrayList<RSymbol>(symbols.length);
        for (RSymbol s : symbols) {
            if (s.isHidden()) continue;
            nonHidden.add(s);
        }
        return nonHidden.toArray(new RSymbol[nonHidden.size()]);
    }

    @Override
    public RSymbol[] ls(boolean includingHidden) {
        RSymbol[] symbols = this.frame.listSymbols();
        if (!includingHidden) {
            return EnvironmentImpl.removeHidden(symbols);
        }
        return symbols;
    }

    public static Object readFromTopLevel(RSymbol symbol) {
        return symbol.getValue();
    }

    @Override
    public RAny.Attributes attributes() {
        return null;
    }

    @Override
    public RAny.Attributes attributesRef() {
        return null;
    }

    @Override
    public RArray setAttributes(RAny.Attributes attributes) {
        Utils.nyi();
        return null;
    }

    @Override
    public boolean dependsOn(RAny value) {
        return false;
    }

    public static class Empty
    extends EnvironmentImpl
    implements REnvironment {
        public Empty() {
            super(null);
        }

        @Override
        public void assign(RSymbol name, RAny value, boolean inherits, ASTNode ast) {
            throw RError.getAssignEmpty(ast);
        }

        @Override
        public void delayedAssign(RSymbol name, RPromise value, ASTNode ast) {
            throw RError.getAssignEmpty(ast);
        }

        @Override
        public RAny get(RSymbol name, boolean inherits) {
            return null;
        }

        @Override
        public Object localGetNotForcing(RSymbol name) {
            return null;
        }

        @Override
        public boolean exists(RSymbol name, boolean inherits) {
            return false;
        }

        @Override
        public RCallable match(RSymbol name) {
            return null;
        }

        @Override
        public RSymbol[] ls(boolean includingHidden) {
            return RSymbol.EMPTY_SYMBOL_ARRAY;
        }

        @Override
        public String pretty() {
            return "<environment: R_EmptyEnv>";
        }
    }

    public static class Global
    extends EnvironmentImpl
    implements REnvironment {
        public Global() {
            super(null);
        }

        @Override
        public void assign(RSymbol name, RAny value, boolean inherits, ASTNode ast) {
            Frame.writeToTopLevelCondRef(name, value);
        }

        @Override
        public void delayedAssign(RSymbol name, RPromise value, ASTNode ast) {
            Frame.writeToTopLevelNoRef(name, value);
        }

        @Override
        public RAny get(RSymbol name, boolean inherits) {
            if (!inherits) {
                return (RAny)Utils.cast(Global.readFromTopLevel(name));
            }
            RAny res = (RAny)Utils.cast(Global.readFromTopLevel(name));
            if (res != null) {
                return res;
            }
            return Primitives.getBuiltIn(name, null);
        }

        @Override
        public Object localGetNotForcing(RSymbol name) {
            return name.getValueNoForce();
        }

        @Override
        public boolean exists(RSymbol name, boolean inherits) {
            if (!inherits) {
                return Global.readFromTopLevel(name) != null;
            }
            RAny res = (RAny)Utils.cast(Global.readFromTopLevel(name));
            if (res != null) {
                return true;
            }
            return Primitives.hasCallFactory(name, null);
        }

        @Override
        public RCallable match(RSymbol name) {
            Object res = Global.readFromTopLevel(name);
            if (res != null && res instanceof RCallable) {
                return (RCallable)res;
            }
            return Primitives.getBuiltIn(name, null);
        }

        @Override
        public RSymbol[] ls(boolean includingHidden) {
            return RSymbol.listUsedSymbols(includingHidden);
        }

        @Override
        public String pretty() {
            return "<environment: R_GlobalEnv>";
        }
    }

    public static class Custom
    extends EnvironmentImpl
    implements REnvironment {
        public Custom(Frame frame) {
            super(frame);
            assert (Utils.check(frame != null));
        }

        public static Custom create(Frame parentFrame, REnvironment rootEnvironment, boolean hash, int hashSize) {
            NoSlotsFrame newFrame = new NoSlotsFrame(new REnvironment.DummyFunction(), parentFrame);
            if (hash) {
                newFrame.installHashedExtension(hashSize);
            } else {
                newFrame.installExtension();
            }
            newFrame.rootEnvironment(rootEnvironment);
            return new Custom(newFrame);
        }

        public static Frame createForList(Frame parentFrame, RList list) {
            NoSlotsFrame newFrame = new NoSlotsFrame(new REnvironment.DummyFunction(), parentFrame);
            int size = list.size();
            newFrame.installHashedExtension(size);
            RArray.Names names = list.names();
            if (names != null) {
                RSymbol[] symbols = names.sequence();
                for (int i = 0; i < size; ++i) {
                    RSymbol s = symbols[i];
                    if (s == RSymbol.NA_SYMBOL || s == RSymbol.EMPTY_SYMBOL) continue;
                    newFrame.localWrite(s, list.getRAnyRef(i));
                }
            }
            return newFrame;
        }

        @Override
        public void assign(RSymbol name, RAny value, boolean inherits, ASTNode ast) {
            if (!inherits) {
                this.frame.customLocalWrite(name, value);
                return;
            }
            this.frame.customReflectiveInheritsWrite(name, value);
        }

        @Override
        public void delayedAssign(RSymbol name, RPromise value, ASTNode ast) {
            this.frame.customLocalWriteNoRef(name, value);
        }

        @Override
        public RAny get(RSymbol name, boolean inherits) {
            if (!inherits) {
                return (RAny)this.frame.customLocalRead(name);
            }
            return (RAny)Utils.cast(this.frame.customRead(name));
        }

        @Override
        public Object localGetNotForcing(RSymbol name) {
            return this.frame.customLocalReadNoForcing(name);
        }

        @Override
        public boolean exists(RSymbol name, boolean inherits) {
            if (!inherits) {
                return this.frame.customLocalExists(name);
            }
            return this.frame.customExists(name);
        }

        @Override
        public RCallable match(RSymbol name) {
            Utils.nyi("generic match");
            return null;
        }
    }
}

