/*
 * Decompiled with CFR 0.152.
 */
package r.data.internal;

import r.Utils;
import r.builtins.Return;
import r.data.RClosure;
import r.data.RFunction;
import r.data.RPromise;
import r.data.RSymbol;
import r.data.internal.ClosureImpl;
import r.nodes.ast.Function;
import r.nodes.exec.BaseR;
import r.nodes.exec.RNode;
import r.runtime.Frame;
import r.runtime.FrameDescriptor;
import r.runtime.GenericFrame;
import r.runtime.SmallFrame;

public class FunctionImpl
extends BaseR
implements RFunction {
    final RFunction enclosingFunction;
    final Function source;
    final RSymbol[] paramNames;
    @RNode.Children
    final RNode[] paramValues;
    @RNode.Child
    RNode body;
    final int dotsIndex;
    final FrameDescriptor frameDescriptor;
    final RSymbol[] writeSet;
    final int writeSetBloom;
    final RFunction.EnclosingSlot[] readSet;
    final int readSetBloom;
    private static final boolean DEBUG_CALLS = false;

    public FunctionImpl(Function source, RSymbol[] paramNames, RNode[] paramValues, RNode body, RFunction enclosingFunction, RSymbol[] writeSet, RFunction.EnclosingSlot[] readSet) {
        super(source);
        this.source = source;
        this.paramNames = paramNames;
        this.paramValues = paramValues;
        this.body = body;
        this.enclosingFunction = enclosingFunction;
        this.writeSet = writeSet;
        this.readSet = readSet;
        int wsBloom = 0;
        int rsBloom = 0;
        for (RSymbol sym : writeSet) {
            wsBloom |= sym.hash();
        }
        for (RFunction.EnclosingSlot rse : readSet) {
            rsBloom |= rse.symbol.hash();
        }
        this.readSetBloom = rsBloom;
        this.writeSetBloom = wsBloom;
        int nparams = paramNames.length;
        this.frameDescriptor = new FrameDescriptor(writeSet);
        int tmpDotsIndex = -1;
        for (int i = 0; i < nparams; ++i) {
            if (paramNames[i] != RSymbol.THREE_DOTS_SYMBOL) continue;
            tmpDotsIndex = i;
            break;
        }
        this.dotsIndex = tmpDotsIndex;
    }

    @Override
    public Object call(Frame frame) {
        Object res;
        for (int i = 0; i < this.paramValues.length; ++i) {
            Object value = frame.get(i);
            if (value != null) continue;
            RNode n = this.paramValues[i];
            if (n != null) {
                frame.set(i, RPromise.createDefault(n, frame));
                continue;
            }
            frame.set(i, RPromise.createMissing(this.paramNames[i], frame));
        }
        try {
            res = this.body.execute(frame);
        }
        catch (Return.ReturnException re) {
            res = frame.returnValue();
        }
        return res;
    }

    private static String printWriteSet(RSymbol[] writeSet) {
        StringBuilder str = new StringBuilder();
        boolean first = true;
        int i = 0;
        for (RSymbol s : writeSet) {
            if (first) {
                first = false;
            } else {
                str.append(", ");
            }
            str.append(s.pretty());
            str.append(":");
            str.append(i);
            ++i;
        }
        return str.toString();
    }

    private static String printReadSet(RFunction.EnclosingSlot[] readSet) {
        StringBuilder str = new StringBuilder();
        boolean first = true;
        for (RFunction.EnclosingSlot e : readSet) {
            if (first) {
                first = false;
            } else {
                str.append(", ");
            }
            str.append(e.symbol.pretty());
            str.append(":");
            str.append("(");
            str.append(e.hops);
            str.append(",");
            str.append(e.slot);
            str.append(")");
        }
        return str.toString();
    }

    @Override
    public int nlocals() {
        return this.writeSet.length;
    }

    @Override
    public int nparams() {
        return this.paramNames.length;
    }

    @Override
    public int dotsIndex() {
        return this.dotsIndex;
    }

    @Override
    public int positionInLocalWriteSet(RSymbol sym) {
        if (FunctionImpl.isIn(sym.hash(), this.writeSetBloom)) {
            RSymbol[] ws = this.writeSet;
            int len = ws.length;
            for (int i = 0; i < len; ++i) {
                if (ws[i] != sym) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int positionInLocalReadSet(RSymbol sym) {
        if (FunctionImpl.isIn(sym.hash(), this.readSetBloom)) {
            RFunction.EnclosingSlot[] rs = this.readSet;
            int len = rs.length;
            for (int i = 0; i < len; ++i) {
                if (rs[i].symbol != sym) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public RFunction.EnclosingSlot getLocalReadSetEntry(RSymbol sym) {
        int i = this.positionInLocalReadSet(sym);
        return i == -1 ? null : this.readSet[i];
    }

    public static boolean isIn(int id, int bloomfilter) {
        return (id & bloomfilter) == id;
    }

    @Override
    public RSymbol[] paramNames() {
        return this.paramNames;
    }

    @Override
    public RNode[] paramValues() {
        return this.paramValues;
    }

    @Override
    public RNode body() {
        return this.body;
    }

    @Override
    public RFunction enclosingFunction() {
        return this.enclosingFunction;
    }

    @Override
    public Function getSource() {
        return this.source;
    }

    @Override
    public RClosure createClosure(Frame enclosingEnvironment) {
        return new ClosureImpl(this, enclosingEnvironment);
    }

    @Override
    public boolean isInWriteSet(RSymbol sym) {
        if (this.positionInLocalWriteSet(sym) != -1) {
            return true;
        }
        if (this.enclosingFunction == null) {
            return false;
        }
        return this.enclosingFunction.isInWriteSet(sym);
    }

    @Override
    public RSymbol[] localWriteSet() {
        return this.writeSet;
    }

    @Override
    public int localSlot(RSymbol symbol) {
        return this.frameDescriptor.findFrameSlot(symbol);
    }

    @Override
    public RFunction.EnclosingSlot enclosingSlot(RSymbol symbol) {
        int hops = 0;
        for (RFunction func = this.enclosingFunction; func != null; func = func.enclosingFunction()) {
            ++hops;
            int slot = func.localSlot(symbol);
            if (slot == -1) continue;
            return new RFunction.EnclosingSlot(symbol, hops, slot);
        }
        return null;
    }

    @Override
    public FrameDescriptor frameDescriptor() {
        return this.frameDescriptor;
    }

    @Override
    public Object execute(Frame frame) {
        assert (Utils.check(false, "unreachable"));
        return null;
    }

    @Override
    protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
        assert (oldNode != null);
        if (this.paramValues != null) {
            for (int i = 0; i < this.paramValues.length; ++i) {
                if (this.paramValues[i] != oldNode) continue;
                this.paramValues[i] = newNode;
                return this.adoptInternal(newNode);
            }
        }
        if (this.body == oldNode) {
            this.body = newNode;
            return this.adoptInternal(newNode);
        }
        return super.replaceChild(oldNode, newNode);
    }

    @Override
    public Frame createFrame(Frame enclosingFrame) {
        switch (this.nlocals()) {
            case 1: {
                return new SmallFrame.SmallFrame1Slot(this, enclosingFrame, this.frameDescriptor());
            }
            case 2: {
                return new SmallFrame.SmallFrame2Slots(this, enclosingFrame, this.frameDescriptor());
            }
            case 3: {
                return new SmallFrame.SmallFrame3Slots(this, enclosingFrame, this.frameDescriptor());
            }
            case 4: {
                return new SmallFrame.SmallFrame4Slots(this, enclosingFrame, this.frameDescriptor());
            }
        }
        return new GenericFrame(this, enclosingFrame, this.frameDescriptor());
    }
}

