/*
 * Decompiled with CFR 0.152.
 */
package r.data.internal;

import r.Convert;
import r.Utils;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RRaw;
import r.data.RString;
import r.data.internal.NonScalarArrayImpl;
import r.data.internal.View;
import r.nodes.ast.OperationFactory;
import r.nodes.exec.RNode;

public class IntImpl
extends NonScalarArrayImpl
implements RInt {
    final int[] content;
    private static final String EMPTY_STRING = "integer(0)";
    private static final String NAMED_EMPTY_STRING = "named integer(0)";

    @Override
    public int[] getContent() {
        return this.content;
    }

    public IntImpl(int[] values, int[] dimensions, RArray.Names names, RAny.Attributes attributes, boolean doCopy) {
        if (doCopy) {
            this.content = new int[values.length];
            System.arraycopy(values, 0, this.content, 0, values.length);
        } else {
            this.content = values;
        }
        this.dimensions = dimensions;
        this.names = names;
        this.attributes = attributes;
    }

    public IntImpl(int[] values, int[] dimensions, RArray.Names names) {
        this(values, dimensions, names, null, true);
    }

    public IntImpl(int[] values) {
        this(values, null, null, null, true);
    }

    public IntImpl(int size) {
        this.content = new int[size];
    }

    public IntImpl(RInt v, boolean valuesOnly) {
        this.content = new int[v.size()];
        for (int i = 0; i < this.content.length; ++i) {
            this.content[i] = v.getInt(i);
        }
        if (!valuesOnly) {
            this.dimensions = v.dimensions();
            this.names = v.names();
            this.attributes = v.attributes();
        }
    }

    public IntImpl(RInt v, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
        this.content = new int[v.size()];
        for (int i = 0; i < this.content.length; ++i) {
            this.content[i] = v.getInt(i);
        }
        this.dimensions = dimensions;
        this.names = names;
        this.attributes = attributes;
    }

    @Override
    public int size() {
        return this.content.length;
    }

    @Override
    public Object get(int i) {
        return this.content[i];
    }

    @Override
    public int getInt(int i) {
        return this.content[i];
    }

    @Override
    public RAny boxedGet(int i) {
        return RInt.RIntFactory.getScalar(this.getInt(i));
    }

    @Override
    public boolean isNAorNaN(int i) {
        return this.content[i] == Integer.MIN_VALUE;
    }

    @Override
    public RArray set(int i, Object val) {
        return this.set(i, (Integer)val);
    }

    @Override
    public RInt set(int i, int val) {
        this.content[i] = val;
        return this;
    }

    @Override
    public IntImpl materialize() {
        return this;
    }

    @Override
    public String pretty() {
        StringBuilder str = new StringBuilder();
        if (this.dimensions != null) {
            str.append(this.arrayPretty());
        } else if (this.content.length == 0) {
            str.append(this.names() == null ? EMPTY_STRING : NAMED_EMPTY_STRING);
        } else if (this.names() != null) {
            str.append(this.namedPretty());
        } else {
            str.append(Convert.prettyNA(Convert.int2string(this.content[0])));
            for (int i = 1; i < this.content.length; ++i) {
                str.append(", ");
                str.append(Convert.prettyNA(Convert.int2string(this.content[i])));
            }
        }
        str.append(this.attributesPretty());
        return str.toString();
    }

    @Override
    public RRaw asRaw() {
        return new RInt.RRawView(this);
    }

    @Override
    public RRaw asRaw(Convert.ConversionStatus warn) {
        return RInt.RIntUtils.intToRaw(this, warn);
    }

    @Override
    public RLogical asLogical() {
        return new RInt.RLogicalView(this);
    }

    @Override
    public RLogical asLogical(Convert.ConversionStatus warn) {
        return this.asLogical();
    }

    @Override
    public RInt asInt() {
        return this;
    }

    @Override
    public RInt asInt(Convert.ConversionStatus warn) {
        return this;
    }

    @Override
    public RDouble asDouble() {
        return new RInt.RDoubleView(this);
    }

    @Override
    public RDouble asDouble(Convert.ConversionStatus warn) {
        return this.asDouble();
    }

    @Override
    public RComplex asComplex() {
        return new RInt.RComplexView(this);
    }

    @Override
    public RComplex asComplex(Convert.ConversionStatus warn) {
        return this.asComplex();
    }

    @Override
    public RString asString() {
        return new RInt.RStringView(this);
    }

    @Override
    public RString asString(Convert.ConversionStatus warn) {
        return this.asString();
    }

    @Override
    public <T extends RNode> T callNodeFactory(OperationFactory<T> factory) {
        return factory.fromInt();
    }

    @Override
    public RArray subset(RInt index) {
        return RInt.RIntFactory.subset(this, index);
    }

    @Override
    public String typeOf() {
        return "integer";
    }

    @Override
    public IntImpl doStrip() {
        return new IntImpl(this.content, null, null, null, false);
    }

    @Override
    public IntImpl doStripKeepNames() {
        return new IntImpl(this.content, null, this.names, null, false);
    }

    public static class RIntSequence
    extends View.RIntView
    implements RInt {
        final int from;
        final int to;
        final int step;
        final int size;

        public RIntSequence(int from, int to, int step) {
            this.from = from;
            this.to = to;
            this.step = step;
            int absstep = step > 0 ? step : -step;
            this.size = from <= to ? (to - from + absstep) / absstep : (from - to + absstep) / absstep;
            assert (Utils.check(this.size > 0));
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public int getInt(int i) {
            assert (Utils.check(i < this.size, "bounds check"));
            assert (Utils.check(i >= 0, "bounds check"));
            return this.from + i * this.step;
        }

        public boolean isPositive() {
            return this.from > 0 && this.to > 0;
        }

        public int from() {
            return this.from;
        }

        public int to() {
            return this.to;
        }

        public int step() {
            return this.step;
        }

        public int min() {
            return this.from < this.to ? this.from : this.to;
        }

        public int max() {
            return this.to > this.from ? this.to : this.from;
        }

        @Override
        public boolean isSharedReal() {
            return false;
        }

        @Override
        public boolean dependsOn(RAny value) {
            return false;
        }

        public static int sequenceSize(int from, int to, int step) {
            int absstep;
            int n = absstep = step > 0 ? step : -step;
            if (from <= to) {
                return (to - from + 1) / absstep;
            }
            return (from - to + 1) / absstep;
        }
    }
}

