/*
 * Decompiled with CFR 0.152.
 */
package r.data.internal;

import r.Convert;
import r.Utils;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RList;
import r.data.RLogical;
import r.data.RNull;
import r.data.RRaw;
import r.data.RString;
import r.data.RSymbol;
import r.data.internal.NonScalarArrayImpl;

public class ListImpl
extends NonScalarArrayImpl
implements RList {
    final RAny[] content;
    private static final StringBuilder emptyString = new StringBuilder();
    private static final String EMPTY_STRING = "list()";
    private static final String NAMED_EMPTY_STRING = "named list()";

    public RAny[] getContent() {
        return this.content;
    }

    public ListImpl(RAny[] values, int[] dimensions, RArray.Names names, RAny.Attributes attributes, boolean doCopy) {
        if (doCopy) {
            this.content = new RAny[values.length];
            System.arraycopy(values, 0, this.content, 0, values.length);
        } else {
            this.content = values;
        }
        this.dimensions = dimensions;
        this.names = names;
        this.attributes = attributes;
    }

    public ListImpl(RAny[] values) {
        this(values, null, null, null, true);
    }

    public ListImpl(RAny[] values, int[] dimensions, RArray.Names names) {
        this(values, dimensions, names, null, true);
    }

    public ListImpl(int size) {
        this.content = new RAny[size];
    }

    public ListImpl(RList v, boolean valuesOnly) {
        this.content = new RAny[v.size()];
        for (int i = 0; i < this.content.length; ++i) {
            RAny e = v.getRAny(i);
            this.content[i] = Utils.copy(e);
        }
        if (!valuesOnly) {
            this.dimensions = v.dimensions();
            this.names = v.names();
            this.attributes = v.attributes();
        }
    }

    public ListImpl(RList v, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
        this.content = new RAny[v.size()];
        for (int i = 0; i < this.content.length; ++i) {
            RAny e = v.getRAny(i);
            this.content[i] = Utils.copy(e);
        }
        this.dimensions = dimensions;
        this.names = names;
        this.attributes = attributes;
    }

    @Override
    public int size() {
        return this.content.length;
    }

    @Override
    public Object get(int i) {
        return this.content[i];
    }

    @Override
    public Object getRef(int i) {
        RAny v = this.content[i];
        v.ref();
        return v;
    }

    @Override
    public RAny boxedGet(int i) {
        return RList.RListFactory.getScalar(this.getRAny(i));
    }

    @Override
    public RAny getRAny(int i) {
        return this.content[i];
    }

    @Override
    public RAny getRAnyRef(int i) {
        RAny v = this.content[i];
        v.ref();
        return v;
    }

    @Override
    public boolean isNAorNaN(int i) {
        RArray a;
        RAny v = this.content[i];
        if (v instanceof RArray && (a = (RArray)v).size() == 1) {
            return a.isNAorNaN(0);
        }
        return false;
    }

    @Override
    public RArray set(int i, Object val) {
        this.content[i] = (RAny)val;
        return this;
    }

    @Override
    public RArray set(int i, RAny val) {
        this.content[i] = val;
        return this;
    }

    @Override
    public String pretty() {
        return this.pretty(emptyString);
    }

    @Override
    public String prettyMatrixElement() {
        String base;
        RArray a;
        int asize;
        Utils.check(this.content.length == 1);
        RAny v = this.content[0];
        if (!(v instanceof RArray)) {
            Utils.nyi("unsupported type");
        }
        if ((asize = (a = (RArray)v).size()) == 1) {
            if (a instanceof RList) {
                return "List,1";
            }
            return a.prettyMatrixElement();
        }
        if (a instanceof RDouble) {
            base = "Numeric";
        } else if (a instanceof RInt) {
            base = "Integer";
        } else if (a instanceof RLogical) {
            base = "Logical";
        } else if (a instanceof RString) {
            base = "Character";
        } else if (a instanceof RRaw) {
            base = "Raw";
        } else if (a instanceof RComplex) {
            base = "Complex";
        } else {
            if (a instanceof RNull) {
                return "NULL";
            }
            Utils.nyi("unsupported type");
            base = null;
        }
        return base + "," + Integer.toString(asize);
    }

    public String pretty(StringBuilder indexPrefix) {
        StringBuilder str = new StringBuilder();
        if (this.dimensions != null) {
            str.append(this.arrayPretty());
        } else if (this.content.length == 0) {
            str.append(this.names() == null ? EMPTY_STRING : NAMED_EMPTY_STRING);
        } else {
            RSymbol[] snames = null;
            if (this.names() != null) {
                snames = this.names().sequence();
            }
            for (int i = 0; i < this.content.length; ++i) {
                RSymbol s;
                if (i >= 1) {
                    str.append("\n\n");
                }
                StringBuilder nprefix = new StringBuilder();
                nprefix.append((CharSequence)indexPrefix);
                RSymbol rSymbol = s = snames == null ? null : snames[i];
                if (s == null || s == RSymbol.EMPTY_SYMBOL) {
                    nprefix.append("[[");
                    nprefix.append(i + 1);
                    nprefix.append("]]");
                } else {
                    nprefix.append("$");
                    nprefix.append(Convert.prettyGTNALT(s.pretty()));
                }
                str.append((CharSequence)nprefix);
                str.append("\n");
                RAny v = this.content[i];
                if (v instanceof ListImpl) {
                    str.append(((ListImpl)v).pretty(nprefix));
                    continue;
                }
                str.append(v.pretty());
            }
        }
        str.append(this.attributesPretty());
        return str.toString();
    }

    @Override
    public RRaw asRaw() {
        Utils.nyi();
        return null;
    }

    @Override
    public RLogical asLogical() {
        Utils.nyi();
        return null;
    }

    @Override
    public RInt asInt() {
        Utils.nyi();
        return null;
    }

    @Override
    public RDouble asDouble() {
        Utils.nyi();
        return null;
    }

    @Override
    public RComplex asComplex() {
        Utils.nyi();
        return null;
    }

    @Override
    public RString asString() {
        Utils.nyi();
        return null;
    }

    @Override
    public ListImpl asList() {
        return this;
    }

    @Override
    public RArray subset(RInt index) {
        return RList.RListFactory.subset(this, index);
    }

    @Override
    public String typeOf() {
        return "list";
    }

    @Override
    public ListImpl doStrip() {
        return new ListImpl(this.content, null, null, null, false);
    }

    @Override
    public ListImpl doStripKeepNames() {
        return new ListImpl(this.content, null, this.names, null, false);
    }

    @Override
    public ListImpl materialize() {
        return this;
    }
}

