/*
 * Decompiled with CFR 0.152.
 */
package r.data.internal;

import r.Convert;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RRaw;
import r.data.RString;
import r.data.internal.NonScalarArrayImpl;
import r.nodes.ast.OperationFactory;
import r.nodes.exec.RNode;

public class LogicalImpl
extends NonScalarArrayImpl
implements RLogical {
    final int[] content;
    private static final String EMPTY_STRING = "logical(0)";
    private static final String NAMED_EMPTY_STRING = "named logical(0)";

    public int[] getContent() {
        return this.content;
    }

    public LogicalImpl(int size) {
        this.content = new int[size];
    }

    public LogicalImpl(int[] values, int[] dimensions, RArray.Names names, RAny.Attributes attributes, boolean doCopy) {
        if (doCopy) {
            this.content = new int[values.length];
            System.arraycopy(values, 0, this.content, 0, values.length);
        } else {
            this.content = values;
        }
        this.dimensions = dimensions;
        this.names = names;
        this.attributes = attributes;
    }

    public LogicalImpl(int[] values, int[] dimensions) {
        this(values, dimensions, null, null, true);
    }

    public LogicalImpl(int[] values) {
        this(values, null, null, null, true);
    }

    public LogicalImpl(RLogical l, boolean valuesOnly) {
        this.content = new int[l.size()];
        for (int i = 0; i < this.content.length; ++i) {
            this.content[i] = l.getLogical(i);
        }
        if (!valuesOnly) {
            this.dimensions = l.dimensions();
            this.names = l.names();
            this.attributes = l.attributes();
        }
    }

    public LogicalImpl(RLogical l, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
        this.content = new int[l.size()];
        for (int i = 0; i < this.content.length; ++i) {
            this.content[i] = l.getLogical(i);
        }
        this.dimensions = dimensions;
        this.names = names;
        this.attributes = attributes;
    }

    @Override
    public int size() {
        return this.content.length;
    }

    @Override
    public Object get(int i) {
        return this.content[i];
    }

    @Override
    public int getLogical(int i) {
        return this.content[i];
    }

    @Override
    public RAny boxedGet(int i) {
        return RLogical.RLogicalFactory.getScalar(this.getLogical(i));
    }

    @Override
    public boolean isNAorNaN(int i) {
        return this.content[i] == Integer.MIN_VALUE;
    }

    @Override
    public RArray set(int i, Object val) {
        return this.set(i, (Integer)val);
    }

    @Override
    public RLogical set(int i, int val) {
        this.content[i] = val;
        return this;
    }

    @Override
    public RRaw asRaw() {
        return new RLogical.RRawView(this);
    }

    @Override
    public RRaw asRaw(Convert.ConversionStatus warn) {
        return RLogical.RLogicalUtils.logicalToRaw(this, warn);
    }

    @Override
    public RLogical asLogical() {
        return this;
    }

    @Override
    public RLogical asLogical(Convert.ConversionStatus warn) {
        return this;
    }

    @Override
    public RInt asInt() {
        return RInt.RIntFactory.getFor(this.content, this.dimensions(), this.names());
    }

    @Override
    public RInt asInt(Convert.ConversionStatus warn) {
        return this.asInt();
    }

    @Override
    public RDouble asDouble() {
        return new RLogical.RDoubleView(this);
    }

    @Override
    public RDouble asDouble(Convert.ConversionStatus warn) {
        return this.asDouble();
    }

    @Override
    public RComplex asComplex() {
        return new RLogical.RComplexView(this);
    }

    @Override
    public RComplex asComplex(Convert.ConversionStatus warn) {
        return this.asComplex();
    }

    @Override
    public RString asString() {
        return new RLogical.RStringView(this);
    }

    @Override
    public RString asString(Convert.ConversionStatus warn) {
        return this.asString();
    }

    @Override
    public LogicalImpl materialize() {
        return this;
    }

    @Override
    public String pretty() {
        StringBuilder str = new StringBuilder();
        if (this.dimensions != null) {
            str.append(this.arrayPretty());
        } else if (this.content.length == 0) {
            str.append(this.names() == null ? EMPTY_STRING : NAMED_EMPTY_STRING);
        } else if (this.names() != null) {
            str.append(this.namedPretty());
        } else {
            str.append(Convert.prettyNA(Convert.logical2string(this.content[0])));
            for (int i = 1; i < this.content.length; ++i) {
                str.append(", ");
                str.append(Convert.prettyNA(Convert.logical2string(this.content[i])));
            }
        }
        str.append(this.attributesPretty());
        return str.toString();
    }

    @Override
    public <T extends RNode> T callNodeFactory(OperationFactory<T> factory) {
        return factory.fromLogical();
    }

    @Override
    public RArray subset(RInt index) {
        return RLogical.RLogicalFactory.subset(this, index);
    }

    @Override
    public String typeOf() {
        return "logical";
    }

    @Override
    public LogicalImpl doStrip() {
        return new LogicalImpl(this.content, null, null, null, false);
    }

    @Override
    public LogicalImpl doStripKeepNames() {
        return new LogicalImpl(this.content, null, this.names, null, false);
    }
}

