/*
 * Decompiled with CFR 0.152.
 */
package r.data.internal;

import java.util.Map;
import r.Utils;
import r.data.RAny;
import r.data.RArray;
import r.data.RSymbol;
import r.data.internal.ArrayImpl;

public abstract class NonScalarArrayImpl
extends ArrayImpl
implements RArray {
    protected int[] dimensions;
    protected RArray.Names names;
    protected int refcount;
    protected RAny.Attributes attributes;

    @Override
    public final boolean isShared() {
        return this.refcount > 1;
    }

    @Override
    public boolean isTemporary() {
        return this.refcount == 0;
    }

    @Override
    public final void ref() {
        if (this.refcount == 0) {
            this.refcount = 1;
        } else if (this.refcount == 1) {
            this.refcount = 2;
        }
    }

    @Override
    public int[] dimensions() {
        return this.dimensions;
    }

    @Override
    public NonScalarArrayImpl setDimensions(int[] dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    @Override
    public RAny.Attributes attributes() {
        return this.attributes;
    }

    @Override
    public RAny.Attributes attributesRef() {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.markShared();
    }

    @Override
    public NonScalarArrayImpl setAttributes(RAny.Attributes attributes) {
        this.attributes = attributes;
        return this;
    }

    @Override
    public RArray.Names names() {
        return this.names;
    }

    @Override
    public NonScalarArrayImpl setNames(RArray.Names names) {
        this.names = names;
        return this;
    }

    private static boolean increment(int[] idx, int[] dim, int ignoreDigits) {
        for (int i = idx.length - 1; i >= ignoreDigits; --i) {
            int n = i;
            idx[n] = idx[n] + 1;
            if (idx[i] <= dim[i]) {
                return false;
            }
            idx[i] = 1;
        }
        return true;
    }

    protected String arrayPretty() {
        assert (this.dimensions != null);
        switch (this.dimensions.length) {
            case 0: {
                return "<zero dimension array>";
            }
            case 1: {
                StringBuilder sb = new StringBuilder();
                sb.append("[1] ");
                for (int i = 0; i < this.dimensions[0]; ++i) {
                    if (i != 0) {
                        sb.append(" ");
                    }
                    sb.append(this.boxedGet(i).prettyMatrixElement());
                }
                return sb.toString();
            }
            case 2: {
                return this.matrixPretty();
            }
        }
        int[] m = new int[this.dimensions.length];
        for (int i = 0; i < m.length - 1; ++i) {
            m[i] = 1;
        }
        int offset = 0;
        int msize = this.dimensions[0] * this.dimensions[1];
        StringBuilder sb = new StringBuilder();
        while (!NonScalarArrayImpl.increment(m, this.dimensions, 2)) {
            if (offset != 0) {
                sb.append("\n\n");
            }
            sb.append(", ");
            for (int i = 2; i < m.length; ++i) {
                sb.append(", " + m[i]);
            }
            sb.append("\n\n");
            this.matrixPretty(sb, offset);
            offset += msize;
        }
        return sb.toString();
    }

    protected void matrixPretty(StringBuilder sb, int fromOffset) {
        int m = this.dimensions[0];
        int n = this.dimensions[1];
        if (m == 0 && n == 0) {
            sb.append("<0 x 0 matrix>");
        } else {
            int i;
            int j;
            String[] colNames = new String[n];
            String[] rowNames = new String[m];
            String[][] data = new String[m][n];
            int[] colWidth = new int[n];
            int rowNamesWidth = -1;
            for (j = 0; j < n; ++j) {
                String cn;
                int maxWidth = -1;
                colNames[j] = cn = "[," + Integer.toString(j + 1) + "]";
                int clen = cn.length();
                if (clen > maxWidth) {
                    maxWidth = clen;
                }
                for (int i2 = 0; i2 < m; ++i2) {
                    String s;
                    data[i2][j] = s = this.boxedGet(fromOffset + j * m + i2).prettyMatrixElement();
                    int l = s.length();
                    if (l <= maxWidth) continue;
                    maxWidth = l;
                }
                colWidth[j] = 1 + maxWidth;
            }
            for (i = 0; i < m; ++i) {
                String rn;
                rowNames[i] = rn = "[" + Integer.toString(i + 1) + ",]";
                int rlen = rn.length();
                if (rlen <= rowNamesWidth) continue;
                rowNamesWidth = rlen;
            }
            if (rowNamesWidth == -1) {
                sb.append("    ");
            } else {
                Utils.strAppend(sb, "", rowNamesWidth);
            }
            for (j = 0; j < n; ++j) {
                Utils.strAppend(sb, colNames[j], colWidth[j]);
            }
            if (m > 0) {
                sb.append("\n");
            }
            for (i = 0; i < m; ++i) {
                Utils.strAppend(sb, rowNames[i], rowNamesWidth);
                for (int j2 = 0; j2 < n; ++j2) {
                    Utils.strAppend(sb, data[i][j2], colWidth[j2]);
                }
                if (i == m - 1) continue;
                sb.append("\n");
            }
        }
    }

    protected String matrixPretty() {
        Utils.check(this.dimensions != null);
        Utils.check(this.dimensions.length == 2);
        StringBuilder sb = new StringBuilder();
        this.matrixPretty(sb, 0);
        return sb.toString();
    }

    protected String attributesPretty() {
        StringBuilder str = new StringBuilder();
        RAny.Attributes a = this.attributes();
        if (a != null) {
            for (Map.Entry<RSymbol, RAny> e : a.map().entrySet()) {
                str.append("\n");
                str.append("attr(,\"");
                str.append(e.getKey().pretty());
                str.append("\")");
                str.append("\n");
                str.append(e.getValue().pretty());
            }
        }
        return str.toString();
    }
}

