/*
 * Decompiled with CFR 0.152.
 */
package r.data.internal;

import r.Convert;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RRaw;
import r.data.RString;
import r.data.internal.NonScalarArrayImpl;

public class RawImpl
extends NonScalarArrayImpl
implements RRaw {
    final byte[] content;
    private static final String EMPTY_STRING = "raw(0)";
    private static final String NAMED_EMPTY_STRING = "named raw(0)";

    public RawImpl(int size) {
        this.content = new byte[size];
    }

    public byte[] getContent() {
        return this.content;
    }

    public RawImpl(byte[] values, int[] dimensions, RArray.Names names, RAny.Attributes attributes, boolean doCopy) {
        if (doCopy) {
            this.content = new byte[values.length];
            System.arraycopy(values, 0, this.content, 0, values.length);
        } else {
            this.content = values;
        }
        this.dimensions = dimensions;
        this.names = names;
        this.attributes = attributes;
    }

    public RawImpl(byte[] values, int[] dimensions) {
        this(values, dimensions, null, null, true);
    }

    public RawImpl(byte[] values) {
        this(values, null, null, null, true);
    }

    public RawImpl(RRaw r, boolean valuesOnly) {
        this.content = new byte[r.size()];
        for (int i = 0; i < this.content.length; ++i) {
            this.content[i] = r.getRaw(i);
        }
        if (!valuesOnly) {
            this.dimensions = r.dimensions();
            this.names = r.names();
            this.attributes = r.attributes();
        }
    }

    public RawImpl(RRaw r, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
        this.content = new byte[r.size()];
        for (int i = 0; i < this.content.length; ++i) {
            this.content[i] = r.getRaw(i);
        }
        this.dimensions = dimensions;
        this.names = names;
        this.attributes = attributes;
    }

    @Override
    public int size() {
        return this.content.length;
    }

    @Override
    public Object get(int i) {
        return this.content[i];
    }

    @Override
    public byte getRaw(int i) {
        return this.content[i];
    }

    @Override
    public RAny boxedGet(int i) {
        return RRaw.RRawFactory.getScalar(this.getRaw(i));
    }

    @Override
    public boolean isNAorNaN(int i) {
        return false;
    }

    @Override
    public RArray set(int i, Object val) {
        return this.set(i, (Byte)val);
    }

    @Override
    public RRaw set(int i, byte val) {
        this.content[i] = val;
        return this;
    }

    @Override
    public RRaw asRaw() {
        return this;
    }

    @Override
    public RRaw asRaw(Convert.ConversionStatus warn) {
        return this;
    }

    @Override
    public RLogical asLogical() {
        return new RRaw.RLogicalView(this);
    }

    @Override
    public RLogical asLogical(Convert.ConversionStatus warn) {
        return this.asLogical();
    }

    @Override
    public RInt asInt() {
        return new RRaw.RIntView(this);
    }

    @Override
    public RInt asInt(Convert.ConversionStatus warn) {
        return this.asInt();
    }

    @Override
    public RDouble asDouble() {
        return new RRaw.RDoubleView(this);
    }

    @Override
    public RDouble asDouble(Convert.ConversionStatus warn) {
        return this.asDouble();
    }

    @Override
    public RComplex asComplex() {
        return new RRaw.RComplexView(this);
    }

    @Override
    public RComplex asComplex(Convert.ConversionStatus warn) {
        return this.asComplex();
    }

    @Override
    public RString asString() {
        return new RRaw.RStringView(this);
    }

    @Override
    public RString asString(Convert.ConversionStatus warn) {
        return this.asString();
    }

    @Override
    public RawImpl materialize() {
        return this;
    }

    @Override
    public String pretty() {
        StringBuilder str = new StringBuilder();
        if (this.dimensions != null) {
            str.append(this.arrayPretty());
        } else if (this.content.length == 0) {
            str.append(this.names() == null ? EMPTY_STRING : NAMED_EMPTY_STRING);
        } else if (this.names() != null) {
            str.append(this.namedPretty());
        } else {
            str.append(Convert.raw2string(this.content[0]));
            for (int i = 1; i < this.content.length; ++i) {
                str.append(", ");
                str.append(Convert.raw2string(this.content[i]));
            }
        }
        str.append(this.attributesPretty());
        return str.toString();
    }

    @Override
    public String typeOf() {
        return "raw";
    }

    @Override
    public RArray subset(RInt index) {
        return RRaw.RRawFactory.subset(this, index);
    }

    @Override
    public RawImpl doStrip() {
        return new RawImpl(this.content, null, null, null, false);
    }

    @Override
    public RawImpl doStripKeepNames() {
        return new RawImpl(this.content, null, this.names, null, false);
    }
}

