/*
 * Decompiled with CFR 0.152.
 */
package r.data.internal;

import r.Convert;
import r.Utils;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RRaw;
import r.data.RString;
import r.data.internal.ArrayImpl;
import r.data.internal.View;

public class ScalarComplexImpl
extends ArrayImpl
implements RComplex {
    double real;
    double imag;

    @Override
    public double[] getContent() {
        return new double[]{this.real, this.imag};
    }

    public ScalarComplexImpl(double real, double imag) {
        this.real = real;
        this.imag = imag;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public Object get(int i) {
        assert (Utils.check(i == 0));
        return this.get();
    }

    public Object get() {
        return new RComplex.Complex(this.real, this.imag);
    }

    @Override
    public RAny boxedGet(int i) {
        assert (Utils.check(i == 0));
        return this.boxedGet();
    }

    public RAny boxedGet() {
        return this;
    }

    @Override
    public RArray set(int i, Object val) {
        assert (Utils.check(i == 0));
        return this.set(val);
    }

    public RArray set(Object val) {
        RComplex.Complex c = (RComplex.Complex)val;
        return this.set(c.realValue(), c.imagValue());
    }

    @Override
    public RComplex setDimensions(int[] dimensions) {
        return RComplex.RComplexFactory.getFor(new double[]{this.real, this.imag}, dimensions, null);
    }

    @Override
    public RComplex setNames(RArray.Names names) {
        return RComplex.RComplexFactory.getFor(new double[]{this.real, this.imag}, null, names);
    }

    @Override
    public RComplex setAttributes(RAny.Attributes attributes) {
        return RComplex.RComplexFactory.getFor(new double[]{this.real, this.imag}, null, null, attributes);
    }

    @Override
    public boolean isNAorNaN(int i) {
        assert (Utils.check(i == 0));
        return this.isNAorNaN();
    }

    public boolean isNAorNaN() {
        return RComplex.RComplexUtils.eitherIsNAorNaN(this.real, this.imag);
    }

    public boolean isNA() {
        return RComplex.RComplexUtils.eitherIsNA(this.real, this.imag);
    }

    @Override
    public String pretty() {
        return Convert.prettyNA(Convert.complex2string(this.real, this.imag));
    }

    @Override
    public RRaw asRaw() {
        return this.asRaw(null);
    }

    @Override
    public RRaw asRaw(Convert.ConversionStatus warn) {
        return RRaw.RRawFactory.getScalar(Convert.complex2raw(this.real, this.imag, warn));
    }

    @Override
    public RLogical asLogical() {
        return RLogical.RLogicalFactory.getScalar(Convert.complex2logical(this.real, this.imag));
    }

    @Override
    public RLogical asLogical(Convert.ConversionStatus warn) {
        return this.asLogical();
    }

    @Override
    public RInt asInt() {
        return this.asInt(null);
    }

    @Override
    public RInt asInt(Convert.ConversionStatus warn) {
        return RInt.RIntFactory.getScalar(Convert.complex2int(this.real, this.imag, warn));
    }

    @Override
    public RDouble asDouble() {
        return this.asDouble(null);
    }

    @Override
    public RDouble asDouble(Convert.ConversionStatus warn) {
        return RDouble.RDoubleFactory.getScalar(Convert.complex2double(this.real, this.imag, warn));
    }

    @Override
    public RComplex asComplex() {
        return this;
    }

    @Override
    public RComplex asComplex(Convert.ConversionStatus warn) {
        return this;
    }

    @Override
    public RString asString() {
        return RString.RStringFactory.getScalar(Convert.complex2string(this.real, this.imag));
    }

    @Override
    public RString asString(Convert.ConversionStatus warn) {
        return this.asString();
    }

    @Override
    public ScalarComplexImpl materialize() {
        return this;
    }

    @Override
    public RComplex set(int i, double real, double imag) {
        assert (Utils.check(i == 0));
        return this.set(real, imag);
    }

    public RComplex set(double real, double imag) {
        this.real = real;
        this.imag = imag;
        return this;
    }

    @Override
    public double getReal(int i) {
        assert (Utils.check(i == 0));
        return this.getReal();
    }

    public double getReal() {
        return this.real;
    }

    @Override
    public double getImag(int i) {
        assert (Utils.check(i == 0));
        return this.getImag();
    }

    public double getImag() {
        return this.imag;
    }

    @Override
    public RComplex subset(final RInt index) {
        final int size = index.size();
        if (size == 1) {
            int i = index.getInt(0);
            if (i > 1) {
                return RComplex.BOXED_NA;
            }
            return this;
        }
        final double rvalue = this.real;
        final double ivalue = this.imag;
        return new View.RComplexView(){

            @Override
            public double getReal(int i) {
                int j = index.getInt(i);
                if (j > 1) {
                    return RDouble.NA;
                }
                return rvalue;
            }

            @Override
            public double getImag(int i) {
                int j = index.getInt(i);
                if (j > 1) {
                    return RDouble.NA;
                }
                return ivalue;
            }

            @Override
            public int size() {
                return size;
            }

            @Override
            public boolean isSharedReal() {
                return index.isShared();
            }

            @Override
            public void ref() {
                index.ref();
            }

            @Override
            public boolean dependsOn(RAny v) {
                return index.dependsOn(v);
            }
        };
    }

    @Override
    public String typeOf() {
        return "complex";
    }
}

