/*
 * Decompiled with CFR 0.152.
 */
package r.data.internal;

import r.Convert;
import r.Utils;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RRaw;
import r.data.RString;
import r.data.internal.ArrayImpl;
import r.data.internal.View;

public final class ScalarDoubleImpl
extends ArrayImpl
implements RDouble {
    double value;

    @Override
    public double[] getContent() {
        return new double[]{this.value};
    }

    public ScalarDoubleImpl(double value) {
        this.value = value;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public Object get(int i) {
        assert (Utils.check(i == 0));
        return this.get();
    }

    public Object get() {
        return this.value;
    }

    @Override
    public RAny boxedGet(int i) {
        assert (Utils.check(i == 0));
        return this.boxedGet();
    }

    public RAny boxedGet() {
        return this;
    }

    @Override
    public RArray set(int i, Object val) {
        assert (Utils.check(i == 0));
        return this.set(val);
    }

    public RArray set(Object val) {
        return this.set((Double)val);
    }

    @Override
    public RDouble setDimensions(int[] dimensions) {
        return RDouble.RDoubleFactory.getFor(new double[]{this.value}, dimensions, null);
    }

    @Override
    public RDouble setNames(RArray.Names names) {
        return RDouble.RDoubleFactory.getFor(new double[]{this.value}, null, names);
    }

    @Override
    public RDouble setAttributes(RAny.Attributes attributes) {
        return RDouble.RDoubleFactory.getFor(new double[]{this.value}, null, null, attributes);
    }

    @Override
    public boolean isNAorNaN(int i) {
        assert (Utils.check(i == 0));
        return this.isNAorNaN();
    }

    public boolean isNAorNaN() {
        return RDouble.RDoubleUtils.isNAorNaN(this.value);
    }

    public boolean isNA() {
        return RDouble.RDoubleUtils.isNA(this.value);
    }

    @Override
    public String pretty() {
        return Convert.prettyNA(Convert.double2string(this.value));
    }

    @Override
    public RRaw asRaw() {
        return RRaw.RRawFactory.getScalar(Convert.double2raw(this.value));
    }

    @Override
    public RRaw asRaw(Convert.ConversionStatus warn) {
        return RRaw.RRawFactory.getScalar(Convert.double2raw(this.value, warn));
    }

    @Override
    public RLogical asLogical() {
        return RLogical.RLogicalFactory.getScalar(Convert.double2logical(this.value));
    }

    @Override
    public RLogical asLogical(Convert.ConversionStatus warn) {
        return this.asLogical();
    }

    @Override
    public RInt asInt() {
        return RInt.RIntFactory.getScalar(Convert.double2int(this.value));
    }

    @Override
    public RInt asInt(Convert.ConversionStatus warn) {
        return RInt.RIntFactory.getScalar(Convert.double2int(this.value, warn));
    }

    @Override
    public RDouble asDouble() {
        return this;
    }

    @Override
    public RDouble asDouble(Convert.ConversionStatus warn) {
        return this;
    }

    @Override
    public RComplex asComplex() {
        if (RDouble.RDoubleUtils.isNAorNaN(this.value)) {
            return RComplex.BOXED_NA;
        }
        return RComplex.RComplexFactory.getScalar(this.value, 0.0);
    }

    @Override
    public RComplex asComplex(Convert.ConversionStatus warn) {
        return this.asComplex();
    }

    @Override
    public RString asString() {
        return RString.RStringFactory.getScalar(Convert.double2string(this.value));
    }

    @Override
    public RString asString(Convert.ConversionStatus warn) {
        return this.asString();
    }

    @Override
    public ScalarDoubleImpl materialize() {
        return this;
    }

    @Override
    public RDouble set(int i, double val) {
        assert (Utils.check(i == 0));
        return this.set(val);
    }

    public RDouble set(double val) {
        this.value = val;
        return this;
    }

    @Override
    public double getDouble(int i) {
        assert (Utils.check(i == 0));
        return this.getDouble();
    }

    public double getDouble() {
        return this.value;
    }

    @Override
    public RDouble subset(final RInt index) {
        final int size = index.size();
        if (size == 1) {
            int i = index.getInt(0);
            if (i > 1) {
                return RDouble.BOXED_NA;
            }
            return this;
        }
        final double dvalue = this.value;
        return new View.RDoubleView(){

            @Override
            public double getDouble(int i) {
                int j = index.getInt(i);
                if (j > 1) {
                    return RDouble.NA;
                }
                return dvalue;
            }

            @Override
            public int size() {
                return size;
            }

            @Override
            public boolean isSharedReal() {
                return index.isShared();
            }

            @Override
            public void ref() {
                index.ref();
            }

            @Override
            public boolean dependsOn(RAny v) {
                return index.dependsOn(v);
            }
        };
    }

    @Override
    public String typeOf() {
        return "double";
    }
}

