/*
 * Decompiled with CFR 0.152.
 */
package r.data.internal;

import r.Convert;
import r.Utils;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RRaw;
import r.data.RString;
import r.data.internal.ArrayImpl;
import r.data.internal.View;

public final class ScalarIntImpl
extends ArrayImpl
implements RInt {
    int value;

    @Override
    public int[] getContent() {
        return new int[]{this.value};
    }

    public ScalarIntImpl(int value) {
        this.value = value;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public Object get(int i) {
        assert (Utils.check(i == 0));
        return this.get();
    }

    public Object get() {
        return this.value;
    }

    @Override
    public RAny boxedGet(int i) {
        assert (Utils.check(i == 0));
        return this.boxedGet();
    }

    public RAny boxedGet() {
        return this;
    }

    @Override
    public RArray set(int i, Object val) {
        assert (Utils.check(i == 0));
        return this.set(val);
    }

    public RArray set(Object val) {
        return this.set((Integer)val);
    }

    @Override
    public RInt setDimensions(int[] dimensions) {
        return RInt.RIntFactory.getFor(new int[]{this.value}, dimensions, null);
    }

    @Override
    public RInt setNames(RArray.Names names) {
        return RInt.RIntFactory.getFor(new int[]{this.value}, null, names);
    }

    @Override
    public RInt setAttributes(RAny.Attributes attributes) {
        return RInt.RIntFactory.getFor(new int[]{this.value}, null, null, attributes);
    }

    @Override
    public boolean isNAorNaN(int i) {
        assert (Utils.check(i == 0));
        return this.isNAorNaN();
    }

    public boolean isNAorNaN() {
        return this.value == Integer.MIN_VALUE;
    }

    @Override
    public ScalarIntImpl materialize() {
        return this;
    }

    @Override
    public String pretty() {
        return Convert.prettyNA(Convert.int2string(this.value));
    }

    @Override
    public RRaw asRaw() {
        return RRaw.RRawFactory.getScalar(Convert.int2raw(this.value));
    }

    @Override
    public RRaw asRaw(Convert.ConversionStatus warn) {
        return RRaw.RRawFactory.getScalar(Convert.int2raw(this.value, warn));
    }

    @Override
    public RLogical asLogical() {
        return RLogical.RLogicalFactory.getScalar(Convert.int2logical(this.value));
    }

    @Override
    public RLogical asLogical(Convert.ConversionStatus warn) {
        return this.asLogical();
    }

    @Override
    public RInt asInt() {
        return this;
    }

    @Override
    public RInt asInt(Convert.ConversionStatus warn) {
        return this;
    }

    @Override
    public RDouble asDouble() {
        return RDouble.RDoubleFactory.getScalar(Convert.int2double(this.value));
    }

    @Override
    public RDouble asDouble(Convert.ConversionStatus warn) {
        return this.asDouble();
    }

    @Override
    public RComplex asComplex() {
        return RComplex.RComplexFactory.getScalar(Convert.int2double(this.value), 0.0);
    }

    @Override
    public RComplex asComplex(Convert.ConversionStatus warn) {
        return this.asComplex();
    }

    @Override
    public RString asString() {
        return RString.RStringFactory.getScalar(Convert.int2string(this.value));
    }

    @Override
    public RString asString(Convert.ConversionStatus warn) {
        return this.asString();
    }

    @Override
    public int getInt(int i) {
        assert (Utils.check(i == 0));
        return this.getInt();
    }

    public int getInt() {
        return this.value;
    }

    @Override
    public RInt set(int i, int val) {
        assert (Utils.check(i == 0));
        return this.set(val);
    }

    public RInt set(int val) {
        this.value = val;
        return this;
    }

    @Override
    public RInt subset(final RInt index) {
        final int size = index.size();
        if (size == 1) {
            int i = index.getInt(0);
            if (i > 1) {
                return RInt.BOXED_NA;
            }
            return this;
        }
        final int ivalue = this.value;
        return new View.RIntView(){

            @Override
            public int getInt(int i) {
                int j = index.getInt(i);
                if (j > 1) {
                    return Integer.MIN_VALUE;
                }
                return ivalue;
            }

            @Override
            public int size() {
                return size;
            }

            @Override
            public boolean isSharedReal() {
                return index.isShared();
            }

            @Override
            public void ref() {
                index.ref();
            }

            @Override
            public boolean dependsOn(RAny v) {
                return index.dependsOn(v);
            }
        };
    }

    @Override
    public String typeOf() {
        return "integer";
    }
}

