/*
 * Decompiled with CFR 0.152.
 */
package r.data.internal;

import r.Convert;
import r.Utils;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RRaw;
import r.data.RString;
import r.data.internal.ArrayImpl;
import r.data.internal.View;

public final class ScalarLogicalImpl
extends ArrayImpl
implements RLogical {
    int value;

    public ScalarLogicalImpl(int value) {
        this.value = value;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public Object get(int i) {
        assert (Utils.check(i == 0));
        return this.get();
    }

    public Object get() {
        return this.value;
    }

    @Override
    public RAny boxedGet(int i) {
        assert (Utils.check(i == 0));
        return this.boxedGet();
    }

    public RAny boxedGet() {
        return this;
    }

    @Override
    public RArray set(int i, Object val) {
        assert (Utils.check(i == 0));
        return this.set(val);
    }

    public RArray set(Object val) {
        return this.set((Integer)val);
    }

    @Override
    public RLogical setDimensions(int[] dimensions) {
        return RLogical.RLogicalFactory.getFor(new int[]{this.value}, dimensions, null);
    }

    @Override
    public RLogical setNames(RArray.Names names) {
        return RLogical.RLogicalFactory.getFor(new int[]{this.value}, null, names);
    }

    @Override
    public RLogical setAttributes(RAny.Attributes attributes) {
        return RLogical.RLogicalFactory.getFor(new int[]{this.value}, null, null, attributes);
    }

    @Override
    public boolean isNAorNaN(int i) {
        assert (Utils.check(i == 0));
        return this.isNAorNaN();
    }

    public boolean isNAorNaN() {
        return this.value == Integer.MIN_VALUE;
    }

    @Override
    public ScalarLogicalImpl materialize() {
        return this;
    }

    @Override
    public String pretty() {
        return Convert.prettyNA(Convert.logical2string(this.value));
    }

    @Override
    public RRaw asRaw() {
        return RRaw.RRawFactory.getScalar(Convert.logical2raw(this.value));
    }

    @Override
    public RRaw asRaw(Convert.ConversionStatus warn) {
        return RRaw.RRawFactory.getScalar(Convert.logical2raw(this.value, warn));
    }

    @Override
    public RLogical asLogical() {
        return this;
    }

    @Override
    public RLogical asLogical(Convert.ConversionStatus warn) {
        return this;
    }

    @Override
    public RInt asInt() {
        return RInt.RIntFactory.getScalar(Convert.logical2int(this.value));
    }

    @Override
    public RInt asInt(Convert.ConversionStatus warn) {
        return this.asInt();
    }

    @Override
    public RDouble asDouble() {
        return RDouble.RDoubleFactory.getScalar(Convert.logical2double(this.value));
    }

    @Override
    public RDouble asDouble(Convert.ConversionStatus warn) {
        return this.asDouble();
    }

    @Override
    public RComplex asComplex() {
        return RComplex.RComplexFactory.getScalar(Convert.logical2double(this.value), 0.0);
    }

    @Override
    public RComplex asComplex(Convert.ConversionStatus warn) {
        return this.asComplex();
    }

    @Override
    public RString asString() {
        return RString.RStringFactory.getScalar(Convert.logical2string(this.value));
    }

    @Override
    public RString asString(Convert.ConversionStatus warn) {
        return this.asString();
    }

    @Override
    public int getLogical(int il) {
        assert (Utils.check(il == 0));
        return this.getLogical();
    }

    public int getLogical() {
        return this.value;
    }

    @Override
    public RLogical set(int i, int val) {
        assert (Utils.check(i == 0));
        return this.set(val);
    }

    public RLogical set(int val) {
        this.value = val;
        return this;
    }

    @Override
    public RLogical subset(final RInt index) {
        final int size = index.size();
        if (size == 1) {
            int i = index.getInt(0);
            if (i > 1) {
                return RLogical.BOXED_NA;
            }
            return this;
        }
        final int lvalue = this.value;
        return new View.RLogicalView(){

            @Override
            public int getLogical(int i) {
                int j = index.getInt(i);
                if (j > 1) {
                    return Integer.MIN_VALUE;
                }
                return lvalue;
            }

            @Override
            public int size() {
                return size;
            }

            @Override
            public boolean isSharedReal() {
                return index.isShared();
            }

            @Override
            public void ref() {
                index.ref();
            }

            @Override
            public boolean dependsOn(RAny v) {
                return index.dependsOn(v);
            }
        };
    }

    @Override
    public String typeOf() {
        return "logical";
    }
}

