/*
 * Decompiled with CFR 0.152.
 */
package r.data.internal;

import r.Convert;
import r.Utils;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RRaw;
import r.data.RString;
import r.data.internal.ArrayImpl;
import r.data.internal.View;

public class ScalarStringImpl
extends ArrayImpl
implements RString {
    String value;

    public ScalarStringImpl(String value) {
        this.value = value;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public Object get(int i) {
        assert (Utils.check(i == 0));
        return this.get();
    }

    public Object get() {
        return this.value;
    }

    @Override
    public RAny boxedGet(int i) {
        assert (Utils.check(i == 0));
        return this.boxedGet();
    }

    public RAny boxedGet() {
        return this;
    }

    @Override
    public RArray set(int i, Object val) {
        assert (Utils.check(i == 0));
        return this.set(val);
    }

    public RArray set(Object val) {
        return this.set((String)val);
    }

    @Override
    public RString setDimensions(int[] dimensions) {
        return RString.RStringFactory.getFor(new String[]{this.value}, dimensions, null);
    }

    @Override
    public RString setNames(RArray.Names names) {
        return RString.RStringFactory.getFor(new String[]{this.value}, null, names);
    }

    @Override
    public RString setAttributes(RAny.Attributes attributes) {
        return RString.RStringFactory.getFor(new String[]{this.value}, null, null, attributes);
    }

    @Override
    public boolean isNAorNaN(int i) {
        assert (Utils.check(i == 0));
        return this.isNAorNaN();
    }

    public boolean isNAorNaN() {
        return this.value == RString.NA;
    }

    @Override
    public ScalarStringImpl materialize() {
        return this;
    }

    @Override
    public String pretty() {
        if (this.value != RString.NA) {
            return "\"" + this.value + "\"";
        }
        return "NA";
    }

    @Override
    public RRaw asRaw() {
        return RRaw.RRawFactory.getScalar(Convert.string2raw(this.value));
    }

    @Override
    public RRaw asRaw(Convert.ConversionStatus warn) {
        return RRaw.RRawFactory.getScalar(Convert.string2raw(this.value, warn));
    }

    @Override
    public RLogical asLogical() {
        return RLogical.RLogicalFactory.getScalar(Convert.string2logical(this.value));
    }

    @Override
    public RLogical asLogical(Convert.ConversionStatus warn) {
        return RLogical.RLogicalFactory.getScalar(Convert.string2logical(this.value, warn));
    }

    @Override
    public RInt asInt() {
        return RInt.RIntFactory.getScalar(Convert.string2int(this.value));
    }

    @Override
    public RInt asInt(Convert.ConversionStatus warn) {
        return RInt.RIntFactory.getScalar(Convert.string2int(this.value, warn));
    }

    @Override
    public RDouble asDouble() {
        return RDouble.RDoubleFactory.getScalar(Convert.string2double(this.value));
    }

    @Override
    public RDouble asDouble(Convert.ConversionStatus warn) {
        return RDouble.RDoubleFactory.getScalar(Convert.string2double(this.value, warn));
    }

    @Override
    public RComplex asComplex() {
        return RComplex.RComplexFactory.getScalar(Convert.string2complex(this.value));
    }

    @Override
    public RComplex asComplex(Convert.ConversionStatus warn) {
        return RComplex.RComplexFactory.getScalar(Convert.string2complex(this.value, warn));
    }

    @Override
    public RString asString() {
        return this;
    }

    @Override
    public RString asString(Convert.ConversionStatus warn) {
        return this;
    }

    @Override
    public String getString(int i) {
        assert (Utils.check(i == 0));
        return this.getString();
    }

    public String getString() {
        return this.value;
    }

    @Override
    public RString set(int i, String val) {
        assert (Utils.check(i == 0));
        return this.set(val);
    }

    public RString set(String val) {
        this.value = val;
        return this;
    }

    @Override
    public RString subset(final RInt index) {
        final int size = index.size();
        if (size == 1) {
            int i = index.getInt(0);
            if (i > 1) {
                return RString.BOXED_NA;
            }
            return this;
        }
        final String svalue = this.value;
        return new View.RStringView(){

            @Override
            public String getString(int i) {
                int j = index.getInt(i);
                if (j > 1) {
                    return RString.NA;
                }
                return svalue;
            }

            @Override
            public int size() {
                return size;
            }

            @Override
            public boolean isSharedReal() {
                return index.isShared();
            }

            @Override
            public void ref() {
                index.ref();
            }

            @Override
            public boolean dependsOn(RAny v) {
                return index.dependsOn(v);
            }
        };
    }

    @Override
    public String typeOf() {
        return "character";
    }
}

