/*
 * Decompiled with CFR 0.152.
 */
package r.data.internal;

import r.Convert;
import r.Utils;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RRaw;
import r.data.RString;
import r.data.internal.NonScalarArrayImpl;
import r.nodes.ast.OperationFactory;
import r.nodes.exec.RNode;

public class StringImpl
extends NonScalarArrayImpl
implements RString {
    final String[] content;
    private static final String EMPTY_STRING = "character(0)";
    private static final String NAMED_EMPTY_STRING = "named character(0)";

    public String[] getContent() {
        return this.content;
    }

    public StringImpl(String[] values, int[] dimensions, RArray.Names names, RAny.Attributes attributes, boolean doCopy) {
        if (doCopy) {
            this.content = new String[values.length];
            System.arraycopy(values, 0, this.content, 0, values.length);
        } else {
            this.content = values;
        }
        this.dimensions = dimensions;
        this.names = names;
        this.attributes = attributes;
    }

    public StringImpl(String[] values, int[] dimensions) {
        this(values, dimensions, null, null, true);
    }

    public StringImpl(String[] values) {
        this(values, null, null, null, true);
    }

    public StringImpl(int size) {
        this.content = new String[size];
    }

    public StringImpl(RString v, boolean valuesOnly) {
        this.content = new String[v.size()];
        for (int i = 0; i < this.content.length; ++i) {
            this.content[i] = v.getString(i);
        }
        if (!valuesOnly) {
            this.dimensions = v.dimensions();
            this.names = v.names();
            this.attributes = v.attributes();
        }
    }

    public StringImpl(RString v, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
        this.content = new String[v.size()];
        for (int i = 0; i < this.content.length; ++i) {
            this.content[i] = v.getString(i);
        }
        this.dimensions = dimensions;
        this.names = names;
        this.attributes = attributes;
    }

    @Override
    public int size() {
        return this.content.length;
    }

    @Override
    public Object get(int i) {
        return this.content[i];
    }

    @Override
    public String getString(int i) {
        return this.content[i];
    }

    @Override
    public RAny boxedGet(int i) {
        return RString.RStringFactory.getScalar(this.getString(i));
    }

    @Override
    public boolean isNAorNaN(int i) {
        return this.content[i] == RString.NA;
    }

    @Override
    public StringImpl set(int i, String val) {
        this.content[i] = val;
        return this;
    }

    @Override
    public RArray set(int i, Object val) {
        this.content[i] = (String)val;
        return this;
    }

    @Override
    public StringImpl materialize() {
        return this;
    }

    @Override
    public String pretty() {
        StringBuilder str = new StringBuilder();
        if (this.dimensions != null) {
            str.append(this.arrayPretty());
        } else if (this.content.length == 0) {
            str.append(this.names() == null ? EMPTY_STRING : NAMED_EMPTY_STRING);
        } else if (this.names() != null) {
            str.append(this.namedPretty());
        } else {
            if (this.content[0] != RString.NA) {
                str.append("\"");
                str.append(this.content[0]);
                str.append("\"");
            } else {
                str.append("NA");
            }
            for (int i = 1; i < this.content.length; ++i) {
                str.append(", ");
                if (this.content[i] != RString.NA) {
                    str.append("\"");
                    str.append(this.content[i]);
                    str.append("\"");
                    continue;
                }
                str.append("NA");
            }
        }
        str.append(this.attributesPretty());
        return str.toString();
    }

    @Override
    public RRaw asRaw() {
        Utils.check(false, "unreachable");
        return null;
    }

    @Override
    public RRaw asRaw(Convert.ConversionStatus warn) {
        return RString.RStringUtils.stringToRaw(this, warn);
    }

    @Override
    public RLogical asLogical() {
        return this.asLogical(null);
    }

    @Override
    public RLogical asLogical(Convert.ConversionStatus warn) {
        return RString.RStringUtils.stringToLogical(this, warn);
    }

    @Override
    public RInt asInt() {
        return this.asInt(null);
    }

    @Override
    public RInt asInt(Convert.ConversionStatus warn) {
        return RString.RStringUtils.stringToInt(this, warn);
    }

    @Override
    public RDouble asDouble() {
        return this.asDouble(null);
    }

    @Override
    public RDouble asDouble(Convert.ConversionStatus warn) {
        return RString.RStringUtils.stringToDouble(this, warn);
    }

    @Override
    public RComplex asComplex() {
        return this.asComplex(null);
    }

    @Override
    public RComplex asComplex(Convert.ConversionStatus warn) {
        return RString.RStringUtils.stringToComplex(this, warn);
    }

    @Override
    public RString asString() {
        return this;
    }

    @Override
    public RString asString(Convert.ConversionStatus warn) {
        return this;
    }

    @Override
    public <T extends RNode> T callNodeFactory(OperationFactory<T> factory) {
        Utils.nyi();
        return null;
    }

    @Override
    public RArray subset(RInt index) {
        return RString.RStringFactory.subset(this, index);
    }

    @Override
    public String typeOf() {
        return "character";
    }

    @Override
    public StringImpl doStrip() {
        return new StringImpl(this.content, null, null, null, false);
    }

    @Override
    public StringImpl doStripKeepNames() {
        return new StringImpl(this.content, null, this.names, null, false);
    }
}

