/*
 * Decompiled with CFR 0.152.
 */
package r.data.internal;

import r.Convert;
import r.Utils;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RList;
import r.data.RLogical;
import r.data.RRaw;
import r.data.RString;
import r.data.internal.ArrayImpl;
import r.data.internal.ListImpl;
import r.nodes.ast.OperationFactory;
import r.nodes.exec.RNode;

public abstract class View
extends ArrayImpl
implements RArray {
    @Override
    public RArray set(int i, Object val) {
        return this.materialize().set(i, val);
    }

    @Override
    public RArray subset(RAny keys) {
        return this.materialize().subset(keys);
    }

    @Override
    public RArray subset(RInt index) {
        return this.materialize().subset(index);
    }

    @Override
    public RArray subset(RString names) {
        return this.materialize().subset(names);
    }

    @Override
    public String pretty() {
        return this.materialize().pretty();
    }

    @Override
    public RArray setDimensions(int[] dimensions) {
        if (this.dimensions() != dimensions) {
            return this.materialize().setDimensions(dimensions);
        }
        return this;
    }

    @Override
    public RArray setNames(RArray.Names names) {
        if (this.names() != names) {
            return this.materialize().setNames(names);
        }
        return this;
    }

    @Override
    public RArray setAttributes(RAny.Attributes attributes) {
        if (this.attributes() != attributes) {
            return this.materialize().setAttributes(attributes);
        }
        return this;
    }

    @Override
    public RArray stripAttributes() {
        if (this.dimensions() == null && this.names() == null && this.attributes() == null) {
            return this;
        }
        return this.materialize().stripAttributes();
    }

    @Override
    public RArray stripAttributesKeepNames() {
        if (this.dimensions() == null && this.attributes() == null) {
            return this;
        }
        return this.materialize().stripAttributesKeepNames();
    }

    @Override
    public <T extends RNode> T callNodeFactory(OperationFactory<T> factory) {
        Utils.nyi();
        return null;
    }

    @Override
    public boolean isShared() {
        return true;
    }

    @Override
    public final boolean isTemporary() {
        return false;
    }

    public boolean isSharedReal() {
        return true;
    }

    @Override
    public boolean dependsOn(RAny value) {
        return true;
    }

    public static abstract class RListProxy<O extends RArray>
    extends RListView
    implements RList {
        protected final O orig;

        public RListProxy(O orig) {
            this.orig = orig;
            RAny.Attributes.markShared(orig.attributes());
        }

        @Override
        public int size() {
            return this.orig.size();
        }

        @Override
        public boolean isSharedReal() {
            return this.orig.isShared();
        }

        @Override
        public void ref() {
            this.orig.ref();
        }

        @Override
        public int[] dimensions() {
            return this.orig.dimensions();
        }

        @Override
        public RArray.Names names() {
            return this.orig.names();
        }

        @Override
        public RAny.Attributes attributes() {
            return this.orig.attributes();
        }

        @Override
        public boolean dependsOn(RAny value) {
            return this.orig.dependsOn(value);
        }
    }

    public static abstract class RListView
    extends View
    implements RList {
        @Override
        public Object get(int i) {
            return this.getRAny(i);
        }

        @Override
        public ListImpl materialize() {
            return RList.RListFactory.copy(this);
        }

        @Override
        public RRaw asRaw() {
            Utils.nyi();
            return null;
        }

        @Override
        public RLogical asLogical() {
            Utils.nyi();
            return null;
        }

        @Override
        public RInt asInt() {
            Utils.nyi();
            return null;
        }

        @Override
        public RDouble asDouble() {
            Utils.nyi();
            return null;
        }

        @Override
        public RComplex asComplex() {
            Utils.nyi();
            return null;
        }

        @Override
        public RString asString() {
            Utils.nyi();
            return null;
        }

        @Override
        public RList asList() {
            return this;
        }

        @Override
        public RAny boxedGet(int i) {
            return RList.RListFactory.getScalar(this.getRAny(i));
        }

        @Override
        public boolean isNAorNaN(int i) {
            RArray a;
            RAny v = this.getRAny(i);
            if (v instanceof RArray && (a = (RArray)v).size() == 1) {
                return a.isNAorNaN(0);
            }
            return false;
        }

        @Override
        public RArray set(int i, RAny val) {
            return this.materialize().set(i, val);
        }

        @Override
        public RArray subset(RInt index) {
            return RList.RListFactory.subset(this, index);
        }

        @Override
        public RAny getRAnyRef(int i) {
            RAny v = this.getRAny(i);
            v.ref();
            return v;
        }

        @Override
        public String typeOf() {
            return "list";
        }

        @Override
        public RList doStrip() {
            return RList.RListFactory.strip(this);
        }

        @Override
        public RList doStripKeepNames() {
            return RList.RListFactory.stripKeepNames(this);
        }
    }

    public static abstract class RStringProxy<O extends RArray>
    extends RStringView
    implements RString {
        protected final O orig;

        public RStringProxy(O orig) {
            this.orig = orig;
            RAny.Attributes.markShared(orig.attributes());
        }

        @Override
        public int size() {
            return this.orig.size();
        }

        @Override
        public boolean isSharedReal() {
            return this.orig.isShared();
        }

        @Override
        public void ref() {
            this.orig.ref();
        }

        @Override
        public int[] dimensions() {
            return this.orig.dimensions();
        }

        @Override
        public RArray.Names names() {
            return this.orig.names();
        }

        @Override
        public RAny.Attributes attributes() {
            return this.orig.attributes();
        }

        @Override
        public boolean dependsOn(RAny value) {
            return this.orig.dependsOn(value);
        }
    }

    public static abstract class RStringView
    extends View
    implements RString {
        @Override
        public Object get(int i) {
            return this.getString(i);
        }

        @Override
        public RString materialize() {
            return RString.RStringFactory.copy(this);
        }

        @Override
        public RRaw asRaw() {
            Utils.check(false, "unreachable");
            return null;
        }

        @Override
        public RRaw asRaw(Convert.ConversionStatus warn) {
            return RString.RStringUtils.stringToRaw(this, warn);
        }

        @Override
        public RLogical asLogical() {
            Utils.check(false, "unreachable");
            return null;
        }

        @Override
        public RLogical asLogical(Convert.ConversionStatus warn) {
            return RString.RStringUtils.stringToLogical(this, warn);
        }

        @Override
        public RInt asInt() {
            Utils.check(false, "unreachable");
            return null;
        }

        @Override
        public RInt asInt(Convert.ConversionStatus warn) {
            return RString.RStringUtils.stringToInt(this, warn);
        }

        @Override
        public RDouble asDouble() {
            Utils.check(false, "unreachable");
            return null;
        }

        @Override
        public RDouble asDouble(Convert.ConversionStatus warn) {
            return RString.RStringUtils.stringToDouble(this, warn);
        }

        @Override
        public RComplex asComplex() {
            Utils.check(false, "unreachable");
            return null;
        }

        @Override
        public RComplex asComplex(Convert.ConversionStatus warn) {
            return RString.RStringUtils.stringToComplex(this, warn);
        }

        @Override
        public RString asString() {
            return this;
        }

        @Override
        public RString asString(Convert.ConversionStatus warn) {
            return this;
        }

        @Override
        public RAny boxedGet(int i) {
            return RString.RStringFactory.getScalar(this.getString(i));
        }

        @Override
        public boolean isNAorNaN(int i) {
            return this.getString(i) == RString.NA;
        }

        @Override
        public RString set(int i, String val) {
            return this.materialize().set(i, val);
        }

        @Override
        public RArray subset(RInt index) {
            return RString.RStringFactory.subset(this, index);
        }

        @Override
        public String typeOf() {
            return "character";
        }

        @Override
        public RString doStrip() {
            return RString.RStringFactory.strip(this);
        }

        @Override
        public RString doStripKeepNames() {
            return RString.RStringFactory.stripKeepNames(this);
        }
    }

    public static abstract class RComplexProxy<O extends RArray>
    extends RComplexView
    implements RComplex {
        protected final O orig;

        public RComplexProxy(O orig) {
            this.orig = orig;
            RAny.Attributes.markShared(orig.attributes());
        }

        @Override
        public int size() {
            return this.orig.size();
        }

        @Override
        public boolean isSharedReal() {
            return this.orig.isShared();
        }

        @Override
        public void ref() {
            this.orig.ref();
        }

        @Override
        public int[] dimensions() {
            return this.orig.dimensions();
        }

        @Override
        public RArray.Names names() {
            return this.orig.names();
        }

        @Override
        public RAny.Attributes attributes() {
            return this.orig.attributes();
        }

        @Override
        public boolean dependsOn(RAny value) {
            return this.orig.dependsOn(value);
        }
    }

    public static abstract class RComplexView
    extends View
    implements RComplex {
        @Override
        public Object get(int i) {
            return new RComplex.Complex(this.getReal(i), this.getImag(i));
        }

        @Override
        public RAny boxedGet(int i) {
            return RComplex.RComplexFactory.getScalar(this.getReal(i), this.getImag(i));
        }

        @Override
        public boolean isNAorNaN(int i) {
            return RComplex.RComplexUtils.eitherIsNAorNaN(this.getReal(i), this.getImag(i));
        }

        @Override
        public RRaw asRaw() {
            return this.asRaw(null);
        }

        @Override
        public RRaw asRaw(Convert.ConversionStatus warn) {
            return RComplex.RComplexUtils.complexToRaw(this, warn);
        }

        @Override
        public RLogical asLogical() {
            return new RComplex.RLogicalView(this);
        }

        @Override
        public RLogical asLogical(Convert.ConversionStatus warn) {
            return this.asLogical();
        }

        @Override
        public RInt asInt() {
            return this.asInt(null);
        }

        @Override
        public RInt asInt(Convert.ConversionStatus warn) {
            return RComplex.RComplexUtils.complex2int(this, warn);
        }

        @Override
        public RDouble asDouble() {
            return this.asDouble(null);
        }

        @Override
        public RDouble asDouble(Convert.ConversionStatus warn) {
            return RComplex.RComplexUtils.complex2double(this, warn);
        }

        @Override
        public RComplex asComplex() {
            return this;
        }

        @Override
        public RComplex asComplex(Convert.ConversionStatus warn) {
            return this;
        }

        @Override
        public RString asString() {
            return new RComplex.RStringView(this);
        }

        @Override
        public RString asString(Convert.ConversionStatus warn) {
            return this.asString();
        }

        @Override
        public RComplex materialize() {
            return RComplex.RComplexFactory.copy(this);
        }

        @Override
        public double[] getContent() {
            return this.materialize().getContent();
        }

        @Override
        public RComplex set(int i, double real, double imag) {
            return this.materialize().set(i, real, imag);
        }

        @Override
        public RArray subset(RInt index) {
            return RComplex.RComplexFactory.subset(this, index);
        }

        @Override
        public String typeOf() {
            return "complex";
        }

        @Override
        public RComplex doStrip() {
            return RComplex.RComplexFactory.strip(this);
        }

        @Override
        public RComplex doStripKeepNames() {
            return RComplex.RComplexFactory.stripKeepNames(this);
        }
    }

    public static abstract class RDoubleProxy<O extends RArray>
    extends RDoubleView
    implements RDouble {
        protected final O orig;

        public RDoubleProxy(O orig) {
            this.orig = orig;
            RAny.Attributes.markShared(orig.attributes());
        }

        @Override
        public int size() {
            return this.orig.size();
        }

        @Override
        public boolean isSharedReal() {
            return this.orig.isShared();
        }

        @Override
        public void ref() {
            this.orig.ref();
        }

        @Override
        public int[] dimensions() {
            return this.orig.dimensions();
        }

        @Override
        public RArray.Names names() {
            return this.orig.names();
        }

        @Override
        public RAny.Attributes attributes() {
            return this.orig.attributes();
        }

        @Override
        public boolean dependsOn(RAny value) {
            return this.orig.dependsOn(value);
        }
    }

    public static abstract class RDoubleView
    extends View
    implements RDouble {
        @Override
        public Object get(int i) {
            return this.getDouble(i);
        }

        @Override
        public RAny boxedGet(int i) {
            return RDouble.RDoubleFactory.getScalar(this.getDouble(i));
        }

        @Override
        public boolean isNAorNaN(int i) {
            return RDouble.RDoubleUtils.isNAorNaN(this.getDouble(i));
        }

        @Override
        public RRaw asRaw() {
            return new RDouble.RRawView(this);
        }

        @Override
        public RRaw asRaw(Convert.ConversionStatus warn) {
            return RDouble.RDoubleUtils.doubleToRaw(this, warn);
        }

        @Override
        public RLogical asLogical() {
            return new RDouble.RLogicalView(this);
        }

        @Override
        public RLogical asLogical(Convert.ConversionStatus warn) {
            return this.asLogical();
        }

        @Override
        public RInt asInt() {
            return new RDouble.RIntView(this);
        }

        @Override
        public RInt asInt(Convert.ConversionStatus warn) {
            return RDouble.RDoubleUtils.double2int(this, warn);
        }

        @Override
        public RDouble asDouble() {
            return this;
        }

        @Override
        public RDouble asDouble(Convert.ConversionStatus warn) {
            return this;
        }

        @Override
        public RComplex asComplex() {
            return new RDouble.RComplexView(this);
        }

        @Override
        public RComplex asComplex(Convert.ConversionStatus warn) {
            return this.asComplex();
        }

        @Override
        public RString asString() {
            return new RDouble.RStringView(this);
        }

        @Override
        public RString asString(Convert.ConversionStatus warn) {
            return this.asString();
        }

        @Override
        public RDouble materialize() {
            return RDouble.RDoubleFactory.copy(this);
        }

        @Override
        public double[] getContent() {
            return this.materialize().getContent();
        }

        @Override
        public RDouble set(int i, double val) {
            return this.materialize().set(i, val);
        }

        @Override
        public RArray subset(RInt index) {
            return RDouble.RDoubleFactory.subset(this, index);
        }

        @Override
        public String typeOf() {
            return "double";
        }

        @Override
        public RDouble doStrip() {
            return RDouble.RDoubleFactory.strip(this);
        }

        @Override
        public RDouble doStripKeepNames() {
            return RDouble.RDoubleFactory.stripKeepNames(this);
        }
    }

    public static abstract class RIntProxy<O extends RArray>
    extends RIntView
    implements RInt {
        protected final O orig;

        public RIntProxy(O orig) {
            this.orig = orig;
            RAny.Attributes.markShared(orig.attributes());
        }

        @Override
        public int size() {
            return this.orig.size();
        }

        @Override
        public boolean isSharedReal() {
            return this.orig.isShared();
        }

        @Override
        public void ref() {
            this.orig.ref();
        }

        @Override
        public int[] dimensions() {
            return this.orig.dimensions();
        }

        @Override
        public RArray.Names names() {
            return this.orig.names();
        }

        @Override
        public RAny.Attributes attributes() {
            return this.orig.attributes();
        }

        @Override
        public boolean dependsOn(RAny value) {
            return this.orig.dependsOn(value);
        }
    }

    public static abstract class RIntView
    extends View
    implements RInt {
        @Override
        public Object get(int i) {
            return this.getInt(i);
        }

        @Override
        public RInt materialize() {
            return RInt.RIntFactory.copy(this);
        }

        @Override
        public int[] getContent() {
            return this.materialize().getContent();
        }

        @Override
        public RRaw asRaw() {
            return new RInt.RRawView(this);
        }

        @Override
        public RRaw asRaw(Convert.ConversionStatus warn) {
            return RInt.RIntUtils.intToRaw(this, warn);
        }

        @Override
        public RLogical asLogical() {
            return new RInt.RLogicalView(this);
        }

        @Override
        public RLogical asLogical(Convert.ConversionStatus warn) {
            return this.asLogical();
        }

        @Override
        public RInt asInt() {
            return this;
        }

        @Override
        public RInt asInt(Convert.ConversionStatus warn) {
            return this;
        }

        @Override
        public RDouble asDouble() {
            return new RInt.RDoubleView(this);
        }

        @Override
        public RDouble asDouble(Convert.ConversionStatus warn) {
            return this.asDouble();
        }

        @Override
        public RComplex asComplex() {
            return new RInt.RComplexView(this);
        }

        @Override
        public RComplex asComplex(Convert.ConversionStatus warn) {
            return this.asComplex();
        }

        @Override
        public RString asString() {
            return new RInt.RStringView(this);
        }

        @Override
        public RAny boxedGet(int i) {
            return RInt.RIntFactory.getScalar(this.getInt(i));
        }

        @Override
        public boolean isNAorNaN(int i) {
            return this.getInt(i) == Integer.MIN_VALUE;
        }

        @Override
        public RInt set(int i, int val) {
            return this.materialize().set(i, val);
        }

        @Override
        public RArray subset(RInt index) {
            return RInt.RIntFactory.subset(this, index);
        }

        @Override
        public String typeOf() {
            return "integer";
        }

        @Override
        public RInt doStrip() {
            return RInt.RIntFactory.strip(this);
        }

        @Override
        public RInt doStripKeepNames() {
            return RInt.RIntFactory.stripKeepNames(this);
        }
    }

    public static abstract class RLogicalProxy<O extends RArray>
    extends RLogicalView
    implements RLogical {
        protected final O orig;

        public RLogicalProxy(O orig) {
            this.orig = orig;
            RAny.Attributes.markShared(orig.attributes());
        }

        @Override
        public int size() {
            return this.orig.size();
        }

        @Override
        public boolean isSharedReal() {
            return this.orig.isShared();
        }

        @Override
        public void ref() {
            this.orig.ref();
        }

        @Override
        public int[] dimensions() {
            return this.orig.dimensions();
        }

        @Override
        public RArray.Names names() {
            return this.orig.names();
        }

        @Override
        public RAny.Attributes attributes() {
            return this.orig.attributes();
        }

        @Override
        public boolean dependsOn(RAny value) {
            return this.orig.dependsOn(value);
        }
    }

    public static abstract class RLogicalView
    extends View
    implements RLogical {
        @Override
        public Object get(int i) {
            return this.getLogical(i);
        }

        @Override
        public RLogical materialize() {
            return RLogical.RLogicalFactory.copy(this);
        }

        @Override
        public RRaw asRaw() {
            return new RLogical.RRawView(this);
        }

        @Override
        public RRaw asRaw(Convert.ConversionStatus warn) {
            return RLogical.RLogicalUtils.logicalToRaw(this, warn);
        }

        @Override
        public RLogical asLogical() {
            return this;
        }

        @Override
        public RLogical asLogical(Convert.ConversionStatus warn) {
            return this;
        }

        @Override
        public RInt asInt() {
            return new RLogical.RIntView(this);
        }

        @Override
        public RInt asInt(Convert.ConversionStatus warn) {
            return this.asInt();
        }

        @Override
        public RDouble asDouble() {
            return new RLogical.RDoubleView(this);
        }

        @Override
        public RDouble asDouble(Convert.ConversionStatus warn) {
            return this.asDouble();
        }

        @Override
        public RComplex asComplex() {
            return new RLogical.RComplexView(this);
        }

        @Override
        public RComplex asComplex(Convert.ConversionStatus warn) {
            return this.asComplex();
        }

        @Override
        public RString asString() {
            return new RLogical.RStringView(this);
        }

        @Override
        public RString asString(Convert.ConversionStatus warn) {
            return this.asString();
        }

        @Override
        public RAny boxedGet(int i) {
            return RLogical.RLogicalFactory.getScalar(this.getLogical(i));
        }

        @Override
        public boolean isNAorNaN(int i) {
            return this.getLogical(i) == Integer.MIN_VALUE;
        }

        @Override
        public RLogical set(int i, int val) {
            return this.materialize().set(i, val);
        }

        @Override
        public RArray subset(RInt index) {
            return RLogical.RLogicalFactory.subset(this, index);
        }

        @Override
        public String typeOf() {
            return "logical";
        }

        @Override
        public RLogical doStrip() {
            return RLogical.RLogicalFactory.strip(this);
        }

        @Override
        public RLogical doStripKeepNames() {
            return RLogical.RLogicalFactory.stripKeepNames(this);
        }
    }

    public static abstract class RRawProxy<O extends RArray>
    extends RRawView
    implements RRaw {
        protected final O orig;

        public RRawProxy(O orig) {
            this.orig = orig;
            RAny.Attributes.markShared(orig.attributes());
        }

        @Override
        public int size() {
            return this.orig.size();
        }

        @Override
        public boolean isSharedReal() {
            return this.orig.isShared();
        }

        @Override
        public void ref() {
            this.orig.ref();
        }

        @Override
        public int[] dimensions() {
            return this.orig.dimensions();
        }

        @Override
        public RArray.Names names() {
            return this.orig.names();
        }

        @Override
        public RAny.Attributes attributes() {
            return this.orig.attributes();
        }

        @Override
        public boolean dependsOn(RAny value) {
            return this.orig.dependsOn(value);
        }
    }

    public static abstract class RRawView
    extends View
    implements RRaw {
        @Override
        public Object get(int i) {
            return this.getRaw(i);
        }

        @Override
        public RRaw materialize() {
            return RRaw.RRawFactory.copy(this);
        }

        @Override
        public RRaw asRaw() {
            return this;
        }

        @Override
        public RRaw asRaw(Convert.ConversionStatus warn) {
            return this;
        }

        @Override
        public RLogical asLogical() {
            return new RRaw.RLogicalView(this);
        }

        @Override
        public RLogical asLogical(Convert.ConversionStatus warn) {
            return this.asLogical();
        }

        @Override
        public RInt asInt() {
            return new RRaw.RIntView(this);
        }

        @Override
        public RInt asInt(Convert.ConversionStatus warn) {
            return this.asInt();
        }

        @Override
        public RDouble asDouble() {
            return new RRaw.RDoubleView(this);
        }

        @Override
        public RDouble asDouble(Convert.ConversionStatus warn) {
            return this.asDouble();
        }

        @Override
        public RComplex asComplex() {
            return new RRaw.RComplexView(this);
        }

        @Override
        public RComplex asComplex(Convert.ConversionStatus warn) {
            return this.asComplex();
        }

        @Override
        public RString asString() {
            return new RRaw.RStringView(this);
        }

        @Override
        public RString asString(Convert.ConversionStatus warn) {
            return this.asString();
        }

        @Override
        public RAny boxedGet(int i) {
            return RRaw.RRawFactory.getScalar(this.getRaw(i));
        }

        @Override
        public boolean isNAorNaN(int i) {
            return false;
        }

        @Override
        public RRaw set(int i, byte val) {
            return this.materialize().set(i, val);
        }

        @Override
        public RArray subset(RInt index) {
            return RRaw.RRawFactory.subset(this, index);
        }

        @Override
        public String typeOf() {
            return "raw";
        }

        @Override
        public RRaw doStrip() {
            return RRaw.RRawFactory.strip(this);
        }

        @Override
        public RRaw doStripKeepNames() {
            return RRaw.RRawFactory.stripKeepNames(this);
        }
    }
}

