/*
 * Decompiled with CFR 0.152.
 */
package r.errors;

import java.io.PrintStream;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.tools.PrettyPrinter;

public class ManageError {
    private PrintStream out;
    public static final String WARNING = "Warning";
    public static final String ERROR = "Error";

    public ManageError(PrintStream errorStream) {
        this.setOutputStream(errorStream);
    }

    public void setOutputStream(PrintStream errorStream) {
        if (this.out != null) {
            this.out.flush();
        }
        this.out = errorStream;
    }

    public void warning(ASTNode expr, String msg) {
        ManageError.displayMessage(WARNING, expr, msg);
    }

    public void warning(RError err) {
        ManageError.displayMessage(WARNING, err instanceof RError.RErrorInExpr ? ((RError.RErrorInExpr)err).getErrorNode() : null, err.getMessage());
    }

    public void error(ASTNode expr, String msg) {
        ManageError.displayMessage(ERROR, expr, msg);
        throw RError.getGenericError(expr, msg);
    }

    public void error(RError err) {
        ManageError.displayMessage(ERROR, err instanceof RError.RErrorInExpr ? ((RError.RErrorInExpr)err).getErrorNode() : null, err.getMessage());
        throw err;
    }

    private static void displayMessage(String prefix, ASTNode cause, String msg) {
        StringBuilder str = new StringBuilder(prefix);
        if (cause != null) {
            str.append(" in ").append(PrettyPrinter.prettyPrint(cause));
        }
        str.append(": ");
        str.append(msg);
        System.err.println(str);
    }
}

