/*
 * Decompiled with CFR 0.152.
 */
package r.ifc;

import r.builtins.CallFactory;
import r.builtins.Primitives;
import r.data.RAny;
import r.data.RArray;
import r.data.RDouble;
import r.data.RInt;
import r.data.RString;
import r.data.RSymbol;
import r.data.internal.DoubleImpl;
import r.data.internal.IntImpl;
import r.data.internal.ScalarStringImpl;
import r.data.internal.StringImpl;
import r.ifc.ExternalJavaBuiltin;

public class Interop {
    public static void initialize() {
        Interop.register(new Invokable(){

            @Override
            public String name() {
                return "jan";
            }

            @Override
            public String[] parameters() {
                return new String[]{"foo"};
            }

            @Override
            public String[] requiredParameters() {
                return new String[0];
            }

            @Override
            public RAny invoke(CallFactory.ArgumentInfo ai, RAny[] args) {
                String res = "jan ";
                int ix = ai.position("foo");
                if (ix != -1) {
                    res = res + " got a foo of " + args[ix].asString().getString(0);
                }
                return Interop.asRString(res);
            }
        });
    }

    public static void register(Invokable fun) {
        Primitives.add(new ExternalJavaBuiltin(fun, fun.name(), fun.parameters(), fun.requiredParameters()));
    }

    public static RString asRString(String s) {
        return new ScalarStringImpl(s);
    }

    public static String asString(RAny r) {
        if (r instanceof ScalarStringImpl) {
            ScalarStringImpl s = (ScalarStringImpl)r;
            return s.getString();
        }
        return null;
    }

    public static int asInteger(RAny r) {
        RInt ri = r.asInt();
        return ri.getInt(0);
    }

    public static double asDouble(RAny r) {
        RDouble rd = r.asDouble();
        return rd.getDouble(0);
    }

    public static String[] asStringArray(RAny r) {
        if (r instanceof StringImpl) {
            return ((StringImpl)r).getContent();
        }
        if (r instanceof ScalarStringImpl) {
            return new String[]{((ScalarStringImpl)r).getString()};
        }
        return null;
    }

    public static RInt asRIntVector(int[] v) {
        return new IntImpl(v);
    }

    public static int[] asIntArray(RAny r) {
        if (r == null) {
            return null;
        }
        if (r instanceof IntImpl) {
            return ((IntImpl)r).getContent();
        }
        return null;
    }

    public static RDouble asRDoubleVector(double[] v) {
        return new DoubleImpl(v);
    }

    public static double[] asDoubleArray(RAny r) {
        if (r instanceof DoubleImpl) {
            return ((DoubleImpl)r).getContent();
        }
        return null;
    }

    public static RAny makeDoubleVector(double[] res, int[] dim, String[] names) {
        RSymbol[] namesSym = new RSymbol[names.length];
        for (int i = 0; i < names.length; ++i) {
            namesSym[i] = RSymbol.getSymbol(names[i]);
        }
        return new DoubleImpl(res, dim, RArray.Names.create(namesSym));
    }

    public static RAny setAttribute(RAny x, String which, String value) {
        RAny.Attributes attr = x.attributes();
        RSymbol which_ = RSymbol.getSymbol(which);
        ScalarStringImpl value_ = new ScalarStringImpl(value);
        if (attr != null) {
            attr.put(which_, value_);
            return x;
        }
        attr = new RAny.Attributes();
        attr.put(which_, value_);
        return x.setAttributes(attr);
    }

    public static String getAttributeAsString(RAny x, String which) {
        RSymbol which_ = RSymbol.getSymbol(which);
        RAny.Attributes attr = x.attributes();
        if (attr == null) {
            return null;
        }
        RAny r = attr.map().get(which_);
        RString rs = r.asString();
        return rs.getString(0);
    }

    public static interface Invokable {
        public RAny invoke(CallFactory.ArgumentInfo var1, RAny[] var2);

        public String name();

        public String[] requiredParameters();

        public String[] parameters();
    }
}

