/*
 * Decompiled with CFR 0.152.
 */
package r.nodes.ast;

import java.util.ArrayList;
import java.util.Collection;
import r.data.RSymbol;
import r.nodes.ast.ASTNode;
import r.nodes.ast.Visitor;

public interface ArgumentList
extends Collection<Entry> {
    public Entry first();

    public void add(ASTNode var1);

    public void add(String var1, ASTNode var2);

    public void add(RSymbol var1, ASTNode var2);

    public ASTNode getNode(int var1);

    public static class Default
    extends ArrayList<Entry>
    implements ArgumentList {
        private static final long serialVersionUID = 1L;

        @Override
        public void add(ASTNode e) {
            super.add(new DefaultEntry(null, e));
        }

        @Override
        public void add(RSymbol name, ASTNode value) {
            super.add(new DefaultEntry(name, value));
        }

        @Override
        public void add(String name, ASTNode value) {
            this.add(RSymbol.getSymbol(name), value);
        }

        @Override
        public Entry first() {
            return (Entry)this.get(0);
        }

        @Override
        public ASTNode getNode(int i) {
            return ((Entry)this.get(i)).getValue();
        }

        public static void updateParent(ASTNode parent, ArgumentList list) {
            for (Entry e : list) {
                parent.updateParent((ASTNode)((Object)e));
            }
        }

        public static final class DefaultEntry
        extends ASTNode
        implements Entry {
            RSymbol name;
            ASTNode value;

            private DefaultEntry(RSymbol n, ASTNode v) {
                this.name = n;
                this.value = this.updateParent(v);
            }

            @Override
            public RSymbol getName() {
                return this.name;
            }

            @Override
            public ASTNode getValue() {
                return this.value;
            }

            @Override
            public void visit_all(Visitor v) {
                this.getValue().accept(v);
            }

            @Override
            public void accept(Visitor v) {
                v.visit(this);
            }
        }
    }

    public static interface Entry {
        public RSymbol getName();

        public ASTNode getValue();
    }
}

