/*
 * Decompiled with CFR 0.152.
 */
package r.nodes.ast;

import r.Utils;
import r.data.RAny;
import r.data.RString;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.ast.AccessVector;
import r.nodes.ast.Constant;
import r.nodes.ast.FieldAccess;
import r.nodes.ast.FunctionCall;
import r.nodes.ast.SimpleAccessVariable;
import r.nodes.ast.SimpleAssignVariable;
import r.nodes.ast.UpdateExpression;
import r.nodes.ast.UpdateField;
import r.nodes.ast.UpdateVector;
import r.nodes.ast.Visitor;

public abstract class AssignVariable
extends ASTNode {
    final boolean isSuper;
    ASTNode rhs;

    AssignVariable(boolean isSuper, ASTNode expr) {
        this.isSuper = isSuper;
        this.rhs = this.updateParent(expr);
    }

    @Override
    public void visit_all(Visitor v) {
        this.getExpr().accept(v);
    }

    public ASTNode getExpr() {
        return this.rhs;
    }

    public boolean isSuper() {
        return this.isSuper;
    }

    public static ASTNode create(boolean isSuper, ASTNode lhs, ASTNode rhs) {
        if (lhs instanceof SimpleAccessVariable) {
            return AssignVariable.writeVariable(isSuper, ((SimpleAccessVariable)lhs).symbol, rhs);
        }
        if (lhs instanceof AccessVector) {
            return AssignVariable.writeVector(isSuper, (AccessVector)lhs, rhs);
        }
        if (lhs instanceof FieldAccess) {
            return AssignVariable.writeField(isSuper, (FieldAccess)lhs, rhs);
        }
        if (lhs instanceof FunctionCall) {
            return AssignVariable.writeFunction(isSuper, (FunctionCall)lhs, rhs);
        }
        if (lhs instanceof Constant) {
            RString svalue;
            RAny value = ((Constant)lhs).getValue();
            if (value instanceof RString && (svalue = (RString)value).size() == 1) {
                String name = svalue.getString(0);
                return AssignVariable.writeVariable(isSuper, RSymbol.getSymbol(name), rhs);
            }
            throw RError.getUnknownObject(rhs);
        }
        Utils.nyi();
        return null;
    }

    public static ASTNode writeVariable(boolean isSuper, RSymbol name, ASTNode rhs) {
        return new SimpleAssignVariable(isSuper, name, rhs);
    }

    public static ASTNode writeVector(boolean isSuper, AccessVector lhs, ASTNode rhs) {
        return new UpdateVector(isSuper, lhs, rhs);
    }

    public static ASTNode writeField(boolean isSuper, FieldAccess lhs, ASTNode rhs) {
        return new UpdateField(isSuper, lhs, rhs);
    }

    public static ASTNode writeFunction(boolean isSuper, FunctionCall lhs, ASTNode rhs) {
        if (lhs.args.size() > 0) {
            ASTNode first = lhs.args.first().getValue();
            if (!(first instanceof SimpleAccessVariable)) {
                return new UpdateExpression(isSuper, lhs, rhs);
            }
            lhs.args.add("value", rhs);
        }
        lhs.name = RSymbol.getSymbol(lhs.name.pretty() + "<-");
        lhs.isAssignment(true);
        lhs.isSuper(isSuper);
        return lhs;
    }
}

