/*
 * Decompiled with CFR 0.152.
 */
package r.nodes.ast;

import r.nodes.ast.ASTNode;
import r.nodes.ast.Add;
import r.nodes.ast.And;
import r.nodes.ast.Colon;
import r.nodes.ast.Div;
import r.nodes.ast.EQ;
import r.nodes.ast.ElementwiseAnd;
import r.nodes.ast.ElementwiseOr;
import r.nodes.ast.GE;
import r.nodes.ast.GT;
import r.nodes.ast.In;
import r.nodes.ast.IntegerDiv;
import r.nodes.ast.LE;
import r.nodes.ast.LT;
import r.nodes.ast.MatMult;
import r.nodes.ast.Mod;
import r.nodes.ast.Mult;
import r.nodes.ast.NE;
import r.nodes.ast.Operation;
import r.nodes.ast.Or;
import r.nodes.ast.OuterMult;
import r.nodes.ast.Pow;
import r.nodes.ast.Sub;
import r.nodes.ast.Visitor;

public abstract class BinaryOperation
extends Operation {
    ASTNode rhs;

    public BinaryOperation(ASTNode left, ASTNode right) {
        super(left);
        this.setRHS(right);
    }

    public ASTNode getRHS() {
        return this.rhs;
    }

    public void setRHS(ASTNode right) {
        this.rhs = this.updateParent(right);
    }

    @Override
    public void visit_all(Visitor v) {
        super.visit_all(v);
        this.getRHS().accept(v);
    }

    public static ASTNode create(BinaryOperator op, ASTNode left, ASTNode right) {
        switch (op) {
            case ADD: {
                return new Add(left, right);
            }
            case SUB: {
                return new Sub(left, right);
            }
            case MULT: {
                return new Mult(left, right);
            }
            case DIV: {
                return new Div(left, right);
            }
            case MOD: {
                return new Mod(left, right);
            }
            case POW: {
                return new Pow(left, right);
            }
            case OR: {
                return new Or(left, right);
            }
            case AND: {
                return new And(left, right);
            }
            case ELEMENTWISEOR: {
                return new ElementwiseOr(left, right);
            }
            case ELEMENTWISEAND: {
                return new ElementwiseAnd(left, right);
            }
            case EQ: {
                return new EQ(left, right);
            }
            case GE: {
                return new GE(left, right);
            }
            case GT: {
                return new GT(left, right);
            }
            case NE: {
                return new NE(left, right);
            }
            case LE: {
                return new LE(left, right);
            }
            case LT: {
                return new LT(left, right);
            }
            case COLON: {
                return new Colon(left, right);
            }
        }
        throw new Error("No node implemented for: '" + (Object)((Object)op) + "' (" + left + ", " + right + ")");
    }

    public static ASTNode create(String op, ASTNode left, ASTNode right) {
        if ("%o%".equals(op)) {
            return new OuterMult(left, right);
        }
        if ("%*%".equals(op)) {
            return new MatMult(left, right);
        }
        if ("%/%".equals(op)) {
            return new IntegerDiv(left, right);
        }
        if ("%in%".equals(op)) {
            return new In(left, right);
        }
        return null;
    }

    public static enum BinaryOperator {
        ASSIGN,
        SUPER_ASSIGN,
        ADD,
        SUB,
        MULT,
        DIV,
        MOD,
        POW,
        MODEL,
        COLON,
        GE,
        GT,
        LE,
        LT,
        EQ,
        NE,
        OR,
        ELEMENTWISEOR,
        AND,
        ELEMENTWISEAND;

    }
}

