/*
 * Decompiled with CFR 0.152.
 */
package r.nodes.ast;

import r.data.RSymbol;
import r.nodes.ast.ASTNode;
import r.nodes.ast.AccessVector;
import r.nodes.ast.ArgumentList;
import r.nodes.ast.FunctionCall;
import r.nodes.ast.SimpleAccessVariable;
import r.nodes.ast.Visitor;

public abstract class Call
extends ASTNode {
    ArgumentList args;

    public Call(ArgumentList alist) {
        this.args = alist;
    }

    @Override
    public void visit_all(Visitor v) {
        for (ArgumentList.Entry e : this.args) {
            ASTNode n = e.getValue();
            if (n == null) continue;
            n.accept(v);
        }
    }

    public ArgumentList getArgs() {
        return this.args;
    }

    public static ASTNode create(ASTNode call, ArgumentList args) {
        if (call instanceof SimpleAccessVariable) {
            SimpleAccessVariable ccall = (SimpleAccessVariable)call;
            return Call.create(ccall.getSymbol(), args);
        }
        return null;
    }

    public static ASTNode create(RSymbol funName, ArgumentList args) {
        return new FunctionCall(funName, args);
    }

    public static ASTNode create(CallOperator op, ASTNode lhs, ArgumentList args) {
        return new AccessVector(lhs, args, op == CallOperator.SUBSET);
    }

    public static enum CallOperator {
        SUBSET,
        SUBSCRIPT;

    }
}

