/*
 * Decompiled with CFR 0.152.
 */
package r.nodes.ast;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import r.Utils;
import r.data.RFunction;
import r.data.RSymbol;
import r.data.internal.FunctionImpl;
import r.nodes.ast.ASTNode;
import r.nodes.ast.AccessVector;
import r.nodes.ast.ArgumentList;
import r.nodes.ast.For;
import r.nodes.ast.FunctionCall;
import r.nodes.ast.SimpleAccessVariable;
import r.nodes.ast.SimpleAssignVariable;
import r.nodes.ast.UpdateVector;
import r.nodes.ast.Visitor;
import r.nodes.exec.RNode;
import r.nodes.tools.BasicVisitor;
import r.nodes.tools.PrettyPrinter;

public class Function
extends ASTNode {
    final ArgumentList signature;
    final ASTNode body;
    private static final RFunction.EnclosingSlot[] emptyReadSet = new RFunction.EnclosingSlot[0];
    RFunction rfunction;
    private static final boolean DEBUG_FUNCTIONS = false;

    Function(ArgumentList alist, ASTNode body) {
        this.signature = alist;
        this.body = this.updateParent(body);
    }

    public RFunction getRFunction() {
        return this.rfunction;
    }

    private void setRFunction(RFunction rfunction) {
        this.rfunction = rfunction;
    }

    public ArgumentList getSignature() {
        return this.signature;
    }

    public ASTNode getBody() {
        return this.body;
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    @Override
    public void visit_all(Visitor v) {
        this.body.accept(v);
    }

    public static ASTNode create(ArgumentList alist, ASTNode body) {
        return new Function(alist, body);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("function (");
        boolean first = true;
        for (ArgumentList.Entry a : this.signature) {
            if (first) {
                first = false;
            } else {
                str.append(", ");
            }
            str.append(a.getName().pretty());
            ASTNode exp = a.getValue();
            if (exp == null) continue;
            str.append("=");
            str.append(exp.toString());
        }
        str.append(") ");
        str.append(PrettyPrinter.prettyPrint(this.body));
        return str.toString();
    }

    private static void printAccesses(Set<RSymbol> read, Set<RSymbol> written) {
        StringBuilder str = new StringBuilder();
        str.append("Reads found in a function:");
        for (RSymbol s : read) {
            str.append(" ");
            str.append(s.pretty());
        }
        str.append("\nWrites found in a function:");
        for (RSymbol s : written) {
            str.append(" ");
            str.append(s.pretty());
        }
        Utils.debug(str.toString());
    }

    public RFunction createImpl(RSymbol[] paramNames, RNode[] paramValues, RNode runnableBody, RFunction enclosing) {
        HashSet<RSymbol> read = new HashSet<RSymbol>();
        HashSet<RSymbol> written = new HashSet<RSymbol>();
        this.findAccesses(read, written);
        RSymbol[] writeSet = Function.buildWriteSet(paramNames, written);
        RFunction.EnclosingSlot[] readSet = Function.buildReadSet(enclosing, read);
        FunctionImpl impl = new FunctionImpl(this, paramNames, paramValues, runnableBody, enclosing, writeSet, readSet);
        this.setRFunction(impl);
        return impl;
    }

    void findAccesses(Set<RSymbol> rs, Set<RSymbol> ws) {
        new FindAccesses().find(rs, ws);
    }

    private static RSymbol[] buildWriteSet(RSymbol[] argNames, Set<RSymbol> origWSet) {
        int i;
        int maxSize = origWSet.size() + argNames.length;
        RSymbol[] writeSet = new RSymbol[maxSize];
        HashSet<RSymbol> args = new HashSet<RSymbol>(argNames.length);
        for (i = 0; i < argNames.length; ++i) {
            RSymbol s;
            writeSet[i] = s = argNames[i];
            args.add(s);
        }
        for (RSymbol s : origWSet) {
            if (args.contains(s)) continue;
            writeSet[i++] = s;
        }
        if (i < maxSize) {
            RSymbol[] bigSet = writeSet;
            writeSet = new RSymbol[i];
            System.arraycopy(bigSet, 0, writeSet, 0, i);
        }
        return writeSet;
    }

    private static RFunction.EnclosingSlot[] buildReadSet(RFunction parent, Set<RSymbol> origRSet) {
        if (parent == null || origRSet.isEmpty()) {
            return emptyReadSet;
        }
        ArrayList<RFunction.EnclosingSlot> rsl = new ArrayList<RFunction.EnclosingSlot>();
        block0: for (RSymbol s : origRSet) {
            RFunction p = parent;
            int hops = 1;
            while (p != null) {
                int slot = p.localSlot(s);
                if (slot != -1) {
                    rsl.add(new RFunction.EnclosingSlot(s, hops, slot));
                    continue block0;
                }
                p = p.enclosingFunction();
                ++hops;
            }
        }
        return rsl.toArray(new RFunction.EnclosingSlot[0]);
    }

    class FindAccesses
    extends BasicVisitor
    implements Visitor {
        Set<RSymbol> read;
        Set<RSymbol> written;

        FindAccesses() {
        }

        public void find(Set<RSymbol> rs, Set<RSymbol> ws) {
            this.read = rs;
            this.written = ws;
            Function.this.visit_all(this);
            ArgumentList al = Function.this.getSignature();
            for (ArgumentList.Entry e : al) {
                ASTNode val = e.getValue();
                if (val == null) continue;
                val.visit_all(this);
            }
        }

        @Override
        public void visit(SimpleAccessVariable readVariable) {
            RSymbol symbol = readVariable.getSymbol();
            int ddval = symbol.dotDotValue();
            if (ddval == -1) {
                this.read.add(readVariable.getSymbol());
            } else {
                this.read.add(RSymbol.THREE_DOTS_SYMBOL);
            }
        }

        @Override
        public void visit(SimpleAssignVariable assign) {
            this.written.add(assign.getSymbol());
            assign.visit_all(this);
        }

        @Override
        public void visit(Function function) {
        }

        @Override
        public void visit(FunctionCall functionCall) {
            this.read.add(functionCall.getName());
            functionCall.visit_all(this);
            if (functionCall.isAssignment()) {
                SimpleAccessVariable varAccess = (SimpleAccessVariable)functionCall.getArgs().first().getValue();
                this.written.add(varAccess.getSymbol());
            }
        }

        @Override
        public void visit(For n) {
            this.written.add(n.getCVar());
            n.visit_all(this);
        }

        @Override
        public void visit(UpdateVector n) {
            AccessVector a = n.getVector();
            ASTNode v = a.getVector();
            if (!(v instanceof SimpleAccessVariable)) {
                Utils.nyi("unsupported");
            }
            this.written.add(((SimpleAccessVariable)v).getSymbol());
            n.visit_all(this);
        }
    }
}

