/*
 * Decompiled with CFR 0.152.
 */
package r.nodes.ast;

import r.nodes.ast.ASTNode;
import r.nodes.ast.Visitor;

public class If
extends ASTNode {
    ASTNode cond;
    ASTNode trueCase;
    ASTNode falseCase;

    If(ASTNode cond, ASTNode truecase, ASTNode falsecase) {
        this.setCond(cond);
        this.setTrueCase(truecase);
        this.setFalseCase(falsecase);
    }

    public ASTNode getCond() {
        return this.cond;
    }

    public ASTNode getTrueCase() {
        return this.trueCase;
    }

    public ASTNode getFalseCase() {
        return this.falseCase;
    }

    public void setCond(ASTNode cond) {
        this.cond = this.updateParent(cond);
    }

    public void setTrueCase(ASTNode trueCase) {
        this.trueCase = this.updateParent(trueCase);
    }

    public void setFalseCase(ASTNode falseCase) {
        this.falseCase = this.updateParent(falseCase);
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    @Override
    public void visit_all(Visitor v) {
        this.getCond().accept(v);
        this.getTrueCase().accept(v);
        ASTNode fcase = this.getFalseCase();
        if (fcase != null) {
            fcase.accept(v);
        }
    }

    public static If create(ASTNode cond, ASTNode trueBranch) {
        return If.create(cond, trueBranch, null);
    }

    public static If create(ASTNode cond, ASTNode trueBranch, ASTNode falseBranch) {
        return new If(cond, trueBranch, falseBranch);
    }
}

