/*
 * Decompiled with CFR 0.152.
 */
package r.nodes.ast;

import java.util.ArrayList;
import r.nodes.ast.ASTNode;
import r.nodes.ast.Visitor;

public class Sequence
extends ASTNode {
    ASTNode[] exprs;

    Sequence(ASTNode[] e) {
        this.exprs = this.updateParent(e);
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    public ASTNode[] getExprs() {
        return this.exprs;
    }

    @Override
    public void visit_all(Visitor v) {
        for (ASTNode e : this.exprs) {
            e.accept(v);
        }
    }

    public String toString() {
        if (this.exprs.length == 0) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        boolean first = true;
        for (ASTNode e : this.exprs) {
            if (!first) {
                str.append("; ");
            }
            first = false;
            str.append(e.toString());
        }
        return str.toString();
    }

    public static ASTNode create(ArrayList<ASTNode> exprs) {
        return new Sequence(exprs.toArray(new ASTNode[exprs.size()]));
    }

    public static ASTNode create(ASTNode[] exprs) {
        return new Sequence(exprs);
    }
}

