/*
 * Decompiled with CFR 0.152.
 */
package r.nodes.ast;

import r.nodes.ast.ASTNode;
import r.nodes.ast.Not;
import r.nodes.ast.Operation;
import r.nodes.ast.UnaryMinus;
import r.nodes.ast.Visitor;

public abstract class UnaryOperation
extends Operation {
    public UnaryOperation(ASTNode op) {
        super(op);
    }

    @Override
    public void accept(Visitor v) {
        this.getLHS().accept(v);
    }

    public static ASTNode create(UnaryOperator op, ASTNode operand) {
        switch (op) {
            case PLUS: {
                return new Not(operand);
            }
            case MINUS: {
                return new UnaryMinus(operand);
            }
            case NOT: {
                return new Not(operand);
            }
        }
        throw new Error("No node implemented for: '" + (Object)((Object)op) + "' (" + operand + ")");
    }

    public static enum UnaryOperator {
        REPEAT,
        PLUS,
        MINUS,
        NOT,
        MODEL;

    }
}

