/*
 * Decompiled with CFR 0.152.
 */
package r.nodes.exec;

import r.Utils;
import r.data.RDots;
import r.data.RFunction;
import r.data.RPromise;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.BaseR;
import r.nodes.exec.FunctionCall;
import r.nodes.exec.RNode;
import r.nodes.tools.PrettyPrinter;
import r.runtime.Frame;

public abstract class AbstractCall
extends BaseR {
    private static final boolean MATERIALIZE_ON_FUNCTION_CALL = true;
    protected final RSymbol[] argNames;
    @RNode.Children
    protected final RNode[] argExprs;

    public AbstractCall(ASTNode orig, RSymbol[] argNames, RNode[] argsExprs, boolean adoptArgsExprs) {
        super(orig);
        this.argNames = argNames;
        this.argExprs = adoptArgsExprs ? this.adoptChildren(argsExprs) : argsExprs;
    }

    public AbstractCall(ASTNode orig, RSymbol[] argNames, RNode[] argsExprs) {
        this(orig, argNames, argsExprs, true);
    }

    public RSymbol[] argNames() {
        return this.argNames;
    }

    public RNode[] argExprs() {
        return this.argExprs;
    }

    @Override
    protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
        assert (oldNode != null);
        if (this.argExprs != null) {
            for (int i = 0; i < this.argExprs.length; ++i) {
                if (this.argExprs[i] != oldNode) continue;
                this.argExprs[i] = newNode;
                return this.adoptInternal(newNode);
            }
        }
        return super.replaceChild(oldNode, newNode);
    }

    public String toString() {
        String args = "";
        for (int i = 0; i < this.argExprs.length; ++i) {
            if (this.argNames != null && this.argNames[i] != null) {
                args = args + this.argNames[i] + "=";
            }
            args = args + this.argExprs[i] + ",";
        }
        return this.getClass() + "[" + args + "]";
    }

    protected final int[] computePositions(RFunction func, FunctionCall.DotsInfo dotsInfo) {
        return this.computePositions(func.paramNames(), dotsInfo, func.dotsIndex());
    }

    protected final int[] computePositions(RSymbol[] paramNames, FunctionCall.DotsInfo dotsInfo, int dotsIndex) {
        int j;
        int nArgs = this.argExprs.length;
        int nParams = paramNames.length;
        boolean[] providedParams = new boolean[nParams];
        int[] argPositions = new int[nArgs];
        for (int i = 0; i < nArgs; ++i) {
            RSymbol argName = this.argNames[i];
            if (argName == null) continue;
            for (j = 0; j < nParams; ++j) {
                if (argName != paramNames[j]) continue;
                if (providedParams[j]) {
                    throw RError.getFormalMatchedMultiple(this.ast, argName.name());
                }
                argPositions[i] = j + 1;
                providedParams[j] = true;
            }
        }
        boolean hasUnmatchedNamedArgs = false;
        for (int i = 0; i < nArgs; ++i) {
            if (this.argNames[i] == null || argPositions[i] != 0) continue;
            hasUnmatchedNamedArgs = true;
            break;
        }
        if (hasUnmatchedNamedArgs) {
            boolean[] argMatchedViaPatternMatching = new boolean[nArgs];
            for (j = 0; j < nParams; ++j) {
                if (providedParams[j]) continue;
                RSymbol paramName = paramNames[j];
                if (paramName == RSymbol.THREE_DOTS_SYMBOL) break;
                boolean paramMatched = false;
                for (int i = 0; i < nArgs; ++i) {
                    RSymbol argName = this.argNames[i];
                    if (argName == null) continue;
                    if (argMatchedViaPatternMatching[i]) {
                        if (!paramName.startsWith(argName)) continue;
                        throw RError.getArgumentMatchesMultiple(this.ast, i + 1);
                    }
                    if (argPositions[i] != 0 || !paramName.startsWith(argName)) continue;
                    if (paramMatched) {
                        throw RError.getFormalMatchedMultiple(this.ast, paramName.name());
                    }
                    argPositions[i] = j + 1;
                    providedParams[j] = true;
                    argMatchedViaPatternMatching[i] = true;
                    paramMatched = true;
                }
            }
        }
        int i = 0;
        j = 0;
        boolean hasUnusedArgsWithNames = false;
        int nDotsArgs = 0;
        block5: while (true) {
            if (i == nArgs) {
                if (!hasUnusedArgsWithNames) break;
                this.reportUnusedArgsError(nArgs, argPositions);
                break;
            }
            if (argPositions[i] != 0) {
                ++i;
                continue;
            }
            while (true) {
                if (j == nParams) {
                    this.reportUnusedArgsError(nArgs, argPositions);
                }
                if (!providedParams[j]) break;
                ++j;
            }
            RSymbol paramName = paramNames[j];
            if (paramName == RSymbol.THREE_DOTS_SYMBOL) {
                argPositions[i] = -1;
                ++i;
                ++nDotsArgs;
                while (i != nArgs) {
                    while (argPositions[i] != 0) {
                        if (++i != nArgs) continue;
                        break block5;
                    }
                    argPositions[i] = -1;
                    ++i;
                    ++nDotsArgs;
                }
                break;
            }
            if (this.argNames[i] == null) {
                argPositions[i] = j + 1;
                providedParams[j] = true;
                ++i;
                ++j;
                continue;
            }
            ++i;
            hasUnusedArgsWithNames = true;
        }
        if (dotsIndex >= 0) {
            RSymbol[] dnames = new RSymbol[nDotsArgs];
            int di = 0;
            for (i = 0; i < nArgs; ++i) {
                if (argPositions[i] >= 0) continue;
                dnames[di++] = this.argNames[i];
            }
            dotsInfo.names = dnames;
        } else {
            dotsInfo.names = null;
        }
        return argPositions;
    }

    private int reportUnusedArgsError(int nArgs, int[] argPositions) {
        StringBuilder str = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < nArgs; ++i) {
            RNode argExpr;
            if (argPositions[i] != 0) continue;
            if (!first) {
                str.append(", ");
            } else {
                first = false;
            }
            RSymbol argName = this.argNames[i];
            if (argName != null) {
                str.append(argName);
                str.append(" = ");
            }
            if ((argExpr = this.argExprs[i]) == null) continue;
            str.append(PrettyPrinter.prettyPrint(argExpr.getAST()));
        }
        throw RError.getUnusedArgument(this.ast, str.toString());
    }

    protected final void placeArgs(Frame callerFrame, Frame newFrame, int[] argPositions, FunctionCall.DotsInfo dotsInfo, int dotsIndex, int nParams) {
        RSymbol[] dnames = dotsInfo.names;
        if (dotsIndex == -1) {
            for (int i = 0; i < this.argExprs.length; ++i) {
                int p = argPositions[i] - 1;
                assert (Utils.check(p >= 0));
                newFrame.set(p, this.promiseForArgument(callerFrame, i));
            }
        } else {
            Object[] dargs = new Object[dnames.length];
            int di = 0;
            for (int i = 0; i < this.argExprs.length; ++i) {
                int p = argPositions[i] - 1;
                if (p >= 0) {
                    newFrame.set(p, this.promiseForArgument(callerFrame, i));
                    continue;
                }
                dargs[di++] = this.promiseForArgument(callerFrame, i);
            }
            newFrame.set(dotsIndex, new RDots(dnames, dargs));
        }
    }

    protected final Object promiseForArgument(Frame callerFrame, int argIndex) {
        RNode argExpr = this.argExprs[argIndex];
        if (argExpr != null) {
            return RPromise.createNormal(argExpr, callerFrame);
        }
        return null;
    }
}

