/*
 * Decompiled with CFR 0.152.
 */
package r.nodes.exec;

import java.util.LinkedHashMap;
import java.util.Map;
import r.RContext;
import r.Utils;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RSymbol;
import r.data.internal.ComplexImpl;
import r.data.internal.DoubleImpl;
import r.data.internal.IntImpl;
import r.data.internal.ScalarComplexImpl;
import r.data.internal.ScalarDoubleImpl;
import r.data.internal.ScalarIntImpl;
import r.data.internal.ScalarLogicalImpl;
import r.data.internal.View;
import r.errors.RError;
import r.gnur.GNUR;
import r.nodes.ast.ASTNode;
import r.nodes.exec.BaseR;
import r.nodes.exec.Constant;
import r.nodes.exec.RNode;
import r.runtime.Frame;
import r.runtime.SpecializationException;

public class Arithmetic
extends BaseR {
    private static final boolean IN_PLACE = true;
    @RNode.Child
    RNode left;
    @RNode.Child
    RNode right;
    final ValueArithmetic arit;
    private static final boolean EAGER = false;
    private static final boolean LIMIT_VIEW_DEPTH = true;
    private static final int MAX_VIEW_DEPTH = 5;
    private static final boolean DEBUG_AR = false;
    private static final boolean EAGER_COMPLEX = true;
    public static final Add ADD = new Add();
    public static final Sub SUB = new Sub();
    public static final Mult MULT = new Mult();
    public static final Pow POW = new Pow();
    public static final Div DIV = new Div();
    public static final IntegerDiv INTEGER_DIV = new IntegerDiv();
    public static final Mod MOD = new Mod();

    public Arithmetic(ASTNode ast, RNode left, RNode right, ValueArithmetic arit) {
        super(ast);
        this.left = this.adoptChild(left);
        this.right = this.adoptChild(right);
        this.arit = arit;
    }

    public static boolean returnsDouble(ValueArithmetic arit) {
        return arit.returnsDouble();
    }

    @Override
    public Object execute(Frame frame) {
        Object lexpr = this.left.execute(frame);
        if (this.getNewNode() != null) {
            return ((Arithmetic)this.getNewNode()).executeWithLexpr(frame, lexpr);
        }
        Object rexpr = this.right.execute(frame);
        if (this.getNewNode() != null) {
            return ((Arithmetic)this.getNewNode()).execute(lexpr, rexpr);
        }
        return this.execute(lexpr, rexpr);
    }

    public Object executeWithLexpr(Frame frame, Object lexpr) {
        Object rexpr = this.right.execute(frame);
        if (this.getNewNode() != null) {
            return ((Arithmetic)this.getNewNode()).execute(lexpr, rexpr);
        }
        return this.execute(lexpr, rexpr);
    }

    public Object execute(Object lexpr, Object rexpr) {
        try {
            throw new SpecializationException((Object)null);
        }
        catch (SpecializationException e) {
            if (this.left instanceof Constant || this.right instanceof Constant) {
                SpecializedConst sc = SpecializedConst.createSpecialized((RAny)lexpr, (RAny)rexpr, this.ast, this.left, this.right, this.arit);
                this.replace(sc, "install Specialized from Uninitialized");
                return sc.execute(lexpr, rexpr);
            }
            Specialized sn = Specialized.createSpecialized((RAny)lexpr, (RAny)rexpr, this.ast, this.left, this.right, this.arit);
            this.replace(sn, "install Specialized from Uninitialized");
            return sn.execute(lexpr, rexpr);
        }
    }

    @Override
    protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
        assert (oldNode != null);
        if (this.left == oldNode) {
            this.left = newNode;
            return this.adoptInternal(newNode);
        }
        if (this.right == oldNode) {
            this.right = newNode;
            return this.adoptInternal(newNode);
        }
        return super.replaceChild(oldNode, newNode);
    }

    public static double convertNaN(double d) {
        if (Double.isNaN(d)) {
            return Math.copySign(0.0, d);
        }
        return d;
    }

    public static double convertInf(double d) {
        return Math.copySign(Double.isInfinite(d) ? 1.0 : 0.0, d);
    }

    public static void cmult(double a, double b, double c, double d, double[] res, int offset) {
        double ac = a * c;
        double bd = b * d;
        double bc = b * c;
        double ad = a * d;
        double real = ac - bd;
        double imag = bc + ad;
        if (Double.isNaN(real) && Double.isNaN(imag)) {
            boolean recalc = false;
            double ra = a;
            double rb = b;
            double rc = c;
            double rd = d;
            if (Double.isInfinite(ra) || Double.isInfinite(rb)) {
                ra = Arithmetic.convertInf(ra);
                rb = Arithmetic.convertInf(rb);
                rc = Arithmetic.convertNaN(rc);
                rd = Arithmetic.convertNaN(rd);
                recalc = true;
            }
            if (Double.isInfinite(rc) || Double.isInfinite(rd)) {
                rc = Arithmetic.convertInf(rc);
                rd = Arithmetic.convertInf(rd);
                ra = Arithmetic.convertNaN(ra);
                rb = Arithmetic.convertNaN(rb);
                recalc = true;
            }
            if (!recalc && (Double.isInfinite(ac) || Double.isInfinite(bd) || Double.isInfinite(ad) || Double.isInfinite(bc))) {
                ra = Arithmetic.convertNaN(ra);
                rb = Arithmetic.convertNaN(rb);
                rc = Arithmetic.convertNaN(rc);
                rd = Arithmetic.convertNaN(rd);
                recalc = true;
            }
            if (recalc) {
                real = Double.POSITIVE_INFINITY * (ra * rc - rb * rd);
                imag = Double.POSITIVE_INFINITY * (ra * rd + rb * rc);
            }
        }
        res[offset] = real;
        res[offset + 1] = imag;
    }

    public static double chypot(double real, double imag) {
        double res = Math.sqrt(real * real + imag * imag);
        if (!Arithmetic.isFinite(real) || !Arithmetic.isFinite(imag)) {
            res = Double.isInfinite(real) || Double.isInfinite(imag) ? Double.POSITIVE_INFINITY : (Double.isNaN(imag) ? imag : real);
        }
        return res;
    }

    public static boolean isFinite(double d) {
        return !Double.isInfinite(d) && !Double.isNaN(d);
    }

    public static double pow(double a, double b) {
        if (!RContext.hasGNUR()) {
            return Math.pow(a, b);
        }
        return GNUR.pow(a, b);
    }

    public static void cdiv(double a, double b, double c, double d, double[] res, int offset) {
        double y;
        double x;
        if (Math.abs(c) < Math.abs(d)) {
            double ratio = c / d;
            double denom = c * ratio + d;
            x = (a * ratio + b) / denom;
            y = (b * ratio - a) / denom;
        } else {
            double ratio = d / c;
            double denom = d * ratio + c;
            x = (b * ratio + a) / denom;
            y = (b - a * ratio) / denom;
        }
        if (Double.isNaN(x) && Double.isNaN(y)) {
            if (!(c != 0.0 || d != 0.0 || Double.isNaN(a) && Double.isNaN(b))) {
                x = Math.copySign(Double.POSITIVE_INFINITY, c) * a;
                y = Math.copySign(Double.POSITIVE_INFINITY, c) * b;
            } else if ((Double.isInfinite(a) || Double.isInfinite(b)) && Arithmetic.isFinite(c) && Arithmetic.isFinite(d)) {
                double ra = Arithmetic.convertInf(a);
                double rb = Arithmetic.convertInf(b);
                x = Double.POSITIVE_INFINITY * (ra * c + rb * d);
                y = Double.POSITIVE_INFINITY * (rb * c - ra * d);
            } else if ((Double.isInfinite(c) || Double.isInfinite(d)) && Arithmetic.isFinite(a) && Arithmetic.isFinite(b)) {
                double rc = Arithmetic.convertInf(c);
                double rd = Arithmetic.convertInf(d);
                x = 0.0 * (a * rc + b * rd);
                y = 0.0 * (b * rc - a * rd);
            }
        }
        res[offset] = x;
        res[offset + 1] = y;
    }

    public static double fmod(ASTNode ast, double a, double b) {
        double q = a / b;
        if (b != 0.0) {
            double tmp = a - Math.floor(q) * b;
            if (RDouble.RDoubleUtils.isFinite(q) && Math.abs(q) > 1.0 / RDouble.EPSILON) {
                RContext.warning(ast, "probable complete loss of accuracy in modulus");
            }
            return tmp - Math.floor(tmp / b) * b;
        }
        return Double.NaN;
    }

    public static RDouble doubleBinary(RDouble a, RDouble b, ValueArithmetic arit, ASTNode ast) {
        DoubleView res;
        int nb;
        int depth = 0;
        int adepth = a instanceof DoubleView ? ((DoubleView)a).depth() : 0;
        int bdepth = b instanceof DoubleView ? ((DoubleView)b).depth() : 0;
        depth = adepth + bdepth + 1;
        int[] dim = Arithmetic.resultDimensions(ast, a, b);
        RArray.Names names = Arithmetic.resultNames(ast, a, b);
        RAny.Attributes attributes = Arithmetic.resultAttributes(ast, a, b);
        int na = a.size();
        if (na == (nb = b.size())) {
            if (arit == POW && na > 1) {
                return arit.op(ast, (DoubleImpl)a.materialize(), (DoubleImpl)b.materialize(), na, dim, names, attributes);
            }
            if (a instanceof DoubleImpl && b instanceof DoubleImpl && (a.isTemporary() || b.isTemporary())) {
                return arit.op(ast, (DoubleImpl)a, (DoubleImpl)b, na, dim, names, attributes);
            }
            res = new DoubleView.EqualSize(a, b, dim, names, attributes, na, depth, arit, ast);
        } else if (nb == 1 && na > 0) {
            if (arit == POW && na > 1) {
                return arit.op(ast, (DoubleImpl)a.materialize(), b.getDouble(0), na, dim, names, attributes);
            }
            if (na > 1 && a instanceof DoubleImpl && a.isTemporary()) {
                return arit.op(ast, (DoubleImpl)a, b.getDouble(0), na, dim, names, attributes);
            }
            res = new DoubleView.VectorScalar(a, b, dim, names, attributes, na, depth, arit, ast);
        } else {
            int n;
            res = na == 1 && nb > 0 ? new DoubleView.ScalarVector(a, b, dim, names, attributes, nb, depth, arit, ast) : ((n = Arithmetic.resultSize(ast, na, nb)) == na ? new DoubleView.GenericASized(a, b, dim, names, attributes, n, depth, arit, ast) : new DoubleView.GenericBSized(a, b, dim, names, attributes, n, depth, arit, ast));
        }
        if (depth > 5 || na == 1 && nb == 1) {
            return RDouble.RDoubleFactory.copy(res);
        }
        return res;
    }

    public static RDouble doubleBinary(RDouble a, RInt b, ValueArithmetic arit, ASTNode ast) {
        View.RDoubleView res;
        int nb;
        int depth = 0;
        int adepth = a instanceof DoubleView ? ((DoubleView)a).depth() : 0;
        int bdepth = b instanceof DoubleView ? ((DoubleView)((Object)b)).depth() : 0;
        depth = adepth + bdepth + 1;
        int[] dim = Arithmetic.resultDimensions(ast, a, b);
        RArray.Names names = Arithmetic.resultNames(ast, a, b);
        RAny.Attributes attributes = Arithmetic.resultAttributes(ast, a, b);
        int na = a.size();
        if (na == (nb = b.size())) {
            res = b instanceof IntImpl.RIntSequence ? new DoubleViewForDoubleInt.EqualSizeVectorSequence(a, (IntImpl.RIntSequence)b, dim, names, attributes, na, depth, arit, ast) : new DoubleViewForDoubleInt.EqualSizeVectorVector(a, b, dim, names, attributes, na, depth, arit, ast);
        } else if (nb == 1 && na > 0) {
            res = new DoubleView.VectorScalar(a, b.asDouble(), dim, names, attributes, na, depth, arit, ast);
        } else if (na == 1 && nb > 0) {
            res = b instanceof IntImpl.RIntSequence ? new DoubleViewForDoubleInt.ScalarSequence(a, (IntImpl.RIntSequence)b, dim, names, attributes, nb, depth, arit, ast) : new DoubleView.ScalarVector(a, b.asDouble(), dim, names, attributes, nb, depth, arit, ast);
        } else {
            int n = Arithmetic.resultSize(ast, na, nb);
            res = b instanceof IntImpl.RIntSequence ? (n == na ? new DoubleViewForDoubleInt.VectorSequenceASized(a, (IntImpl.RIntSequence)b, dim, names, attributes, n, depth, arit, ast) : new DoubleViewForDoubleInt.VectorSequenceBSized(a, (IntImpl.RIntSequence)b, dim, names, attributes, n, depth, arit, ast)) : (n == na ? new DoubleView.GenericASized(a, b.asDouble(), dim, names, attributes, n, depth, arit, ast) : new DoubleView.GenericBSized(a, b.asDouble(), dim, names, attributes, n, depth, arit, ast));
        }
        if (depth > 5 || na == 1 && nb == 1) {
            return RDouble.RDoubleFactory.copy(res);
        }
        return res;
    }

    public static RDouble doubleBinary(RInt a, RDouble b, ValueArithmetic arit, ASTNode ast) {
        View.RDoubleView res;
        int nb;
        int depth = 0;
        int adepth = a instanceof DoubleView ? ((DoubleView)((Object)a)).depth() : 0;
        int bdepth = b instanceof DoubleView ? ((DoubleView)b).depth() : 0;
        depth = adepth + bdepth + 1;
        int[] dim = Arithmetic.resultDimensions(ast, a, b);
        RArray.Names names = Arithmetic.resultNames(ast, a, b);
        RAny.Attributes attributes = Arithmetic.resultAttributes(ast, a, b);
        int na = a.size();
        if (na == (nb = b.size())) {
            res = a instanceof IntImpl.RIntSequence ? new DoubleViewForIntDouble.EqualSizeSequenceVector((IntImpl.RIntSequence)a, b, dim, names, attributes, na, depth, arit, ast) : new DoubleViewForIntDouble.EqualSizeVectorVector(a, b, dim, names, attributes, na, depth, arit, ast);
        } else if (nb == 1 && na > 0) {
            res = a instanceof IntImpl.RIntSequence ? new DoubleViewForIntDouble.SequenceScalar((IntImpl.RIntSequence)a, b, dim, names, attributes, na, depth, arit, ast) : new DoubleViewForIntDouble.VectorScalar(a, b, dim, names, attributes, na, depth, arit, ast);
        } else if (na == 1 && nb > 0) {
            res = new DoubleView.ScalarVector(a.asDouble(), b, dim, names, attributes, nb, depth, arit, ast);
        } else {
            int n = Arithmetic.resultSize(ast, na, nb);
            res = a instanceof IntImpl.RIntSequence ? (n == na ? new DoubleViewForIntDouble.SequenceVectorASized((IntImpl.RIntSequence)a, b, dim, names, attributes, n, depth, arit, ast) : new DoubleViewForIntDouble.SequenceVectorBSized((IntImpl.RIntSequence)a, b, dim, names, attributes, n, depth, arit, ast)) : (n == na ? new DoubleView.GenericASized(a.asDouble(), b, dim, names, attributes, n, depth, arit, ast) : new DoubleView.GenericBSized(a.asDouble(), b, dim, names, attributes, n, depth, arit, ast));
        }
        if (depth > 5 || na == 1 && nb == 1) {
            return RDouble.RDoubleFactory.copy(res);
        }
        return res;
    }

    public static RInt intBinary(RInt a, RInt b, ValueArithmetic arit, ASTNode ast) {
        IntView res;
        int nb;
        assert (Utils.check(!arit.returnsDouble()));
        int depth = 0;
        int adepth = a instanceof IntView ? ((IntView)a).depth() : 0;
        int bdepth = b instanceof IntView ? ((IntView)b).depth() : 0;
        depth = adepth + bdepth + 1;
        int[] dim = Arithmetic.resultDimensions(ast, a, b);
        RArray.Names names = Arithmetic.resultNames(ast, a, b);
        RAny.Attributes attributes = Arithmetic.resultAttributes(ast, a, b);
        int na = a.size();
        if (na == (nb = b.size())) {
            res = b instanceof IntImpl.RIntSequence ? new IntView.EqualSizeIntSequence(a, (IntImpl.RIntSequence)b, dim, names, attributes, na, depth, arit, ast) : (a instanceof IntImpl.RIntSequence ? new IntView.EqualSizeSequenceInt((IntImpl.RIntSequence)a, b, dim, names, attributes, na, depth, arit, ast) : new IntView.EqualSize(a, b, dim, names, attributes, na, depth, arit, ast));
        } else if (nb == 1 && na > 0) {
            res = a instanceof IntImpl.RIntSequence ? new IntView.SequenceScalar((IntImpl.RIntSequence)a, b, dim, names, attributes, na, depth, arit, ast) : new IntView.VectorScalar(a, b, dim, names, attributes, na, depth, arit, ast);
        } else if (na == 1 && nb > 0) {
            res = b instanceof IntImpl.RIntSequence ? new IntView.ScalarSequence(a, (IntImpl.RIntSequence)b, dim, names, attributes, nb, depth, arit, ast) : new IntView.ScalarVector(a, b, dim, names, attributes, nb, depth, arit, ast);
        } else {
            int n = Arithmetic.resultSize(ast, na, nb);
            res = b instanceof IntImpl.RIntSequence ? (na == n ? new IntView.VectorSequenceASized(a, (IntImpl.RIntSequence)b, dim, names, attributes, n, depth, arit, ast) : new IntView.VectorSequenceBSized(a, (IntImpl.RIntSequence)b, dim, names, attributes, n, depth, arit, ast)) : (a instanceof IntImpl.RIntSequence ? (na == n ? new IntView.SequenceVectorASized((IntImpl.RIntSequence)a, b, dim, names, attributes, n, depth, arit, ast) : new IntView.SequenceVectorBSized((IntImpl.RIntSequence)a, b, dim, names, attributes, n, depth, arit, ast)) : (n == na ? new IntView.GenericASized(a, b, dim, names, attributes, n, depth, arit, ast) : new IntView.GenericBSized(a, b, dim, names, attributes, n, depth, arit, ast)));
        }
        if (depth > 5 || na == 1 && nb == 1) {
            return RInt.RIntFactory.copy(res);
        }
        return res;
    }

    public static int[] resultDimensions(ASTNode ast, RArray a, RArray b) {
        int[] dima = a.dimensions();
        int[] dimb = b.dimensions();
        if (dima == null) {
            int bsize;
            int asize;
            if (dimb != null && (asize = a.size()) > (bsize = b.size())) {
                throw RError.getDimsDontMatchLength(ast, bsize, asize);
            }
            return dimb;
        }
        if (dimb == null) {
            if (dima != null) {
                int asize = a.size();
                int bsize = b.size();
                if (bsize > asize) {
                    throw RError.getDimsDontMatchLength(ast, asize, bsize);
                }
            }
            return dima;
        }
        int alen = dima.length;
        int blen = dimb.length;
        if (alen == 2 && blen == 2 && dima[0] == dimb[0] && dima[1] == dimb[1]) {
            return dima;
        }
        if (alen == blen) {
            for (int i = 0; i < alen; ++i) {
                if (dima[i] == dimb[i]) continue;
                throw RError.getNonConformableArrays(ast);
            }
            return dima;
        }
        throw RError.getNonConformableArrays(ast);
    }

    public static RArray.Names resultNames(ASTNode ast, RArray a, RArray b) {
        RArray.Names na = a.names();
        RArray.Names nb = b.names();
        if (nb == null) {
            return na;
        }
        if (na == null) {
            return nb;
        }
        int asize = a.size();
        int bsize = b.size();
        if (bsize > asize) {
            return nb;
        }
        return na;
    }

    public static RAny.Attributes resultAttributes(ASTNode ast, RArray a, RArray b) {
        int bsize;
        RAny.Attributes aa = a.attributes();
        RAny.Attributes ba = b.attributes();
        if (ba == null && aa == null) {
            return null;
        }
        int asize = a.size();
        if (asize > (bsize = b.size())) {
            return RAny.Attributes.markShared(aa);
        }
        if (bsize > asize) {
            return RAny.Attributes.markShared(ba);
        }
        if (ba == null) {
            return RAny.Attributes.markShared(aa);
        }
        if (aa == null) {
            return RAny.Attributes.markShared(ba);
        }
        RAny.Attributes res = ba.copy();
        LinkedHashMap<RSymbol, RAny> amap = aa.map();
        for (Map.Entry ae : amap.entrySet()) {
            RAny value = (RAny)ae.getValue();
            value.ref();
            res.put((RSymbol)ae.getKey(), value);
        }
        return res;
    }

    public static int resultSize(ASTNode ast, int na, int nb) {
        int n;
        if (na == 0 || nb == 0) {
            return 0;
        }
        if (na > nb) {
            n = na;
            if (n / nb * nb != n) {
                RContext.warning(ast, "longer object length is not a multiple of shorter object length");
            }
        } else {
            n = nb;
            if (n / na * na != n) {
                RContext.warning(ast, "longer object length is not a multiple of shorter object length");
            }
        }
        return n;
    }

    static abstract class IntView
    extends View.RIntView
    implements RInt {
        final RInt a;
        final RInt b;
        final int n;
        final int[] dimensions;
        final RArray.Names names;
        final RAny.Attributes attributes;
        boolean overflown = false;
        final ValueArithmetic arit;
        final ASTNode ast;
        private int depth;

        public IntView(RInt a, RInt b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int n, int depth, ValueArithmetic arit, ASTNode ast) {
            this.a = a;
            this.b = b;
            this.dimensions = dimensions;
            this.names = names;
            this.attributes = attributes;
            this.n = n;
            this.depth = depth;
            this.arit = arit;
            this.ast = ast;
        }

        @Override
        public final int size() {
            return this.n;
        }

        @Override
        public boolean isSharedReal() {
            return this.a.isShared() || this.b.isShared();
        }

        @Override
        public void ref() {
            this.a.ref();
            this.b.ref();
        }

        @Override
        public int[] dimensions() {
            return this.dimensions;
        }

        @Override
        public RArray.Names names() {
            return this.names;
        }

        @Override
        public RAny.Attributes attributes() {
            return this.attributes;
        }

        @Override
        public boolean dependsOn(RAny value) {
            return this.a.dependsOn(value) || this.b.dependsOn(value);
        }

        public final int depth() {
            return this.depth;
        }

        static final class ScalarSequence
        extends IntView
        implements RInt {
            final boolean arithIsNA;
            final int aint;
            final int bfrom;
            final int bstep;

            public ScalarSequence(RInt a, IntImpl.RIntSequence b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int n, int depth, ValueArithmetic arit, ASTNode ast) {
                super(a, b, dimensions, names, attributes, n, depth, arit, ast);
                this.aint = a.getInt(0);
                this.arithIsNA = this.aint == Integer.MIN_VALUE;
                this.bfrom = b.from();
                this.bstep = b.step();
            }

            @Override
            public int getInt(int i) {
                int bint = this.bfrom + i * this.bstep;
                if (this.arithIsNA) {
                    return Integer.MIN_VALUE;
                }
                int res = this.arit.op(this.ast, this.aint, bint);
                if (res == Integer.MIN_VALUE && !this.overflown) {
                    this.overflown = true;
                    this.arit.emitOverflowWarning(this.ast);
                }
                return res;
            }
        }

        static final class ScalarVector
        extends IntView
        implements RInt {
            final boolean arithIsNA;
            final int aint;

            public ScalarVector(RInt a, RInt b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int n, int depth, ValueArithmetic arit, ASTNode ast) {
                super(a, b, dimensions, names, attributes, n, depth, arit, ast);
                this.aint = a.getInt(0);
                this.arithIsNA = this.aint == Integer.MIN_VALUE;
            }

            @Override
            public int getInt(int i) {
                int bint = this.b.getInt(i);
                if (this.arithIsNA || bint == Integer.MIN_VALUE) {
                    return Integer.MIN_VALUE;
                }
                int res = this.arit.op(this.ast, this.aint, bint);
                if (res == Integer.MIN_VALUE && !this.overflown) {
                    this.overflown = true;
                    this.arit.emitOverflowWarning(this.ast);
                }
                return res;
            }
        }

        static final class SequenceScalar
        extends IntView
        implements RInt {
            final boolean arithIsNA;
            final int bint;
            final int afrom;
            final int astep;

            public SequenceScalar(IntImpl.RIntSequence a, RInt b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int n, int depth, ValueArithmetic arit, ASTNode ast) {
                super(a, b, dimensions, names, attributes, n, depth, arit, ast);
                this.bint = b.getInt(0);
                this.arithIsNA = this.bint == Integer.MIN_VALUE;
                this.afrom = a.from();
                this.astep = a.step();
            }

            @Override
            public int getInt(int i) {
                int aint = this.afrom + i * this.astep;
                if (this.arithIsNA) {
                    return Integer.MIN_VALUE;
                }
                int res = this.arit.op(this.ast, aint, this.bint);
                if (res == Integer.MIN_VALUE && !this.overflown) {
                    this.overflown = true;
                    this.arit.emitOverflowWarning(this.ast);
                }
                return res;
            }
        }

        static final class VectorScalar
        extends IntView
        implements RInt {
            final boolean arithIsNA;
            final int bint;

            public VectorScalar(RInt a, RInt b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int n, int depth, ValueArithmetic arit, ASTNode ast) {
                super(a, b, dimensions, names, attributes, n, depth, arit, ast);
                this.bint = b.getInt(0);
                this.arithIsNA = this.bint == Integer.MIN_VALUE;
            }

            @Override
            public int getInt(int i) {
                int aint = this.a.getInt(i);
                if (this.arithIsNA || aint == Integer.MIN_VALUE) {
                    return Integer.MIN_VALUE;
                }
                int res = this.arit.op(this.ast, aint, this.bint);
                if (res == Integer.MIN_VALUE && !this.overflown) {
                    this.overflown = true;
                    this.arit.emitOverflowWarning(this.ast);
                }
                return res;
            }
        }

        static final class EqualSizeSequenceInt
        extends IntView
        implements RInt {
            final int afrom;
            final int astep;

            public EqualSizeSequenceInt(IntImpl.RIntSequence a, RInt b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int n, int depth, ValueArithmetic arit, ASTNode ast) {
                super(a, b, dimensions, names, attributes, n, depth, arit, ast);
                this.afrom = a.from();
                this.astep = a.step();
            }

            @Override
            public int getInt(int i) {
                int aint = this.afrom + i * this.astep;
                int bint = this.b.getInt(i);
                if (bint == Integer.MIN_VALUE) {
                    return Integer.MIN_VALUE;
                }
                int res = this.arit.op(this.ast, aint, bint);
                if (res == Integer.MIN_VALUE && !this.overflown) {
                    this.overflown = true;
                    this.arit.emitOverflowWarning(this.ast);
                }
                return res;
            }
        }

        static final class EqualSizeIntSequence
        extends IntView
        implements RInt {
            final int bfrom;
            final int bstep;

            public EqualSizeIntSequence(RInt a, IntImpl.RIntSequence b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int n, int depth, ValueArithmetic arit, ASTNode ast) {
                super(a, b, dimensions, names, attributes, n, depth, arit, ast);
                this.bfrom = b.from();
                this.bstep = b.step();
            }

            @Override
            public int getInt(int i) {
                int aint = this.a.getInt(i);
                int bint = this.bfrom + i * this.bstep;
                if (aint == Integer.MIN_VALUE) {
                    return Integer.MIN_VALUE;
                }
                int res = this.arit.op(this.ast, aint, bint);
                if (res == Integer.MIN_VALUE && !this.overflown) {
                    this.overflown = true;
                    this.arit.emitOverflowWarning(this.ast);
                }
                return res;
            }
        }

        static final class EqualSize
        extends IntView
        implements RInt {
            public EqualSize(RInt a, RInt b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int n, int depth, ValueArithmetic arit, ASTNode ast) {
                super(a, b, dimensions, names, attributes, n, depth, arit, ast);
            }

            @Override
            public int getInt(int i) {
                int aint = this.a.getInt(i);
                int bint = this.b.getInt(i);
                if (aint == Integer.MIN_VALUE || bint == Integer.MIN_VALUE) {
                    return Integer.MIN_VALUE;
                }
                int res = this.arit.op(this.ast, aint, bint);
                if (res == Integer.MIN_VALUE && !this.overflown) {
                    this.overflown = true;
                    this.arit.emitOverflowWarning(this.ast);
                }
                return res;
            }
        }

        static final class SequenceVectorBSized
        extends IntView
        implements RInt {
            final int na;
            final int afrom;
            final int astep;

            public SequenceVectorBSized(IntImpl.RIntSequence a, RInt b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int n, int depth, ValueArithmetic arit, ASTNode ast) {
                super(a, b, dimensions, names, attributes, n, depth, arit, ast);
                this.na = a.size();
                assert (Utils.check(n == b.size()));
                this.afrom = a.from();
                this.astep = a.step();
            }

            @Override
            public int getInt(int i) {
                int ai = i % this.na;
                int aint = this.afrom + ai * this.astep;
                int bint = this.b.getInt(i);
                if (bint == Integer.MIN_VALUE) {
                    return Integer.MIN_VALUE;
                }
                int res = this.arit.op(this.ast, aint, bint);
                if (res == Integer.MIN_VALUE && !this.overflown) {
                    this.overflown = true;
                    this.arit.emitOverflowWarning(this.ast);
                }
                return res;
            }
        }

        static final class SequenceVectorASized
        extends IntView
        implements RInt {
            final int nb;
            final int afrom;
            final int astep;

            public SequenceVectorASized(IntImpl.RIntSequence a, RInt b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int n, int depth, ValueArithmetic arit, ASTNode ast) {
                super(a, b, dimensions, names, attributes, n, depth, arit, ast);
                assert (Utils.check(n == a.size()));
                this.nb = b.size();
                this.afrom = a.from();
                this.astep = a.step();
            }

            @Override
            public int getInt(int i) {
                int bi = i % this.nb;
                int aint = this.afrom + i * this.astep;
                int bint = this.b.getInt(bi);
                if (bint == Integer.MIN_VALUE) {
                    return Integer.MIN_VALUE;
                }
                int res = this.arit.op(this.ast, aint, bint);
                if (res == Integer.MIN_VALUE && !this.overflown) {
                    this.overflown = true;
                    this.arit.emitOverflowWarning(this.ast);
                }
                return res;
            }
        }

        static final class SequenceVector
        extends IntView
        implements RInt {
            final int na;
            final int nb;
            final int afrom;
            final int astep;

            public SequenceVector(IntImpl.RIntSequence a, RInt b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int n, int depth, ValueArithmetic arit, ASTNode ast) {
                super(a, b, dimensions, names, attributes, n, depth, arit, ast);
                this.na = a.size();
                this.nb = b.size();
                this.afrom = a.from();
                this.astep = a.step();
            }

            @Override
            public int getInt(int i) {
                int bi;
                int ai;
                if (i >= this.na) {
                    ai = i % this.na;
                    bi = i;
                } else if (i >= this.nb) {
                    bi = i % this.nb;
                    ai = i;
                } else {
                    ai = i;
                    bi = i;
                }
                int aint = this.afrom + ai * this.astep;
                int bint = this.b.getInt(bi);
                if (bint == Integer.MIN_VALUE) {
                    return Integer.MIN_VALUE;
                }
                int res = this.arit.op(this.ast, aint, bint);
                if (res == Integer.MIN_VALUE && !this.overflown) {
                    this.overflown = true;
                    this.arit.emitOverflowWarning(this.ast);
                }
                return res;
            }
        }

        static final class VectorSequenceBSized
        extends IntView
        implements RInt {
            final int na;
            final int bfrom;
            final int bstep;

            public VectorSequenceBSized(RInt a, IntImpl.RIntSequence b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int n, int depth, ValueArithmetic arit, ASTNode ast) {
                super(a, b, dimensions, names, attributes, n, depth, arit, ast);
                assert (Utils.check(b.size() == n));
                this.na = a.size();
                this.bfrom = b.from();
                this.bstep = b.step();
            }

            @Override
            public int getInt(int i) {
                int ai = i % this.na;
                int aint = this.a.getInt(ai);
                int bint = this.bfrom + i * this.bstep;
                if (aint == Integer.MIN_VALUE) {
                    return Integer.MIN_VALUE;
                }
                int res = this.arit.op(this.ast, aint, bint);
                if (res == Integer.MIN_VALUE && !this.overflown) {
                    this.overflown = true;
                    this.arit.emitOverflowWarning(this.ast);
                }
                return res;
            }
        }

        static final class VectorSequenceASized
        extends IntView
        implements RInt {
            final int nb;
            final int bfrom;
            final int bstep;

            public VectorSequenceASized(RInt a, IntImpl.RIntSequence b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int n, int depth, ValueArithmetic arit, ASTNode ast) {
                super(a, b, dimensions, names, attributes, n, depth, arit, ast);
                assert (Utils.check(a.size() == n));
                this.nb = b.size();
                this.bfrom = b.from();
                this.bstep = b.step();
            }

            @Override
            public int getInt(int i) {
                int bi = i % this.nb;
                int aint = this.a.getInt(i);
                int bint = this.bfrom + bi * this.bstep;
                if (aint == Integer.MIN_VALUE) {
                    return Integer.MIN_VALUE;
                }
                int res = this.arit.op(this.ast, aint, bint);
                if (res == Integer.MIN_VALUE && !this.overflown) {
                    this.overflown = true;
                    this.arit.emitOverflowWarning(this.ast);
                }
                return res;
            }
        }

        static final class VectorSequence
        extends IntView
        implements RInt {
            final int na;
            final int nb;
            final int bfrom;
            final int bstep;

            public VectorSequence(RInt a, IntImpl.RIntSequence b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int n, int depth, ValueArithmetic arit, ASTNode ast) {
                super(a, b, dimensions, names, attributes, n, depth, arit, ast);
                this.na = a.size();
                this.nb = b.size();
                this.bfrom = b.from();
                this.bstep = b.step();
            }

            @Override
            public int getInt(int i) {
                int bi;
                int ai;
                if (i >= this.na) {
                    ai = i % this.na;
                    bi = i;
                } else if (i >= this.nb) {
                    bi = i % this.nb;
                    ai = i;
                } else {
                    ai = i;
                    bi = i;
                }
                int aint = this.a.getInt(ai);
                int bint = this.bfrom + bi * this.bstep;
                if (aint == Integer.MIN_VALUE) {
                    return Integer.MIN_VALUE;
                }
                int res = this.arit.op(this.ast, aint, bint);
                if (res == Integer.MIN_VALUE && !this.overflown) {
                    this.overflown = true;
                    this.arit.emitOverflowWarning(this.ast);
                }
                return res;
            }
        }

        static final class GenericBSized
        extends IntView
        implements RInt {
            final int na;

            public GenericBSized(RInt a, RInt b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int n, int depth, ValueArithmetic arit, ASTNode ast) {
                super(a, b, dimensions, names, attributes, n, depth, arit, ast);
                this.na = a.size();
                assert (Utils.check(b.size() == n));
            }

            @Override
            public int getInt(int i) {
                int ai = i % this.na;
                int aint = this.a.getInt(ai);
                int bint = this.b.getInt(i);
                if (aint == Integer.MIN_VALUE || bint == Integer.MIN_VALUE) {
                    return Integer.MIN_VALUE;
                }
                int res = this.arit.op(this.ast, aint, bint);
                if (res == Integer.MIN_VALUE && !this.overflown) {
                    this.overflown = true;
                    this.arit.emitOverflowWarning(this.ast);
                }
                return res;
            }
        }

        static final class GenericASized
        extends IntView
        implements RInt {
            final int nb;

            public GenericASized(RInt a, RInt b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int n, int depth, ValueArithmetic arit, ASTNode ast) {
                super(a, b, dimensions, names, attributes, n, depth, arit, ast);
                assert (Utils.check(n == a.size()));
                this.nb = b.size();
            }

            @Override
            public int getInt(int i) {
                int bi = i % this.nb;
                int aint = this.a.getInt(i);
                int bint = this.b.getInt(bi);
                if (aint == Integer.MIN_VALUE || bint == Integer.MIN_VALUE) {
                    return Integer.MIN_VALUE;
                }
                int res = this.arit.op(this.ast, aint, bint);
                if (res == Integer.MIN_VALUE && !this.overflown) {
                    this.overflown = true;
                    this.arit.emitOverflowWarning(this.ast);
                }
                return res;
            }
        }

        static final class Generic
        extends IntView
        implements RInt {
            final int na;
            final int nb;

            public Generic(RInt a, RInt b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int n, int depth, ValueArithmetic arit, ASTNode ast) {
                super(a, b, dimensions, names, attributes, n, depth, arit, ast);
                this.na = a.size();
                this.nb = b.size();
            }

            @Override
            public int getInt(int i) {
                int bi;
                int ai;
                if (i >= this.na) {
                    ai = i % this.na;
                    bi = i;
                } else if (i >= this.nb) {
                    bi = i % this.nb;
                    ai = i;
                } else {
                    ai = i;
                    bi = i;
                }
                int aint = this.a.getInt(ai);
                int bint = this.b.getInt(bi);
                if (aint == Integer.MIN_VALUE || bint == Integer.MIN_VALUE) {
                    return Integer.MIN_VALUE;
                }
                int res = this.arit.op(this.ast, aint, bint);
                if (res == Integer.MIN_VALUE && !this.overflown) {
                    this.overflown = true;
                    this.arit.emitOverflowWarning(this.ast);
                }
                return res;
            }
        }
    }

    static abstract class DoubleViewForIntDouble
    extends View.RDoubleView
    implements RDouble {
        final RInt a;
        final RDouble b;
        final int n;
        final int[] dimensions;
        final RArray.Names names;
        final RAny.Attributes attributes;
        final ValueArithmetic arit;
        final ASTNode ast;
        private int depth;

        public DoubleViewForIntDouble(RInt a, RDouble b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int n, int depth, ValueArithmetic arit, ASTNode ast) {
            this.a = a;
            this.b = b;
            this.dimensions = dimensions;
            this.names = names;
            this.attributes = attributes;
            this.n = n;
            this.depth = depth;
            this.arit = arit;
            this.ast = ast;
        }

        @Override
        public final int size() {
            return this.n;
        }

        @Override
        public final boolean isSharedReal() {
            return this.a.isShared() || this.b.isShared();
        }

        @Override
        public final void ref() {
            this.a.ref();
            this.b.ref();
        }

        @Override
        public final int[] dimensions() {
            return this.dimensions;
        }

        @Override
        public final RArray.Names names() {
            return this.names;
        }

        @Override
        public final RAny.Attributes attributes() {
            return this.attributes;
        }

        @Override
        public final boolean dependsOn(RAny value) {
            return this.a.dependsOn(value) || this.b.dependsOn(value);
        }

        public final int depth() {
            return this.depth;
        }

        static final class SequenceScalar
        extends DoubleViewForIntDouble
        implements RDouble {
            final boolean arithIsNA;
            final double bdbl;
            final int afrom;
            final int astep;

            public SequenceScalar(IntImpl.RIntSequence a, RDouble b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int n, int depth, ValueArithmetic arit, ASTNode ast) {
                super(a, b, dimensions, names, attributes, n, depth, arit, ast);
                this.bdbl = b.getDouble(0);
                this.arithIsNA = RDouble.RDoubleUtils.arithIsNA(this.bdbl);
                this.afrom = a.from();
                this.astep = a.step();
            }

            @Override
            public double getDouble(int i) {
                double aint = this.afrom + i * this.astep;
                if (this.arithIsNA) {
                    return RDouble.NA;
                }
                return this.arit.op(this.ast, aint, this.bdbl);
            }
        }

        static final class VectorScalar
        extends DoubleViewForIntDouble
        implements RDouble {
            final boolean arithIsNA;
            final double bdbl;

            public VectorScalar(RInt a, RDouble b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int n, int depth, ValueArithmetic arit, ASTNode ast) {
                super(a, b, dimensions, names, attributes, n, depth, arit, ast);
                this.bdbl = b.getDouble(0);
                this.arithIsNA = RDouble.RDoubleUtils.arithIsNA(this.bdbl);
            }

            @Override
            public double getDouble(int i) {
                double aint = this.a.getInt(i);
                if (this.arithIsNA || aint == -2.147483648E9) {
                    return RDouble.NA;
                }
                return this.arit.op(this.ast, aint, this.bdbl);
            }
        }

        static final class EqualSizeSequenceVector
        extends DoubleViewForIntDouble
        implements RDouble {
            final int afrom;
            final int astep;

            public EqualSizeSequenceVector(IntImpl.RIntSequence a, RDouble b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int n, int depth, ValueArithmetic arit, ASTNode ast) {
                super(a, b, dimensions, names, attributes, n, depth, arit, ast);
                this.afrom = a.from();
                this.astep = a.step();
            }

            @Override
            public double getDouble(int i) {
                int aint = this.afrom + i * this.astep;
                double bdbl = this.b.getDouble(i);
                if (RDouble.RDoubleUtils.arithIsNA(bdbl)) {
                    return RDouble.NA;
                }
                return this.arit.op(this.ast, aint, bdbl);
            }
        }

        static final class EqualSizeVectorVector
        extends DoubleViewForIntDouble
        implements RDouble {
            public EqualSizeVectorVector(RInt a, RDouble b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int n, int depth, ValueArithmetic arit, ASTNode ast) {
                super(a, b, dimensions, names, attributes, n, depth, arit, ast);
            }

            @Override
            public double getDouble(int i) {
                int aint = this.a.getInt(i);
                double bdbl = this.b.getDouble(i);
                if (aint == Integer.MIN_VALUE || RDouble.RDoubleUtils.arithIsNA(bdbl)) {
                    return RDouble.NA;
                }
                return this.arit.op(this.ast, aint, bdbl);
            }
        }

        static final class SequenceVectorBSized
        extends DoubleViewForIntDouble
        implements RDouble {
            final int na;
            final int afrom;
            final int astep;

            public SequenceVectorBSized(IntImpl.RIntSequence a, RDouble b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int n, int depth, ValueArithmetic arit, ASTNode ast) {
                super(a, b, dimensions, names, attributes, n, depth, arit, ast);
                this.na = a.size();
                assert (Utils.check(n == b.size()));
                this.afrom = a.from();
                this.astep = a.step();
            }

            @Override
            public double getDouble(int i) {
                int ai = i % this.na;
                int aint = this.afrom + ai * this.astep;
                double bdbl = this.b.getDouble(i);
                if (RDouble.RDoubleUtils.arithIsNA(bdbl)) {
                    return RDouble.NA;
                }
                return this.arit.op(this.ast, aint, bdbl);
            }
        }

        static final class SequenceVectorASized
        extends DoubleViewForIntDouble
        implements RDouble {
            final int nb;
            final int afrom;
            final int astep;

            public SequenceVectorASized(IntImpl.RIntSequence a, RDouble b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int n, int depth, ValueArithmetic arit, ASTNode ast) {
                super(a, b, dimensions, names, attributes, n, depth, arit, ast);
                assert (Utils.check(n == a.size()));
                this.nb = b.size();
                this.afrom = a.from();
                this.astep = a.step();
            }

            @Override
            public double getDouble(int i) {
                int bi = i % this.nb;
                int aint = this.afrom + i * this.astep;
                double bdbl = this.b.getDouble(bi);
                if (RDouble.RDoubleUtils.arithIsNA(bdbl)) {
                    return RDouble.NA;
                }
                return this.arit.op(this.ast, aint, bdbl);
            }
        }

        static final class SequenceVector
        extends DoubleViewForIntDouble
        implements RDouble {
            final int na;
            final int nb;
            final int afrom;
            final int astep;

            public SequenceVector(IntImpl.RIntSequence a, RDouble b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int n, int depth, ValueArithmetic arit, ASTNode ast) {
                super(a, b, dimensions, names, attributes, n, depth, arit, ast);
                this.na = a.size();
                this.nb = b.size();
                this.afrom = a.from();
                this.astep = a.step();
            }

            @Override
            public double getDouble(int i) {
                int bi;
                int ai;
                if (i >= this.na) {
                    ai = i % this.na;
                    bi = i;
                } else if (i >= this.nb) {
                    bi = i % this.nb;
                    ai = i;
                } else {
                    ai = i;
                    bi = i;
                }
                int aint = this.afrom + ai * this.astep;
                double bdbl = this.b.getDouble(bi);
                if (RDouble.RDoubleUtils.arithIsNA(bdbl)) {
                    return RDouble.NA;
                }
                return this.arit.op(this.ast, aint, bdbl);
            }
        }
    }

    static abstract class DoubleViewForDoubleInt
    extends View.RDoubleView
    implements RDouble {
        final RDouble a;
        final RInt b;
        final int n;
        final int[] dimensions;
        final RArray.Names names;
        final RAny.Attributes attributes;
        final ValueArithmetic arit;
        final ASTNode ast;
        private int depth;

        public DoubleViewForDoubleInt(RDouble a, RInt b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int n, int depth, ValueArithmetic arit, ASTNode ast) {
            this.a = a;
            this.b = b;
            this.dimensions = dimensions;
            this.names = names;
            this.attributes = attributes;
            this.n = n;
            this.depth = depth;
            this.arit = arit;
            this.ast = ast;
        }

        @Override
        public final int size() {
            return this.n;
        }

        @Override
        public final boolean isSharedReal() {
            return this.a.isShared() || this.b.isShared();
        }

        @Override
        public final void ref() {
            this.a.ref();
            this.b.ref();
        }

        @Override
        public final int[] dimensions() {
            return this.dimensions;
        }

        @Override
        public final RArray.Names names() {
            return this.names;
        }

        @Override
        public final RAny.Attributes attributes() {
            return this.attributes;
        }

        @Override
        public final boolean dependsOn(RAny value) {
            return this.a.dependsOn(value) || this.b.dependsOn(value);
        }

        public final int depth() {
            return this.depth;
        }

        static final class ScalarSequence
        extends DoubleViewForDoubleInt
        implements RDouble {
            final boolean arithIsNA;
            final double adbl;
            final int bfrom;
            final int bstep;

            public ScalarSequence(RDouble a, IntImpl.RIntSequence b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int n, int depth, ValueArithmetic arit, ASTNode ast) {
                super(a, b, dimensions, names, attributes, n, depth, arit, ast);
                this.adbl = a.getDouble(0);
                this.arithIsNA = RDouble.RDoubleUtils.arithIsNA(this.adbl);
                this.bfrom = b.from();
                this.bstep = b.step();
            }

            @Override
            public double getDouble(int i) {
                int bint = this.bfrom + i * this.bstep;
                if (this.arithIsNA) {
                    return RDouble.NA;
                }
                return this.arit.op(this.ast, this.adbl, bint);
            }
        }

        static final class EqualSizeVectorSequence
        extends DoubleViewForDoubleInt
        implements RDouble {
            final int bfrom;
            final int bstep;

            public EqualSizeVectorSequence(RDouble a, IntImpl.RIntSequence b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int n, int depth, ValueArithmetic arit, ASTNode ast) {
                super(a, b, dimensions, names, attributes, n, depth, arit, ast);
                this.bfrom = b.from();
                this.bstep = b.step();
            }

            @Override
            public double getDouble(int i) {
                double adbl = this.a.getDouble(i);
                int bint = this.bfrom + i * this.bstep;
                if (RDouble.RDoubleUtils.arithIsNA(adbl)) {
                    return RDouble.NA;
                }
                return this.arit.op(this.ast, adbl, bint);
            }
        }

        static final class EqualSizeVectorVector
        extends DoubleViewForDoubleInt
        implements RDouble {
            public EqualSizeVectorVector(RDouble a, RInt b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int n, int depth, ValueArithmetic arit, ASTNode ast) {
                super(a, b, dimensions, names, attributes, n, depth, arit, ast);
            }

            @Override
            public double getDouble(int i) {
                double adbl = this.a.getDouble(i);
                int bint = this.b.getInt(i);
                if (bint == Integer.MIN_VALUE || RDouble.RDoubleUtils.arithIsNA(adbl)) {
                    return RDouble.NA;
                }
                return this.arit.op(this.ast, adbl, bint);
            }
        }

        static final class VectorSequenceBSized
        extends DoubleViewForDoubleInt
        implements RDouble {
            final int na;
            final int bfrom;
            final int bstep;

            public VectorSequenceBSized(RDouble a, IntImpl.RIntSequence b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int n, int depth, ValueArithmetic arit, ASTNode ast) {
                super(a, b, dimensions, names, attributes, n, depth, arit, ast);
                this.na = a.size();
                assert (Utils.check(n == b.size()));
                this.bfrom = b.from();
                this.bstep = b.step();
            }

            @Override
            public double getDouble(int i) {
                int ai = i % this.na;
                double adbl = this.a.getDouble(ai);
                int bint = this.bfrom + i * this.bstep;
                if (RDouble.RDoubleUtils.arithIsNA(adbl)) {
                    return RDouble.NA;
                }
                return this.arit.op(this.ast, adbl, bint);
            }
        }

        static final class VectorSequenceASized
        extends DoubleViewForDoubleInt
        implements RDouble {
            final int nb;
            final int bfrom;
            final int bstep;

            public VectorSequenceASized(RDouble a, IntImpl.RIntSequence b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int n, int depth, ValueArithmetic arit, ASTNode ast) {
                super(a, b, dimensions, names, attributes, n, depth, arit, ast);
                assert (Utils.check(a.size() == n));
                this.nb = b.size();
                this.bfrom = b.from();
                this.bstep = b.step();
            }

            @Override
            public double getDouble(int i) {
                int bi = i % this.nb;
                double adbl = this.a.getDouble(i);
                int bint = this.bfrom + bi * this.bstep;
                if (RDouble.RDoubleUtils.arithIsNA(adbl)) {
                    return RDouble.NA;
                }
                return this.arit.op(this.ast, adbl, bint);
            }
        }

        static final class VectorSequence
        extends DoubleViewForDoubleInt
        implements RDouble {
            final int na;
            final int nb;
            final int bfrom;
            final int bstep;

            public VectorSequence(RDouble a, IntImpl.RIntSequence b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int n, int depth, ValueArithmetic arit, ASTNode ast) {
                super(a, b, dimensions, names, attributes, n, depth, arit, ast);
                this.na = a.size();
                this.nb = b.size();
                this.bfrom = b.from();
                this.bstep = b.step();
            }

            @Override
            public double getDouble(int i) {
                int bi;
                int ai;
                if (i >= this.na) {
                    ai = i % this.na;
                    bi = i;
                } else if (i >= this.nb) {
                    bi = i % this.nb;
                    ai = i;
                } else {
                    ai = i;
                    bi = i;
                }
                double adbl = this.a.getDouble(ai);
                int bint = this.bfrom + bi * this.bstep;
                if (RDouble.RDoubleUtils.arithIsNA(adbl)) {
                    return RDouble.NA;
                }
                return this.arit.op(this.ast, adbl, bint);
            }
        }
    }

    static abstract class DoubleView
    extends View.RDoubleView
    implements RDouble {
        final RDouble a;
        final RDouble b;
        final int n;
        final int[] dimensions;
        final RArray.Names names;
        final RAny.Attributes attributes;
        final ValueArithmetic arit;
        final ASTNode ast;
        private int depth;

        public DoubleView(RDouble a, RDouble b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int n, int depth, ValueArithmetic arit, ASTNode ast) {
            this.a = a;
            this.b = b;
            this.dimensions = dimensions;
            this.names = names;
            this.attributes = attributes;
            this.n = n;
            this.depth = depth;
            this.arit = arit;
            this.ast = ast;
        }

        @Override
        public final int size() {
            return this.n;
        }

        @Override
        public final boolean isSharedReal() {
            return this.a.isShared() || this.b.isShared();
        }

        @Override
        public final void ref() {
            this.a.ref();
            this.b.ref();
        }

        @Override
        public final int[] dimensions() {
            return this.dimensions;
        }

        @Override
        public final RArray.Names names() {
            return this.names;
        }

        @Override
        public final RAny.Attributes attributes() {
            return this.attributes;
        }

        @Override
        public final boolean dependsOn(RAny value) {
            return this.a.dependsOn(value) || this.b.dependsOn(value);
        }

        public final int depth() {
            return this.depth;
        }

        static final class ScalarVector
        extends DoubleView
        implements RDouble {
            final boolean arithIsNA;
            final double adbl;

            public ScalarVector(RDouble a, RDouble b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int n, int depth, ValueArithmetic arit, ASTNode ast) {
                super(a, b, dimensions, names, attributes, n, depth, arit, ast);
                this.adbl = a.getDouble(0);
                this.arithIsNA = RDouble.RDoubleUtils.arithIsNA(this.adbl);
            }

            @Override
            public double getDouble(int i) {
                double bdbl = this.b.getDouble(i);
                if (this.arithIsNA || RDouble.RDoubleUtils.arithIsNA(bdbl)) {
                    return RDouble.NA;
                }
                return this.arit.op(this.ast, this.adbl, bdbl);
            }
        }

        static final class VectorScalar
        extends DoubleView
        implements RDouble {
            final boolean arithIsNA;
            final double bdbl;

            public VectorScalar(RDouble a, RDouble b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int n, int depth, ValueArithmetic arit, ASTNode ast) {
                super(a, b, dimensions, names, attributes, n, depth, arit, ast);
                this.bdbl = b.getDouble(0);
                this.arithIsNA = RDouble.RDoubleUtils.arithIsNA(this.bdbl);
            }

            @Override
            public double getDouble(int i) {
                double adbl = this.a.getDouble(i);
                if (this.arithIsNA || RDouble.RDoubleUtils.arithIsNA(adbl)) {
                    return RDouble.NA;
                }
                return this.arit.op(this.ast, adbl, this.bdbl);
            }
        }

        static final class EqualSize
        extends DoubleView
        implements RDouble {
            public EqualSize(RDouble a, RDouble b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int n, int depth, ValueArithmetic arit, ASTNode ast) {
                super(a, b, dimensions, names, attributes, n, depth, arit, ast);
            }

            @Override
            public double getDouble(int i) {
                double adbl = this.a.getDouble(i);
                double bdbl = this.b.getDouble(i);
                if (RDouble.RDoubleUtils.arithIsNA(adbl) || RDouble.RDoubleUtils.arithIsNA(bdbl)) {
                    return RDouble.NA;
                }
                return this.arit.op(this.ast, adbl, bdbl);
            }

            @Override
            public RDouble materialize() {
                double[] res = new double[this.n];
                this.arit.op(this.ast, this.a.getContent(), this.b.getContent(), res, this.n);
                return RDouble.RDoubleFactory.getFor(res, this.dimensions, this.names, this.attributes);
            }
        }

        static final class GenericBSized
        extends DoubleView
        implements RDouble {
            final int na;

            public GenericBSized(RDouble a, RDouble b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int n, int depth, ValueArithmetic arit, ASTNode ast) {
                super(a, b, dimensions, names, attributes, n, depth, arit, ast);
                this.na = a.size();
                assert (Utils.check(b.size() == n));
            }

            @Override
            public double getDouble(int i) {
                int ai = i % this.na;
                double adbl = this.a.getDouble(ai);
                double bdbl = this.b.getDouble(i);
                if (RDouble.RDoubleUtils.arithIsNA(adbl) || RDouble.RDoubleUtils.arithIsNA(bdbl)) {
                    return RDouble.NA;
                }
                return this.arit.op(this.ast, adbl, bdbl);
            }
        }

        static final class GenericASized
        extends DoubleView
        implements RDouble {
            final int nb;

            public GenericASized(RDouble a, RDouble b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int n, int depth, ValueArithmetic arit, ASTNode ast) {
                super(a, b, dimensions, names, attributes, n, depth, arit, ast);
                assert (Utils.check(a.size() == n));
                this.nb = b.size();
            }

            @Override
            public double getDouble(int i) {
                int bi = i % this.nb;
                double adbl = this.a.getDouble(i);
                double bdbl = this.b.getDouble(bi);
                if (RDouble.RDoubleUtils.arithIsNA(adbl) || RDouble.RDoubleUtils.arithIsNA(bdbl)) {
                    return RDouble.NA;
                }
                return this.arit.op(this.ast, adbl, bdbl);
            }
        }

        static final class Generic
        extends DoubleView
        implements RDouble {
            final int na;
            final int nb;

            public Generic(RDouble a, RDouble b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int n, int depth, ValueArithmetic arit, ASTNode ast) {
                super(a, b, dimensions, names, attributes, n, depth, arit, ast);
                this.na = a.size();
                this.nb = b.size();
            }

            @Override
            public double getDouble(int i) {
                int bi;
                int ai;
                if (i >= this.na) {
                    ai = i % this.na;
                    bi = i;
                } else if (i >= this.nb) {
                    bi = i % this.nb;
                    ai = i;
                } else {
                    ai = i;
                    bi = i;
                }
                double adbl = this.a.getDouble(ai);
                double bdbl = this.b.getDouble(bi);
                if (RDouble.RDoubleUtils.arithIsNA(adbl) || RDouble.RDoubleUtils.arithIsNA(bdbl)) {
                    return RDouble.NA;
                }
                return this.arit.op(this.ast, adbl, bdbl);
            }
        }
    }

    public static class ComplexView
    extends View.RComplexView
    implements RComplex {
        final RComplex a;
        final RComplex b;
        final int na;
        final int nb;
        final int n;
        final int[] dimensions;
        final RArray.Names names;
        final RAny.Attributes attributes;
        boolean overflown = false;
        final ValueArithmetic arit;
        final ASTNode ast;
        private int depth;

        public static RComplex create(RComplex a, RComplex b, ValueArithmetic arit, ASTNode ast) {
            int asize = a.size();
            if (asize > 1) {
                double d;
                double c;
                int bsize = b.size();
                if (asize == bsize) {
                    return arit.op(ast, (ComplexImpl)a.materialize(), (ComplexImpl)b.materialize(), asize, Arithmetic.resultDimensions(ast, a, b), Arithmetic.resultNames(ast, a, b), Arithmetic.resultAttributes(ast, a, b));
                }
                if (bsize == 1 && !RComplex.RComplexUtils.arithEitherIsNA(c = b.getReal(0), d = b.getImag(0))) {
                    return arit.op(ast, (ComplexImpl)a.materialize(), c, d, asize, Arithmetic.resultDimensions(ast, a, b), Arithmetic.resultNames(ast, a, b), Arithmetic.resultAttributes(ast, a, b));
                }
            }
            int depth = 0;
            int adepth = a instanceof ComplexView ? ((ComplexView)a).depth : 0;
            int bdepth = b instanceof ComplexView ? ((ComplexView)b).depth : 0;
            depth = adepth + bdepth + 1;
            int[] dim = Arithmetic.resultDimensions(ast, a, b);
            RArray.Names names = Arithmetic.resultNames(ast, a, b);
            RAny.Attributes attributes = Arithmetic.resultAttributes(ast, a, b);
            ComplexView res = new ComplexView(a, b, dim, names, attributes, depth, arit, ast);
            if (depth > 5 || a instanceof ScalarComplexImpl && b instanceof ScalarComplexImpl) {
                return RComplex.RComplexFactory.copy(res);
            }
            return res;
        }

        public ComplexView(RComplex a, RComplex b, int[] dimensions, RArray.Names names, RAny.Attributes attributes, int depth, ValueArithmetic arit, ASTNode ast) {
            this.a = a;
            this.b = b;
            this.na = a.size();
            this.nb = b.size();
            this.ast = ast;
            this.arit = arit;
            this.dimensions = dimensions;
            this.names = names;
            this.attributes = attributes;
            this.depth = depth;
            if (this.na > this.nb) {
                this.n = this.na;
                if (this.n / this.nb * this.nb != this.n) {
                    RContext.warning(ast, "longer object length is not a multiple of shorter object length");
                }
            } else {
                this.n = this.nb;
                if (this.n / this.na * this.na != this.n) {
                    RContext.warning(ast, "longer object length is not a multiple of shorter object length");
                }
            }
        }

        @Override
        public int size() {
            return this.n;
        }

        @Override
        public double getReal(int i) {
            int bi;
            int ai;
            if (i >= this.na) {
                ai = i % this.na;
                bi = i;
            } else if (i >= this.nb) {
                bi = i % this.nb;
                ai = i;
            } else {
                ai = i;
                bi = i;
            }
            double areal = this.a.getReal(ai);
            double aimag = this.a.getImag(ai);
            double breal = this.b.getReal(bi);
            double bimag = this.b.getImag(bi);
            if (!RComplex.RComplexUtils.arithEitherIsNA(areal, aimag) && !RComplex.RComplexUtils.arithEitherIsNA(breal, bimag)) {
                return this.arit.opReal(this.ast, areal, aimag, breal, bimag);
            }
            return RDouble.NA;
        }

        @Override
        public double getImag(int i) {
            int bi;
            int ai;
            if (i >= this.na) {
                ai = i % this.na;
                bi = i;
            } else if (i >= this.nb) {
                bi = i % this.nb;
                ai = i;
            } else {
                ai = i;
                bi = i;
            }
            double areal = this.a.getReal(ai);
            double aimag = this.a.getImag(ai);
            double breal = this.b.getReal(bi);
            double bimag = this.b.getImag(bi);
            if (!RComplex.RComplexUtils.arithEitherIsNA(areal, aimag) && !RComplex.RComplexUtils.arithEitherIsNA(breal, bimag)) {
                return this.arit.opImag(this.ast, areal, aimag, breal, bimag);
            }
            return RDouble.NA;
        }

        @Override
        public boolean isSharedReal() {
            return this.a.isShared() || this.b.isShared();
        }

        @Override
        public void ref() {
            this.a.ref();
            this.b.ref();
        }

        @Override
        public int[] dimensions() {
            return this.dimensions;
        }

        @Override
        public RArray.Names names() {
            return this.names;
        }

        @Override
        public RAny.Attributes attributes() {
            return this.attributes;
        }

        @Override
        public boolean dependsOn(RAny value) {
            return this.a.dependsOn(value) || this.b.dependsOn(value);
        }
    }

    public static final class Mod
    extends ValueArithmetic {
        @Override
        public double opReal(ASTNode ast, double a, double b, double c, double d) {
            throw RError.getUnimplementedComplex(ast);
        }

        @Override
        public double opImag(ASTNode ast, double a, double b, double c, double d) {
            throw RError.getUnimplementedComplex(ast);
        }

        @Override
        public double op(ASTNode ast, double a, double b) {
            return Arithmetic.fmod(ast, a, b);
        }

        @Override
        public int op(ASTNode ast, int a, int b) {
            if (b != 0) {
                if (a >= 0 && b > 0) {
                    return a % b;
                }
                return (int)Arithmetic.fmod(ast, a, b);
            }
            return Integer.MIN_VALUE;
        }

        @Override
        public void emitOverflowWarning(ASTNode ast) {
        }

        @Override
        public RComplex op(ASTNode ast, ComplexImpl xcomp, ComplexImpl ycomp, int size, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
            throw RError.getUnimplementedComplex(ast);
        }

        @Override
        public RComplex op(ASTNode ast, ComplexImpl xcomp, double c, double d, int size, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
            throw RError.getUnimplementedComplex(ast);
        }

        @Override
        public void op(ASTNode ast, double[] x, double[] y, double[] res, int size) {
            if (!RContext.hasGNUR()) {
                for (int i = 0; i < size; ++i) {
                    double a = x[i];
                    double b = y[i];
                    double c = Arithmetic.fmod(ast, a, b);
                    if (RDouble.RDoubleUtils.arithIsNA(c)) {
                        if (!RDouble.RDoubleUtils.arithIsNA(a) && !RDouble.RDoubleUtils.arithIsNA(b)) continue;
                        res[i] = RDouble.NA;
                        continue;
                    }
                    res[i] = c;
                }
            } else {
                boolean warn = GNUR.fmod(x, y, res, size);
                if (warn) {
                    RContext.warning(ast, "probable complete loss of accuracy in modulus");
                }
            }
        }

        @Override
        public void op(ASTNode ast, double[] x, double y, double[] res, int size) {
            for (int i = 0; i < size; ++i) {
                double a = x[i];
                double c = Arithmetic.fmod(ast, a, y);
                if (RDouble.RDoubleUtils.arithIsNA(c)) {
                    if (!RDouble.RDoubleUtils.arithIsNA(a) && !RDouble.RDoubleUtils.arithIsNA(y)) continue;
                    res[i] = RDouble.NA;
                    continue;
                }
                res[i] = c;
            }
        }

        @Override
        public void op(ASTNode ast, int[] x, int yfrom, int yto, int ystep, int[] res, int size) {
            Utils.nyi();
        }

        @Override
        public boolean returnsDouble() {
            return false;
        }
    }

    public static final class IntegerDiv
    extends ValueArithmetic {
        @Override
        public double opReal(ASTNode ast, double a, double b, double c, double d) {
            throw RError.getUnimplementedComplex(ast);
        }

        @Override
        public double opImag(ASTNode ast, double a, double b, double c, double d) {
            throw RError.getUnimplementedComplex(ast);
        }

        @Override
        public double op(ASTNode ast, double a, double b) {
            double q = a / b;
            if (b != 0.0) {
                double qfloor = Math.floor(q);
                double tmp = a - qfloor * b;
                return qfloor + Math.floor(tmp / b);
            }
            return q;
        }

        @Override
        public int op(ASTNode ast, int a, int b) {
            if (b != 0) {
                return (int)Math.floor((double)a / (double)b);
            }
            return Integer.MIN_VALUE;
        }

        @Override
        public void emitOverflowWarning(ASTNode ast) {
        }

        @Override
        public RComplex op(ASTNode ast, ComplexImpl xcomp, ComplexImpl ycomp, int size, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
            throw RError.getUnimplementedComplex(ast);
        }

        @Override
        public RComplex op(ASTNode ast, ComplexImpl xcomp, double c, double d, int size, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
            throw RError.getUnimplementedComplex(ast);
        }

        @Override
        public void op(ASTNode ast, double[] x, double[] y, double[] res, int size) {
            for (int i = 0; i < size; ++i) {
                double a = x[i];
                double b = y[i];
                double c = this.op(ast, a, b);
                if (RDouble.RDoubleUtils.arithIsNA(c)) {
                    if (!RDouble.RDoubleUtils.arithIsNA(a) && !RDouble.RDoubleUtils.arithIsNA(b)) continue;
                    res[i] = RDouble.NA;
                    continue;
                }
                res[i] = c;
            }
        }

        @Override
        public void op(ASTNode ast, double[] x, double y, double[] res, int size) {
            for (int i = 0; i < size; ++i) {
                double a = x[i];
                double c = this.op(ast, a, y);
                if (RDouble.RDoubleUtils.arithIsNA(c)) {
                    if (!RDouble.RDoubleUtils.arithIsNA(a) && !RDouble.RDoubleUtils.arithIsNA(y)) continue;
                    res[i] = RDouble.NA;
                    continue;
                }
                res[i] = c;
            }
        }

        @Override
        public void op(ASTNode ast, int[] x, int yfrom, int yto, int ystep, int[] res, int size) {
            Utils.nyi();
        }

        @Override
        public boolean returnsDouble() {
            return false;
        }
    }

    public static final class Div
    extends ValueArithmetic {
        private static final double[] opTMP = new double[2];

        @Override
        public double opReal(ASTNode ast, double a, double b, double c, double d) {
            Arithmetic.cdiv(a, b, c, d, opTMP, 0);
            return opTMP[0];
        }

        @Override
        public double opImag(ASTNode ast, double a, double b, double c, double d) {
            Arithmetic.cdiv(a, b, c, d, opTMP, 0);
            return opTMP[1];
        }

        @Override
        public double op(ASTNode ast, double a, double b) {
            return a / b;
        }

        @Override
        public int op(ASTNode ast, int a, int b) {
            Utils.nyi("unreachable");
            return -1;
        }

        @Override
        public void emitOverflowWarning(ASTNode ast) {
            Utils.nyi("unreachable");
        }

        @Override
        public RComplex op(ASTNode ast, ComplexImpl xcomp, ComplexImpl ycomp, int size, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
            int rsize = size * 2;
            double[] res = new double[rsize];
            double[] x = xcomp.getContent();
            double[] y = ycomp.getContent();
            int j = 1;
            int i = 0;
            while (i < rsize) {
                double a = x[i];
                double b = x[j];
                double c = y[i];
                double d = y[j];
                if (!RComplex.RComplexUtils.arithEitherIsNA(a, b) && !RComplex.RComplexUtils.arithEitherIsNA(c, d)) {
                    Arithmetic.cdiv(a, b, c, d, res, i);
                } else {
                    res[i] = RDouble.NA;
                    res[j] = RDouble.NA;
                }
                ++i;
                ++i;
                ++j;
                ++j;
            }
            return RComplex.RComplexFactory.getFor(res, dimensions, names, attributes);
        }

        @Override
        public RComplex op(ASTNode ast, ComplexImpl xcomp, double c, double d, int size, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
            int rsize = size * 2;
            double[] res = new double[rsize];
            double[] x = xcomp.getContent();
            int j = 1;
            int i = 0;
            while (i < rsize) {
                double a = x[i];
                double b = x[j];
                if (!RComplex.RComplexUtils.arithEitherIsNA(a, b)) {
                    Arithmetic.cdiv(a, b, c, d, res, i);
                } else {
                    res[i] = RDouble.NA;
                    res[j] = RDouble.NA;
                }
                ++i;
                ++i;
                ++j;
                ++j;
            }
            return RComplex.RComplexFactory.getFor(res, dimensions, names, attributes);
        }

        @Override
        public void op(ASTNode ast, double[] x, double[] y, double[] res, int size) {
            for (int i = 0; i < size; ++i) {
                double a = x[i];
                double b = y[i];
                double c = a / b;
                if (RDouble.RDoubleUtils.arithIsNA(c)) {
                    if (!RDouble.RDoubleUtils.arithIsNA(a) && !RDouble.RDoubleUtils.arithIsNA(b)) continue;
                    res[i] = RDouble.NA;
                    continue;
                }
                res[i] = c;
            }
        }

        @Override
        public void op(ASTNode ast, double[] x, double y, double[] res, int size) {
            for (int i = 0; i < size; ++i) {
                double a = x[i];
                double c = a / y;
                if (RDouble.RDoubleUtils.arithIsNA(c)) {
                    if (!RDouble.RDoubleUtils.arithIsNA(a) && !RDouble.RDoubleUtils.arithIsNA(y)) continue;
                    res[i] = RDouble.NA;
                    continue;
                }
                res[i] = c;
            }
        }

        @Override
        public void op(ASTNode ast, int[] x, int yfrom, int yto, int ystep, int[] res, int size) {
            Utils.nyi();
        }

        @Override
        public boolean returnsDouble() {
            return true;
        }
    }

    public static final class Pow
    extends ValueArithmetic {
        private static final double[] cpowTMP = new double[2];
        private static final double[] opTMP = new double[2];

        private static void creciprocal(double[] z, int offset) {
            double y;
            double x;
            double c = z[offset];
            double d = z[offset + 1];
            if (Math.abs(c) < Math.abs(d)) {
                double ratio = c / d;
                double denom = c * ratio + d;
                x = ratio / denom;
                y = -1.0 / denom;
            } else {
                double ratio = d / c;
                double denom = d * ratio + c;
                x = 1.0 / denom;
                y = -ratio / denom;
            }
            if (Double.isNaN(x) && Double.isNaN(y)) {
                if (c == 0.0 && d == 0.0) {
                    x = Math.copySign(Double.POSITIVE_INFINITY, c);
                    y = Math.copySign(Double.NaN, c);
                } else if (Double.isInfinite(c) || Double.isInfinite(d)) {
                    double rc = Arithmetic.convertInf(c);
                    double rd = Arithmetic.convertInf(d);
                    x = 0.0 * rc;
                    y = 0.0 * -rd;
                }
            }
            z[offset] = x;
            z[offset + 1] = y;
        }

        private static void cpow(double xr, double xi, int k, double[] z, int offset) {
            if (k == 0) {
                z[offset] = 1.0;
                z[offset + 1] = 0.0;
                return;
            }
            if (k == 1) {
                z[offset] = xr;
                z[offset + 1] = xi;
                return;
            }
            if (k < 0) {
                Pow.cpow(xr, xi, -k, z, offset);
                Pow.creciprocal(z, offset);
                return;
            }
            double[] x = cpowTMP;
            x[0] = xr;
            x[1] = xi;
            z[offset] = 1.0;
            z[offset + 1] = 0.0;
            for (int kk = k; kk > 0; kk /= 2) {
                if ((kk & 1) != 0) {
                    Arithmetic.cmult(z[offset], z[offset + 1], x[0], x[1], z, offset);
                    if (kk == 1) break;
                }
                Pow.cpow2(x[0], x[1], x, 0);
            }
        }

        private static void cpow(double xr, double xi, double yr, double yi, double[] z, int offset) {
            double rho;
            int k;
            if (xr == 0.0) {
                if (yi == 0.0) {
                    z[offset] = Arithmetic.pow(0.0, yr);
                    z[offset + 1] = xi;
                } else {
                    z[offset] = Double.NaN;
                    z[offset + 1] = Double.NaN;
                }
                return;
            }
            if (yi == 0.0 && yr == (double)(k = (int)yr) && Math.abs(k) <= 65536) {
                Pow.cpow(xr, xi, k, z, offset);
                return;
            }
            double zr = Arithmetic.chypot(xr, xi);
            double zi = Math.atan2(xi, xr);
            double theta = zi * yr;
            if (yi == 0.0) {
                rho = Arithmetic.pow(zr, yr);
            } else {
                zr = Math.log(zr);
                theta += zr * yi;
                rho = Math.exp(zr * yr - zi * yi);
            }
            z[offset] = rho * Math.cos(theta);
            z[offset + 1] = rho * Math.sin(theta);
        }

        @Override
        public double opReal(ASTNode ast, double a, double b, double c, double d) {
            Pow.cpow(a, b, c, d, opTMP, 0);
            return opTMP[0];
        }

        @Override
        public double opImag(ASTNode ast, double a, double b, double c, double d) {
            Pow.cpow(a, b, c, d, opTMP, 0);
            return opTMP[1];
        }

        @Override
        public double op(ASTNode ast, double a, double b) {
            if (b == 2.0) {
                return a * a;
            }
            if (a == 1.0 || b == 0.0) {
                return 1.0;
            }
            if (a == 0.0) {
                if (b > 0.0) {
                    return 0.0;
                }
                if (b < 0.0) {
                    return Double.POSITIVE_INFINITY;
                }
                return b;
            }
            if (Arithmetic.isFinite(a) && Arithmetic.isFinite(b)) {
                return Arithmetic.pow(a, b);
            }
            if (RDouble.RDoubleUtils.isNAorNaN(a) || RDouble.RDoubleUtils.isNAorNaN(b)) {
                return a + b;
            }
            if (!Arithmetic.isFinite(a)) {
                if (a > 0.0) {
                    if (b < 0.0) {
                        return 0.0;
                    }
                    return Double.POSITIVE_INFINITY;
                }
                if (Arithmetic.isFinite(b) && b == Math.floor(b)) {
                    if (b < 0.0) {
                        return 0.0;
                    }
                    return Arithmetic.fmod(ast, b, 2.0) != 0.0 ? a : -a;
                }
            }
            if (!Arithmetic.isFinite(b) && a >= 0.0) {
                if (b > 0.0) {
                    return a >= 1.0 ? Double.POSITIVE_INFINITY : 0.0;
                }
                return a < 1.0 ? Double.POSITIVE_INFINITY : 0.0;
            }
            return Double.NaN;
        }

        @Override
        public int op(ASTNode ast, int a, int b) {
            Utils.nyi("unreachable");
            return -1;
        }

        @Override
        public void emitOverflowWarning(ASTNode ast) {
            Utils.nyi("unreachable");
        }

        @Override
        public RComplex op(ASTNode ast, ComplexImpl xcomp, ComplexImpl ycomp, int size, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
            double[] x = xcomp.getContent();
            double[] y = ycomp.getContent();
            double[] z = new double[x.length];
            for (int i = 0; i < x.length; i += 2) {
                double xr = x[i];
                double xi = x[i + 1];
                double yr = y[i];
                double yi = y[i + 1];
                if (!RComplex.RComplexUtils.arithEitherIsNA(xr, xi) && !RComplex.RComplexUtils.arithEitherIsNA(yr, yi)) {
                    Pow.cpow(x[i], x[i + 1], y[i], y[i + 1], z, i);
                    continue;
                }
                z[i] = RDouble.NA;
                z[i + 1] = RDouble.NA;
            }
            RComplex res = RComplex.RComplexFactory.getFor(z, dimensions, names);
            return res;
        }

        public static void cpow2(double a, double b, double[] res, int offset) {
            double a2 = a * a;
            double b2 = b * b;
            double ab = a * b;
            double real = a2 - b2;
            double imag = 2.0 * ab;
            if (Double.isNaN(real) && Double.isNaN(imag)) {
                boolean recalc = false;
                double ra = a;
                double rb = b;
                if (Double.isInfinite(ra) || Double.isInfinite(rb)) {
                    ra = Arithmetic.convertInf(ra);
                    rb = Arithmetic.convertInf(rb);
                    recalc = true;
                }
                if (!recalc && (Double.isInfinite(a2) || Double.isInfinite(b2) || Double.isInfinite(ab))) {
                    ra = Arithmetic.convertNaN(ra);
                    rb = Arithmetic.convertNaN(rb);
                    recalc = true;
                }
                if (recalc) {
                    real = Double.POSITIVE_INFINITY * (ra * ra - rb * rb);
                    imag = Double.POSITIVE_INFINITY * (ra * rb);
                }
            }
            res[offset] = real;
            res[offset + 1] = imag;
        }

        private static void cpow(double[] res, double[] x, double yr, double yi) {
            if (yr == 2.0 && yi == 0.0) {
                for (int i = 0; i < x.length; i += 2) {
                    double xr = x[i];
                    double xi = x[i + 1];
                    if (!RComplex.RComplexUtils.arithEitherIsNA(xr, xi)) {
                        Pow.cpow2(xr, xi, res, i);
                        continue;
                    }
                    res[i] = RDouble.NA;
                    res[i + 1] = RDouble.NA;
                }
            } else {
                for (int i = 0; i < x.length; i += 2) {
                    double xr = x[i];
                    double xi = x[i + 1];
                    if (!RComplex.RComplexUtils.arithEitherIsNA(xr, xi)) {
                        Pow.cpow(x[i], x[i + 1], yr, yi, res, i);
                        continue;
                    }
                    res[i] = RDouble.NA;
                    res[i + 1] = RDouble.NA;
                }
            }
        }

        @Override
        public RComplex op(ASTNode ast, ComplexImpl xcomp, double yr, double yi, int size, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
            double[] x = xcomp.getContent();
            if (xcomp.isTemporary()) {
                Pow.cpow(x, x, yr, yi);
                xcomp.setNames(names).setDimensions(dimensions).setAttributes(attributes);
                return xcomp;
            }
            double[] res = new double[x.length];
            Pow.cpow(res, x, yr, yi);
            return RComplex.RComplexFactory.getFor(res, dimensions, names, attributes);
        }

        @Override
        public void op(ASTNode ast, double[] x, double[] y, double[] res, int size) {
            if (!RContext.hasGNUR()) {
                for (int i = 0; i < size; ++i) {
                    double a = x[i];
                    double b = y[i];
                    double c = Arithmetic.pow(a, b);
                    if (RDouble.RDoubleUtils.arithIsNA(c)) {
                        if (!RDouble.RDoubleUtils.arithIsNA(a) && !RDouble.RDoubleUtils.arithIsNA(b)) continue;
                        res[i] = RDouble.NA;
                        continue;
                    }
                    res[i] = c;
                }
            } else {
                GNUR.pow(x, y, res, size);
            }
        }

        @Override
        public void op(ASTNode ast, double[] x, double y, double[] res, int size) {
            if (!RContext.hasGNUR()) {
                for (int i = 0; i < size; ++i) {
                    double a = x[i];
                    double c = Arithmetic.pow(a, y);
                    if (RDouble.RDoubleUtils.arithIsNA(c)) {
                        if (!RDouble.RDoubleUtils.arithIsNA(a) && !RDouble.RDoubleUtils.arithIsNA(y)) continue;
                        res[i] = RDouble.NA;
                        continue;
                    }
                    res[i] = c;
                }
            } else {
                GNUR.pow(x, y, res, size);
            }
        }

        @Override
        public void op(ASTNode ast, int[] x, int yfrom, int yto, int ystep, int[] res, int size) {
            Utils.nyi();
        }

        @Override
        public boolean returnsDouble() {
            return true;
        }
    }

    public static final class Mult
    extends ValueArithmetic {
        private static final double[] opTMP = new double[2];

        @Override
        public double opReal(ASTNode ast, double a, double b, double c, double d) {
            Arithmetic.cmult(a, b, c, d, opTMP, 0);
            return opTMP[0];
        }

        @Override
        public double opImag(ASTNode ast, double a, double b, double c, double d) {
            Arithmetic.cmult(a, b, c, d, opTMP, 0);
            return opTMP[1];
        }

        @Override
        public double op(ASTNode ast, double a, double b) {
            return a * b;
        }

        @Override
        public int op(ASTNode ast, int a, int b) {
            long l = (long)a * (long)b;
            if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                return (int)l;
            }
            return Integer.MIN_VALUE;
        }

        @Override
        public void emitOverflowWarning(ASTNode ast) {
            RContext.warning(ast, "NAs produced by integer overflow");
        }

        private static void cmult(double[] res, double[] x, double[] y, int rsize) {
            if (x == y) {
                int j = 1;
                int i = 0;
                while (i < rsize) {
                    double a = x[i];
                    double b = x[j];
                    if (!RComplex.RComplexUtils.arithEitherIsNA(a, b)) {
                        Pow.cpow2(a, b, res, i);
                    } else {
                        res[i] = RDouble.NA;
                        res[j] = RDouble.NA;
                    }
                    ++i;
                    ++i;
                    ++j;
                    ++j;
                }
                return;
            }
            int j = 1;
            int i = 0;
            while (i < rsize) {
                double a = x[i];
                double b = x[j];
                double c = y[i];
                double d = y[j];
                if (!RComplex.RComplexUtils.arithEitherIsNA(a, b) && !RComplex.RComplexUtils.arithEitherIsNA(c, d)) {
                    Arithmetic.cmult(a, b, c, d, res, i);
                } else {
                    res[i] = RDouble.NA;
                    res[j] = RDouble.NA;
                }
                ++i;
                ++i;
                ++j;
                ++j;
            }
        }

        @Override
        public RComplex op(ASTNode ast, ComplexImpl xcomp, ComplexImpl ycomp, int size, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
            int rsize = size * 2;
            double[] x = xcomp.getContent();
            double[] y = ycomp.getContent();
            if (xcomp.isTemporary()) {
                Mult.cmult(x, x, y, rsize);
                xcomp.setNames(names).setDimensions(dimensions).setAttributes(attributes);
                return xcomp;
            }
            if (ycomp.isTemporary()) {
                Mult.cmult(y, x, y, rsize);
                ycomp.setNames(names).setDimensions(dimensions).setAttributes(attributes);
                return ycomp;
            }
            double[] res = new double[rsize];
            Mult.cmult(res, x, y, rsize);
            return RComplex.RComplexFactory.getFor(res, dimensions, names, attributes);
        }

        @Override
        public RComplex op(ASTNode ast, ComplexImpl xcomp, double c, double d, int size, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
            int rsize = size * 2;
            double[] res = new double[rsize];
            double[] x = xcomp.getContent();
            int j = 1;
            int i = 0;
            while (i < rsize) {
                double a = x[i];
                double b = x[j];
                if (!RComplex.RComplexUtils.arithEitherIsNA(a, b)) {
                    Arithmetic.cmult(x[i], x[j], c, d, res, i);
                } else {
                    res[i] = RDouble.NA;
                    res[j] = RDouble.NA;
                }
                ++i;
                ++i;
                ++j;
                ++j;
            }
            return RComplex.RComplexFactory.getFor(res, dimensions, names, attributes);
        }

        @Override
        public void op(ASTNode ast, double[] x, double[] y, double[] res, int size) {
            for (int i = 0; i < size; ++i) {
                double a = x[i];
                double b = y[i];
                double c = a * b;
                if (RDouble.RDoubleUtils.arithIsNA(c)) {
                    if (!RDouble.RDoubleUtils.arithIsNA(a) && !RDouble.RDoubleUtils.arithIsNA(b)) continue;
                    res[i] = RDouble.NA;
                    continue;
                }
                res[i] = c;
            }
        }

        @Override
        public void op(ASTNode ast, double[] x, double y, double[] res, int size) {
            for (int i = 0; i < size; ++i) {
                double a = x[i];
                double c = a * y;
                if (RDouble.RDoubleUtils.arithIsNA(c)) {
                    if (!RDouble.RDoubleUtils.arithIsNA(a) && !RDouble.RDoubleUtils.arithIsNA(y)) continue;
                    res[i] = RDouble.NA;
                    continue;
                }
                res[i] = c;
            }
        }

        @Override
        public void op(ASTNode ast, int[] x, int yfrom, int yto, int ystep, int[] res, int size) {
            Utils.nyi();
        }

        @Override
        public boolean returnsDouble() {
            return false;
        }
    }

    public static final class Sub
    extends ValueArithmetic {
        @Override
        public double opReal(ASTNode ast, double a, double b, double c, double d) {
            return a - c;
        }

        @Override
        public double opImag(ASTNode ast, double a, double b, double c, double d) {
            return b - d;
        }

        @Override
        public double op(ASTNode ast, double a, double b) {
            return a - b;
        }

        @Override
        public int op(ASTNode ast, int a, int b) {
            int r = a - b;
            if (a < 0 == b < 0 || a < 0 == r < 0) {
                return r;
            }
            return Integer.MIN_VALUE;
        }

        @Override
        public void emitOverflowWarning(ASTNode ast) {
            RContext.warning(ast, "NAs produced by integer overflow");
        }

        @Override
        public RComplex op(ASTNode ast, ComplexImpl xcomp, ComplexImpl ycomp, int size, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
            int rsize = size * 2;
            double[] res = new double[rsize];
            double[] x = xcomp.getContent();
            double[] y = ycomp.getContent();
            int j = 1;
            int i = 0;
            while (i < rsize) {
                double a = x[i];
                double b = x[j];
                double c = y[i];
                double d = y[j];
                if (!RComplex.RComplexUtils.arithEitherIsNA(a, b) && !RComplex.RComplexUtils.arithEitherIsNA(c, d)) {
                    res[i] = a - c;
                    res[j] = b - d;
                } else {
                    res[i] = RDouble.NA;
                    res[j] = RDouble.NA;
                }
                ++i;
                ++i;
                ++j;
                ++j;
            }
            return RComplex.RComplexFactory.getFor(res, dimensions, names, attributes);
        }

        @Override
        public RComplex op(ASTNode ast, ComplexImpl xcomp, double c, double d, int size, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
            int rsize = size * 2;
            double[] res = new double[rsize];
            double[] x = xcomp.getContent();
            int j = 1;
            int i = 0;
            while (i < rsize) {
                double a = x[i];
                double b = x[j];
                if (!RComplex.RComplexUtils.arithEitherIsNA(a, b)) {
                    res[i] = a - c;
                    res[j] = b - d;
                } else {
                    res[i] = RDouble.NA;
                    res[j] = RDouble.NA;
                }
                ++i;
                ++i;
                ++j;
                ++j;
            }
            return RComplex.RComplexFactory.getFor(res, dimensions, names, attributes);
        }

        @Override
        public void op(ASTNode ast, double[] x, double[] y, double[] res, int size) {
            for (int i = 0; i < size; ++i) {
                double a = x[i];
                double b = y[i];
                double c = a - b;
                if (RDouble.RDoubleUtils.arithIsNA(c)) {
                    if (!RDouble.RDoubleUtils.arithIsNA(a) && !RDouble.RDoubleUtils.arithIsNA(b)) continue;
                    res[i] = RDouble.NA;
                    continue;
                }
                res[i] = c;
            }
        }

        @Override
        public void op(ASTNode ast, double[] x, double y, double[] res, int size) {
            for (int i = 0; i < size; ++i) {
                double a = x[i];
                double c = a - y;
                if (RDouble.RDoubleUtils.arithIsNA(c)) {
                    if (!RDouble.RDoubleUtils.arithIsNA(a) && !RDouble.RDoubleUtils.arithIsNA(y)) continue;
                    res[i] = RDouble.NA;
                    continue;
                }
                res[i] = c;
            }
        }

        @Override
        public void op(ASTNode ast, int[] x, int yfrom, int yto, int ystep, int[] res, int size) {
            Utils.nyi();
        }

        @Override
        public boolean returnsDouble() {
            return false;
        }
    }

    public static final class Add
    extends ValueArithmetic {
        @Override
        public double opReal(ASTNode ast, double a, double b, double c, double d) {
            return a + c;
        }

        @Override
        public double opImag(ASTNode ast, double a, double b, double c, double d) {
            return b + d;
        }

        @Override
        public double op(ASTNode ast, double a, double b) {
            return a + b;
        }

        public static int add(int a, int b) {
            boolean bLTr;
            int r = a + b;
            boolean bl = bLTr = b < r;
            if (a > 0 ? bLTr : !bLTr) {
                return r;
            }
            return Integer.MIN_VALUE;
        }

        @Override
        public int op(ASTNode ast, int a, int b) {
            return Add.add(a, b);
        }

        @Override
        public void emitOverflowWarning(ASTNode ast) {
            RContext.warning(ast, "NAs produced by integer overflow");
        }

        private static void add(double[] res, double[] x, double[] y, int rsize) {
            int j = 1;
            int i = 0;
            while (i < rsize) {
                double a = x[i];
                double b = x[j];
                double c = y[i];
                double d = y[j];
                if (!RComplex.RComplexUtils.arithEitherIsNA(a, b) && !RComplex.RComplexUtils.arithEitherIsNA(c, d)) {
                    res[i] = a + c;
                    res[j] = b + d;
                } else {
                    res[i] = RDouble.NA;
                    res[j] = RDouble.NA;
                }
                ++i;
                ++i;
                ++j;
                ++j;
            }
        }

        @Override
        public RComplex op(ASTNode ast, ComplexImpl xcomp, ComplexImpl ycomp, int size, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
            int rsize = size * 2;
            double[] x = xcomp.getContent();
            double[] y = ycomp.getContent();
            if (xcomp.isTemporary()) {
                Add.add(x, x, y, rsize);
                xcomp.setNames(names).setDimensions(dimensions).setAttributes(attributes);
                return xcomp;
            }
            if (ycomp.isTemporary()) {
                Add.add(y, x, y, rsize);
                ycomp.setNames(names).setDimensions(dimensions).setAttributes(attributes);
                return ycomp;
            }
            double[] res = new double[rsize];
            Add.add(res, x, y, rsize);
            return RComplex.RComplexFactory.getFor(res, dimensions, names, attributes);
        }

        private static void add(double[] res, double[] x, double c, double d, int rsize) {
            int j = 1;
            int i = 0;
            while (i < rsize) {
                double a = x[i];
                double b = x[j];
                if (!RComplex.RComplexUtils.arithEitherIsNA(a, b)) {
                    res[i] = a + c;
                    res[j] = b + d;
                } else {
                    res[i] = RDouble.NA;
                    res[j] = RDouble.NA;
                }
                ++i;
                ++i;
                ++j;
                ++j;
            }
        }

        @Override
        public RComplex op(ASTNode ast, ComplexImpl xcomp, double c, double d, int size, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
            int rsize = size * 2;
            double[] x = xcomp.getContent();
            if (xcomp.isTemporary()) {
                Add.add(x, x, c, d, rsize);
                xcomp.setNames(names).setDimensions(dimensions).setAttributes(attributes);
                return xcomp;
            }
            double[] res = new double[rsize];
            Add.add(res, x, c, d, rsize);
            return RComplex.RComplexFactory.getFor(res, dimensions, names, attributes);
        }

        @Override
        public void op(ASTNode ast, double[] x, double[] y, double[] res, int size) {
            for (int i = 0; i < size; ++i) {
                double a = x[i];
                double b = y[i];
                double c = a + b;
                if (RDouble.RDoubleUtils.arithIsNA(c)) {
                    if (!RDouble.RDoubleUtils.arithIsNA(a) && !RDouble.RDoubleUtils.arithIsNA(b)) continue;
                    res[i] = RDouble.NA;
                    continue;
                }
                res[i] = c;
            }
        }

        @Override
        public void op(ASTNode ast, double[] x, double y, double[] res, int size) {
            for (int i = 0; i < size; ++i) {
                double a = x[i];
                double c = a + y;
                if (RDouble.RDoubleUtils.arithIsNA(c)) {
                    if (!RDouble.RDoubleUtils.arithIsNA(a) && !RDouble.RDoubleUtils.arithIsNA(y)) continue;
                    res[i] = RDouble.NA;
                    continue;
                }
                res[i] = c;
            }
        }

        @Override
        public void op(ASTNode ast, int[] x, int yfrom, int yto, int ystep, int[] res, int size) {
            int y = yfrom;
            boolean overflown = false;
            for (int i = 0; i < size; ++i) {
                int a = x[i];
                if (a == Integer.MIN_VALUE) {
                    res[i] = Integer.MIN_VALUE;
                } else {
                    int r = Add.add(a, y);
                    if (r == Integer.MIN_VALUE) {
                        overflown = true;
                    }
                    res[i] = r;
                }
                if ((y += ystep) <= yto) continue;
                y = yfrom;
            }
            if (y != yfrom) {
                RContext.warning(ast, "longer object length is not a multiple of shorter object length");
            }
            if (overflown) {
                this.emitOverflowWarning(ast);
            }
        }

        @Override
        public boolean returnsDouble() {
            return false;
        }
    }

    public static abstract class ValueArithmetic {
        public abstract double opReal(ASTNode var1, double var2, double var4, double var6, double var8);

        public abstract double opImag(ASTNode var1, double var2, double var4, double var6, double var8);

        public abstract double op(ASTNode var1, double var2, double var4);

        public abstract int op(ASTNode var1, int var2, int var3);

        public abstract void emitOverflowWarning(ASTNode var1);

        public final int opWarnOverflow(ASTNode ast, int a, int b) {
            int res = this.op(ast, a, b);
            if (res == Integer.MIN_VALUE) {
                this.emitOverflowWarning(ast);
            }
            return res;
        }

        public final double op(ASTNode ast, double a, int b) {
            return this.op(ast, a, (double)b);
        }

        public final double op(ASTNode ast, int a, double b) {
            return this.op(ast, (double)a, b);
        }

        public abstract RComplex op(ASTNode var1, ComplexImpl var2, ComplexImpl var3, int var4, int[] var5, RArray.Names var6, RAny.Attributes var7);

        public abstract RComplex op(ASTNode var1, ComplexImpl var2, double var3, double var5, int var7, int[] var8, RArray.Names var9, RAny.Attributes var10);

        public abstract void op(ASTNode var1, double[] var2, double[] var3, double[] var4, int var5);

        public abstract void op(ASTNode var1, double[] var2, double var3, double[] var5, int var6);

        public RDouble op(ASTNode ast, DoubleImpl xdbl, DoubleImpl ydbl, int size, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
            double[] x = xdbl.getContent();
            double[] y = ydbl.getContent();
            if (xdbl.isTemporary()) {
                this.op(ast, x, y, x, size);
                xdbl.setNames(names).setDimensions(dimensions).setAttributes(attributes);
                return xdbl;
            }
            if (ydbl.isTemporary()) {
                this.op(ast, x, y, y, size);
                ydbl.setNames(names).setDimensions(dimensions).setAttributes(attributes);
                return ydbl;
            }
            double[] res = new double[size];
            this.op(ast, x, y, res, size);
            return RDouble.RDoubleFactory.getFor(res, dimensions, names, attributes);
        }

        public RDouble op(ASTNode ast, DoubleImpl xdbl, double y, int size, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
            double[] x = xdbl.getContent();
            if (xdbl.isTemporary()) {
                this.op(ast, x, y, x, size);
                xdbl.setNames(names).setDimensions(dimensions).setAttributes(attributes);
                return xdbl;
            }
            double[] res = new double[size];
            this.op(ast, x, y, res, size);
            return RDouble.RDoubleFactory.getFor(res, dimensions, names, attributes);
        }

        public abstract void op(ASTNode var1, int[] var2, int var3, int var4, int var5, int[] var6, int var7);

        public RInt op(ASTNode ast, IntImpl xint, IntImpl.RIntSequence y, int size, int[] dimensions, RArray.Names names, RAny.Attributes attributes) {
            int[] x = xint.getContent();
            if (xint.isTemporary()) {
                this.op(ast, x, y.from(), y.to(), y.step(), x, size);
                xint.setNames(names).setDimensions(dimensions).setAttributes(attributes);
                return xint;
            }
            int[] res = new int[size];
            this.op(ast, x, y.from(), y.to(), y.step(), res, size);
            return RInt.RIntFactory.getFor(res, dimensions, names, attributes);
        }

        public abstract boolean returnsDouble();
    }

    static class SpecializedConst
    extends Arithmetic {
        final String dbg;
        final Calculator calc;

        public SpecializedConst(ASTNode ast, RNode left, RNode right, ValueArithmetic arit, Calculator calc, String dbg) {
            super(ast, left, right, arit);
            this.dbg = dbg;
            this.calc = calc;
        }

        public static SpecializedConst createSpecialized(RAny leftTemplate, RAny rightTemplate, final ASTNode ast, RNode left, RNode right, final ValueArithmetic arit) {
            boolean leftConst = left instanceof Constant;
            boolean rightConst = right instanceof Constant;
            if (leftConst && rightTemplate instanceof ScalarComplexImpl && (leftTemplate instanceof ScalarComplexImpl || leftTemplate instanceof ScalarDoubleImpl || leftTemplate instanceof ScalarIntImpl || leftTemplate instanceof ScalarLogicalImpl)) {
                RComplex lcmp = leftTemplate.asComplex();
                final double lreal = lcmp.getReal(0);
                final double limag = lcmp.getImag(0);
                final boolean isLeftNA = RComplex.RComplexUtils.arithEitherIsNA(lreal, limag);
                Calculator c = new Calculator(){

                    @Override
                    public Object calc(Object lexpr, Object rexpr) throws SpecializationException {
                        if (!(rexpr instanceof ScalarComplexImpl)) {
                            throw new SpecializationException((Object)FailedSpecialization.FIXED_TYPE);
                        }
                        ScalarComplexImpl rcmp = (ScalarComplexImpl)rexpr;
                        double rreal = rcmp.getReal();
                        double rimag = rcmp.getImag();
                        if (isLeftNA || RComplex.RComplexUtils.arithEitherIsNA(rreal, rimag)) {
                            return RComplex.BOXED_NA;
                        }
                        return RComplex.RComplexFactory.getScalar(arit.opReal(ast, lreal, limag, rreal, rimag), arit.opImag(ast, lreal, limag, rreal, rimag));
                    }
                };
                return SpecializedConst.createLeftConst(ast, left, right, arit, c, "<ConstScalarNumber, ScalarComplex>");
            }
            if (rightConst && leftTemplate instanceof ScalarComplexImpl && (rightTemplate instanceof ScalarComplexImpl || rightTemplate instanceof ScalarDoubleImpl || rightTemplate instanceof ScalarIntImpl || rightTemplate instanceof ScalarLogicalImpl)) {
                RComplex rcmp = rightTemplate.asComplex();
                final double rreal = rcmp.getReal(0);
                final double rimag = rcmp.getImag(0);
                final boolean isRightNA = RComplex.RComplexUtils.arithEitherIsNA(rreal, rimag);
                Calculator c = new Calculator(){

                    @Override
                    public Object calc(Object lexpr, Object rexpr) throws SpecializationException {
                        if (!(lexpr instanceof ScalarComplexImpl)) {
                            throw new SpecializationException((Object)FailedSpecialization.FIXED_TYPE);
                        }
                        ScalarComplexImpl lcmp = (ScalarComplexImpl)lexpr;
                        double lreal = lcmp.getReal();
                        double limag = lcmp.getImag();
                        if (isRightNA || RComplex.RComplexUtils.arithEitherIsNA(lreal, limag)) {
                            return RComplex.BOXED_NA;
                        }
                        return RComplex.RComplexFactory.getScalar(arit.opReal(ast, lreal, limag, rreal, rimag), arit.opImag(ast, lreal, limag, rreal, rimag));
                    }
                };
                return SpecializedConst.createRightConst(ast, left, right, arit, c, "<ScalarComplex, ConstScalarNumber>");
            }
            if (leftConst && rightTemplate instanceof ScalarDoubleImpl && leftTemplate instanceof ScalarComplexImpl) {
                ScalarComplexImpl lcmp = (ScalarComplexImpl)leftTemplate;
                final double lreal = lcmp.getReal(0);
                final double limag = lcmp.getImag(0);
                final boolean isLeftNA = RComplex.RComplexUtils.arithEitherIsNA(lreal, limag);
                Calculator c = new Calculator(){

                    @Override
                    public Object calc(Object lexpr, Object rexpr) throws SpecializationException {
                        if (!(rexpr instanceof ScalarDoubleImpl)) {
                            throw new SpecializationException((Object)FailedSpecialization.FIXED_TYPE);
                        }
                        double rreal = ((ScalarDoubleImpl)rexpr).getDouble();
                        if (isLeftNA || RDouble.RDoubleUtils.isNAorNaN(rreal)) {
                            return RComplex.BOXED_NA;
                        }
                        return RComplex.RComplexFactory.getScalar(arit.opReal(ast, lreal, limag, rreal, 0.0), arit.opImag(ast, lreal, limag, rreal, 0.0));
                    }
                };
                return SpecializedConst.createLeftConst(ast, left, right, arit, c, "<ConstScalarComplex, ScalarDouble>");
            }
            if (rightConst && leftTemplate instanceof ScalarDoubleImpl && rightTemplate instanceof ScalarComplexImpl) {
                ScalarComplexImpl rcmp = (ScalarComplexImpl)rightTemplate;
                final double rreal = rcmp.getReal(0);
                final double rimag = rcmp.getImag(0);
                final boolean isRightNA = RComplex.RComplexUtils.arithEitherIsNA(rreal, rimag);
                Calculator c = new Calculator(){

                    @Override
                    public Object calc(Object lexpr, Object rexpr) throws SpecializationException {
                        if (!(lexpr instanceof ScalarDoubleImpl)) {
                            throw new SpecializationException((Object)FailedSpecialization.FIXED_TYPE);
                        }
                        double lreal = ((ScalarDoubleImpl)lexpr).getDouble();
                        if (isRightNA || RDouble.RDoubleUtils.isNAorNaN(lreal)) {
                            return RComplex.BOXED_NA;
                        }
                        return RComplex.RComplexFactory.getScalar(arit.opReal(ast, lreal, 0.0, rreal, rimag), arit.opImag(ast, lreal, 0.0, rreal, rimag));
                    }
                };
                return SpecializedConst.createRightConst(ast, left, right, arit, c, "<ScalarDouble, ConstScalarComplex>");
            }
            if (leftConst && rightTemplate instanceof ScalarDoubleImpl && (leftTemplate instanceof ScalarDoubleImpl || leftTemplate instanceof ScalarIntImpl || leftTemplate instanceof ScalarLogicalImpl)) {
                final double ldbl = leftTemplate.asDouble().getDouble(0);
                final boolean isLeftNA = RDouble.RDoubleUtils.arithIsNA(ldbl);
                Calculator c = new Calculator(){

                    @Override
                    public Object calc(Object lexpr, Object rexpr) throws SpecializationException {
                        if (!(rexpr instanceof ScalarDoubleImpl)) {
                            throw new SpecializationException((Object)FailedSpecialization.FIXED_TYPE);
                        }
                        double rdbl = ((ScalarDoubleImpl)rexpr).getDouble();
                        if (isLeftNA || RDouble.RDoubleUtils.arithIsNA(rdbl)) {
                            return RDouble.BOXED_NA;
                        }
                        return RDouble.RDoubleFactory.getScalar(arit.op(ast, ldbl, rdbl));
                    }
                };
                return SpecializedConst.createLeftConst(ast, left, right, arit, c, "<ConstScalarNon-Complex, ScalarDouble>");
            }
            if (rightConst && leftTemplate instanceof ScalarDoubleImpl && (rightTemplate instanceof ScalarDoubleImpl || rightTemplate instanceof ScalarIntImpl || rightTemplate instanceof ScalarLogicalImpl)) {
                final double rdbl = rightTemplate.asDouble().getDouble(0);
                final boolean isRightNA = RDouble.RDoubleUtils.arithIsNA(rdbl);
                Calculator c = new Calculator(){

                    @Override
                    public Object calc(Object lexpr, Object rexpr) throws SpecializationException {
                        if (!(lexpr instanceof ScalarDoubleImpl)) {
                            throw new SpecializationException((Object)FailedSpecialization.FIXED_TYPE);
                        }
                        double ldbl = ((ScalarDoubleImpl)lexpr).getDouble();
                        if (isRightNA || RDouble.RDoubleUtils.arithIsNA(ldbl)) {
                            return RDouble.BOXED_NA;
                        }
                        return RDouble.RDoubleFactory.getScalar(arit.op(ast, ldbl, rdbl));
                    }
                };
                return SpecializedConst.createRightConst(ast, left, right, arit, c, "<ScalarDouble, ConstScalarNon-Complex>");
            }
            if (leftConst && leftTemplate instanceof ScalarDoubleImpl && rightTemplate instanceof ScalarIntImpl) {
                final double ldbl = leftTemplate.asDouble().getDouble(0);
                final boolean isLeftNA = RDouble.RDoubleUtils.arithIsNA(ldbl);
                Calculator c = new Calculator(){

                    @Override
                    public Object calc(Object lexpr, Object rexpr) throws SpecializationException {
                        if (!(rexpr instanceof ScalarIntImpl)) {
                            throw new SpecializationException((Object)FailedSpecialization.FIXED_TYPE);
                        }
                        int rint = ((ScalarIntImpl)rexpr).getInt();
                        if (isLeftNA || rint == Integer.MIN_VALUE) {
                            return RDouble.BOXED_NA;
                        }
                        return RDouble.RDoubleFactory.getScalar(arit.op(ast, ldbl, rint));
                    }
                };
                return SpecializedConst.createLeftConst(ast, left, right, arit, c, "<ConstScalarDouble, ScalarInt>");
            }
            if (rightConst && rightTemplate instanceof ScalarDoubleImpl && leftTemplate instanceof ScalarIntImpl) {
                final double rdbl = rightTemplate.asDouble().getDouble(0);
                final boolean isRightNA = RDouble.RDoubleUtils.arithIsNA(rdbl);
                Calculator c = new Calculator(){

                    @Override
                    public Object calc(Object lexpr, Object rexpr) throws SpecializationException {
                        if (!(lexpr instanceof ScalarIntImpl)) {
                            throw new SpecializationException((Object)FailedSpecialization.FIXED_TYPE);
                        }
                        int lint = ((ScalarIntImpl)lexpr).getInt();
                        if (isRightNA || lint == Integer.MIN_VALUE) {
                            return RDouble.BOXED_NA;
                        }
                        return RDouble.RDoubleFactory.getScalar(arit.op(ast, lint, rdbl));
                    }
                };
                return SpecializedConst.createRightConst(ast, left, right, arit, c, "<ScalarInt, ConstScalarDouble>");
            }
            if (leftConst && (leftTemplate instanceof ScalarIntImpl || leftTemplate instanceof ScalarLogicalImpl) && rightTemplate instanceof ScalarIntImpl) {
                boolean isLeftNA;
                final int lint = leftTemplate.asInt().getInt(0);
                boolean bl = isLeftNA = lint == Integer.MIN_VALUE;
                if (SpecializedConst.returnsDouble(arit)) {
                    final double ldbl = lint;
                    Calculator c = new Calculator(){

                        @Override
                        public Object calc(Object lexpr, Object rexpr) throws SpecializationException {
                            if (!(rexpr instanceof ScalarIntImpl)) {
                                throw new SpecializationException((Object)FailedSpecialization.FIXED_TYPE);
                            }
                            int rint = ((ScalarIntImpl)rexpr).getInt();
                            if (isLeftNA || rint == Integer.MIN_VALUE) {
                                return RDouble.BOXED_NA;
                            }
                            return RDouble.RDoubleFactory.getScalar(arit.op(ast, ldbl, (double)rint));
                        }
                    };
                    return SpecializedConst.createLeftConst(ast, left, right, arit, c, "<ConstScalarInt, ScalarInt>");
                }
                Calculator c = new Calculator(){

                    @Override
                    public Object calc(Object lexpr, Object rexpr) throws SpecializationException {
                        if (!(rexpr instanceof ScalarIntImpl)) {
                            throw new SpecializationException((Object)FailedSpecialization.FIXED_TYPE);
                        }
                        int rint = ((ScalarIntImpl)rexpr).getInt();
                        if (isLeftNA || rint == Integer.MIN_VALUE) {
                            return RInt.BOXED_NA;
                        }
                        return RInt.RIntFactory.getScalar(arit.opWarnOverflow(ast, lint, rint));
                    }
                };
                return SpecializedConst.createLeftConst(ast, left, right, arit, c, "<ConstScalarInt, ScalarInt>");
            }
            if (rightConst && (rightTemplate instanceof ScalarIntImpl || rightTemplate instanceof ScalarLogicalImpl) && leftTemplate instanceof ScalarIntImpl) {
                boolean isRightNA;
                final int rint = rightTemplate.asInt().getInt(0);
                boolean bl = isRightNA = rint == Integer.MIN_VALUE;
                if (SpecializedConst.returnsDouble(arit)) {
                    final double rdbl = rint;
                    Calculator c = new Calculator(){

                        @Override
                        public Object calc(Object lexpr, Object rexpr) throws SpecializationException {
                            if (!(lexpr instanceof ScalarIntImpl)) {
                                throw new SpecializationException((Object)FailedSpecialization.FIXED_TYPE);
                            }
                            int lint = ((ScalarIntImpl)lexpr).getInt();
                            if (isRightNA || lint == Integer.MIN_VALUE) {
                                return RDouble.BOXED_NA;
                            }
                            return RDouble.RDoubleFactory.getScalar(arit.op(ast, (double)lint, rdbl));
                        }
                    };
                    return SpecializedConst.createRightConst(ast, left, right, arit, c, "<ScalarInt, ConstScalarInt>");
                }
                Calculator c = new Calculator(){

                    @Override
                    public Object calc(Object lexpr, Object rexpr) throws SpecializationException {
                        if (!(lexpr instanceof ScalarIntImpl)) {
                            throw new SpecializationException((Object)FailedSpecialization.FIXED_TYPE);
                        }
                        int lint = ((ScalarIntImpl)lexpr).getInt();
                        if (isRightNA || lint == Integer.MIN_VALUE) {
                            return RInt.BOXED_NA;
                        }
                        return RInt.RIntFactory.getScalar(arit.opWarnOverflow(ast, lint, rint));
                    }
                };
                return SpecializedConst.createRightConst(ast, left, right, arit, c, "<ScalarInt, ConstScalarInt>");
            }
            return SpecializedConst.createGeneric(leftTemplate, rightTemplate, ast, left, right, arit);
        }

        public static SpecializedConst createSpecializedMultiType(RAny leftTemplate, RAny rightTemplate, final ASTNode ast, RNode left, RNode right, final ValueArithmetic arit) {
            boolean tisRightDouble;
            boolean tisRightNA;
            double trdbl;
            int trint;
            boolean leftConst = left instanceof Constant;
            boolean rightConst = right instanceof Constant;
            assert (Utils.check(leftConst || rightConst));
            boolean alwaysDouble = SpecializedConst.returnsDouble(arit);
            if (!(leftTemplate instanceof ScalarIntImpl) && !(leftTemplate instanceof ScalarDoubleImpl) || !(rightTemplate instanceof ScalarIntImpl) && !(rightTemplate instanceof ScalarDoubleImpl)) {
                return null;
            }
            if (leftConst) {
                boolean tisLeftDouble;
                boolean tisLeftNA;
                double tldbl;
                int tlint;
                if (leftTemplate instanceof ScalarDoubleImpl) {
                    tlint = -1;
                    tldbl = ((ScalarDoubleImpl)leftTemplate).getDouble();
                    tisLeftNA = RDouble.RDoubleUtils.arithIsNA(tldbl);
                    tisLeftDouble = true;
                } else {
                    tlint = ((ScalarIntImpl)leftTemplate).getInt();
                    tldbl = tlint;
                    tisLeftNA = tlint == Integer.MIN_VALUE;
                    tisLeftDouble = false;
                }
                final double ldbl = tldbl;
                final int lint = tlint;
                final boolean isLeftNA = tisLeftNA;
                boolean isLeftDouble = tisLeftDouble;
                if (isLeftDouble || alwaysDouble) {
                    Calculator c = new Calculator(){

                        @Override
                        public Object calc(Object lexpr, Object rexpr) throws SpecializationException {
                            if (rexpr instanceof ScalarDoubleImpl) {
                                double rdbl = ((ScalarDoubleImpl)rexpr).getDouble();
                                if (isLeftNA || RDouble.RDoubleUtils.arithIsNA(rdbl)) {
                                    return RDouble.BOXED_NA;
                                }
                                return RDouble.RDoubleFactory.getScalar(arit.op(ast, ldbl, rdbl));
                            }
                            if (rexpr instanceof ScalarIntImpl) {
                                int rint = ((ScalarIntImpl)rexpr).getInt();
                                if (isLeftNA || rint == Integer.MIN_VALUE) {
                                    return RDouble.BOXED_NA;
                                }
                                return RDouble.RDoubleFactory.getScalar(arit.op(ast, ldbl, rint));
                            }
                            throw new SpecializationException((Object)FailedSpecialization.MULTI_TYPE);
                        }
                    };
                    return SpecializedConst.createLeftConst(ast, left, right, arit, c, "<ConstScalarDouble, ScalarInt|Double>");
                }
                Calculator c = new Calculator(){

                    @Override
                    public Object calc(Object lexpr, Object rexpr) throws SpecializationException {
                        if (rexpr instanceof ScalarDoubleImpl) {
                            double rdbl = ((ScalarDoubleImpl)rexpr).getDouble();
                            if (isLeftNA || RDouble.RDoubleUtils.arithIsNA(rdbl)) {
                                return RDouble.BOXED_NA;
                            }
                            return RDouble.RDoubleFactory.getScalar(arit.op(ast, lint, rdbl));
                        }
                        if (rexpr instanceof ScalarIntImpl) {
                            int rint = ((ScalarIntImpl)rexpr).getInt();
                            if (isLeftNA || rint == Integer.MIN_VALUE) {
                                return RInt.BOXED_NA;
                            }
                            return RInt.RIntFactory.getScalar(arit.opWarnOverflow(ast, lint, rint));
                        }
                        throw new SpecializationException((Object)FailedSpecialization.MULTI_TYPE);
                    }
                };
                return SpecializedConst.createLeftConst(ast, left, right, arit, c, "<ConstScalarInt, ScalarInt|Double>");
            }
            if (rightTemplate instanceof ScalarDoubleImpl) {
                trint = -1;
                trdbl = ((ScalarDoubleImpl)rightTemplate).getDouble();
                tisRightNA = RDouble.RDoubleUtils.arithIsNA(trdbl);
                tisRightDouble = true;
            } else {
                trint = ((ScalarIntImpl)rightTemplate).getInt();
                trdbl = trint;
                tisRightNA = trint == Integer.MIN_VALUE;
                tisRightDouble = false;
            }
            final double rdbl = trdbl;
            final int rint = trint;
            final boolean isRightNA = tisRightNA;
            boolean isRightDouble = tisRightDouble;
            if (isRightDouble || alwaysDouble) {
                Calculator c = new Calculator(){

                    @Override
                    public Object calc(Object lexpr, Object rexpr) throws SpecializationException {
                        if (lexpr instanceof ScalarDoubleImpl) {
                            double ldbl = ((ScalarDoubleImpl)lexpr).getDouble();
                            if (isRightNA || RDouble.RDoubleUtils.arithIsNA(ldbl)) {
                                return RDouble.BOXED_NA;
                            }
                            return RDouble.RDoubleFactory.getScalar(arit.op(ast, ldbl, rdbl));
                        }
                        if (lexpr instanceof ScalarIntImpl) {
                            int lint = ((ScalarIntImpl)lexpr).getInt();
                            if (isRightNA || lint == Integer.MIN_VALUE) {
                                return RDouble.BOXED_NA;
                            }
                            return RDouble.RDoubleFactory.getScalar(arit.op(ast, lint, rdbl));
                        }
                        throw new SpecializationException((Object)FailedSpecialization.MULTI_TYPE);
                    }
                };
                return SpecializedConst.createRightConst(ast, left, right, arit, c, "<ScalarInt|Double, ConstScalarDouble>");
            }
            Calculator c = new Calculator(){

                @Override
                public Object calc(Object lexpr, Object rexpr) throws SpecializationException {
                    if (lexpr instanceof ScalarDoubleImpl) {
                        double ldbl = ((ScalarDoubleImpl)lexpr).getDouble();
                        if (isRightNA || RDouble.RDoubleUtils.arithIsNA(ldbl)) {
                            return RDouble.BOXED_NA;
                        }
                        return RDouble.RDoubleFactory.getScalar(arit.op(ast, ldbl, rint));
                    }
                    if (lexpr instanceof ScalarIntImpl) {
                        int lint = ((ScalarIntImpl)lexpr).getInt();
                        if (isRightNA || lint == Integer.MIN_VALUE) {
                            return RInt.BOXED_NA;
                        }
                        return RInt.RIntFactory.getScalar(arit.opWarnOverflow(ast, lint, rint));
                    }
                    throw new SpecializationException((Object)FailedSpecialization.MULTI_TYPE);
                }
            };
            return SpecializedConst.createRightConst(ast, left, right, arit, c, "<ScalarInt|Double, ConstScalarInt>");
        }

        public static SpecializedConst createGeneric(RAny leftTemplate, RAny rightTemplate, final ASTNode ast, RNode left, RNode right, final ValueArithmetic arit) {
            Calculator c = null;
            boolean leftConst = left instanceof Constant;
            boolean rightConst = right instanceof Constant;
            final boolean returnsDouble = SpecializedConst.returnsDouble(arit);
            if (leftConst) {
                final boolean leftComplex = leftTemplate instanceof RComplex;
                final boolean leftDouble = leftTemplate instanceof RDouble;
                final boolean leftInt = leftTemplate instanceof RInt;
                final boolean leftLogicalOrInt = leftTemplate instanceof RLogical || leftTemplate instanceof RInt;
                final RComplex lcmp = leftComplex ? (RComplex)leftTemplate : leftTemplate.asComplex();
                final RDouble ldbl = leftDouble ? (RDouble)leftTemplate : leftTemplate.asDouble();
                final RInt lint = leftLogicalOrInt ? leftTemplate.asInt() : null;
                c = new Calculator(){

                    @Override
                    public Object calc(Object lexpr, Object rexpr) {
                        if (leftComplex || rexpr instanceof RComplex) {
                            RComplex rcmp = ((RAny)rexpr).asComplex();
                            return ComplexView.create(lcmp, rcmp, arit, ast);
                        }
                        if (returnsDouble) {
                            return Arithmetic.doubleBinary(ldbl, ((RAny)rexpr).asDouble(), arit, ast);
                        }
                        if (leftDouble) {
                            if (rexpr instanceof RDouble) {
                                return Arithmetic.doubleBinary(ldbl, (RDouble)rexpr, arit, ast);
                            }
                            if (rexpr instanceof RInt) {
                                return Arithmetic.doubleBinary(ldbl, (RInt)rexpr, arit, ast);
                            }
                            return Arithmetic.doubleBinary(ldbl, ((RAny)rexpr).asDouble(), arit, ast);
                        }
                        if (rexpr instanceof RDouble) {
                            RDouble rdbl = (RDouble)rexpr;
                            if (leftInt) {
                                return Arithmetic.doubleBinary(lint, rdbl, arit, ast);
                            }
                            return Arithmetic.doubleBinary(ldbl, rdbl, arit, ast);
                        }
                        if (leftLogicalOrInt || rexpr instanceof RInt || rexpr instanceof RLogical) {
                            RInt rint = ((RAny)rexpr).asInt();
                            return Arithmetic.intBinary(lint, rint, arit, ast);
                        }
                        Utils.nyi("unsupported case for binary arithmetic operation");
                        return null;
                    }
                };
            }
            if (rightConst) {
                final boolean rightComplex = rightTemplate instanceof RComplex;
                final boolean rightDouble = rightTemplate instanceof RDouble;
                final boolean rightInt = rightTemplate instanceof RInt;
                final boolean rightLogicalOrInt = rightTemplate instanceof RLogical || rightTemplate instanceof RInt;
                final RComplex rcmp = rightComplex ? (RComplex)rightTemplate : rightTemplate.asComplex();
                final RDouble rdbl = rightDouble ? (RDouble)rightTemplate : rightTemplate.asDouble();
                final RInt rint = rightLogicalOrInt ? rightTemplate.asInt() : null;
                c = new Calculator(){

                    @Override
                    public Object calc(Object lexpr, Object rexpr) {
                        if (rightComplex || lexpr instanceof RComplex) {
                            RComplex lcmp = ((RAny)lexpr).asComplex();
                            return ComplexView.create(lcmp, rcmp, arit, ast);
                        }
                        if (returnsDouble) {
                            return Arithmetic.doubleBinary(((RAny)lexpr).asDouble(), rdbl, arit, ast);
                        }
                        if (rightDouble) {
                            if (lexpr instanceof RDouble) {
                                return Arithmetic.doubleBinary((RDouble)lexpr, rdbl, arit, ast);
                            }
                            if (lexpr instanceof RInt) {
                                return Arithmetic.doubleBinary((RInt)lexpr, rdbl, arit, ast);
                            }
                            return Arithmetic.doubleBinary(((RAny)lexpr).asDouble(), rdbl, arit, ast);
                        }
                        if (lexpr instanceof RDouble) {
                            RDouble ldbl = (RDouble)lexpr;
                            if (rightInt) {
                                return Arithmetic.doubleBinary(ldbl, rint, arit, ast);
                            }
                            return Arithmetic.doubleBinary(((RAny)lexpr).asDouble(), rdbl, arit, ast);
                        }
                        if (rightLogicalOrInt || lexpr instanceof RInt || lexpr instanceof RLogical) {
                            RInt lint = ((RAny)lexpr).asInt();
                            return Arithmetic.intBinary(lint, rint, arit, ast);
                        }
                        Utils.nyi("unsupported case for binary arithmetic operation");
                        return null;
                    }
                };
            }
            assert (Utils.check(c != null));
            if (rightConst) {
                return SpecializedConst.createRightConst(ast, left, right, arit, c, "<Generic, ConstGeneric>");
            }
            return SpecializedConst.createLeftConst(ast, left, right, arit, c, "<ConstGeneric, Generic>");
        }

        public static SpecializedConst createLeftConst(ASTNode ast, RNode left, RNode right, ValueArithmetic arit, Calculator calc, String dbg) {
            assert (Utils.check(left instanceof Constant));
            return new SpecializedConst(ast, left, right, arit, calc, dbg){

                @Override
                public Object execute(Frame frame) {
                    RAny rexpr = (RAny)this.right.execute(frame);
                    if (this.getNewNode() != null) {
                        ((SpecializedConst)this.getNewNode()).executeWithLexpr(null, rexpr);
                    }
                    return this.execute(null, rexpr);
                }
            };
        }

        public static SpecializedConst createRightConst(ASTNode ast, RNode left, RNode right, ValueArithmetic arit, Calculator calc, String dbg) {
            assert (Utils.check(right instanceof Constant));
            return new SpecializedConst(ast, left, right, arit, calc, dbg){

                @Override
                public Object execute(Frame frame) {
                    RAny lexpr = (RAny)this.left.execute(frame);
                    if (this.getNewNode() != null) {
                        ((SpecializedConst)this.getNewNode()).execute(lexpr, null);
                    }
                    return this.execute(lexpr, null);
                }
            };
        }

        private static RAny getExpr(RNode node, RAny value) {
            if (value == null) {
                return (RAny)node.execute(null);
            }
            return value;
        }

        @Override
        public Object execute(Object lexpr, Object rexpr) {
            try {
                return this.calc.calc(lexpr, rexpr);
            }
            catch (SpecializationException e) {
                SpecializedConst sn;
                FailedSpecialization f = (FailedSpecialization)((Object)e.getResult());
                RAny leftTemplate = SpecializedConst.getExpr(this.left, (RAny)lexpr);
                RAny rightTemplate = SpecializedConst.getExpr(this.right, (RAny)rexpr);
                if (f == FailedSpecialization.FIXED_TYPE && (sn = SpecializedConst.createSpecializedMultiType(leftTemplate, rightTemplate, this.ast, this.left, this.right, this.arit)) != null) {
                    this.replace(sn, "install SpecializedConstMultiType from SpecializedConst");
                    return sn.execute(lexpr, rexpr);
                }
                SpecializedConst gn = SpecializedConst.createGeneric(leftTemplate, rightTemplate, this.ast, this.left, this.right, this.arit);
                this.replace(gn, "install SpecializedConst<Generic, Generic> from SpecializedConst");
                return gn.execute(leftTemplate, rightTemplate);
            }
        }

        public static abstract class Calculator {
            public abstract Object calc(Object var1, Object var2) throws SpecializationException;
        }
    }

    static class Specialized
    extends Arithmetic {
        final String dbg;
        final Calculator calc;

        public Specialized(ASTNode ast, RNode left, RNode right, ValueArithmetic arit, Calculator calc, String dbg) {
            super(ast, left, right, arit);
            this.dbg = dbg;
            this.calc = calc;
        }

        public static Specialized createSpecialized(RAny leftTemplate, RAny rightTemplate, final ASTNode ast, RNode left, RNode right, final ValueArithmetic arit) {
            if (leftTemplate instanceof ScalarComplexImpl && rightTemplate instanceof ScalarComplexImpl) {
                Calculator c = new Calculator(){

                    @Override
                    public Object calc(Object lexpr, Object rexpr) throws SpecializationException {
                        if (!(lexpr instanceof ScalarComplexImpl) || !(rexpr instanceof ScalarComplexImpl)) {
                            throw new SpecializationException((Object)FailedSpecialization.FIXED_TYPE);
                        }
                        ScalarComplexImpl lcomp = (ScalarComplexImpl)lexpr;
                        double lreal = lcomp.getReal();
                        double limag = lcomp.getImag();
                        ScalarComplexImpl rcomp = (ScalarComplexImpl)rexpr;
                        double rreal = rcomp.getReal();
                        double rimag = rcomp.getImag();
                        if (!RComplex.RComplexUtils.arithEitherIsNA(lreal, limag) && !RComplex.RComplexUtils.arithEitherIsNA(rreal, rimag)) {
                            return RComplex.RComplexFactory.getScalar(arit.opReal(ast, lreal, limag, rreal, rimag), arit.opImag(ast, lreal, limag, rreal, rimag));
                        }
                        return RComplex.BOXED_NA;
                    }
                };
                return new Specialized(ast, left, right, arit, c, "<ScalarComplex, ScalarComplex>");
            }
            if (leftTemplate instanceof ScalarComplexImpl && rightTemplate instanceof ScalarDoubleImpl) {
                Calculator c = new Calculator(){

                    @Override
                    public Object calc(Object lexpr, Object rexpr) throws SpecializationException {
                        if (!(lexpr instanceof ScalarComplexImpl) || !(rexpr instanceof ScalarDoubleImpl)) {
                            throw new SpecializationException((Object)FailedSpecialization.FIXED_TYPE);
                        }
                        ScalarComplexImpl lcomp = (ScalarComplexImpl)lexpr;
                        double lreal = lcomp.getReal();
                        double limag = lcomp.getImag();
                        double rreal = ((ScalarDoubleImpl)rexpr).getDouble();
                        if (!RComplex.RComplexUtils.arithEitherIsNA(lreal, limag) && !RDouble.RDoubleUtils.arithIsNA(rreal)) {
                            return RComplex.RComplexFactory.getScalar(arit.opReal(ast, lreal, limag, rreal, 0.0), arit.opImag(ast, lreal, limag, rreal, 0.0));
                        }
                        return RComplex.BOXED_NA;
                    }
                };
                return new Specialized(ast, left, right, arit, c, "<ScalarComplex, ScalarDouble>");
            }
            if (leftTemplate instanceof ScalarDoubleImpl && rightTemplate instanceof ScalarComplexImpl) {
                Calculator c = new Calculator(){

                    @Override
                    public Object calc(Object lexpr, Object rexpr) throws SpecializationException {
                        if (!(lexpr instanceof ScalarDoubleImpl) || !(rexpr instanceof ScalarComplexImpl)) {
                            throw new SpecializationException((Object)FailedSpecialization.FIXED_TYPE);
                        }
                        double lreal = ((ScalarDoubleImpl)lexpr).getDouble();
                        ScalarComplexImpl rcomp = (ScalarComplexImpl)rexpr;
                        double rreal = rcomp.getReal();
                        double rimag = rcomp.getImag();
                        if (!RDouble.RDoubleUtils.arithIsNA(lreal) && !RComplex.RComplexUtils.arithEitherIsNA(rreal, rimag)) {
                            return RComplex.RComplexFactory.getScalar(arit.opReal(ast, lreal, 0.0, rreal, rimag), arit.opImag(ast, lreal, 0.0, rreal, rimag));
                        }
                        return RComplex.BOXED_NA;
                    }
                };
                return new Specialized(ast, left, right, arit, c, "<ScalarDouble, ScalarComplex>");
            }
            if (leftTemplate instanceof ScalarDoubleImpl && rightTemplate instanceof ScalarDoubleImpl) {
                Calculator c = new Calculator(){

                    @Override
                    public Object calc(Object lexpr, Object rexpr) throws SpecializationException {
                        if (!(lexpr instanceof ScalarDoubleImpl) || !(rexpr instanceof ScalarDoubleImpl)) {
                            throw new SpecializationException((Object)FailedSpecialization.FIXED_TYPE);
                        }
                        double ldbl = ((ScalarDoubleImpl)lexpr).getDouble();
                        double rdbl = ((ScalarDoubleImpl)rexpr).getDouble();
                        if (RDouble.RDoubleUtils.arithIsNA(ldbl) || RDouble.RDoubleUtils.arithIsNA(rdbl)) {
                            return RDouble.BOXED_NA;
                        }
                        return RDouble.RDoubleFactory.getScalar(arit.op(ast, ldbl, rdbl));
                    }
                };
                return new Specialized(ast, left, right, arit, c, "<ScalarDouble, ScalarDouble>");
            }
            if (leftTemplate instanceof ScalarDoubleImpl && rightTemplate instanceof ScalarIntImpl) {
                Calculator c = new Calculator(){

                    @Override
                    public Object calc(Object lexpr, Object rexpr) throws SpecializationException {
                        if (!(lexpr instanceof ScalarDoubleImpl) || !(rexpr instanceof ScalarIntImpl)) {
                            throw new SpecializationException((Object)FailedSpecialization.FIXED_TYPE);
                        }
                        double ldbl = ((ScalarDoubleImpl)lexpr).getDouble();
                        int rint = ((ScalarIntImpl)rexpr).getInt();
                        if (RDouble.RDoubleUtils.arithIsNA(ldbl) || rint == Integer.MIN_VALUE) {
                            return RDouble.BOXED_NA;
                        }
                        return RDouble.RDoubleFactory.getScalar(arit.op(ast, ldbl, rint));
                    }
                };
                return new Specialized(ast, left, right, arit, c, "<ScalarDouble, ScalarInt>");
            }
            if (leftTemplate instanceof ScalarIntImpl && rightTemplate instanceof ScalarDoubleImpl) {
                Calculator c = new Calculator(){

                    @Override
                    public Object calc(Object lexpr, Object rexpr) throws SpecializationException {
                        if (!(lexpr instanceof ScalarIntImpl) || !(rexpr instanceof ScalarDoubleImpl)) {
                            throw new SpecializationException((Object)FailedSpecialization.FIXED_TYPE);
                        }
                        int lint = ((ScalarIntImpl)lexpr).getInt();
                        double rdbl = ((ScalarDoubleImpl)rexpr).getDouble();
                        if (lint == Integer.MIN_VALUE || RDouble.RDoubleUtils.arithIsNA(rdbl)) {
                            return RDouble.BOXED_NA;
                        }
                        return RDouble.RDoubleFactory.getScalar(arit.op(ast, lint, rdbl));
                    }
                };
                return new Specialized(ast, left, right, arit, c, "<ScalarInt, ScalarDouble>");
            }
            if (leftTemplate instanceof ScalarIntImpl && rightTemplate instanceof ScalarIntImpl) {
                if (Specialized.returnsDouble(arit)) {
                    Calculator c = new Calculator(){

                        @Override
                        public Object calc(Object lexpr, Object rexpr) throws SpecializationException {
                            if (!(lexpr instanceof ScalarIntImpl) || !(rexpr instanceof ScalarIntImpl)) {
                                throw new SpecializationException((Object)FailedSpecialization.FIXED_TYPE);
                            }
                            int lint = ((ScalarIntImpl)lexpr).getInt();
                            int rint = ((ScalarIntImpl)rexpr).getInt();
                            if (lint == Integer.MIN_VALUE || rint == Integer.MIN_VALUE) {
                                return RDouble.BOXED_NA;
                            }
                            return RDouble.RDoubleFactory.getScalar(arit.op(ast, (double)lint, (double)rint));
                        }
                    };
                    return new Specialized(ast, left, right, arit, c, "<ScalarInt, ScalarInt>");
                }
                Calculator c = new Calculator(){

                    @Override
                    public Object calc(Object lexpr, Object rexpr) throws SpecializationException {
                        if (!(lexpr instanceof ScalarIntImpl) || !(rexpr instanceof ScalarIntImpl)) {
                            throw new SpecializationException((Object)FailedSpecialization.FIXED_TYPE);
                        }
                        int lint = ((ScalarIntImpl)lexpr).getInt();
                        int rint = ((ScalarIntImpl)rexpr).getInt();
                        if (lint == Integer.MIN_VALUE || rint == Integer.MIN_VALUE) {
                            return RInt.BOXED_NA;
                        }
                        return RInt.RIntFactory.getScalar(arit.opWarnOverflow(ast, lint, rint));
                    }
                };
                return new Specialized(ast, left, right, arit, c, "<ScalarInt, ScalarInt>");
            }
            if (leftTemplate instanceof RDouble && rightTemplate instanceof RDouble) {
                Calculator c = new Calculator(){

                    @Override
                    public Object calc(Object lexpr, Object rexpr) throws SpecializationException {
                        if (!(lexpr instanceof RDouble) || !(rexpr instanceof RDouble)) {
                            throw new SpecializationException((Object)null);
                        }
                        return Arithmetic.doubleBinary((RDouble)lexpr, (RDouble)rexpr, arit, ast);
                    }
                };
                return new Specialized(ast, left, right, arit, c, "<RDouble, RDouble>");
            }
            if (leftTemplate instanceof RInt && rightTemplate instanceof RInt && !Specialized.returnsDouble(arit)) {
                Calculator c = new Calculator(){

                    @Override
                    public Object calc(Object lexpr, Object rexpr) throws SpecializationException {
                        if (!(lexpr instanceof RInt) || !(rexpr instanceof RInt)) {
                            throw new SpecializationException((Object)null);
                        }
                        return Arithmetic.intBinary((RInt)lexpr, (RInt)rexpr, arit, ast);
                    }
                };
                return new Specialized(ast, left, right, arit, c, "<RInt, RInt>");
            }
            return Specialized.createGeneric(ast, left, right, arit);
        }

        public static Specialized createSpecializedMultiType(RAny leftTemplate, RAny rightTemplate, final ASTNode ast, RNode left, RNode right, final ValueArithmetic arit) {
            if ((leftTemplate instanceof ScalarIntImpl || leftTemplate instanceof ScalarDoubleImpl) && (rightTemplate instanceof ScalarIntImpl || rightTemplate instanceof ScalarDoubleImpl)) {
                final boolean alwaysDouble = Specialized.returnsDouble(arit);
                Calculator c = new Calculator(){

                    @Override
                    public Object calc(Object lexpr, Object rexpr) throws SpecializationException {
                        if (lexpr instanceof ScalarDoubleImpl) {
                            double ldbl = ((ScalarDoubleImpl)lexpr).getDouble();
                            boolean leftIsNA = RDouble.RDoubleUtils.arithIsNA(ldbl);
                            if (rexpr instanceof ScalarDoubleImpl) {
                                double rdbl = ((ScalarDoubleImpl)rexpr).getDouble();
                                if (leftIsNA || RDouble.RDoubleUtils.arithIsNA(rdbl)) {
                                    return RDouble.BOXED_NA;
                                }
                                return RDouble.RDoubleFactory.getScalar(arit.op(ast, ldbl, rdbl));
                            }
                            if (rexpr instanceof ScalarIntImpl) {
                                int rint = ((ScalarIntImpl)rexpr).getInt();
                                if (leftIsNA || rint == Integer.MIN_VALUE) {
                                    return RDouble.BOXED_NA;
                                }
                                return RDouble.RDoubleFactory.getScalar(arit.op(ast, ldbl, rint));
                            }
                        } else if (lexpr instanceof ScalarIntImpl) {
                            boolean leftIsNA;
                            int lint = ((ScalarIntImpl)lexpr).getInt();
                            boolean bl = leftIsNA = lint == Integer.MIN_VALUE;
                            if (rexpr instanceof ScalarDoubleImpl) {
                                double rdbl = ((ScalarDoubleImpl)rexpr).getDouble();
                                if (leftIsNA || RDouble.RDoubleUtils.arithIsNA(rdbl)) {
                                    return RDouble.BOXED_NA;
                                }
                                return RDouble.RDoubleFactory.getScalar(arit.op(ast, lint, rdbl));
                            }
                            if (rexpr instanceof ScalarIntImpl) {
                                boolean arithIsNA;
                                int rint = ((ScalarIntImpl)rexpr).getInt();
                                boolean bl2 = arithIsNA = leftIsNA || rint == Integer.MIN_VALUE;
                                if (alwaysDouble) {
                                    if (arithIsNA) {
                                        return RDouble.BOXED_NA;
                                    }
                                    return RDouble.RDoubleFactory.getScalar(arit.op(ast, (double)lint, (double)rint));
                                }
                                if (arithIsNA) {
                                    return RInt.BOXED_NA;
                                }
                                return RInt.RIntFactory.getScalar(arit.opWarnOverflow(ast, lint, rint));
                            }
                        }
                        throw new SpecializationException((Object)FailedSpecialization.MULTI_TYPE);
                    }
                };
                return new Specialized(ast, left, right, arit, c, "<ScalarDouble|Int, ScalarDouble|Int>");
            }
            return null;
        }

        public static Specialized createGeneric(final ASTNode ast, RNode left, RNode right, final ValueArithmetic arit) {
            final boolean returnsDouble = Specialized.returnsDouble(arit);
            Calculator c = new Calculator(){

                @Override
                public Object calc(Object lexpr, Object rexpr) {
                    if (lexpr instanceof RComplex || rexpr instanceof RComplex) {
                        RComplex lcmp = ((RAny)lexpr).asComplex();
                        RComplex rcmp = ((RAny)rexpr).asComplex();
                        return ComplexView.create(lcmp, rcmp, arit, ast);
                    }
                    if (returnsDouble) {
                        RDouble ldbl = ((RAny)lexpr).asDouble();
                        RDouble rdbl = ((RAny)rexpr).asDouble();
                        return Arithmetic.doubleBinary(ldbl, rdbl, arit, ast);
                    }
                    if (lexpr instanceof RDouble) {
                        RDouble ldbl = (RDouble)lexpr;
                        if (rexpr instanceof RDouble) {
                            return Arithmetic.doubleBinary(ldbl, (RDouble)rexpr, arit, ast);
                        }
                        if (rexpr instanceof RInt) {
                            return Arithmetic.doubleBinary(ldbl, (RInt)rexpr, arit, ast);
                        }
                        return Arithmetic.doubleBinary(ldbl, ((RAny)rexpr).asDouble(), arit, ast);
                    }
                    if (rexpr instanceof RDouble) {
                        RDouble rdbl = (RDouble)rexpr;
                        if (lexpr instanceof RInt) {
                            return Arithmetic.doubleBinary((RInt)lexpr, rdbl, arit, ast);
                        }
                        return Arithmetic.doubleBinary(((RAny)lexpr).asDouble(), rdbl, arit, ast);
                    }
                    if (lexpr instanceof RInt || rexpr instanceof RInt || lexpr instanceof RLogical || rexpr instanceof RLogical) {
                        RInt lint = ((RAny)lexpr).asInt();
                        RInt rint = ((RAny)rexpr).asInt();
                        return Arithmetic.intBinary(lint, rint, arit, ast);
                    }
                    throw RError.getNonNumericBinary(ast);
                }
            };
            return new Specialized(ast, left, right, arit, c, "<Generic, Generic>");
        }

        @Override
        public final Object execute(Object lexpr, Object rexpr) {
            try {
                return this.calc.calc(lexpr, rexpr);
            }
            catch (SpecializationException e) {
                Specialized sn;
                FailedSpecialization f = (FailedSpecialization)((Object)e.getResult());
                if (f == FailedSpecialization.FIXED_TYPE && (sn = Specialized.createSpecializedMultiType((RAny)lexpr, (RAny)rexpr, this.ast, this.left, this.right, this.arit)) != null) {
                    this.replace(sn, "install SpecializedMultiType from Specialized");
                    return sn.execute(lexpr, rexpr);
                }
                Specialized gn = Specialized.createGeneric(this.ast, this.left, this.right, this.arit);
                this.replace(gn, "install Specialized<Generic, Generic> from Specialized");
                return gn.execute(lexpr, rexpr);
            }
        }

        public static abstract class Calculator {
            public abstract Object calc(Object var1, Object var2) throws SpecializationException;
        }
    }

    public static enum FailedSpecialization {
        FIXED_TYPE,
        MULTI_TYPE;

    }
}

