/*
 * Decompiled with CFR 0.152.
 */
package r.nodes.exec;

import r.data.RSymbol;
import r.data.internal.ScalarIntImpl;
import r.nodes.ast.Add;
import r.nodes.ast.SimpleAccessVariable;
import r.nodes.ast.SimpleAssignVariable;
import r.nodes.ast.Sub;
import r.nodes.exec.Arithmetic;
import r.nodes.exec.BaseR;
import r.nodes.exec.Constant;
import r.nodes.exec.ReadVariable;
import r.nodes.exec.WriteVariable;
import r.runtime.Frame;
import r.runtime.SpecializationException;

public abstract class ArithmeticUpdateVariable
extends BaseR {
    final RSymbol varName;

    public ArithmeticUpdateVariable(SimpleAssignVariable ast) {
        super(ast);
        this.varName = ast.getSymbol();
    }

    protected Object constantAddReplaceAndExecute(Frame frame) {
        SimpleAccessVariable accessAST;
        SimpleAssignVariable assignAST = (SimpleAssignVariable)this.ast;
        Add addAST = (Add)assignAST.getExpr();
        Arithmetic rhsNode = null;
        if (addAST.getLHS() instanceof SimpleAccessVariable) {
            accessAST = (SimpleAccessVariable)addAST.getLHS();
            r.nodes.ast.Constant constantAST = (r.nodes.ast.Constant)addAST.getRHS();
            rhsNode = new Arithmetic(addAST, ReadVariable.getUninitialized(accessAST, this.varName), new Constant(constantAST, constantAST.getValue()), Arithmetic.ADD);
        } else {
            accessAST = (SimpleAccessVariable)addAST.getRHS();
            r.nodes.ast.Constant constantAST = (r.nodes.ast.Constant)addAST.getLHS();
            rhsNode = new Arithmetic(addAST, new Constant(constantAST, constantAST.getValue()), ReadVariable.getUninitialized(accessAST, this.varName), Arithmetic.ADD);
        }
        WriteVariable assignmentNode = WriteVariable.getUninitialized(assignAST, this.varName, rhsNode);
        this.replace(assignmentNode, "install generic Arithmetic node from ArithmeticUpdateVariable");
        return assignmentNode.execute(frame);
    }

    protected Object constantSubReplaceAndExecute(Frame frame) {
        SimpleAssignVariable assignAST = (SimpleAssignVariable)this.ast;
        Sub subAST = (Sub)assignAST.getExpr();
        Arithmetic rhsNode = null;
        if (subAST.getLHS() instanceof SimpleAccessVariable) {
            SimpleAccessVariable accessAST = (SimpleAccessVariable)subAST.getLHS();
            r.nodes.ast.Constant constantAST = (r.nodes.ast.Constant)subAST.getRHS();
            rhsNode = new Arithmetic(subAST, ReadVariable.getUninitialized(accessAST, this.varName), new Constant(constantAST, constantAST.getValue()), Arithmetic.SUB);
        }
        WriteVariable assignmentNode = WriteVariable.getUninitialized(assignAST, this.varName, rhsNode);
        this.replace(assignmentNode, "install generic Arithmetic node from ArithmeticUpdateVariable");
        return assignmentNode.execute(frame);
    }

    public static class ScalarIntLocalDecrement
    extends ArithmeticUpdateVariable {
        final int slot;

        public ScalarIntLocalDecrement(SimpleAssignVariable ast, int slot) {
            super(ast);
            this.slot = slot;
        }

        @Override
        public Object execute(Frame frame) {
            try {
                Object value = frame.getObjectForcingPromises(this.slot);
                if (value != null && value instanceof ScalarIntImpl) {
                    int i = ((ScalarIntImpl)value).getInt();
                    int newi = i - 1;
                    if (i != Integer.MIN_VALUE && newi != Integer.MIN_VALUE) {
                        ScalarIntImpl res = new ScalarIntImpl(newi);
                        frame.set(this.slot, res);
                        return res;
                    }
                }
                throw new SpecializationException((Object)null);
            }
            catch (SpecializationException e) {
                return this.constantSubReplaceAndExecute(frame);
            }
        }
    }

    public static class ScalarIntLocalIncrement
    extends ArithmeticUpdateVariable {
        final int slot;

        public ScalarIntLocalIncrement(SimpleAssignVariable ast, int slot) {
            super(ast);
            this.slot = slot;
        }

        @Override
        public Object execute(Frame frame) {
            try {
                Object value = frame.getObjectForcingPromises(this.slot);
                if (value != null && value instanceof ScalarIntImpl) {
                    int i = ((ScalarIntImpl)value).getInt();
                    int newi = i + 1;
                    if (i != Integer.MIN_VALUE && newi != Integer.MIN_VALUE) {
                        ScalarIntImpl res = new ScalarIntImpl(newi);
                        frame.set(this.slot, res);
                        return res;
                    }
                }
                throw new SpecializationException((Object)null);
            }
            catch (SpecializationException e) {
                return this.constantAddReplaceAndExecute(frame);
            }
        }
    }
}

