/*
 * Decompiled with CFR 0.152.
 */
package r.nodes.exec;

import r.Convert;
import r.RContext;
import r.Utils;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RRaw;
import r.data.RString;
import r.data.internal.ScalarDoubleImpl;
import r.data.internal.ScalarIntImpl;
import r.data.internal.ScalarLogicalImpl;
import r.data.internal.ScalarStringImpl;
import r.data.internal.View;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.ast.AccessVector;
import r.nodes.exec.Arithmetic;
import r.nodes.exec.BaseR;
import r.nodes.exec.RNode;
import r.runtime.Frame;
import r.runtime.SpecializationException;

public class Comparison
extends BaseR {
    final ValueComparison cmp;
    @RNode.Child
    RNode left;
    @RNode.Child
    RNode right;
    private static final boolean LAZY_COMPARISON_IN_VECTOR_INDEX = false;
    private static final boolean DEBUG_CMP = false;

    public Comparison(ASTNode ast, RNode left, RNode right, ValueComparison cmp) {
        super(ast);
        this.left = this.adoptChild(left);
        this.right = this.adoptChild(right);
        this.cmp = cmp;
    }

    @Override
    public final int executeScalarLogical(Frame frame) throws SpecializationException {
        assert (Utils.check(this.getNewNode() == null));
        RAny lexpr = (RAny)this.left.execute(frame);
        if (this.getNewNode() != null) {
            return ((Comparison)this.getNewNode()).executeScalarLogicalWithLeft(frame, lexpr);
        }
        return this.executeScalarLogicalWithLeft(frame, lexpr);
    }

    public final int executeScalarLogicalWithLeft(Frame frame, RAny lexpr) throws SpecializationException {
        RAny rexpr = (RAny)this.right.execute(frame);
        if (this.getNewNode() != null) {
            return ((Comparison)this.getNewNode()).executeScalarLogical(lexpr, rexpr);
        }
        return this.executeScalarLogical(lexpr, rexpr);
    }

    public int executeScalarLogical(RAny lexpr, RAny rexpr) throws SpecializationException {
        try {
            throw new SpecializationException((Object)null);
        }
        catch (SpecializationException e) {
            ScalarComparison sc = ScalarComparison.createSpecialized(lexpr, rexpr, this.ast, this.left, this.right, this.cmp);
            this.replace(sc, "install ScalarComparison.Specialized from Comparison");
            return sc.executeScalarLogical(lexpr, rexpr);
        }
    }

    @Override
    public Object execute(Frame frame) {
        try {
            return RLogical.RLogicalFactory.getScalar(this.executeScalarLogical(frame));
        }
        catch (SpecializationException e) {
            return e.getResult();
        }
    }

    @Override
    protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
        assert (oldNode != null);
        if (this.left == oldNode) {
            this.left = newNode;
            return this.adoptInternal(newNode);
        }
        if (this.right == oldNode) {
            this.right = newNode;
            return this.adoptInternal(newNode);
        }
        return super.replaceChild(oldNode, newNode);
    }

    public Object execute(RAny lexpr, RAny rexpr) {
        try {
            return RLogical.RLogicalFactory.getScalar(this.executeScalarLogical(lexpr, rexpr));
        }
        catch (SpecializationException e) {
            return e.getResult();
        }
    }

    public static boolean isPartOfArrayIndex(ASTNode ast) {
        ASTNode n = ast;
        while (n != null) {
            AccessVector av;
            ASTNode pn = n.getParent();
            if (pn instanceof AccessVector && (av = (AccessVector)pn).getVector() != n) {
                return false;
            }
            n = pn;
        }
        return false;
    }

    public static ValueComparison getEQ() {
        return new ValueComparison(){

            @Override
            public boolean cmp(byte a, byte b) {
                return a == b;
            }

            @Override
            public boolean cmp(int a, int b) {
                return a == b;
            }

            @Override
            public boolean cmp(double a, double b) {
                return a == b;
            }

            @Override
            public boolean cmp(double areal, double aimag, double breal, double bimag) {
                return areal == breal && aimag == bimag;
            }

            @Override
            public boolean cmp(String a, String b) {
                return a.compareTo(b) == 0;
            }

            @Override
            public boolean resultForNaN() {
                return false;
            }
        };
    }

    public static ValueComparison getNE() {
        return new ValueComparison(){

            @Override
            public boolean cmp(byte a, byte b) {
                return a != b;
            }

            @Override
            public boolean cmp(int a, int b) {
                return a != b;
            }

            @Override
            public boolean cmp(double a, double b) {
                return a != b;
            }

            @Override
            public boolean cmp(double areal, double aimag, double breal, double bimag) {
                return areal != breal || aimag != bimag;
            }

            @Override
            public boolean cmp(String a, String b) {
                return a.compareTo(b) != 0;
            }

            @Override
            public boolean resultForNaN() {
                return true;
            }
        };
    }

    public static ValueComparison getLE() {
        return new ValueComparison(){

            @Override
            public boolean cmp(byte a, byte b) {
                return Convert.byteToUnsigned(a) <= Convert.byteToUnsigned(b);
            }

            @Override
            public boolean cmp(int a, int b) {
                return a <= b;
            }

            @Override
            public boolean cmp(double a, double b) {
                return a <= b;
            }

            @Override
            public boolean cmp(double areal, double aimag, double breal, double bimag) {
                Utils.nyi();
                return false;
            }

            @Override
            public RLogical cmp(RComplex a, RComplex b, ASTNode ast) {
                throw RError.getComparisonComplex(ast);
            }

            @Override
            public boolean cmp(String a, String b) {
                return a.compareTo(b) <= 0;
            }

            @Override
            public boolean resultForNaN() {
                return false;
            }
        };
    }

    public static ValueComparison getGE() {
        return new ValueComparison(){

            @Override
            public boolean cmp(byte a, byte b) {
                return Convert.byteToUnsigned(a) >= Convert.byteToUnsigned(b);
            }

            @Override
            public boolean cmp(int a, int b) {
                return a >= b;
            }

            @Override
            public boolean cmp(double a, double b) {
                return a >= b;
            }

            @Override
            public boolean cmp(double areal, double aimag, double breal, double bimag) {
                Utils.nyi();
                return false;
            }

            @Override
            public RLogical cmp(RComplex a, RComplex b, ASTNode ast) {
                throw RError.getComparisonComplex(ast);
            }

            @Override
            public boolean cmp(String a, String b) {
                return a.compareTo(b) >= 0;
            }

            @Override
            public boolean resultForNaN() {
                return false;
            }
        };
    }

    public static ValueComparison getLT() {
        return new ValueComparison(){

            @Override
            public boolean cmp(byte a, byte b) {
                return Convert.byteToUnsigned(a) < Convert.byteToUnsigned(b);
            }

            @Override
            public boolean cmp(int a, int b) {
                return a < b;
            }

            @Override
            public boolean cmp(double a, double b) {
                return a < b;
            }

            @Override
            public boolean cmp(double areal, double aimag, double breal, double bimag) {
                Utils.nyi();
                return false;
            }

            @Override
            public RLogical cmp(RComplex a, RComplex b, ASTNode ast) {
                throw RError.getComparisonComplex(ast);
            }

            @Override
            public boolean cmp(String a, String b) {
                return a.compareTo(b) < 0;
            }

            @Override
            public boolean resultForNaN() {
                return false;
            }
        };
    }

    public static ValueComparison getGT() {
        return new ValueComparison(){

            @Override
            public boolean cmp(byte a, byte b) {
                return Convert.byteToUnsigned(a) > Convert.byteToUnsigned(b);
            }

            @Override
            public boolean cmp(int a, int b) {
                return a > b;
            }

            @Override
            public boolean cmp(double a, double b) {
                return a > b;
            }

            @Override
            public boolean cmp(double areal, double aimag, double breal, double bimag) {
                Utils.nyi();
                return false;
            }

            @Override
            public RLogical cmp(RComplex a, RComplex b, ASTNode ast) {
                throw RError.getComparisonComplex(ast);
            }

            @Override
            public boolean cmp(String a, String b) {
                return a.compareTo(b) > 0;
            }

            @Override
            public boolean resultForNaN() {
                return false;
            }
        };
    }

    public static abstract class ValueComparison {
        public abstract boolean cmp(byte var1, byte var2);

        public abstract boolean cmp(int var1, int var2);

        public abstract boolean cmp(double var1, double var3);

        public abstract boolean cmp(double var1, double var3, double var5, double var7);

        public abstract boolean cmp(String var1, String var2);

        public abstract boolean resultForNaN();

        public boolean cmp(int a, double b) {
            return this.cmp((double)a, b);
        }

        public boolean cmp(double a, int b) {
            return this.cmp(a, (double)b);
        }

        public RLogical cmp(RString a, String b) {
            int n = a.size();
            if (b == RString.NA) {
                return RLogical.RLogicalFactory.getNAArray(n, a.dimensions());
            }
            int[] content = new int[n];
            for (int i = 0; i < n; ++i) {
                String astr = a.getString(i);
                content[i] = astr == RString.NA ? Integer.MIN_VALUE : (this.cmp(astr, b) ? 1 : 0);
            }
            return RLogical.RLogicalFactory.getFor(content, a.dimensions(), a.names());
        }

        public RLogical cmp(String a, RString b) {
            int n = b.size();
            if (a == RString.NA) {
                return RLogical.RLogicalFactory.getNAArray(n, b.dimensions());
            }
            int[] content = new int[n];
            for (int i = 0; i < n; ++i) {
                String bstr = b.getString(i);
                content[i] = bstr == RString.NA ? Integer.MIN_VALUE : (this.cmp(a, bstr) ? 1 : 0);
            }
            return RLogical.RLogicalFactory.getFor(content, b.dimensions(), b.names());
        }

        public RLogical cmp(RDouble a, double b) {
            int n = a.size();
            if (RDouble.RDoubleUtils.isNAorNaN(b)) {
                return RLogical.RLogicalFactory.getNAArray(n, a.dimensions());
            }
            int[] content = new int[n];
            if (!this.resultForNaN()) {
                for (int i = 0; i < n; ++i) {
                    double adbl = a.getDouble(i);
                    content[i] = this.cmp(adbl, b) ? 1 : (adbl != adbl ? Integer.MIN_VALUE : 0);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    double adbl = a.getDouble(i);
                    content[i] = this.cmp(adbl, b) ? (adbl != adbl ? Integer.MIN_VALUE : 1) : 0;
                }
            }
            return RLogical.RLogicalFactory.getFor(content, a.dimensions(), a.names());
        }

        public RLogical cmp(double a, RDouble b) {
            int n = b.size();
            if (RDouble.RDoubleUtils.isNAorNaN(a)) {
                return RLogical.RLogicalFactory.getNAArray(n, b.dimensions());
            }
            int[] content = new int[n];
            if (!this.resultForNaN()) {
                for (int i = 0; i < n; ++i) {
                    double bdbl = b.getDouble(i);
                    content[i] = this.cmp(a, bdbl) ? 1 : (bdbl != bdbl ? Integer.MIN_VALUE : 0);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    double bdbl = b.getDouble(i);
                    content[i] = this.cmp(a, bdbl) ? (bdbl != bdbl ? Integer.MIN_VALUE : 1) : 0;
                }
            }
            return RLogical.RLogicalFactory.getFor(content, b.dimensions(), b.names());
        }

        public RLogical cmp(RInt a, int b) {
            int n = a.size();
            if (b == Integer.MIN_VALUE) {
                return RLogical.RLogicalFactory.getNAArray(n, a.dimensions());
            }
            int[] content = new int[n];
            for (int i = 0; i < n; ++i) {
                int aint = a.getInt(i);
                content[i] = aint == Integer.MIN_VALUE ? Integer.MIN_VALUE : (this.cmp(aint, b) ? 1 : 0);
            }
            return RLogical.RLogicalFactory.getFor(content, a.dimensions(), a.names());
        }

        public RLogical cmp(int a, RInt b) {
            int n = b.size();
            if (a == Integer.MIN_VALUE) {
                return RLogical.RLogicalFactory.getNAArray(n, b.dimensions());
            }
            int[] content = new int[n];
            for (int i = 0; i < n; ++i) {
                int bint = b.getInt(i);
                content[i] = bint == Integer.MIN_VALUE ? Integer.MIN_VALUE : (this.cmp(a, bint) ? 1 : 0);
            }
            return RLogical.RLogicalFactory.getFor(content, b.dimensions(), b.names());
        }

        public RLogical cmp(RString a, RString b, ASTNode ast) {
            int na = a.size();
            int nb = b.size();
            int[] dimensions = Arithmetic.resultDimensions(ast, a, b);
            RArray.Names names = Arithmetic.resultNames(ast, a, b);
            if (na == 0 || nb == 0) {
                return RLogical.EMPTY;
            }
            int n = na > nb ? na : nb;
            int[] content = new int[n];
            int ai = 0;
            int bi = 0;
            for (int i = 0; i < n; ++i) {
                String astr = a.getString(ai++);
                if (ai == na) {
                    ai = 0;
                }
                String bstr = b.getString(bi++);
                if (bi == nb) {
                    bi = 0;
                }
                content[i] = astr == RString.NA || bstr == RString.NA ? Integer.MIN_VALUE : (this.cmp(astr, bstr) ? 1 : 0);
            }
            if (ai != 0 || bi != 0) {
                RContext.warning(ast, "longer object length is not a multiple of shorter object length");
            }
            return RLogical.RLogicalFactory.getFor(content, dimensions, names);
        }

        public RLogical cmp(RComplex a, RComplex b, ASTNode ast) {
            int na = a.size();
            int nb = b.size();
            int[] dimensions = Arithmetic.resultDimensions(ast, a, b);
            RArray.Names names = Arithmetic.resultNames(ast, a, b);
            if (na == 0 || nb == 0) {
                return RLogical.EMPTY;
            }
            int n = na > nb ? na : nb;
            int[] content = new int[n];
            int ai = 0;
            int bi = 0;
            for (int i = 0; i < n; ++i) {
                double areal = a.getReal(ai);
                double aimag = a.getImag(ai);
                if (++ai == na) {
                    ai = 0;
                }
                double breal = b.getReal(bi);
                double bimag = b.getImag(bi);
                if (++bi == nb) {
                    bi = 0;
                }
                content[i] = RComplex.RComplexUtils.eitherIsNA(areal, aimag) || RComplex.RComplexUtils.eitherIsNA(breal, bimag) ? Integer.MIN_VALUE : (this.cmp(areal, aimag, breal, bimag) ? 1 : 0);
            }
            if (ai != 0 || bi != 0) {
                RContext.warning(ast, "longer object length is not a multiple of shorter object length");
            }
            return RLogical.RLogicalFactory.getFor(content, dimensions, names);
        }

        public RLogical cmp(RDouble a, RDouble b, ASTNode ast) {
            int na = a.size();
            int nb = b.size();
            int[] dimensions = Arithmetic.resultDimensions(ast, a, b);
            RArray.Names names = Arithmetic.resultNames(ast, a, b);
            if (na == 0 || nb == 0) {
                return RLogical.EMPTY;
            }
            int n = na > nb ? na : nb;
            int[] content = new int[n];
            int ai = 0;
            int bi = 0;
            if (!this.resultForNaN()) {
                for (int i = 0; i < n; ++i) {
                    double adbl = a.getDouble(ai++);
                    if (ai == na) {
                        ai = 0;
                    }
                    double bdbl = b.getDouble(bi++);
                    if (bi == nb) {
                        bi = 0;
                    }
                    content[i] = this.cmp(adbl, bdbl) ? 1 : (bdbl != bdbl ? Integer.MIN_VALUE : 0);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    double adbl = a.getDouble(ai++);
                    if (ai == na) {
                        ai = 0;
                    }
                    double bdbl = b.getDouble(bi++);
                    if (bi == nb) {
                        bi = 0;
                    }
                    content[i] = this.cmp(adbl, bdbl) ? (bdbl != bdbl ? Integer.MIN_VALUE : 1) : 0;
                }
            }
            if (ai != 0 || bi != 0) {
                RContext.warning(ast, "longer object length is not a multiple of shorter object length");
            }
            return RLogical.RLogicalFactory.getFor(content, dimensions, names);
        }

        public RLogical cmp(RInt a, RInt b, ASTNode ast) {
            int na = a.size();
            int nb = b.size();
            int[] dimensions = Arithmetic.resultDimensions(ast, a, b);
            RArray.Names names = Arithmetic.resultNames(ast, a, b);
            if (na == 0 || nb == 0) {
                return RLogical.EMPTY;
            }
            int n = na > nb ? na : nb;
            int[] content = new int[n];
            int ai = 0;
            int bi = 0;
            for (int i = 0; i < n; ++i) {
                int aint = a.getInt(ai++);
                if (ai == na) {
                    ai = 0;
                }
                int bint = b.getInt(bi++);
                if (bi == nb) {
                    bi = 0;
                }
                content[i] = aint == Integer.MIN_VALUE || bint == Integer.MIN_VALUE ? Integer.MIN_VALUE : (this.cmp(aint, bint) ? 1 : 0);
            }
            if (ai != 0 || bi != 0) {
                RContext.warning(ast, "longer object length is not a multiple of shorter object length");
            }
            return RLogical.RLogicalFactory.getFor(content, dimensions, names);
        }

        public RLogical cmp(RLogical a, RLogical b, ASTNode ast) {
            int na = a.size();
            int nb = b.size();
            int[] dimensions = Arithmetic.resultDimensions(ast, a, b);
            RArray.Names names = Arithmetic.resultNames(ast, a, b);
            if (na == 0 || nb == 0) {
                return RLogical.EMPTY;
            }
            int n = na > nb ? na : nb;
            int[] content = new int[n];
            int ai = 0;
            int bi = 0;
            for (int i = 0; i < n; ++i) {
                int alog = a.getLogical(ai++);
                if (ai == na) {
                    ai = 0;
                }
                int blog = b.getLogical(bi++);
                if (bi == nb) {
                    bi = 0;
                }
                content[i] = alog == Integer.MIN_VALUE || blog == Integer.MIN_VALUE ? Integer.MIN_VALUE : (this.cmp(alog, blog) ? 1 : 0);
            }
            if (ai != 0 || bi != 0) {
                RContext.warning(ast, "longer object length is not a multiple of shorter object length");
            }
            return RLogical.RLogicalFactory.getFor(content, dimensions, names);
        }

        public RLogical cmp(RRaw a, RRaw b, ASTNode ast) {
            int na = a.size();
            int nb = b.size();
            int[] dimensions = Arithmetic.resultDimensions(ast, a, b);
            RArray.Names names = Arithmetic.resultNames(ast, a, b);
            if (na == 0 || nb == 0) {
                return RLogical.EMPTY;
            }
            int n = na > nb ? na : nb;
            int[] content = new int[n];
            int ai = 0;
            int bi = 0;
            for (int i = 0; i < n; ++i) {
                byte araw = a.getRaw(ai++);
                if (ai == na) {
                    ai = 0;
                }
                byte braw = b.getRaw(bi++);
                if (bi == nb) {
                    bi = 0;
                }
                content[i] = this.cmp(araw, braw) ? 1 : 0;
            }
            if (ai != 0 || bi != 0) {
                RContext.warning(ast, "longer object length is not a multiple of shorter object length");
            }
            return RLogical.RLogicalFactory.getFor(content, dimensions, names);
        }
    }

    static class GenericComparison
    extends NonScalarComparison {
        public GenericComparison(ASTNode ast, RNode left, RNode right, ValueComparison cmp) {
            super(ast, left, right, cmp);
        }

        @Override
        public Object execute(RAny lexpr, RAny rexpr) {
            if (lexpr instanceof RString || rexpr instanceof RString) {
                RString lstr = lexpr.asString();
                RString rstr = rexpr.asString();
                return this.cmp.cmp(lstr, rstr, this.ast);
            }
            if (lexpr instanceof RComplex || rexpr instanceof RComplex) {
                RComplex lcmp = lexpr.asComplex();
                RComplex rcmp = rexpr.asComplex();
                return this.cmp.cmp(lcmp, rcmp, this.ast);
            }
            if (lexpr instanceof RDouble || rexpr instanceof RDouble) {
                RDouble ldbl = lexpr.asDouble();
                RDouble rdbl = rexpr.asDouble();
                return this.cmp.cmp(ldbl, rdbl, this.ast);
            }
            if (lexpr instanceof RInt || rexpr instanceof RInt) {
                RInt lint = lexpr.asInt();
                RInt rint = rexpr.asInt();
                return this.cmp.cmp(lint, rint, this.ast);
            }
            if (lexpr instanceof RLogical || rexpr instanceof RLogical) {
                RLogical llog = lexpr.asLogical();
                RLogical rlog = rexpr.asLogical();
                return this.cmp.cmp(llog, rlog, this.ast);
            }
            if (lexpr instanceof RRaw || rexpr instanceof RRaw) {
                RRaw lraw = lexpr.asRaw();
                RRaw rraw = rexpr.asRaw();
                return this.cmp.cmp(lraw, rraw, this.ast);
            }
            Utils.nyi("unsupported case for comparison");
            return null;
        }
    }

    static class LazyComparison
    extends NonScalarComparison {
        public LazyComparison(ASTNode ast, RNode left, RNode right, ValueComparison cmp) {
            super(ast, left, right, cmp);
        }

        @Override
        public Object execute(RAny lexpr, RAny rexpr) {
            try {
                if (lexpr instanceof RDouble || rexpr instanceof RDouble) {
                    final RDouble adbl = lexpr.asDouble();
                    RDouble bdbl = rexpr.asDouble();
                    int na = adbl.size();
                    int nb = bdbl.size();
                    if (na > 1 && nb == 1) {
                        final double bconst = bdbl.getDouble(0);
                        if (RDouble.RDoubleUtils.isNAorNaN(bconst)) {
                            return RLogical.RLogicalFactory.getNAArray(na, adbl.dimensions());
                        }
                        if (!this.cmp.resultForNaN()) {
                            return new LogicalView(adbl, bdbl, na, this.cmp, this.ast){

                                @Override
                                public int getLogical(int i) {
                                    double aval = adbl.getDouble(i);
                                    if (this.cmp.cmp(aval, bconst)) {
                                        return 1;
                                    }
                                    return RDouble.RDoubleUtils.isNAorNaN(aval) ? Integer.MIN_VALUE : 0;
                                }
                            };
                        }
                    }
                }
                throw new SpecializationException((Object)null);
            }
            catch (SpecializationException e) {
                GenericComparison vs = new GenericComparison(this.ast, this.left, this.right, this.cmp);
                this.replace(vs, "genericComparison");
                return vs.execute(lexpr, rexpr);
            }
        }
    }

    static abstract class LogicalView
    extends View.RLogicalView {
        final RArray a;
        final RArray b;
        final int n;
        final int[] dimensions;
        final RArray.Names names;
        final ValueComparison cmp;
        final ASTNode ast;

        public LogicalView(RArray a, RArray b, int n, ValueComparison cmp, ASTNode ast) {
            this.a = a;
            this.b = b;
            this.dimensions = Arithmetic.resultDimensions(ast, a, b);
            this.names = Arithmetic.resultNames(ast, a, b);
            this.n = n;
            this.cmp = cmp;
            this.ast = ast;
        }

        @Override
        public final int size() {
            return this.n;
        }

        @Override
        public final boolean isSharedReal() {
            return this.a.isShared() || this.b.isShared();
        }

        @Override
        public final void ref() {
            this.a.ref();
            this.b.ref();
        }

        @Override
        public final int[] dimensions() {
            return this.dimensions;
        }

        @Override
        public final RArray.Names names() {
            return this.names;
        }

        @Override
        public final boolean dependsOn(RAny value) {
            return this.a.dependsOn(value) || this.b.dependsOn(value);
        }
    }

    static class VectorScalarComparison
    extends NonScalarComparison {
        public VectorScalarComparison(ASTNode ast, RNode left, RNode right, ValueComparison cmp) {
            super(ast, left, right, cmp);
        }

        @Override
        public Object execute(RAny lexpr, RAny rexpr) {
            try {
                RInt lint;
                RDouble ldbl;
                if (lexpr instanceof RDouble) {
                    ldbl = (RDouble)lexpr;
                    if (rexpr instanceof RDouble) {
                        RDouble rdbl = (RDouble)rexpr;
                        if (rdbl.size() == 1) {
                            if (ldbl.size() >= 1 && rdbl.dimensions() == null) {
                                return this.cmp.cmp(ldbl, rdbl.getDouble(0));
                            }
                            throw new SpecializationException((Object)null);
                        }
                        if (rdbl.size() > 1 && ldbl.size() == 1 && ldbl.dimensions() == null) {
                            return this.cmp.cmp(ldbl.getDouble(0), rdbl);
                        }
                        throw new SpecializationException((Object)null);
                    }
                }
                if (lexpr instanceof RInt) {
                    lint = (RInt)lexpr;
                    if (rexpr instanceof RInt) {
                        RInt rint = (RInt)rexpr;
                        if (rint.size() == 1) {
                            if (lint.size() >= 1 && rint.dimensions() == null) {
                                return this.cmp.cmp(lint, rint.getInt(0));
                            }
                            throw new SpecializationException((Object)null);
                        }
                        if (rint.size() > 1 && lint.size() == 1 && lint.dimensions() == null) {
                            return this.cmp.cmp(lint.getInt(0), rint);
                        }
                        throw new SpecializationException((Object)null);
                    }
                }
                if (lexpr instanceof RString || rexpr instanceof RString) {
                    RString lstr = lexpr.asString();
                    RString rstr = rexpr.asString();
                    if (rstr.size() == 1 && rstr.dimensions() == null) {
                        return this.cmp.cmp(lstr, rstr.getString(0));
                    }
                    if (lstr.size() == 1 && lstr.dimensions() == null) {
                        return this.cmp.cmp(lstr.getString(0), rstr);
                    }
                    throw new SpecializationException((Object)null);
                }
                if (lexpr instanceof RComplex || rexpr instanceof RComplex) {
                    throw new SpecializationException((Object)null);
                }
                if (lexpr instanceof RDouble || rexpr instanceof RDouble) {
                    ldbl = lexpr.asDouble();
                    RDouble rdbl = rexpr.asDouble();
                    if (rdbl.size() == 1 && rdbl.dimensions() == null) {
                        return this.cmp.cmp(ldbl, rdbl.getDouble(0));
                    }
                    if (ldbl.size() == 1 && ldbl.dimensions() == null) {
                        return this.cmp.cmp(ldbl.getDouble(0), rdbl);
                    }
                    throw new SpecializationException((Object)null);
                }
                if (lexpr instanceof RInt || rexpr instanceof RInt) {
                    lint = lexpr.asInt();
                    RInt rint = rexpr.asInt();
                    if (rint.size() == 1 && rint.dimensions() == null) {
                        return this.cmp.cmp(lint, rint.getInt(0));
                    }
                    if (lint.size() == 1 && lint.dimensions() == null) {
                        return this.cmp.cmp(lint.getInt(0), rint);
                    }
                    throw new SpecializationException((Object)null);
                }
                throw new SpecializationException((Object)null);
            }
            catch (SpecializationException e) {
                GenericComparison vs = new GenericComparison(this.ast, this.left, this.right, this.cmp);
                this.replace(vs, "genericComparison");
                return vs.execute(lexpr, rexpr);
            }
        }
    }

    static class NonScalarComparison
    extends Comparison {
        public NonScalarComparison(ASTNode ast, RNode left, RNode right, ValueComparison cmp) {
            super(ast, left, right, cmp);
        }

        @Override
        public Object execute(Frame frame) {
            Object lexpr = this.left.execute(frame);
            if (this.getNewNode() != null) {
                return ((Arithmetic)this.getNewNode()).executeWithLexpr(frame, lexpr);
            }
            return this.executeWithLexpr(frame, lexpr);
        }

        public Object executeWithLexpr(Frame frame, Object lexpr) {
            Object rexpr = this.right.execute(frame);
            if (this.getNewNode() != null) {
                return ((Arithmetic)this.getNewNode()).execute(lexpr, rexpr);
            }
            return this.execute((RAny)lexpr, (RAny)rexpr);
        }
    }

    static class ScalarComparison
    extends Comparison {
        final Comparator comp;

        public ScalarComparison(ASTNode ast, RNode left, RNode right, ValueComparison cmp, Comparator comp) {
            super(ast, left, right, cmp);
            this.comp = comp;
        }

        public static ScalarComparison createSpecialized(RAny leftTemplate, RAny rightTemplate, ASTNode ast, RNode left, RNode right, final ValueComparison cmp) {
            if (leftTemplate instanceof ScalarDoubleImpl && rightTemplate instanceof ScalarDoubleImpl) {
                Comparator c = new Comparator(){

                    @Override
                    public final int compare(RAny lexpr, RAny rexpr) throws SpecializationException {
                        if (!(lexpr instanceof ScalarDoubleImpl) || !(rexpr instanceof ScalarDoubleImpl)) {
                            throw new SpecializationException((Object)Transition.COMMON_SCALAR);
                        }
                        double l = ((ScalarDoubleImpl)lexpr).getDouble();
                        double r = ((ScalarDoubleImpl)rexpr).getDouble();
                        if (RDouble.RDoubleUtils.isNAorNaN(r) || RDouble.RDoubleUtils.isNAorNaN(l)) {
                            return Integer.MIN_VALUE;
                        }
                        return cmp.cmp(l, r) ? 1 : 0;
                    }
                };
                return new ScalarComparison(ast, left, right, cmp, c);
            }
            if (leftTemplate instanceof ScalarIntImpl && rightTemplate instanceof ScalarIntImpl) {
                Comparator c = new Comparator(){

                    @Override
                    public final int compare(RAny lexpr, RAny rexpr) throws SpecializationException {
                        if (!(lexpr instanceof ScalarIntImpl) || !(rexpr instanceof ScalarIntImpl)) {
                            throw new SpecializationException((Object)Transition.COMMON_SCALAR);
                        }
                        int l = ((ScalarIntImpl)lexpr).getInt();
                        int r = ((ScalarIntImpl)rexpr).getInt();
                        if (l == Integer.MIN_VALUE || r == Integer.MIN_VALUE) {
                            return Integer.MIN_VALUE;
                        }
                        return cmp.cmp(l, r) ? 1 : 0;
                    }
                };
                return new ScalarComparison(ast, left, right, cmp, c);
            }
            if (leftTemplate instanceof ScalarDoubleImpl && rightTemplate instanceof ScalarIntImpl) {
                Comparator c = new Comparator(){

                    @Override
                    public final int compare(RAny lexpr, RAny rexpr) throws SpecializationException {
                        if (!(lexpr instanceof ScalarDoubleImpl) || !(rexpr instanceof ScalarIntImpl)) {
                            throw new SpecializationException((Object)Transition.COMMON_SCALAR);
                        }
                        double l = ((ScalarDoubleImpl)lexpr).getDouble();
                        int r = ((ScalarIntImpl)rexpr).getInt();
                        if (RDouble.RDoubleUtils.isNAorNaN(l) || r == Integer.MIN_VALUE) {
                            return Integer.MIN_VALUE;
                        }
                        return cmp.cmp(l, r) ? 1 : 0;
                    }
                };
                return new ScalarComparison(ast, left, right, cmp, c);
            }
            if (leftTemplate instanceof ScalarIntImpl && rightTemplate instanceof ScalarDoubleImpl) {
                Comparator c = new Comparator(){

                    @Override
                    public final int compare(RAny lexpr, RAny rexpr) throws SpecializationException {
                        if (!(lexpr instanceof ScalarIntImpl) || !(rexpr instanceof ScalarDoubleImpl)) {
                            throw new SpecializationException((Object)Transition.COMMON_SCALAR);
                        }
                        int l = ((ScalarIntImpl)lexpr).getInt();
                        double r = ((ScalarDoubleImpl)rexpr).getDouble();
                        if (l == Integer.MIN_VALUE || RDouble.RDoubleUtils.isNAorNaN(r)) {
                            return Integer.MIN_VALUE;
                        }
                        return cmp.cmp(l, r) ? 1 : 0;
                    }
                };
                return new ScalarComparison(ast, left, right, cmp, c);
            }
            if (leftTemplate instanceof ScalarIntImpl && rightTemplate instanceof ScalarLogicalImpl) {
                Comparator c = new Comparator(){

                    @Override
                    public final int compare(RAny lexpr, RAny rexpr) throws SpecializationException {
                        if (!(lexpr instanceof ScalarIntImpl) || !(rexpr instanceof ScalarLogicalImpl)) {
                            throw new SpecializationException((Object)Transition.COMMON_SCALAR);
                        }
                        int l = ((ScalarIntImpl)lexpr).getInt();
                        int r = ((ScalarLogicalImpl)rexpr).getLogical();
                        if (l == Integer.MIN_VALUE || r == Integer.MIN_VALUE) {
                            return Integer.MIN_VALUE;
                        }
                        return cmp.cmp(l, r) ? 1 : 0;
                    }
                };
                return new ScalarComparison(ast, left, right, cmp, c);
            }
            if (leftTemplate instanceof ScalarLogicalImpl && rightTemplate instanceof ScalarIntImpl) {
                Comparator c = new Comparator(){

                    @Override
                    public final int compare(RAny lexpr, RAny rexpr) throws SpecializationException {
                        if (!(lexpr instanceof ScalarLogicalImpl) || !(rexpr instanceof ScalarIntImpl)) {
                            throw new SpecializationException((Object)Transition.COMMON_SCALAR);
                        }
                        int l = ((ScalarLogicalImpl)lexpr).getLogical();
                        int r = ((ScalarIntImpl)rexpr).getInt();
                        if (l == Integer.MIN_VALUE || r == Integer.MIN_VALUE) {
                            return Integer.MIN_VALUE;
                        }
                        return cmp.cmp(l, r) ? 1 : 0;
                    }
                };
                return new ScalarComparison(ast, left, right, cmp, c);
            }
            return ScalarComparison.createGeneric(ast, left, right, cmp);
        }

        public static int generic(RAny lexpr, RAny rexpr, ValueComparison cmp, ASTNode ast) throws SpecializationException {
            if (lexpr instanceof ScalarStringImpl) {
                String lstr = ((ScalarStringImpl)lexpr).getString();
                if (lstr == RString.NA) {
                    return Integer.MIN_VALUE;
                }
                if (rexpr instanceof ScalarStringImpl) {
                    String rstr = ((ScalarStringImpl)rexpr).getString();
                    if (rstr == RString.NA) {
                        return Integer.MIN_VALUE;
                    }
                    return cmp.cmp(lstr, rstr) ? 1 : 0;
                }
            } else if (lexpr instanceof ScalarDoubleImpl) {
                double ldbl = ((ScalarDoubleImpl)lexpr).getDouble();
                if (rexpr instanceof ScalarDoubleImpl) {
                    double rdbl = ((ScalarDoubleImpl)rexpr).getDouble();
                    if (RDouble.RDoubleUtils.isNAorNaN(ldbl) || RDouble.RDoubleUtils.isNAorNaN(rdbl)) {
                        return Integer.MIN_VALUE;
                    }
                    return cmp.cmp(ldbl, rdbl) ? 1 : 0;
                }
                if (rexpr instanceof ScalarIntImpl) {
                    int rint = ((ScalarIntImpl)rexpr).getInt();
                    if (RDouble.RDoubleUtils.isNAorNaN(ldbl) || rint == Integer.MIN_VALUE) {
                        return Integer.MIN_VALUE;
                    }
                    return cmp.cmp(ldbl, rint) ? 1 : 0;
                }
            } else if (lexpr instanceof ScalarIntImpl) {
                int lint = ((ScalarIntImpl)lexpr).getInt();
                if (rexpr instanceof ScalarIntImpl) {
                    int rint = ((ScalarIntImpl)rexpr).getInt();
                    if (lint == Integer.MIN_VALUE || rint == Integer.MIN_VALUE) {
                        return Integer.MIN_VALUE;
                    }
                    return cmp.cmp(lint, rint) ? 1 : 0;
                }
                if (rexpr instanceof ScalarDoubleImpl) {
                    double rdbl = ((ScalarDoubleImpl)rexpr).getDouble();
                    if (lint == Integer.MIN_VALUE || RDouble.RDoubleUtils.isNAorNaN(rdbl)) {
                        return Integer.MIN_VALUE;
                    }
                    return cmp.cmp(lint, rdbl) ? 1 : 0;
                }
            }
            throw new SpecializationException((Object)Transition.VECTOR_SCALAR);
        }

        public static ScalarComparison createGeneric(final ASTNode ast, RNode left, RNode right, final ValueComparison cmp) {
            Comparator c = new Comparator(){

                @Override
                public int compare(RAny lexpr, RAny rexpr) throws SpecializationException {
                    return ScalarComparison.generic(lexpr, rexpr, cmp, ast);
                }
            };
            return new ScalarComparison(ast, left, right, cmp, c);
        }

        @Override
        public final int executeScalarLogical(RAny lexpr, RAny rexpr) throws SpecializationException {
            try {
                return this.comp.compare(lexpr, rexpr);
            }
            catch (SpecializationException e) {
                Transition t = (Transition)((Object)e.getResult());
                if (t == Transition.COMMON_SCALAR) {
                    ScalarComparison sc = ScalarComparison.createGeneric(this.ast, this.left, this.right, this.cmp);
                    this.replace(sc, "install CommonScalar from Comparison.Scalar");
                    return sc.executeScalarLogical(lexpr, rexpr);
                }
                VectorScalarComparison vs = new VectorScalarComparison(this.ast, this.left, this.right, this.cmp);
                this.replace(vs, "specializeNumericVectorScalarComparison");
                Object res = vs.execute(lexpr, rexpr);
                throw new SpecializationException(res);
            }
        }

        static enum Transition {
            COMMON_SCALAR,
            VECTOR_SCALAR;

        }

        public static abstract class Comparator {
            public abstract int compare(RAny var1, RAny var2) throws SpecializationException;
        }
    }
}

