/*
 * Decompiled with CFR 0.152.
 */
package r.nodes.exec;

import r.RContext;
import r.Utils;
import r.data.RAny;
import r.data.RInt;
import r.data.RLogical;
import r.errors.RError;
import r.nodes.exec.BaseR;
import r.nodes.exec.RNode;
import r.runtime.Frame;
import r.runtime.SpecializationException;

public abstract class ConvertToLogicalOne
extends BaseR {
    @RNode.Child
    RNode input;
    private static final boolean DEBUG_C = false;

    private ConvertToLogicalOne(RNode input) {
        super(input.getAST());
        this.input = this.insert(input, "inserting cast node ConvertToLogicalOne");
    }

    @Override
    public final Object execute(Frame frame) {
        return RLogical.RLogicalFactory.getScalar(this.executeScalarLogical(frame));
    }

    @Override
    protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
        assert (oldNode != null);
        if (this.input == oldNode) {
            this.input = newNode;
            return this.adoptInternal(newNode);
        }
        return super.replaceChild(oldNode, newNode);
    }

    @Override
    public final int executeScalarLogical(Frame frame) {
        assert (Utils.check(this.getNewNode() == null));
        RAny value = (RAny)this.input.execute(frame);
        if (this.getNewNode() != null) {
            return ((ConvertToLogicalOne)this.getNewNode()).executeScalarLogical(value);
        }
        return this.executeScalarLogical(value);
    }

    public int executeScalarLogical(RAny condValue) {
        try {
            return this.cast(condValue);
        }
        catch (SpecializationException e) {
            ConvertToLogicalOne castNode = this.replace(ConvertToLogicalOne.fromGeneric(this.input), "installGenericConvertToLogical from cast node");
            return castNode.executeScalarLogical(condValue);
        }
    }

    public static ConvertToLogicalOne createAndInsertNode(RNode input, RAny value) {
        if (value instanceof RLogical) {
            return ConvertToLogicalOne.fromLogical(input);
        }
        if (value instanceof RInt) {
            return ConvertToLogicalOne.fromInt(input);
        }
        return ConvertToLogicalOne.fromGeneric(input);
    }

    public abstract int cast(RAny var1) throws SpecializationException;

    public static ConvertToLogicalOne fromLogical(RNode input) {
        return new ConvertToLogicalOne(input){

            @Override
            public int cast(RAny value) throws SpecializationException {
                if (!(value instanceof RLogical)) {
                    throw new SpecializationException(this.input);
                }
                RLogical logicalArray = (RLogical)value;
                if (logicalArray.size() == 1) {
                    return logicalArray.getLogical(0);
                }
                if (logicalArray.size() > 1) {
                    RContext.warning(this.ast, "the condition has length > 1 and only the first element will be used");
                    return logicalArray.getLogical(0);
                }
                throw RError.getLengthZero(null);
            }
        };
    }

    public static ConvertToLogicalOne fromInt(RNode input) {
        return new ConvertToLogicalOne(input){

            @Override
            public int cast(RAny value) throws SpecializationException {
                int intValue;
                if (!(value instanceof RInt)) {
                    throw new SpecializationException(this.input);
                }
                RInt intArray = (RInt)value;
                if (intArray.size() == 1) {
                    intValue = intArray.getInt(0);
                } else if (intArray.size() > 1) {
                    RContext.warning(this.ast, "the condition has length > 1 and only the first element will be used");
                    intValue = intArray.getInt(0);
                } else {
                    throw RError.getLengthZero(null);
                }
                switch (intValue) {
                    case 0: {
                        return intValue;
                    }
                    case -2147483648: {
                        throw RError.getArgumentNotInterpretableLogical(this.ast);
                    }
                }
                return 1;
            }
        };
    }

    public static ConvertToLogicalOne fromGeneric(RNode input) {
        return new ConvertToLogicalOne(input){

            @Override
            public int cast(RAny value) {
                int logicalValue;
                RLogical logicalArray = value.asLogical();
                int asize = logicalArray.size();
                if (asize == 1) {
                    logicalValue = logicalArray.getLogical(0);
                } else if (asize > 1) {
                    logicalValue = logicalArray.getLogical(0);
                    RContext.warning(this.getAST(), "the condition has length > 1 and only the first element will be used");
                } else {
                    assert (Utils.check(asize == 0));
                    throw RError.getLengthZero(this.ast);
                }
                if (logicalValue == Integer.MIN_VALUE && !(value instanceof RLogical)) {
                    throw RError.getArgumentNotInterpretableLogical(this.ast);
                }
                return logicalValue;
            }

            @Override
            public int executeScalarLogical(RAny condValue) {
                return this.cast(condValue);
            }
        };
    }
}

