/*
 * Decompiled with CFR 0.152.
 */
package r.nodes.exec;

import r.RContext;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RRaw;
import r.data.internal.ScalarLogicalImpl;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.Arithmetic;
import r.nodes.exec.BaseR;
import r.nodes.exec.RNode;
import r.runtime.Frame;
import r.runtime.SpecializationException;

public abstract class ElementwiseLogicalOperation
extends BaseR {
    @RNode.Child
    RNode left;
    @RNode.Child
    RNode right;
    final Operation op;
    public static final Operation AND = new Operation(){

        @Override
        public byte op(byte a, byte b) {
            return (byte)(a & b);
        }

        @Override
        public int op(int a, int b) {
            if (a == 1) {
                return b;
            }
            if (a == 0) {
                return 0;
            }
            if (b == 1) {
                return Integer.MIN_VALUE;
            }
            return b;
        }
    };
    public static final Operation OR = new Operation(){

        @Override
        public byte op(byte a, byte b) {
            return (byte)(a | b);
        }

        @Override
        public int op(int a, int b) {
            if (a == 1) {
                return 1;
            }
            if (a == 0) {
                return b;
            }
            if (b == 1) {
                return 1;
            }
            return Integer.MIN_VALUE;
        }
    };

    public ElementwiseLogicalOperation(ASTNode ast, RNode left, Operation op, RNode right) {
        super(ast);
        this.left = this.adoptChild(left);
        this.right = this.adoptChild(right);
        this.op = op;
    }

    @Override
    public final Object execute(Frame frame) {
        RAny leftValue = (RAny)this.left.execute(frame);
        RAny rightValue = (RAny)this.right.execute(frame);
        return this.execute(leftValue, rightValue);
    }

    @Override
    protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
        assert (oldNode != null);
        if (this.left == oldNode) {
            this.left = newNode;
            return this.adoptInternal(newNode);
        }
        if (this.right == oldNode) {
            this.right = newNode;
            return this.adoptInternal(newNode);
        }
        return super.replaceChild(oldNode, newNode);
    }

    public abstract RAny execute(RAny var1, RAny var2);

    public static ElementwiseLogicalOperation createUninitialized(ASTNode ast, RNode left, Operation op, RNode right) {
        return new ElementwiseLogicalOperation(ast, left, op, right){

            @Override
            public RAny execute(RAny leftValue, RAny rightValue) {
                try {
                    throw new SpecializationException((Object)null);
                }
                catch (SpecializationException e) {
                    ElementwiseLogicalOperation sn = Specialized.create(this.ast, this.left, this.op, this.right, leftValue, rightValue);
                    this.replace(sn, "install LogicalOperation from Uninitialized");
                    return sn.execute(leftValue, rightValue);
                }
            }
        };
    }

    public static ElementwiseLogicalOperation createGeneric(ASTNode ast, RNode left, Operation op, RNode right) {
        return new ElementwiseLogicalOperation(ast, left, op, right){

            @Override
            public RAny execute(RAny leftValue, RAny rightValue) {
                if (leftValue instanceof RLogical && rightValue instanceof RLogical) {
                    return this.op.op((RLogical)leftValue, (RLogical)rightValue, this.ast);
                }
                if ((leftValue instanceof RInt || leftValue instanceof RDouble || leftValue instanceof RLogical || leftValue instanceof RComplex) && (rightValue instanceof RInt || rightValue instanceof RDouble || rightValue instanceof RLogical || rightValue instanceof RComplex)) {
                    return this.op.op(leftValue.asLogical(), rightValue.asLogical(), this.ast);
                }
                if (leftValue instanceof RRaw && rightValue instanceof RRaw) {
                    return this.op.op(leftValue.asRaw(), rightValue.asRaw(), this.ast);
                }
                throw RError.getOperationsNumericLogicalComplex(this.ast);
            }
        };
    }

    public static abstract class Operation {
        public abstract int op(int var1, int var2);

        public abstract byte op(byte var1, byte var2);

        public RLogical op(RLogical a, RLogical b, ASTNode ast) {
            int na = a.size();
            int nb = b.size();
            int[] dimensions = Arithmetic.resultDimensions(ast, a, b);
            RArray.Names names = Arithmetic.resultNames(ast, a, b);
            if (na == 0 || nb == 0) {
                return RLogical.EMPTY;
            }
            int n = na > nb ? na : nb;
            int[] content = new int[n];
            int ai = 0;
            int bi = 0;
            for (int i = 0; i < n; ++i) {
                int alog = a.getLogical(ai++);
                if (ai == na) {
                    ai = 0;
                }
                int blog = b.getLogical(bi++);
                if (bi == nb) {
                    bi = 0;
                }
                content[i] = this.op(alog, blog);
            }
            if (ai != 0 || bi != 0) {
                RContext.warning(ast, "longer object length is not a multiple of shorter object length");
            }
            return RLogical.RLogicalFactory.getFor(content, dimensions, names);
        }

        public RRaw op(RRaw a, RRaw b, ASTNode ast) {
            int na = a.size();
            int nb = b.size();
            int[] dimensions = Arithmetic.resultDimensions(ast, a, b);
            RArray.Names names = Arithmetic.resultNames(ast, a, b);
            if (na == 0 || nb == 0) {
                return RRaw.EMPTY;
            }
            int n = na > nb ? na : nb;
            byte[] content = new byte[n];
            int ai = 0;
            int bi = 0;
            for (int i = 0; i < n; ++i) {
                byte araw = a.getRaw(ai++);
                if (ai == na) {
                    ai = 0;
                }
                byte braw = b.getRaw(bi++);
                if (bi == nb) {
                    bi = 0;
                }
                content[i] = this.op(araw, braw);
            }
            if (ai != 0 || bi != 0) {
                RContext.warning(ast, "longer object length is not a multiple of shorter object length");
            }
            return RRaw.RRawFactory.getFor(content, dimensions, names);
        }
    }

    public static class Specialized
    extends ElementwiseLogicalOperation {
        private final Action action;

        Specialized(ASTNode ast, RNode left, Operation op, RNode right, Action action) {
            super(ast, left, op, right);
            this.action = action;
        }

        public static ElementwiseLogicalOperation create(ASTNode ast, RNode left, final Operation op, RNode right, RAny leftTemplate, RAny rightTemplate) {
            if (leftTemplate instanceof ScalarLogicalImpl && rightTemplate instanceof ScalarLogicalImpl) {
                return new Specialized(ast, left, op, right, new Action(){

                    @Override
                    RLogical doFor(RAny leftValue, RAny rightValue, ASTNode ast) throws SpecializationException {
                        if (leftValue instanceof ScalarLogicalImpl && rightValue instanceof ScalarLogicalImpl) {
                            int l = op.op(((ScalarLogicalImpl)leftValue).getLogical(), ((ScalarLogicalImpl)rightValue).getLogical());
                            return RLogical.RLogicalFactory.getScalar(l);
                        }
                        throw new SpecializationException((Object)null);
                    }
                });
            }
            if (leftTemplate instanceof RLogical && rightTemplate instanceof RLogical) {
                return new Specialized(ast, left, op, right, new Action(){

                    @Override
                    RLogical doFor(RAny leftValue, RAny rightValue, ASTNode ast) throws SpecializationException {
                        if (leftValue instanceof RLogical && rightValue instanceof RLogical) {
                            return op.op((RLogical)leftValue, (RLogical)rightValue, ast);
                        }
                        throw new SpecializationException((Object)null);
                    }
                });
            }
            if (leftTemplate instanceof RRaw && rightTemplate instanceof RRaw) {
                return new Specialized(ast, left, op, right, new Action(){

                    @Override
                    RRaw doFor(RAny leftValue, RAny rightValue, ASTNode ast) throws SpecializationException {
                        if (leftValue instanceof RRaw && rightValue instanceof RRaw) {
                            return op.op((RRaw)leftValue, (RRaw)rightValue, ast);
                        }
                        throw new SpecializationException((Object)null);
                    }
                });
            }
            return Specialized.createGeneric(ast, left, op, right);
        }

        @Override
        public RAny execute(RAny leftValue, RAny rightValue) {
            try {
                return this.action.doFor(leftValue, rightValue, this.ast);
            }
            catch (SpecializationException e) {
                ElementwiseLogicalOperation gn = Specialized.createGeneric(this.ast, this.left, this.op, this.right);
                this.replace(gn, "install Generic from ElementwiseLogicalOperation.Specialized");
                return gn.execute(leftValue, rightValue);
            }
        }

        public static abstract class Action {
            abstract RAny doFor(RAny var1, RAny var2, ASTNode var3) throws SpecializationException;
        }
    }
}

