/*
 * Decompiled with CFR 0.152.
 */
package r.nodes.exec;

import r.RValueConversion;
import r.Utils;
import r.builtins.CallFactory;
import r.builtins.Primitives;
import r.data.RAny;
import r.data.RBuiltIn;
import r.data.RClosure;
import r.data.RDots;
import r.data.RFunction;
import r.data.RPromise;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.ast.SimpleAccessVariable;
import r.nodes.exec.AbstractCall;
import r.nodes.exec.BaseR;
import r.nodes.exec.Constant;
import r.nodes.exec.MatchCallable;
import r.nodes.exec.RNode;
import r.nodes.tools.PrettyPrinter;
import r.runtime.Frame;
import r.runtime.SpecializationException;

public abstract class FunctionCall
extends AbstractCall {
    public static final boolean PROMISES = true;
    @RNode.Child
    RNode callableExpr;
    protected final int[] dotsArgs;
    public static CallFactory FACTORY = new CallFactory("<empty>"){

        @Override
        public FunctionCall create(ASTNode call, RSymbol[] names, RNode[] exprs) {
            r.nodes.ast.FunctionCall fcall = (r.nodes.ast.FunctionCall)call;
            RSymbol fname = fcall.getName();
            MatchCallable fexp = MatchCallable.getUninitialized(call, fname);
            return FunctionCall.getFunctionCall(fcall, fexp, names, exprs);
        }
    };

    private FunctionCall(ASTNode ast, RNode callableExpr, RSymbol[] argNames, RNode[] argExprs, int[] dotsArgs) {
        super(ast, argNames, argExprs);
        this.callableExpr = this.adoptChild(callableExpr);
        this.dotsArgs = dotsArgs;
    }

    @Override
    protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
        assert (oldNode != null);
        if (this.callableExpr == oldNode) {
            this.callableExpr = newNode;
            return this.adoptInternal(newNode);
        }
        return super.replaceChild(oldNode, newNode);
    }

    public static FunctionCall getFunctionCall(ASTNode ast, RNode callableExpr, RSymbol[] argNames, RNode[] argExprs) {
        int[] dotsArgs = FunctionCall.findDotsArgs(argExprs);
        if (dotsArgs != null) {
            return new GenericDotsCall(ast, callableExpr, argNames, argExprs, dotsArgs);
        }
        return new UninitializedCall(ast, callableExpr, argNames, argExprs);
    }

    public static int[] findDotsArgs(RNode[] argExprs) {
        int[] res = new int[argExprs.length];
        int j = 0;
        for (int i = 0; i < argExprs.length; ++i) {
            ASTNode ast;
            RNode expr = argExprs[i];
            if (expr == null || !((ast = expr.getAST()) instanceof SimpleAccessVariable) || ((SimpleAccessVariable)ast).getSymbol() != RSymbol.THREE_DOTS_SYMBOL) continue;
            res[j++] = i;
        }
        if (j == 0) {
            return null;
        }
        int[] toret = new int[j];
        System.arraycopy(res, 0, toret, 0, j);
        return toret;
    }

    public static AbstractCall createBuiltinCall(ASTNode call, RSymbol[] argNames, RNode[] argExprs) {
        int[] dotsArgs = FunctionCall.findDotsArgs(argExprs);
        if (dotsArgs != null) {
            return null;
        }
        r.nodes.ast.FunctionCall fcall = (r.nodes.ast.FunctionCall)call;
        RSymbol fname = fcall.getName();
        RBuiltIn builtin = Primitives.getBuiltIn(fname, null);
        if (builtin != null) {
            RNode builtinNode;
            try {
                builtinNode = builtin.callFactory().create(call, argNames, argExprs);
            }
            catch (RError e) {
                return null;
            }
            assert (Utils.check(builtinNode != null));
            return new SimpleBuiltinCall(fcall, fname, argNames, argExprs, builtinNode);
        }
        return null;
    }

    protected final void placeDotsArgs(Frame callerFrame, Frame newFrame, RSymbol[] paramNames) {
        int j;
        int nextDots = this.dotsArgs[0];
        RDots dotsArg = (RDots)this.argExprs[nextDots].execute(callerFrame);
        RSymbol[] dotsArgNames = dotsArg.names();
        Object[] dotsArgValues = dotsArg.values();
        int dotsArgLen = dotsArgNames.length;
        int ndots = this.dotsArgs.length;
        int nArgs = this.argExprs.length + ndots * (dotsArgLen - 1);
        int nParams = paramNames.length;
        RSymbol[] actualArgNames = new RSymbol[nArgs];
        Object[] actualArgValues = new Object[nArgs];
        int dotsIndex = 0;
        int i = 0;
        int j2 = 0;
        while (j2 < nArgs) {
            if (i == nextDots) {
                int k = 0;
                while (k < dotsArgLen) {
                    actualArgNames[j2] = dotsArgNames[k];
                    actualArgValues[j2] = dotsArgValues[k];
                    ++k;
                    ++j2;
                }
                if (++dotsIndex < ndots) {
                    nextDots = dotsIndex;
                }
            } else {
                actualArgNames[j2] = this.argNames[i];
                actualArgValues[j2] = this.promiseForArgument(callerFrame, i);
                ++j2;
            }
            ++i;
        }
        boolean[] usedArgs = new boolean[nArgs];
        for (int i2 = 0; i2 < nArgs; ++i2) {
            RSymbol argName = actualArgNames[i2];
            if (argName == null) continue;
            for (j = 0; j < nParams; ++j) {
                if (argName != paramNames[j]) continue;
                if (newFrame.get(j) != null) {
                    throw RError.getFormalMatchedMultiple(this.ast, argName.name());
                }
                newFrame.set(j, actualArgValues[i2]);
                usedArgs[i2] = true;
            }
        }
        boolean hasUnmatchedNamedArgs = false;
        for (int i3 = 0; i3 < nArgs; ++i3) {
            if (actualArgNames[i3] == null || usedArgs[i3]) continue;
            hasUnmatchedNamedArgs = true;
            break;
        }
        if (hasUnmatchedNamedArgs) {
            boolean[] argMatchedViaPartialMatching = new boolean[nArgs];
            for (j = 0; j < nParams; ++j) {
                if (newFrame.get(j) != null) continue;
                RSymbol paramName = paramNames[j];
                if (paramName == RSymbol.THREE_DOTS_SYMBOL) break;
                for (int i4 = 0; i4 < nArgs; ++i4) {
                    RSymbol argName = actualArgNames[i4];
                    if (argName == null) continue;
                    if (argMatchedViaPartialMatching[i4]) {
                        if (!paramName.startsWith(argName)) continue;
                        throw RError.getArgumentMatchesMultiple(this.ast, i4 + 1);
                    }
                    if (usedArgs[i4] || !paramName.startsWith(argName)) continue;
                    if (newFrame.get(j) != null) {
                        throw RError.getFormalMatchedMultiple(this.ast, paramName.name());
                    }
                    newFrame.set(j, actualArgValues[i4]);
                    usedArgs[i4] = true;
                    argMatchedViaPartialMatching[i4] = true;
                }
            }
        }
        int i5 = 0;
        j = 0;
        boolean hasUnusedArgsWithNames = false;
        while (true) {
            if (i5 == nArgs) {
                if (!hasUnusedArgsWithNames) break;
                this.reportUnusedArgsError(usedArgs, actualArgValues, actualArgNames);
                break;
            }
            if (usedArgs[i5]) {
                ++i5;
                continue;
            }
            while (true) {
                if (j == nParams) {
                    this.reportUnusedArgsError(usedArgs, actualArgValues, actualArgNames);
                }
                if (newFrame.get(j) == null) break;
                ++j;
            }
            RSymbol paramName = paramNames[j];
            if (paramName == RSymbol.THREE_DOTS_SYMBOL) {
                int nToDots = 0;
                for (int ii = i5; ii < nArgs; ++ii) {
                    if (usedArgs[ii]) continue;
                    ++nToDots;
                }
                RSymbol[] dnames = new RSymbol[nToDots];
                Object[] dvalues = new Object[nToDots];
                int di = 0;
                while (i5 < nArgs) {
                    if (!usedArgs[i5]) {
                        dnames[di] = actualArgNames[i5];
                        dvalues[di] = actualArgValues[i5];
                        ++di;
                        usedArgs[i5] = true;
                    }
                    ++i5;
                }
                newFrame.set(j, new RDots(dnames, dvalues));
                continue;
            }
            if (actualArgNames[i5] == null) {
                newFrame.set(j, actualArgValues[i5]);
                usedArgs[i5] = true;
                ++i5;
                ++j;
                continue;
            }
            ++i5;
            hasUnusedArgsWithNames = true;
        }
    }

    private int reportUnusedArgsError(boolean[] usedArgs, Object[] actualArgValues, RSymbol[] actualArgNames) {
        StringBuilder str = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < usedArgs.length; ++i) {
            Object argValue;
            if (usedArgs[i]) continue;
            if (!first) {
                str.append(", ");
            } else {
                first = false;
            }
            RSymbol argName = actualArgNames[i];
            if (argName != null) {
                str.append(argName);
                str.append(" = ");
            }
            if ((argValue = actualArgValues[i]) == null) continue;
            if (argValue instanceof RPromise) {
                RNode argExpr = ((RPromise)argValue).expression();
                str.append(PrettyPrinter.prettyPrint(argExpr.getAST()));
                continue;
            }
            if (!(argValue instanceof RAny)) continue;
            str.append(((RAny)argValue).pretty());
        }
        throw RError.getUnusedArgument(this.ast, str.toString());
    }

    public static class DotsInfo {
        RSymbol[] names;
    }

    public static final class GenericDotsCall
    extends FunctionCall {
        GenericDotsCall(ASTNode ast, RNode callableExpr, RSymbol[] argNames, RNode[] argExprs, int[] dotsArgs) {
            super(ast, callableExpr, argNames, argExprs, dotsArgs);
            assert (Utils.check(dotsArgs != null));
        }

        @Override
        public Object execute(Frame callerFrame) {
            Object callable = this.callableExpr.execute(callerFrame);
            if (callable instanceof RClosure) {
                RClosure closure = (RClosure)callable;
                RFunction function = closure.function();
                Frame newFrame = function.createFrame(closure.enclosingFrame());
                this.placeDotsArgs(callerFrame, newFrame, function.paramNames());
                return function.call(newFrame);
            }
            assert (Utils.check(callable instanceof RBuiltIn));
            RBuiltIn builtIn = (RBuiltIn)Utils.cast(callable);
            int nextDots = this.dotsArgs[0];
            RDots dotsArg = (RDots)this.argExprs[nextDots].execute(callerFrame);
            RSymbol[] dotsArgNames = dotsArg.names();
            Object[] dotsArgValues = dotsArg.values();
            int dotsArgLen = dotsArgNames.length;
            int ndots = this.dotsArgs.length;
            int nArgs = this.argExprs.length + ndots * (dotsArgLen - 1);
            RSymbol[] actualArgNames = new RSymbol[nArgs];
            RNode[] actualArgExprs = new RNode[nArgs];
            int dotsIndex = 0;
            int i = 0;
            int j = 0;
            while (j < nArgs) {
                if (i == nextDots) {
                    int k = 0;
                    while (k < dotsArgLen) {
                        actualArgNames[j] = dotsArgNames[k];
                        Object value = dotsArgValues[k];
                        if (value instanceof RPromise) {
                            final RPromise promise = (RPromise)value;
                            actualArgExprs[j] = new BaseR(promise.expression().getAST()){

                                @Override
                                public Object execute(Frame frame) {
                                    return promise.forceOrGet();
                                }
                            };
                        } else {
                            assert (Utils.check(value instanceof RAny));
                            RAny rvalue = (RAny)Utils.cast(value);
                            r.nodes.ast.Constant dummyAST = new r.nodes.ast.Constant(rvalue);
                            actualArgExprs[j] = new Constant(dummyAST, rvalue);
                        }
                        ++k;
                        ++j;
                    }
                    if (++dotsIndex < ndots) {
                        nextDots = dotsIndex;
                    }
                } else {
                    actualArgNames[j] = this.argNames[i];
                    actualArgExprs[j] = this.argExprs[i];
                    ++j;
                }
                ++i;
            }
            return builtIn.callFactory().invokeDynamic(callerFrame, actualArgNames, actualArgExprs, this.ast);
        }
    }

    public static final class GenericCall
    extends FunctionCall {
        Object lastCallable;
        RClosure lastClosure;
        RFunction closureFunction;
        int[] functionArgPositions;
        Frame closureEnclosingFrame;
        final DotsInfo functionDotsInfo = new DotsInfo();
        RBuiltIn lastBuiltIn;
        RSymbol builtInName;
        @RNode.Child
        RNode builtInNode;

        GenericCall(ASTNode ast, RNode callableExpr, RSymbol[] argNames, RNode[] argExprs) {
            super(ast, callableExpr, argNames, argExprs, null);
        }

        @Override
        public Object execute(Frame callerFrame) {
            Object callable = this.callableExpr.execute(callerFrame);
            if (callable == this.lastClosure) {
                Frame newFrame = this.closureFunction.createFrame(this.closureEnclosingFrame);
                this.placeArgs(callerFrame, newFrame, this.functionArgPositions, this.functionDotsInfo, this.closureFunction.dotsIndex(), this.closureFunction.nparams());
                return this.closureFunction.call(newFrame);
            }
            if (callable == this.lastBuiltIn) {
                return this.builtInNode.execute(callerFrame);
            }
            if (callable instanceof RClosure) {
                RClosure closure = (RClosure)callable;
                RFunction function = closure.function();
                if (function != this.closureFunction) {
                    this.closureFunction = function;
                    this.functionArgPositions = this.computePositions(this.closureFunction, this.functionDotsInfo);
                }
                this.closureEnclosingFrame = closure.enclosingFrame();
                this.lastClosure = closure;
                this.lastBuiltIn = null;
                Frame newFrame = this.closureFunction.createFrame(this.closureEnclosingFrame);
                this.placeArgs(callerFrame, newFrame, this.functionArgPositions, this.functionDotsInfo, this.closureFunction.dotsIndex(), this.closureFunction.nparams());
                return this.closureFunction.call(newFrame);
            }
            RBuiltIn builtIn = (RBuiltIn)callable;
            RSymbol name = builtIn.name();
            if (name != this.builtInName) {
                this.builtInName = name;
                if (this.builtInNode == null) {
                    this.builtInNode = this.adoptChild(builtIn.callFactory().create(this.ast, this.argNames, this.argExprs));
                } else {
                    this.builtInNode.replace(builtIn.callFactory().create(this.ast, this.argNames, this.argExprs));
                }
            }
            this.lastBuiltIn = builtIn;
            this.lastClosure = null;
            return this.builtInNode.execute(callerFrame);
        }

        @Override
        protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
            assert (oldNode != null);
            if (this.builtInNode == oldNode) {
                this.builtInNode = newNode;
                return this.adoptInternal(newNode);
            }
            return super.replaceChild(oldNode, newNode);
        }

        @Override
        public int executeScalarLogical(Frame callerFrame) throws SpecializationException {
            Object callable = this.callableExpr.execute(callerFrame);
            if (callable == this.lastClosure) {
                Frame newFrame = this.closureFunction.createFrame(this.closureEnclosingFrame);
                this.placeArgs(callerFrame, newFrame, this.functionArgPositions, this.functionDotsInfo, this.closureFunction.dotsIndex(), this.closureFunction.nparams());
                return RValueConversion.expectScalarLogical((RAny)this.closureFunction.call(newFrame));
            }
            if (callable == this.lastBuiltIn) {
                return this.builtInNode.executeScalarLogical(callerFrame);
            }
            if (callable instanceof RClosure) {
                RClosure closure = (RClosure)callable;
                RFunction function = closure.function();
                if (function != this.closureFunction) {
                    this.closureFunction = function;
                    this.functionArgPositions = this.computePositions(this.closureFunction, this.functionDotsInfo);
                }
                this.closureEnclosingFrame = closure.enclosingFrame();
                this.lastClosure = closure;
                this.lastBuiltIn = null;
                Frame newFrame = this.closureFunction.createFrame(this.closureEnclosingFrame);
                this.placeArgs(callerFrame, newFrame, this.functionArgPositions, this.functionDotsInfo, this.closureFunction.dotsIndex(), this.closureFunction.nparams());
                return RValueConversion.expectScalarLogical((RAny)this.closureFunction.call(newFrame));
            }
            RBuiltIn builtIn = (RBuiltIn)callable;
            RSymbol name = builtIn.name();
            if (name != this.builtInName) {
                this.builtInName = name;
                if (this.builtInNode == null) {
                    this.builtInNode = this.adoptChild(builtIn.callFactory().create(this.ast, this.argNames, this.argExprs));
                } else {
                    this.builtInNode.replace(builtIn.callFactory().create(this.ast, this.argNames, this.argExprs));
                }
            }
            this.lastBuiltIn = builtIn;
            this.lastClosure = null;
            return this.builtInNode.executeScalarLogical(callerFrame);
        }

        @Override
        public int executeScalarNonNALogical(Frame callerFrame) throws SpecializationException {
            Object callable = this.callableExpr.execute(callerFrame);
            if (callable == this.lastClosure) {
                Frame newFrame = this.closureFunction.createFrame(this.closureEnclosingFrame);
                this.placeArgs(callerFrame, newFrame, this.functionArgPositions, this.functionDotsInfo, this.closureFunction.dotsIndex(), this.closureFunction.nparams());
                return RValueConversion.expectScalarNonNALogical((RAny)this.closureFunction.call(newFrame));
            }
            if (callable == this.lastBuiltIn) {
                return this.builtInNode.executeScalarNonNALogical(callerFrame);
            }
            if (callable instanceof RClosure) {
                RClosure closure = (RClosure)callable;
                RFunction function = closure.function();
                if (function != this.closureFunction) {
                    this.closureFunction = function;
                    this.functionArgPositions = this.computePositions(this.closureFunction, this.functionDotsInfo);
                }
                this.closureEnclosingFrame = closure.enclosingFrame();
                this.lastClosure = closure;
                this.lastBuiltIn = null;
                Frame newFrame = this.closureFunction.createFrame(this.closureEnclosingFrame);
                this.placeArgs(callerFrame, newFrame, this.functionArgPositions, this.functionDotsInfo, this.closureFunction.dotsIndex(), this.closureFunction.nparams());
                return RValueConversion.expectScalarNonNALogical((RAny)this.closureFunction.call(newFrame));
            }
            RBuiltIn builtIn = (RBuiltIn)callable;
            RSymbol name = builtIn.name();
            if (name != this.builtInName) {
                this.builtInName = name;
                if (this.builtInNode == null) {
                    this.builtInNode = this.adoptChild(builtIn.callFactory().create(this.ast, this.argNames, this.argExprs));
                } else {
                    this.builtInNode.replace(builtIn.callFactory().create(this.ast, this.argNames, this.argExprs));
                }
            }
            this.lastBuiltIn = builtIn;
            this.lastClosure = null;
            return this.builtInNode.executeScalarNonNALogical(callerFrame);
        }
    }

    public static final class StableBuiltinCall
    extends BaseR {
        final RBuiltIn builtIn;
        @RNode.Child
        RNode builtInNode;
        @RNode.Child
        RNode callableExpr;
        final RNode[] rememberedArgExprs;
        final RSymbol[] rememberedArgNames;

        StableBuiltinCall(ASTNode ast, RNode callableExpr, RSymbol[] argNames, RNode[] argExprs, RBuiltIn builtIn, RNode builtInNode) {
            super(ast);
            this.callableExpr = this.adoptChild(callableExpr);
            this.rememberedArgNames = argNames;
            this.rememberedArgExprs = argExprs;
            this.builtIn = builtIn;
            this.builtInNode = this.adoptChild(builtInNode);
        }

        @Override
        public Object execute(Frame callerFrame) {
            Object callable = this.callableExpr.execute(callerFrame);
            try {
                if (callable != this.builtIn) {
                    throw new SpecializationException((Object)null);
                }
                return this.builtInNode.execute(callerFrame);
            }
            catch (SpecializationException e) {
                RNode theCallableExpr = this.callableExpr;
                GenericCall n = new GenericCall(this.ast, this.callableExpr, this.rememberedArgNames, this.rememberedArgExprs);
                return this.replace(theCallableExpr, callable, n, callerFrame);
            }
        }

        @Override
        protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
            assert (oldNode != null);
            if (this.builtInNode == oldNode) {
                this.builtInNode = newNode;
                return this.adoptInternal(newNode);
            }
            if (this.callableExpr == oldNode) {
                this.callableExpr = newNode;
                return this.adoptInternal(newNode);
            }
            if (this.rememberedArgExprs != null) {
                for (int i = 0; i < this.rememberedArgExprs.length; ++i) {
                    if (this.rememberedArgExprs[i] != oldNode) continue;
                    this.rememberedArgExprs[i] = newNode;
                    return this.adoptInternal(newNode);
                }
            }
            return super.replaceChild(oldNode, newNode);
        }
    }

    public static final class SimpleBuiltinCall
    extends AbstractCall {
        final RSymbol builtinName;
        @RNode.Child
        RNode builtinNode;

        SimpleBuiltinCall(ASTNode ast, RSymbol builtinName, RSymbol[] argNames, RNode[] argExprs, RNode builtInNode) {
            super(ast, argNames, argExprs, false);
            this.builtinName = builtinName;
            this.builtinNode = this.adoptChild(builtInNode);
        }

        @Override
        public Object execute(Frame callerFrame) {
            try {
                if (this.builtinName.getValue() != null || this.builtinName.getVersion() != 0) {
                    throw new SpecializationException((Object)null);
                }
                return this.builtinNode.execute(callerFrame);
            }
            catch (SpecializationException e) {
                MatchCallable callableExpr = MatchCallable.getUninitialized(this.ast, this.builtinName);
                return this.replace(FunctionCall.getFunctionCall(this.ast, callableExpr, this.argNames, this.argExprs)).execute(callerFrame);
            }
        }

        @Override
        protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
            assert (oldNode != null);
            if (this.builtinNode == oldNode) {
                this.builtinNode = newNode;
                return this.adoptInternal(newNode);
            }
            return super.replaceChild(oldNode, newNode);
        }
    }

    public static final class UninitializedCall
    extends FunctionCall {
        public UninitializedCall(ASTNode ast, RNode callableExpr, RSymbol[] argNames, RNode[] argExprs) {
            super(ast, callableExpr, argNames, argExprs, null);
        }

        @Override
        public Object execute(Frame callerFrame) {
            Object callable = this.callableExpr.execute(callerFrame);
            try {
                throw new SpecializationException((Object)null);
            }
            catch (SpecializationException e) {
                BaseR n;
                RNode theCallableExpr = this.callableExpr;
                if (callable instanceof RBuiltIn) {
                    RBuiltIn builtIn = (RBuiltIn)callable;
                    RNode builtInNode = builtIn.callFactory().create(this.ast, this.argNames, this.argExprs);
                    n = new StableBuiltinCall(this.ast, this.callableExpr, this.argNames, this.argExprs, builtIn, builtInNode);
                } else {
                    n = new GenericCall(this.ast, this.callableExpr, this.argNames, this.argExprs);
                }
                return this.replace(theCallableExpr, callable, n, callerFrame);
            }
        }
    }
}

