/*
 * Decompiled with CFR 0.152.
 */
package r.nodes.exec;

import r.Convert;
import r.Utils;
import r.data.RAny;
import r.data.RDouble;
import r.data.RInt;
import r.data.RNull;
import r.data.internal.ScalarDoubleImpl;
import r.data.internal.ScalarIntImpl;
import r.data.internal.ScalarLogicalImpl;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.BaseR;
import r.nodes.exec.Constant;
import r.nodes.exec.ConvertToLogicalOne;
import r.nodes.exec.RNode;
import r.runtime.Frame;
import r.runtime.SpecializationException;

public class If
extends BaseR {
    @RNode.Child
    RNode cond;
    @RNode.Child
    RNode trueBranch;
    @RNode.Child
    RNode falseBranch;
    private static final boolean DEBUG_IF = false;

    public If(ASTNode ast, RNode cond, RNode trueBranch, RNode falseBranch) {
        super(ast);
        this.cond = this.adoptChild(cond);
        this.trueBranch = this.adoptChild(trueBranch);
        this.falseBranch = this.adoptChild(falseBranch);
    }

    @Override
    public final Object execute(Frame frame) {
        int ifVal;
        assert (Utils.check(this.getNewNode() == null));
        try {
            ifVal = this.cond.executeScalarLogical(frame);
        }
        catch (SpecializationException e) {
            RAny result = (RAny)e.getResult();
            if (this.getNewNode() != null) {
                return ((If)this.getNewNode()).executeWithFailedCond(frame, result);
            }
            return this.executeWithFailedCond(frame, result);
        }
        if (this.getNewNode() != null) {
            return ((If)this.getNewNode()).executeWithCond(frame, ifVal);
        }
        return this.executeWithCond(frame, ifVal);
    }

    public Object executeWithFailedCond(Frame frame, RAny result) {
        ConvertToLogicalOne castNode = ConvertToLogicalOne.createAndInsertNode(this.cond, result);
        int ifVal = castNode.executeScalarLogical(result);
        if (this.getNewNode() != null) {
            return ((If)this.getNewNode()).executeWithCond(frame, ifVal);
        }
        return this.executeWithCond(frame, ifVal);
    }

    public Object executeWithCond(Frame frame, int ifVal) {
        if (ifVal == 1) {
            return this.trueBranch.execute(frame);
        }
        if (ifVal == 0) {
            return this.falseBranch.execute(frame);
        }
        throw RError.getUnexpectedNA(this.getAST());
    }

    @Override
    protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
        assert (oldNode != null);
        if (this.cond == oldNode) {
            this.cond = newNode;
            return this.adoptInternal(newNode);
        }
        if (this.trueBranch == oldNode) {
            this.trueBranch = newNode;
            return this.adoptInternal(newNode);
        }
        if (this.falseBranch == oldNode) {
            this.falseBranch = newNode;
            return this.adoptInternal(newNode);
        }
        return super.replaceChild(oldNode, newNode);
    }

    public static class IfConst
    extends BaseR {
        @RNode.Child
        RNode cond;
        @RNode.Child
        RNode expr;
        @RNode.Child
        RNode trueBranch;
        @RNode.Child
        RNode falseBranch;
        final RAny constant;

        public IfConst(ASTNode ast, RNode cond, RNode expr, RNode trueBranch, RNode falseBranch, RAny constant) {
            super(ast);
            this.cond = this.adoptChild(cond);
            this.expr = this.adoptChild(expr);
            this.trueBranch = this.adoptChild(trueBranch);
            this.falseBranch = this.adoptChild(falseBranch);
            this.constant = constant;
        }

        @Override
        public final Object execute(Frame frame) {
            assert (Utils.check(this.getNewNode() == null));
            RAny value = (RAny)this.expr.execute(frame);
            assert (Utils.check(this.getNewNode() == null));
            return this.execute(frame, value);
        }

        @Override
        protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
            assert (oldNode != null);
            if (this.cond == oldNode) {
                this.cond = newNode;
                return this.adoptInternal(newNode);
            }
            if (this.expr == oldNode) {
                this.expr = newNode;
                return this.adoptInternal(newNode);
            }
            if (this.trueBranch == oldNode) {
                this.trueBranch = newNode;
                return this.adoptInternal(newNode);
            }
            if (this.falseBranch == oldNode) {
                this.falseBranch = newNode;
                return this.adoptInternal(newNode);
            }
            return super.replaceChild(oldNode, newNode);
        }

        public Object execute(Frame frame, RAny value) {
            assert (Utils.check(this.getNewNode() == null));
            try {
                throw new SpecializationException((Object)null);
            }
            catch (SpecializationException e) {
                Specialized s = Specialized.create(this.ast, this.cond, this.expr, this.trueBranch, this.falseBranch, this.constant, value);
                if (s != null) {
                    this.replace(s, "install Specialized from IfConst");
                    return s.execute(frame);
                }
                If in = new If(this.ast, this.cond, this.trueBranch, this.falseBranch);
                this.replace(in, "install If from IfConst");
                return in.execute(frame);
            }
        }

        public static class Specialized
        extends IfConst {
            final Comparison cmp;

            public Specialized(ASTNode ast, RNode cond, RNode expr, RNode trueBranch, RNode falseBranch, RAny constant, Comparison cmp) {
                super(ast, cond, expr, trueBranch, falseBranch, constant);
                this.cmp = cmp;
            }

            public static Specialized create(final ASTNode ast, RNode cond, RNode expr, RNode trueBranch, RNode falseBranch, RAny constant, RAny valueTemplate) {
                if (valueTemplate instanceof ScalarDoubleImpl) {
                    if (!(constant instanceof ScalarDoubleImpl || constant instanceof ScalarIntImpl || constant instanceof ScalarLogicalImpl)) {
                        return null;
                    }
                    RDouble dc = constant.asDouble();
                    final double c = dc.getDouble(0);
                    final boolean cIsNAorNaN = RDouble.RDoubleUtils.isNAorNaN(c);
                    Comparison cmp = new Comparison(){

                        @Override
                        public int cmp(RAny value) throws SpecializationException {
                            if (!(value instanceof ScalarDoubleImpl)) {
                                throw new SpecializationException((Object)null);
                            }
                            double v = ((ScalarDoubleImpl)value).getDouble();
                            if (!cIsNAorNaN && !RDouble.RDoubleUtils.isNAorNaN(v)) {
                                return v == c ? 1 : 0;
                            }
                            throw RError.getUnexpectedNA(ast);
                        }
                    };
                    return new Specialized(ast, cond, expr, trueBranch, falseBranch, constant, cmp);
                }
                if (valueTemplate instanceof ScalarIntImpl) {
                    Comparison cmp = null;
                    if (constant instanceof ScalarDoubleImpl) {
                        final double c = ((ScalarDoubleImpl)constant).getDouble();
                        final boolean cIsNAorNaN = RDouble.RDoubleUtils.isNAorNaN(c);
                        cmp = new Comparison(){

                            @Override
                            public int cmp(RAny value) throws SpecializationException {
                                if (!(value instanceof ScalarIntImpl)) {
                                    throw new SpecializationException((Object)null);
                                }
                                double v = Convert.int2double(((ScalarIntImpl)value).getInt());
                                if (!cIsNAorNaN && !RDouble.RDoubleUtils.isNAorNaN(v)) {
                                    return v == c ? 1 : 0;
                                }
                                throw RError.getUnexpectedNA(ast);
                            }
                        };
                    } else if (constant instanceof ScalarIntImpl || constant instanceof ScalarLogicalImpl) {
                        RInt ic = constant.asInt();
                        final int c = ic.getInt(0);
                        final boolean cIsNA = c == Integer.MIN_VALUE;
                        cmp = new Comparison(){

                            @Override
                            public int cmp(RAny value) throws SpecializationException {
                                if (!(value instanceof ScalarIntImpl)) {
                                    throw new SpecializationException((Object)null);
                                }
                                int v = ((ScalarIntImpl)value).getInt();
                                if (!cIsNA && v != Integer.MIN_VALUE) {
                                    return v == c ? 1 : 0;
                                }
                                throw RError.getUnexpectedNA(ast);
                            }
                        };
                    } else {
                        return null;
                    }
                    return new Specialized(ast, cond, expr, trueBranch, falseBranch, constant, cmp);
                }
                if (valueTemplate instanceof ScalarLogicalImpl) {
                    if (!(constant instanceof ScalarLogicalImpl) && !(constant instanceof ScalarIntImpl)) {
                        return null;
                    }
                    final int c = constant.asLogical().getLogical(0);
                    final boolean cIsNA = c == Integer.MIN_VALUE;
                    Comparison cmp = new Comparison(){

                        @Override
                        public int cmp(RAny value) throws SpecializationException {
                            if (!(value instanceof ScalarLogicalImpl)) {
                                throw new SpecializationException((Object)null);
                            }
                            int v = ((ScalarLogicalImpl)value).getLogical();
                            if (!cIsNA && v != Integer.MIN_VALUE) {
                                return v == c ? 1 : 0;
                            }
                            throw RError.getUnexpectedNA(ast);
                        }
                    };
                    return new Specialized(ast, cond, expr, trueBranch, falseBranch, constant, cmp);
                }
                return null;
            }

            @Override
            public final Object execute(Frame frame, RAny value) {
                assert (Utils.check(this.getNewNode() == null));
                try {
                    int ifVal = this.cmp.cmp(value);
                    if (ifVal == 1) {
                        assert (Utils.check(this.getNewNode() == null));
                        return this.trueBranch.execute(frame);
                    }
                    assert (Utils.check(this.getNewNode() == null));
                    assert (Utils.check(ifVal == 0));
                    return this.falseBranch.execute(frame);
                }
                catch (SpecializationException e) {
                    If in = new If(this.ast, this.cond, this.trueBranch, this.falseBranch);
                    this.replace(in, "install If from IfConst.Specialized");
                    return in.execute(frame);
                }
            }
        }

        public static abstract class Comparison {
            public abstract int cmp(RAny var1) throws SpecializationException;
        }
    }

    public static class IfElse
    extends BaseR {
        @RNode.Child
        RNode cond;
        @RNode.Child
        RNode trueBranch;
        @RNode.Child
        RNode falseBranch;

        public IfElse(ASTNode ast, RNode cond, RNode trueBranch, RNode falseBranch) {
            super(ast);
            this.cond = this.adoptChild(cond);
            this.trueBranch = this.adoptChild(trueBranch);
            this.falseBranch = this.adoptChild(falseBranch);
        }

        @Override
        public final Object execute(Frame frame) {
            int ifVal;
            assert (Utils.check(this.getNewNode() == null));
            try {
                ifVal = this.cond.executeScalarNonNALogical(frame);
            }
            catch (SpecializationException e) {
                RAny result = (RAny)e.getResult();
                RNode theCond = this.cond;
                ConvertToLogicalOne castNode = ConvertToLogicalOne.createAndInsertNode(this.cond, result);
                If ifnode = new If(this.ast, castNode, this.trueBranch, this.falseBranch);
                return this.replace(theCond, result, ifnode, frame);
            }
            if (ifVal == 1) {
                return this.trueBranch.execute(frame);
            }
            return this.falseBranch.execute(frame);
        }

        @Override
        protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
            assert (oldNode != null);
            if (this.cond == oldNode) {
                this.cond = newNode;
                return this.adoptInternal(newNode);
            }
            if (this.trueBranch == oldNode) {
                this.trueBranch = newNode;
                return this.adoptInternal(newNode);
            }
            if (this.falseBranch == oldNode) {
                this.falseBranch = newNode;
                return this.adoptInternal(newNode);
            }
            return super.replaceChild(oldNode, newNode);
        }
    }

    public static class IfNoElse
    extends BaseR {
        @RNode.Child
        RNode cond;
        @RNode.Child
        RNode trueBranch;

        public IfNoElse(ASTNode ast, RNode cond, RNode trueBranch) {
            super(ast);
            this.cond = this.adoptChild(cond);
            this.trueBranch = this.adoptChild(trueBranch);
        }

        @Override
        public final Object execute(Frame frame) {
            int ifVal;
            assert (Utils.check(this.getNewNode() == null));
            try {
                ifVal = this.cond.executeScalarNonNALogical(frame);
            }
            catch (SpecializationException e) {
                RAny result = (RAny)e.getResult();
                RNode theCond = this.cond;
                ConvertToLogicalOne castNode = ConvertToLogicalOne.createAndInsertNode(this.cond, result);
                If ifnode = new If(this.ast, castNode, this.trueBranch, Constant.getNull());
                return this.replace(theCond, result, ifnode, frame);
            }
            if (ifVal == 1) {
                return this.trueBranch.execute(frame);
            }
            return RNull.getNull();
        }

        @Override
        protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
            assert (oldNode != null);
            if (this.cond == oldNode) {
                this.cond = newNode;
                return this.adoptInternal(newNode);
            }
            if (this.trueBranch == oldNode) {
                this.trueBranch = newNode;
                return this.adoptInternal(newNode);
            }
            return super.replaceChild(oldNode, newNode);
        }
    }
}

