/*
 * Decompiled with CFR 0.152.
 */
package r.nodes.exec;

import java.util.HashSet;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RList;
import r.data.RLogical;
import r.data.RRaw;
import r.data.RString;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.BaseR;
import r.nodes.exec.RNode;
import r.runtime.Frame;

public class InOperation
extends BaseR {
    @RNode.Child
    RNode left;
    @RNode.Child
    RNode right;

    public InOperation(ASTNode ast, RNode left, RNode right) {
        super(ast);
        this.left = this.adoptChild(left);
        this.right = this.adoptChild(right);
    }

    @Override
    public final Object execute(Frame frame) {
        RAny leftValue = (RAny)this.left.execute(frame);
        RAny rightValue = (RAny)this.right.execute(frame);
        return this.execute(leftValue, rightValue);
    }

    @Override
    protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
        assert (oldNode != null);
        if (this.left == oldNode) {
            this.left = newNode;
            return this.adoptInternal(newNode);
        }
        if (this.right == oldNode) {
            this.right = newNode;
            return this.adoptInternal(newNode);
        }
        return super.replaceChild(oldNode, newNode);
    }

    public Object execute(RAny left, RAny right) {
        int i;
        RArray typedTable;
        RArray typedX;
        if (left instanceof RString || right instanceof RString || left instanceof RList || right instanceof RList) {
            typedX = left.asString();
            typedTable = right.asString();
        } else if (left instanceof RComplex || right instanceof RComplex) {
            typedX = left.asComplex();
            typedTable = right.asComplex();
        } else if (left instanceof RDouble || right instanceof RDouble) {
            typedX = left.asDouble();
            typedTable = right.asDouble();
        } else if (left instanceof RInt || right instanceof RInt || left instanceof RRaw || right instanceof RRaw) {
            typedX = left.asInt();
            typedTable = right.asInt();
        } else if (left instanceof RLogical && right instanceof RLogical) {
            typedX = left.asLogical();
            typedTable = right.asLogical();
        } else {
            throw RError.getMatchVectorArgs(this.ast);
        }
        int xsize = typedX.size();
        int tableSize = typedTable.size();
        if (xsize == 1) {
            Object x = typedX.get(0);
            for (int i2 = 0; i2 < tableSize; ++i2) {
                Object v = typedTable.get(i2);
                if (!x.equals(v)) continue;
                return RLogical.BOXED_TRUE;
            }
            return RLogical.BOXED_FALSE;
        }
        int[] content = new int[xsize];
        HashSet<Object> set = new HashSet<Object>(tableSize);
        for (i = 0; i < tableSize; ++i) {
            Object v = typedTable.get(i);
            set.add(v);
        }
        for (i = 0; i < xsize; ++i) {
            Object x = typedX.get(i);
            content[i] = set.contains(x) ? 1 : 0;
        }
        return RLogical.RLogicalFactory.getFor(content);
    }
}

