/*
 * Decompiled with CFR 0.152.
 */
package r.nodes.exec;

import r.Convert;
import r.Utils;
import r.data.RAny;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.internal.ScalarDoubleImpl;
import r.data.internal.ScalarIntImpl;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.ast.BinaryOperation;
import r.nodes.exec.BaseR;
import r.nodes.exec.RNode;
import r.runtime.Frame;
import r.runtime.SpecializationException;

public abstract class LogicalOperation
extends BaseR {
    @RNode.Child
    RNode left;
    @RNode.Child
    RNode right;

    public LogicalOperation(ASTNode ast, RNode left, RNode right) {
        super(ast);
        this.left = this.adoptChild(left);
        this.right = this.adoptChild(right);
    }

    @Override
    public final Object execute(Frame frame) {
        return RLogical.RLogicalFactory.getScalar(this.executeScalarLogical(frame));
    }

    @Override
    protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
        assert (oldNode != null);
        if (this.left == oldNode) {
            this.left = newNode;
            return this.adoptInternal(newNode);
        }
        if (this.right == oldNode) {
            this.right = newNode;
            return this.adoptInternal(newNode);
        }
        return super.replaceChild(oldNode, newNode);
    }

    @Override
    public abstract int executeScalarLogical(Frame var1);

    public final int extractLeftValue(Frame frame) {
        while (true) {
            try {
                return this.left.executeScalarLogical(frame);
            }
            catch (SpecializationException e) {
                LogicalOperation.createAndInsertCastNode(this.left.getAST(), (RAny)e.getResult(), this.left);
                continue;
            }
            break;
        }
    }

    public final int extractRightValue(Frame frame) {
        while (true) {
            try {
                return this.right.executeScalarLogical(frame);
            }
            catch (SpecializationException e) {
                LogicalOperation.createAndInsertCastNode(this.right.getAST(), (RAny)e.getResult(), this.right);
                continue;
            }
            break;
        }
    }

    public static CastNode createAndInsertCastNode(ASTNode ast, RAny template, RNode failedNode) {
        RNode child;
        int iteration = -1;
        if (failedNode instanceof CastNode) {
            iteration = ((CastNode)failedNode).iteration;
            child = ((CastNode)failedNode).child;
        } else {
            child = failedNode;
        }
        if (iteration < 0) {
            assert (Utils.check(!(failedNode instanceof CastNode)));
            assert (Utils.check(child == failedNode));
            if (template instanceof ScalarDoubleImpl) {
                return new CastNode(ast, child, iteration + 1, failedNode){

                    @Override
                    int extract(RAny value) throws SpecializationException {
                        if (value instanceof ScalarDoubleImpl) {
                            return Convert.double2logical(((ScalarDoubleImpl)value).getDouble());
                        }
                        throw new SpecializationException(value);
                    }
                };
            }
            if (template instanceof ScalarIntImpl) {
                return new CastNode(ast, child, iteration + 1, failedNode){

                    @Override
                    int extract(RAny value) throws SpecializationException {
                        if (value instanceof ScalarIntImpl) {
                            return Convert.int2logical(((ScalarIntImpl)value).getInt());
                        }
                        throw new SpecializationException(value);
                    }
                };
            }
        }
        if (iteration < 1) {
            if (template instanceof RLogical) {
                return new CastNode(ast, child, iteration + 1, failedNode){

                    @Override
                    int extract(RAny value) throws SpecializationException {
                        if (value instanceof RLogical) {
                            RLogical v = (RLogical)value;
                            if (v.size() > 0) {
                                return v.getLogical(0);
                            }
                            return Integer.MIN_VALUE;
                        }
                        throw new SpecializationException(value);
                    }
                };
            }
            if (template instanceof RDouble) {
                return new CastNode(ast, child, iteration + 1, failedNode){

                    @Override
                    int extract(RAny value) throws SpecializationException {
                        if (value instanceof RDouble) {
                            RDouble v = (RDouble)value;
                            if (v.size() > 0) {
                                return Convert.double2logical(v.getDouble(0));
                            }
                            return Integer.MIN_VALUE;
                        }
                        throw new SpecializationException(value);
                    }
                };
            }
            if (template instanceof RInt) {
                return new CastNode(ast, child, iteration + 1, failedNode){

                    @Override
                    int extract(RAny value) throws SpecializationException {
                        if (value instanceof RInt) {
                            RInt v = (RInt)value;
                            if (v.size() > 0) {
                                return Convert.int2logical(v.getInt(0));
                            }
                            return Integer.MIN_VALUE;
                        }
                        throw new SpecializationException(value);
                    }
                };
            }
        }
        return new CastNode(ast, child, iteration + 1, failedNode){

            @Override
            int extract(RAny value) {
                if (value instanceof RLogical || value instanceof RInt || value instanceof RDouble || value instanceof RComplex) {
                    RLogical l = value.asLogical();
                    if (l.size() > 0) {
                        return l.getLogical(0);
                    }
                    return Integer.MIN_VALUE;
                }
                BinaryOperation parentOp = (BinaryOperation)this.ast.getParent();
                String operator = parentOp.getLHS() == this.ast ? "x" : "y";
                throw RError.getInvalidTypeIn(parentOp, operator, parentOp.getPrettyOperator());
            }
        };
    }

    public static abstract class CastNode
    extends BaseR {
        @RNode.Child
        RNode child;
        int iteration;

        public CastNode(ASTNode ast, RNode child, int iteration, RNode failedNode) {
            super(ast);
            if (failedNode == child) {
                this.child = this.insert(child, "insert cast node for logical operation");
            } else {
                assert (Utils.check(failedNode instanceof CastNode));
                failedNode.replace(this);
                this.child = this.adoptChild(child);
            }
            this.iteration = iteration;
        }

        @Override
        public final Object execute(Frame frame) {
            Utils.nyi("unreachable");
            return null;
        }

        @Override
        protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
            assert (oldNode != null);
            if (this.child == oldNode) {
                this.child = newNode;
                return this.adoptInternal(newNode);
            }
            return super.replaceChild(oldNode, newNode);
        }

        @Override
        public int executeScalarLogical(Frame frame) throws SpecializationException {
            RAny value = (RAny)this.child.execute(frame);
            return this.extract(value);
        }

        abstract int extract(RAny var1) throws SpecializationException;
    }

    public static class And
    extends LogicalOperation {
        public And(ASTNode ast, RNode left, RNode right) {
            super(ast, left, right);
        }

        @Override
        public int executeScalarLogical(Frame frame) {
            int leftValue = this.extractLeftValue(frame);
            if (leftValue == 1) {
                return this.extractRightValue(frame);
            }
            if (leftValue == 0) {
                return 0;
            }
            int rightValue = this.extractRightValue(frame);
            if (rightValue == 0) {
                return 0;
            }
            return Integer.MIN_VALUE;
        }
    }

    public static class Or
    extends LogicalOperation {
        public Or(ASTNode ast, RNode left, RNode right) {
            super(ast, left, right);
        }

        @Override
        public int executeScalarLogical(Frame frame) {
            int leftValue = this.extractLeftValue(frame);
            if (leftValue == 1) {
                return 1;
            }
            return this.extractRightValue(frame);
        }
    }
}

