/*
 * Decompiled with CFR 0.152.
 */
package r.nodes.exec;

import r.data.RAny;
import r.data.RArray;
import r.data.RInt;
import r.data.RList;
import r.data.RNull;
import r.data.RSymbol;
import r.data.internal.IntImpl;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.BaseR;
import r.nodes.exec.ConvertToLogicalOne;
import r.nodes.exec.RNode;
import r.runtime.Frame;
import r.runtime.SpecializationException;

public abstract class Loop
extends BaseR {
    @RNode.Child
    RNode body;
    private static final boolean DEBUG_LO = false;

    Loop(ASTNode ast, RNode body) {
        super(ast);
        this.body = this.adoptChild(body);
    }

    @Override
    protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
        assert (oldNode != null);
        if (this.body == oldNode) {
            this.body = newNode;
            return this.adoptInternal(newNode);
        }
        return super.replaceChild(oldNode, newNode);
    }

    public static abstract class For
    extends Loop {
        @RNode.Child
        RNode range;
        final RSymbol cvar;

        For(ASTNode ast, RSymbol cvar, RNode range, RNode body) {
            super(ast, body);
            this.range = this.adoptChild(range);
            this.cvar = cvar;
        }

        @Override
        protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
            assert (oldNode != null);
            if (this.range == oldNode) {
                this.range = newNode;
                return this.adoptInternal(newNode);
            }
            return super.replaceChild(oldNode, newNode);
        }

        public static abstract class Generic
        extends For {
            public Generic(ASTNode ast, RSymbol cvar, RNode range, RNode body) {
                super(ast, cvar, range, body);
            }

            @Override
            public final RAny execute(Frame frame) {
                RAny rval = (RAny)this.range.execute(frame);
                return this.execute(frame, rval);
            }

            public abstract RAny execute(Frame var1, RAny var2);

            public static Generic createToplevel(ASTNode ast, RSymbol cvar, RNode range, RNode body) {
                return new Generic(ast, cvar, range, body){

                    @Override
                    public final RAny execute(Frame frame, RAny rval) {
                        if (!(rval instanceof RArray)) {
                            throw RError.getInvalidForSequence(this.ast);
                        }
                        RArray arange = (RArray)rval;
                        int size = arange.size();
                        try {
                            for (int i = 0; i < size; ++i) {
                                RAny vvalue = arange instanceof RList ? ((RList)arange).getRAny(i) : arange.boxedGet(i);
                                Frame.writeToTopLevelRef(this.cvar, vvalue);
                                try {
                                    this.body.execute(frame);
                                    continue;
                                }
                                catch (ContinueException ce) {
                                    // empty catch block
                                }
                            }
                        }
                        catch (BreakException be) {
                            // empty catch block
                        }
                        return RNull.getNull();
                    }
                };
            }

            public static Generic create(ASTNode ast, RSymbol cvar, RNode range, RNode body, final int slot) {
                return new Generic(ast, cvar, range, body){

                    @Override
                    public final RAny execute(Frame frame, RAny rval) {
                        if (!(rval instanceof RArray)) {
                            throw RError.getInvalidForSequence(this.ast);
                        }
                        RArray arange = (RArray)rval;
                        int size = arange.size();
                        try {
                            for (int i = 0; i < size; ++i) {
                                RAny vvalue = arange.boxedGet(i);
                                frame.writeAtRef(slot, vvalue);
                                try {
                                    this.body.execute(frame);
                                    continue;
                                }
                                catch (ContinueException ce) {
                                    // empty catch block
                                }
                            }
                        }
                        catch (BreakException be) {
                            // empty catch block
                        }
                        return RNull.getNull();
                    }
                };
            }

            public static Generic createDynamic(ASTNode ast, RSymbol cvar, RNode range, RNode body) {
                return new Generic(ast, cvar, range, body){

                    @Override
                    public final RAny execute(Frame frame, RAny rval) {
                        if (!(rval instanceof RArray)) {
                            throw RError.getInvalidForSequence(this.ast);
                        }
                        RArray arange = (RArray)rval;
                        int size = arange.size();
                        try {
                            for (int i = 0; i < size; ++i) {
                                RAny vvalue = arange.boxedGet(i);
                                frame.writeToExtension(this.cvar, vvalue);
                                try {
                                    this.body.execute(frame);
                                    continue;
                                }
                                catch (ContinueException ce) {
                                    // empty catch block
                                }
                            }
                        }
                        catch (BreakException be) {
                            // empty catch block
                        }
                        return RNull.getNull();
                    }
                };
            }
        }

        public static class IntSequenceRange
        extends For {
            public IntSequenceRange(ASTNode ast, RSymbol cvar, RNode range, RNode body) {
                super(ast, cvar, range, body);
            }

            @Override
            public Object execute(Frame frame) {
                try {
                    throw new SpecializationException((Object)null);
                }
                catch (SpecializationException e) {
                    String dbg;
                    RNode sn;
                    if (frame == null) {
                        sn = IntSequenceRange.createToplevel(this.ast, this.cvar, this.range, this.body);
                        dbg = "install IntSequenceRange.TopLevel from IntSequenceRange (uninitialized)";
                    } else {
                        int slot = frame.findVariable(this.cvar);
                        if (slot != -1) {
                            sn = IntSequenceRange.createSimple(this.ast, this.cvar, this.range, this.body, slot);
                            dbg = "install IntSequenceRange.Simple from IntSequenceRange (uninitialized)";
                        } else {
                            sn = IntSequenceRange.createDynamic(this.ast, this.cvar, this.range, this.body);
                            dbg = "install IntSequenceRange.Dynamic from IntSequenceRange (uninitialized)";
                        }
                    }
                    this.replace(sn, dbg);
                    return ((RNode)sn).execute(frame);
                }
            }

            @Override
            protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
                assert (oldNode != null);
                if (this.range == oldNode) {
                    this.range = newNode;
                    return this.adoptInternal(newNode);
                }
                return super.replaceChild(oldNode, newNode);
            }

            public static Specialized createToplevel(ASTNode ast, RSymbol cvar, RNode range, RNode body) {
                return new Specialized(ast, cvar, range, body){

                    @Override
                    public final RAny execute(Frame frame, IntImpl.RIntSequence sval, int size) {
                        int from = sval.from();
                        int to = sval.to();
                        int step = sval.step();
                        try {
                            int i = from;
                            while (true) {
                                Frame.writeToTopLevelNoRef(this.cvar, RInt.RIntFactory.getScalar(i));
                                try {
                                    this.body.execute(frame);
                                }
                                catch (ContinueException ce) {
                                    // empty catch block
                                }
                                if (i != to) {
                                    i += step;
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (BreakException be) {
                            // empty catch block
                        }
                        return RNull.getNull();
                    }
                };
            }

            public static RNode createSimple(ASTNode ast, RSymbol cvar, RNode range, RNode body, final int slot) {
                return new IntSequenceRange(ast, cvar, range, body){

                    @Override
                    public final RAny execute(Frame frame) {
                        RAny rval = (RAny)this.range.execute(frame);
                        try {
                            if (!(rval instanceof IntImpl.RIntSequence)) {
                                throw new SpecializationException((Object)null);
                            }
                            IntImpl.RIntSequence sval = (IntImpl.RIntSequence)rval;
                            int from = sval.from();
                            int to = sval.to();
                            int step = sval.step();
                            if (from > to || step != 1 || from != 1) {
                                throw new SpecializationException((Object)null);
                            }
                            try {
                                for (int i = 1; i <= to; ++i) {
                                    frame.writeAtNoRef(slot, RInt.RIntFactory.getScalar(i));
                                    try {
                                        this.body.execute(frame);
                                        continue;
                                    }
                                    catch (ContinueException ce) {
                                        // empty catch block
                                    }
                                }
                            }
                            catch (BreakException be) {
                                // empty catch block
                            }
                            return RNull.getNull();
                        }
                        catch (SpecializationException e) {
                            if (rval instanceof IntImpl.RIntSequence) {
                                Specialized sn = Specialized.create(this.ast, this.cvar, this.range, this.body, slot);
                                this.replace(sn, "install Specialized from IntSequenceRange.Simple");
                                return sn.execute(frame, (IntImpl.RIntSequence)rval, ((IntImpl.RIntSequence)rval).size());
                            }
                            Generic gn = Generic.create(this.ast, this.cvar, this.range, this.body, slot);
                            this.replace(gn, "install Generic from IntSequenceRange.Simple");
                            return gn.execute(frame, rval);
                        }
                    }
                };
            }

            public static Specialized create(ASTNode ast, RSymbol cvar, RNode range, RNode body, final int slot) {
                return new Specialized(ast, cvar, range, body){

                    @Override
                    public final RAny execute(Frame frame, IntImpl.RIntSequence sval, int size) {
                        int from = sval.from();
                        int to = sval.to();
                        int step = sval.step();
                        try {
                            int i = from;
                            while (true) {
                                frame.writeAtNoRef(slot, RInt.RIntFactory.getScalar(i));
                                try {
                                    this.body.execute(frame);
                                }
                                catch (ContinueException ce) {
                                    // empty catch block
                                }
                                if (i != to) {
                                    i += step;
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (BreakException be) {
                            // empty catch block
                        }
                        return RNull.getNull();
                    }
                };
            }

            public static Specialized createDynamic(ASTNode ast, RSymbol cvar, RNode range, RNode body) {
                return new Specialized(ast, cvar, range, body){

                    @Override
                    public final RAny execute(Frame frame, IntImpl.RIntSequence sval, int size) {
                        int from = sval.from();
                        int to = sval.to();
                        int step = sval.step();
                        try {
                            int i = from;
                            while (true) {
                                frame.writeToExtension(this.cvar, RInt.RIntFactory.getScalar(i));
                                try {
                                    this.body.execute(frame);
                                }
                                catch (ContinueException ce) {
                                    // empty catch block
                                }
                                if (i != to) {
                                    i += step;
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (BreakException be) {
                            // empty catch block
                        }
                        return RNull.getNull();
                    }
                };
            }

            public static abstract class Specialized
            extends IntSequenceRange {
                public Specialized(ASTNode ast, RSymbol cvar, RNode range, RNode body) {
                    super(ast, cvar, range, body);
                }

                @Override
                public final RAny execute(Frame frame) {
                    RAny rval = (RAny)this.range.execute(frame);
                    try {
                        if (!(rval instanceof IntImpl.RIntSequence)) {
                            throw new SpecializationException((Object)null);
                        }
                        IntImpl.RIntSequence sval = (IntImpl.RIntSequence)rval;
                        int size = sval.size();
                        return this.execute(frame, sval, size);
                    }
                    catch (SpecializationException e) {
                        int slot;
                        Generic gn = frame == null ? Generic.createToplevel(this.ast, this.cvar, this.range, this.body) : ((slot = frame.findVariable(this.cvar)) != -1 ? Generic.create(this.ast, this.cvar, this.range, this.body, slot) : Generic.createDynamic(this.ast, this.cvar, this.range, this.body));
                        this.replace(gn, "install Generic from IntSequenceRange");
                        return gn.execute(frame, rval);
                    }
                }

                public abstract RAny execute(Frame var1, IntImpl.RIntSequence var2, int var3);
            }
        }
    }

    public static class While
    extends Loop {
        @RNode.Child
        RNode cond;

        public While(ASTNode ast, RNode cond, RNode body) {
            super(ast, body);
            this.cond = this.adoptChild(cond);
        }

        @Override
        public final RAny execute(Frame frame) {
            block10: {
                try {
                    while (true) {
                        try {
                            while (true) {
                                int condVal;
                                try {
                                    condVal = this.cond.executeScalarLogical(frame);
                                }
                                catch (SpecializationException e) {
                                    RAny result = (RAny)e.getResult();
                                    ConvertToLogicalOne castNode = ConvertToLogicalOne.createAndInsertNode(this.cond, result);
                                    this.cond = this.adoptChild(castNode);
                                    condVal = castNode.executeScalarLogical(result);
                                }
                                if (condVal != 0) {
                                    if (condVal == Integer.MIN_VALUE) {
                                        throw RError.getUnexpectedNA(this.ast);
                                    }
                                    this.body.execute(frame);
                                    continue;
                                }
                                break block10;
                                break;
                            }
                        }
                        catch (ContinueException ce) {
                            continue;
                        }
                        break;
                    }
                }
                catch (BreakException breakException) {
                    // empty catch block
                }
            }
            return RNull.getNull();
        }

        @Override
        protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
            assert (oldNode != null);
            if (this.cond == oldNode) {
                this.cond = newNode;
                return this.adoptInternal(newNode);
            }
            return super.replaceChild(oldNode, newNode);
        }
    }

    public static class Repeat
    extends Loop {
        public Repeat(ASTNode ast, RNode body) {
            super(ast, body);
        }

        @Override
        public final RAny execute(Frame frame) {
            try {
                while (true) {
                    try {
                        while (true) {
                            this.body.execute(frame);
                        }
                    }
                    catch (ContinueException ce) {
                        continue;
                    }
                    break;
                }
            }
            catch (BreakException breakException) {
                return RNull.getNull();
            }
        }
    }

    public static class Next
    extends BaseR {
        public Next(ASTNode ast) {
            super(ast);
        }

        @Override
        public final RAny execute(Frame frame) {
            throw ContinueException.instance;
        }
    }

    public static class Break
    extends BaseR {
        public Break(ASTNode ast) {
            super(ast);
        }

        @Override
        public final RAny execute(Frame frame) {
            throw BreakException.instance;
        }
    }

    public static final class ContinueException
    extends RuntimeException {
        public static ContinueException instance = new ContinueException();
        private static final long serialVersionUID = -5960047826708655261L;
    }

    public static final class BreakException
    extends RuntimeException {
        public static BreakException instance = new BreakException();
        private static final long serialVersionUID = -7381797804423147124L;
    }
}

