/*
 * Decompiled with CFR 0.152.
 */
package r.nodes.exec;

import r.Utils;
import r.builtins.Primitives;
import r.data.RBuiltIn;
import r.data.RCallable;
import r.data.RFunction;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.BaseR;
import r.runtime.Frame;
import r.runtime.SpecializationException;

public abstract class MatchCallable
extends BaseR {
    final RSymbol symbol;

    public MatchCallable(ASTNode ast, RSymbol symbol) {
        super(ast);
        this.symbol = symbol;
    }

    public static RCallable matchNonVariable(ASTNode ast, RSymbol symbol) {
        RBuiltIn builtIn = Primitives.getBuiltIn(symbol, null);
        if (builtIn != null) {
            return builtIn;
        }
        throw RError.getUnknownFunction(ast, symbol);
    }

    public static RCallable matchGeneric(ASTNode ast, Frame frame, RSymbol symbol) {
        RCallable res = Frame.match(frame, symbol);
        if (res != null) {
            return res;
        }
        throw RError.getUnknownObjectMode(ast, symbol, "function");
    }

    public static MatchCallable getUninitialized(ASTNode ast, RSymbol sym) {
        return new MatchCallable(ast, sym){

            private Object replaceAndExecute(MatchCallable node, String reason, Frame frame) {
                this.replace(node, reason);
                return node.execute(frame);
            }

            @Override
            public final Object execute(Frame frame) {
                try {
                    throw new SpecializationException((Object)null);
                }
                catch (SpecializationException e) {
                    if (frame == null) {
                        return this.replaceAndExecute(1.getMatchOnlyFromTopLevel(this.ast, this.symbol), "installMatchOnlyFromTopLevel", frame);
                    }
                    int slot = frame.findVariable(this.symbol);
                    if (slot != -1) {
                        return this.replaceAndExecute(1.getMatchLocal(this.ast, this.symbol, slot), "installMatchLocal", frame);
                    }
                    RFunction.EnclosingSlot rse = frame.readSetEntry(this.symbol);
                    if (rse == null) {
                        return this.replaceAndExecute(1.getMatchTopLevel(this.ast, this.symbol), "installMatchTopLevel", frame);
                    }
                    return this.replaceAndExecute(1.getMatchEnclosing(this.ast, this.symbol, rse.hops, rse.slot), "installMatchEnclosing", frame);
                }
            }
        };
    }

    public static MatchCallable getMatchLocal(ASTNode ast, RSymbol symbol, final int slot) {
        return new MatchCallable(ast, symbol){

            @Override
            public final Object execute(Frame frame) {
                RCallable val = frame.matchViaWriteSet(slot, this.symbol);
                if (val == null) {
                    throw RError.getUnknownFunction(this.ast, this.symbol);
                }
                return val;
            }
        };
    }

    public static MatchCallable getMatchEnclosing(ASTNode ast, RSymbol symbol, final int hops, final int slot) {
        return new MatchCallable(ast, symbol){

            @Override
            public final Object execute(Frame frame) {
                RCallable val = frame.matchViaReadSet(hops, slot, this.symbol);
                if (val == null) {
                    throw RError.getUnknownFunction(this.ast, this.symbol);
                }
                return val;
            }
        };
    }

    public static MatchCallable getMatchTopLevel(ASTNode ast, RSymbol symbol) {
        return new MatchCallable(ast, symbol){

            @Override
            public final Object execute(Frame frame) {
                Object val;
                if (this.symbol.getVersion() != 0) {
                    val = frame.matchFromExtensionEntry(this.symbol);
                    if (val == null) {
                        val = this.symbol.getValue();
                    }
                } else {
                    val = this.symbol.getValue();
                }
                if (val == null || !(val instanceof RCallable)) {
                    return 4.matchNonVariable(this.ast, this.symbol);
                }
                return val;
            }
        };
    }

    public static MatchCallable getMatchOnlyFromTopLevel(ASTNode ast, RSymbol symbol) {
        return new MatchCallable(ast, symbol){

            @Override
            public final Object execute(Frame frame) {
                assert (Utils.check(frame == null));
                Object val = this.symbol.getValue();
                if (val == null || !(val instanceof RCallable)) {
                    return 5.matchNonVariable(this.ast, this.symbol);
                }
                return val;
            }
        };
    }
}

